/*
 * Decompiled with CFR 0.152.
 */
package me.bkrmt.bkteleport.bkcore.teleport;

import me.bkrmt.bkteleport.bkcore.BkPlugin;
import me.bkrmt.bkteleport.bkcore.Utils;
import me.bkrmt.bkteleport.bkcore.config.Configuration;
import me.bkrmt.bkteleport.bkcore.teleport.TeleportRunnable;
import me.bkrmt.bkteleport.bkcore.teleport.TeleportType;
import me.bkrmt.teleport.CancelCause;
import me.bkrmt.teleport.TeleportCore;
import me.bkrmt.teleport.events.PlayerBkTeleportCountStartEvent;
import me.bkrmt.teleport.events.PlayerBkTeleportEvent;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;

public class Teleport {
    private int duration;
    private int startingDuration;
    private final CommandSender sender;
    private final TeleportType type;
    private String warpName;
    private String title;
    private String subtitle;
    private final BkPlugin bkPlugin;
    private final PlayerBkTeleportCountStartEvent startEvent;
    private Location location = null;
    private boolean hasMoveListener;
    private boolean isCancelable = true;
    private TeleportRunnable finishRunnable;
    private Listener moveListener;

    @Deprecated
    public Teleport(BkPlugin bkPlugin, CommandSender sender, String warpName, TeleportType type) {
        this.type = type;
        this.bkPlugin = bkPlugin;
        if (type.equals((Object)TeleportType.Tpa)) {
            this.sender = Utils.getPlayer(warpName);
            this.warpName = sender.getName();
        } else {
            this.sender = sender;
            this.warpName = warpName;
        }
        this.duration = this.getDuration();
        this.hasMoveListener = true;
        this.startEvent = new PlayerBkTeleportCountStartEvent((Player)sender, this.duration);
        this.startingDuration = this.duration;
        this.finishRunnable = null;
        this.startTeleport();
    }

    public Teleport(BkPlugin bkPlugin, Player player, boolean hasMoveListener) {
        this.bkPlugin = bkPlugin;
        this.sender = player;
        this.hasMoveListener = hasMoveListener;
        this.type = null;
        this.duration = 5;
        this.finishRunnable = null;
        this.title = "";
        this.subtitle = "";
        this.warpName = null;
        this.location = null;
        this.startEvent = new PlayerBkTeleportCountStartEvent((Player)this.sender, this.duration);
        this.startingDuration = this.duration;
    }

    private void startMoveListener(BkPlugin bkPlugin) {
        Listener listener = this.moveListener = bkPlugin.getConfigManager().getConfig().getBoolean("teleport-countdown.cancel-on-move") ? new Listener(){

            @EventHandler
            public void onMove(PlayerMoveEvent event) {
                if ((int)event.getFrom().getX() != (int)event.getTo().getX() || (int)event.getFrom().getZ() != (int)event.getTo().getZ()) {
                    Player player = event.getPlayer();
                    if (TeleportCore.INSTANCE.getPlayersInCooldown().get(player.getName()) != null) {
                        TeleportCore.INSTANCE.getPlayersInCooldown().put(player.getName(), false);
                        TeleportCore.INSTANCE.getCancelCause().put(player.getName(), CancelCause.Moved);
                        HandlerList.unregisterAll((Listener)Teleport.this.moveListener);
                    }
                }
            }
        } : null;
        if (this.moveListener != null) {
            bkPlugin.getServer().getPluginManager().registerEvents(this.moveListener, (Plugin)bkPlugin);
        }
    }

    public Teleport setRunnable(TeleportRunnable runnable) {
        this.finishRunnable = runnable;
        return this;
    }

    public Teleport setDuration(int duration) {
        this.duration = duration;
        this.startingDuration = duration;
        return this;
    }

    public Teleport setLocation(String name, Location location) {
        this.location = location;
        this.warpName = name;
        return this;
    }

    public Teleport setIsCancellable(boolean isCancellable) {
        this.isCancelable = isCancellable;
        return this;
    }

    public void startTeleport() {
        if (TeleportCore.INSTANCE.getPlayersInCooldown().get(this.sender.getName()) == null) {
            TeleportCore.INSTANCE.getPlayersInCooldown().put(this.sender.getName(), true);
            if (TeleportCore.INSTANCE.getPlayerTeleport().get(this.sender.getName()) != null) {
                TeleportCore.INSTANCE.getPlayerTeleport().get(this.sender.getName()).cancel();
            }
            final boolean useSound = this.bkPlugin.getConfigManager().getConfig().getBoolean("teleport-countdown.use-sound");
            final boolean useTitle = this.bkPlugin.getConfigManager().getConfig().getBoolean("teleport-countdown.use-title");
            final boolean useAction = this.bkPlugin.getConfigManager().getConfig().getBoolean("teleport-countdown.use-actionbar");
            if (this.duration == 0) {
                this.teleport(useSound);
                return;
            }
            this.bkPlugin.getServer().getPluginManager().callEvent((Event)this.startEvent);
            if (!this.isCanceled(useSound) && this.hasMoveListener) {
                this.startMoveListener(this.bkPlugin);
            }
            BukkitTask teleport = new BukkitRunnable(){

                public void run() {
                    if (Teleport.this.isCanceled(useSound)) {
                        this.cancel();
                    } else {
                        Teleport.this.sendCountdown(useTitle, useAction, useSound);
                    }
                    if (Teleport.this.duration <= 0) {
                        Teleport.this.teleport(useSound);
                        this.cancel();
                    }
                }
            }.runTaskTimer((Plugin)this.bkPlugin, 0L, 20L);
            TeleportCore.INSTANCE.getPlayerTeleport().put(this.sender.getName(), teleport);
        } else {
            this.sender.sendMessage(this.bkPlugin.getLangFile().get("error.already-waiting"));
        }
    }

    private void pling(boolean useSound, int volume, float pitch) {
        if (useSound) {
            ((Player)this.sender).playSound(((Player)this.sender).getLocation(), this.bkPlugin.getHandler().getSoundManager().getPling(), (float)volume, pitch);
        }
    }

    private void sendCountdown(boolean useTitle, boolean useActionBar, boolean useSound) {
        if (useTitle) {
            this.bkPlugin.sendTitle((Player)this.sender, 5, 10, 5, this.bkPlugin.getLangFile().get("info.time-remaining").replace("{seconds}", String.valueOf(this.duration)), "");
        }
        if (useActionBar) {
            this.bkPlugin.sendActionBar((Player)this.sender, this.buildBar());
        }
        --this.duration;
        if (useSound) {
            new BukkitRunnable(){

                public void run() {
                    Teleport.this.pling(true, 15, 1.0f);
                }
            }.runTaskLater((Plugin)this.bkPlugin, 5L);
        }
    }

    private void teleport(final boolean useSound) {
        if (this.startingDuration > 0) {
            new BukkitRunnable(){

                public void run() {
                    Teleport.this.checkTeleport(useSound);
                }
            }.runTaskLater((Plugin)this.bkPlugin, 25L);
        } else {
            this.checkTeleport(useSound);
        }
    }

    public Teleport setTitle(String title) {
        this.title = title;
        return this;
    }

    public Teleport setSubtitle(String subtitle) {
        this.subtitle = subtitle;
        return this;
    }

    private void checkTeleport(boolean useSound) {
        if (this.isCanceled(useSound)) {
            return;
        }
        TeleportCore.INSTANCE.getPlayerTeleport().remove(this.sender.getName());
        TeleportCore.INSTANCE.getPlayersInCooldown().remove(this.sender.getName());
        try {
            Player player = (Player)this.sender;
            PlayerBkTeleportEvent tpEvent = new PlayerBkTeleportEvent(player, this.getWarpingLocation());
            this.bkPlugin.getServer().getPluginManager().callEvent((Event)tpEvent);
            if (!tpEvent.isCancelled()) {
                this.movePlayer();
                this.pling(useSound, 15, 2.0f);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private boolean isCanceled(boolean useSound) {
        if (!this.isCancelable) {
            return false;
        }
        if (this.startEvent.isCancelled()) {
            TeleportCore.INSTANCE.getPlayerTeleport().remove(this.sender.getName());
            TeleportCore.INSTANCE.getPlayersInCooldown().remove(this.sender.getName());
            if (this.finishRunnable != null) {
                Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)this.bkPlugin, () -> this.finishRunnable.run((Player)this.sender, this.location, true), 3L);
            }
            return true;
        }
        if (!TeleportCore.INSTANCE.getPlayersInCooldown().get(this.sender.getName()).booleanValue()) {
            String subtitle = "";
            if (TeleportCore.INSTANCE.getCancelCause().get(this.sender.getName()).equals((Object)CancelCause.DealtDamage)) {
                subtitle = this.bkPlugin.getLangFile().get("error.warp-canceled-cause.took-damage");
            } else if (TeleportCore.INSTANCE.getCancelCause().get(this.sender.getName()).equals((Object)CancelCause.TookDamage)) {
                subtitle = this.bkPlugin.getLangFile().get("error.warp-canceled-cause.dealt-damage");
            } else if (TeleportCore.INSTANCE.getCancelCause().get(this.sender.getName()).equals((Object)CancelCause.Moved)) {
                subtitle = this.bkPlugin.getLangFile().get("error.warp-canceled-cause.moved");
            }
            this.bkPlugin.sendTitle((Player)this.sender, 5, 30, 5, this.bkPlugin.getLangFile().get("error.warp-canceled-title"), subtitle);
            this.pling(useSound, 15, 0.5f);
            TeleportCore.INSTANCE.getPlayerTeleport().remove(this.sender.getName());
            TeleportCore.INSTANCE.getPlayersInCooldown().remove(this.sender.getName());
            TeleportCore.INSTANCE.getCancelCause().remove(this.sender.getName());
            if (this.finishRunnable != null) {
                Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)this.bkPlugin, () -> this.finishRunnable.run((Player)this.sender, this.location, true), 3L);
            }
            return true;
        }
        return false;
    }

    private void movePlayer() {
        this.bkPlugin.sendActionBar((Player)this.sender, " ");
        int invTime = this.bkPlugin.getConfigManager().getConfig().getInt("invulnerable-time");
        if (!((Player)this.sender).getGameMode().equals((Object)GameMode.CREATIVE) && invTime > 0) {
            if (TeleportCore.INSTANCE.getInvulnerablePlayers().get(this.sender.getName()) != null) {
                ((BukkitTask)TeleportCore.INSTANCE.getInvulnerablePlayers().get(this.sender.getName())[2]).cancel();
                TeleportCore.INSTANCE.getInvulnerablePlayers().remove(this.sender.getName());
            }
            final String actionMessage = this.bkPlugin.getLangFile().get("info.invulnerable-remaining");
            this.bkPlugin.sendActionBar((Player)this.sender, actionMessage.replace("{seconds}", String.valueOf(invTime)));
            Object[] values = new Object[]{invTime, Float.valueOf(0.0f), new BukkitRunnable(){
                boolean sendActionBar = false;

                public void run() {
                    Player player = (Player)Teleport.this.sender;
                    if (!player.isOnline()) {
                        this.cancel();
                        TeleportCore.INSTANCE.getInvulnerablePlayers().remove(Teleport.this.sender.getName());
                    } else {
                        float count;
                        Object[] values = TeleportCore.INSTANCE.getInvulnerablePlayers().get(Teleport.this.sender.getName());
                        int length = (Integer)values[0];
                        if ((int)((float)length - (count = ((Float)values[1]).floatValue())) > 0) {
                            if (this.sendActionBar) {
                                Teleport.this.bkPlugin.sendActionBar(player, actionMessage.replace("{seconds}", String.valueOf((int)((float)length - count))));
                                this.sendActionBar = false;
                            } else {
                                this.sendActionBar = true;
                            }
                            TeleportCore.INSTANCE.getInvulnerablePlayers().get((Object)((Teleport)Teleport.this).sender.getName())[1] = Float.valueOf(count + 0.5f);
                        } else {
                            Teleport.this.bkPlugin.sendActionBar(player, "");
                            this.cancel();
                            TeleportCore.INSTANCE.getInvulnerablePlayers().remove(player.getName());
                        }
                    }
                }
            }.runTaskTimer((Plugin)this.bkPlugin, 10L, 10L), new String[]{this.bkPlugin.getLangFile().get("error.cant-attack-now.self"), this.bkPlugin.getLangFile().get("error.cant-attack-now.others")}};
            TeleportCore.INSTANCE.getInvulnerablePlayers().put(this.sender.getName(), values);
        }
        ((Player)this.sender).teleport(this.getWarpingLocation());
        if (this.type == null) {
            if (this.title.isEmpty()) {
                this.title = this.bkPlugin.getLangFile().get("info.warped.title");
            }
            if (this.subtitle.isEmpty()) {
                this.subtitle = this.bkPlugin.getLangFile().get("info.warped.subtitle").replace("{location-name}", this.warpName);
            }
        } else {
            if (this.type.equals((Object)TeleportType.Tpa) || this.type.equals((Object)TeleportType.Shop)) {
                if (Utils.getPlayer(this.warpName) == null) {
                    OfflinePlayer offlineTarget = Bukkit.getServer().getOfflinePlayer(this.warpName);
                    if (offlineTarget != null) {
                        this.warpName = offlineTarget.getName();
                    }
                } else {
                    this.warpName = Utils.getPlayer(this.warpName).getName();
                }
            }
            if (this.type.equals((Object)TeleportType.Shop)) {
                Configuration configFile = this.bkPlugin.getConfigManager().getConfig("shops", this.warpName.toLowerCase() + ".yml");
                String customColor = "7";
                this.title = this.bkPlugin.getLangFile().get("info.warped.title").replace("{player}", this.warpName);
                if (configFile.getString("shop.color") != null) {
                    customColor = configFile.getString("shop.color");
                }
                if (configFile.getString("shop.message") != null) {
                    this.subtitle = "&" + customColor + configFile.getString("shop.message");
                }
                this.title = "&" + customColor + this.title;
            } else {
                this.title = this.bkPlugin.getLangFile().get("info.warped.title");
                this.subtitle = this.bkPlugin.getLangFile().get("info.warped.subtitle").replace("{player}", this.warpName);
            }
        }
        if (this.finishRunnable != null) {
            Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)this.bkPlugin, () -> this.finishRunnable.run((Player)this.sender, this.location, false), 3L);
        }
        if (this.type != null) {
            this.bkPlugin.sendTitle((Player)this.sender, 5, 45, 10, ChatColor.translateAlternateColorCodes((char)'&', (String)this.title), ChatColor.translateAlternateColorCodes((char)'&', (String)this.subtitle));
        } else if (!this.title.isEmpty()) {
            this.bkPlugin.sendTitle((Player)this.sender, 5, 45, 10, Utils.translateColor(this.title), Utils.translateColor(this.subtitle));
        }
    }

    private String buildBar() {
        int barAmount = this.duration;
        StringBuilder barBuilder = new StringBuilder();
        barBuilder.append("\u00a77[");
        int count = 0;
        for (int i = 0; i < this.startingDuration; ++i) {
            if (count > 0) {
                barBuilder.append(" ");
            }
            if (barAmount > 0) {
                barBuilder.append(this.getBarColor(count)).append("\u2b1b");
                --barAmount;
            } else {
                barBuilder.append("\u00a77\u2b1b");
            }
            ++count;
        }
        barBuilder.append("\u00a77]");
        return barBuilder.toString();
    }

    private String getBarColor(int count) {
        int percentage = (int)((double)count / (double)this.startingDuration * 100.0);
        if (percentage < 33) {
            return "\u00a7c";
        }
        if (percentage < 66) {
            return "\u00a7e";
        }
        return "\u00a7a";
    }

    private Location getWarpingLocation() {
        if (this.location == null) {
            Location warpingLocation;
            String fileName = "";
            String filePath = this.bkPlugin.getDataFolder().getPath();
            String configKey = "";
            String tempWarpName = this.warpName + ".";
            if (this.type.equals((Object)TeleportType.Home) || this.type.equals((Object)TeleportType.Shop)) {
                if (this.type.equals((Object)TeleportType.Home)) {
                    filePath = "userdata";
                    configKey = "homes.";
                    fileName = ((Player)this.sender).getUniqueId().toString() + ".yml";
                } else {
                    fileName = this.warpName.toLowerCase() + ".yml";
                    filePath = "shops";
                    tempWarpName = ".";
                    configKey = "shop";
                }
            } else if (this.type.equals((Object)TeleportType.Warp)) {
                filePath = "warps";
                tempWarpName = "";
                configKey = "";
                fileName = this.warpName.toLowerCase() + ".yml";
            }
            if (this.type.equals((Object)TeleportType.Tpa)) {
                warpingLocation = Utils.getPlayer(this.warpName).getLocation();
            } else if (this.type.equals((Object)TeleportType.TpaHere)) {
                warpingLocation = ((Player)this.sender).getLocation();
            } else {
                Configuration config = this.bkPlugin.getConfigManager().getConfig(filePath, fileName);
                World world = this.bkPlugin.getServer().getWorld(config.getString(configKey + tempWarpName + "world"));
                double x = config.getDouble(configKey + tempWarpName + "x");
                double y = config.getDouble(configKey + tempWarpName + "y");
                double z = config.getDouble(configKey + tempWarpName + "z");
                float yaw = (float)config.getDouble(configKey + tempWarpName + "yaw");
                float pitch = (float)config.getDouble(configKey + tempWarpName + "pitch");
                warpingLocation = new Location(world, x, y, z, yaw, pitch);
            }
            return warpingLocation;
        }
        return this.location;
    }

    private int getDuration() {
        Player player = (Player)this.sender;
        String permission = "";
        permission = this.type.equals((Object)TeleportType.Shop) ? "bkshop" : permission + "bkteleport";
        int returnDuration = 5;
        for (int count = 0; count <= 99; ++count) {
            if (!player.hasPermission(permission + ".countdown." + count)) continue;
            returnDuration = count;
            break;
        }
        return returnDuration;
    }
}

