/*
 * Decompiled with CFR 0.152.
 */
package me.bkrmt.bkteleport.bkcore.message;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import me.bkrmt.bkteleport.bkcore.BkPlugin;
import me.bkrmt.bkteleport.bkcore.Utils;
import me.bkrmt.bkteleport.bkcore.config.ConfigType;
import me.bkrmt.bkteleport.bkcore.config.Configuration;
import me.bkrmt.bkteleport.bkcore.message.InternalMessages;
import me.clip.placeholderapi.PlaceholderAPI;
import org.bukkit.ChatColor;
import org.bukkit.OfflinePlayer;

public class LangFile {
    private String language;
    private final BkPlugin plugin;
    private final Configuration langConfig;
    private ConcurrentHashMap<String, String> messages;
    private ConcurrentHashMap<String, List<String>> lists;

    public LangFile(BkPlugin plugin, ArrayList<String> langList) {
        this.plugin = plugin;
        File langFolder = new File(plugin.getDataFolder(), "lang");
        if (!langFolder.exists()) {
            langFolder.mkdir();
        }
        this.language = plugin.getConfigManager().getConfig().getString("language");
        this.messages = new ConcurrentHashMap();
        this.lists = new ConcurrentHashMap();
        String langFile = this.language + ".yml";
        if (!plugin.containsResource(langFile) && !plugin.getFile("lang", langFile).exists()) {
            plugin.getServer().getLogger().log(Level.WARNING, InternalMessages.NO_LANG.getMessage().replace("{0}", langFile));
            this.language = "en_US";
        }
        this.langConfig = this.createConfig(this.language);
        langList.remove(this.language);
        for (String lang : langList) {
            this.createConfig(lang);
        }
        this.loadMessages();
    }

    private Configuration createConfig(String language) {
        Configuration config = new Configuration(this.plugin, this.plugin.getFile("lang", language + ".yml"), ConfigType.Lang);
        if (!config.getFile().exists()) {
            config.saveToFile();
        } else if (config.getFile().exists() && config.getFile().length() == 0L) {
            config.saveToFile();
        }
        return config;
    }

    public final String getLanguage() {
        return this.language;
    }

    public Configuration getConfig() {
        return this.langConfig;
    }

    public List<String> getStringList(OfflinePlayer player, String key) {
        List<String> list = this.getStringList(key);
        boolean hasPapiHook = this.plugin.hasPlaceholderHook();
        list.forEach(line -> {
            if (line.contains("%") && hasPapiHook) {
                list.set(list.indexOf(line), PlaceholderAPI.setPlaceholders((OfflinePlayer)player, (String)line));
            }
        });
        return list;
    }

    public List<String> getStringList(String key) {
        return this.getStringList(key, true);
    }

    public List<String> getStringList(String key, boolean translate) {
        try {
            ArrayList<String> list = new ArrayList<String>(this.lists.get(key) == null ? Collections.singletonList(this.messages.get(key)) : (Collection)this.lists.get(key));
            if (translate) {
                list.forEach(line -> list.set(list.indexOf(line), Utils.translateColor(line)));
            }
            return list;
        }
        catch (Exception ignored) {
            ignored.printStackTrace();
            this.plugin.sendConsoleMessage(Utils.translateColor(InternalMessages.INVALID_MESSAGE.getMessage().replace("{0}", Utils.translateColor("&7[&4" + this.plugin.getName() + "&7]&c")).replace("{1}", ChatColor.stripColor((String)key))));
            return Collections.singletonList(ChatColor.RED + "Error, check console!");
        }
    }

    public String get(OfflinePlayer player, String key) {
        return this.get(player, key, true);
    }

    public String get(OfflinePlayer player, String key, boolean translate) {
        try {
            String text = this.get(key, translate);
            return text.contains("%") && this.plugin.hasPlaceholderHook() ? PlaceholderAPI.setPlaceholders((OfflinePlayer)player, (String)text) : text;
        }
        catch (Exception e) {
            e.printStackTrace();
            return "\u00a7cError when trying to get the message " + key;
        }
    }

    public String get(String key) {
        return this.get(key, true);
    }

    public String get(String key, boolean translate) {
        try {
            String message = this.messages.get(key);
            if (message.contains("%") && this.plugin.hasPlaceholderHook()) {
                message = PlaceholderAPI.setPlaceholders(null, (String)message);
            }
            return translate ? ChatColor.translateAlternateColorCodes((char)'&', (String)message) : message;
        }
        catch (Exception ignored) {
            this.plugin.sendConsoleMessage(Utils.translateColor(InternalMessages.INVALID_MESSAGE.getMessage().replace("{0}", Utils.translateColor("&7[&4" + this.plugin.getName() + "&7]&c")).replace("{1}", ChatColor.stripColor((String)key))));
            return ChatColor.RED + "Error, check console!";
        }
    }

    public void reloadMessages() {
        this.langConfig.loadFromFile();
        this.messages = new ConcurrentHashMap();
        this.lists = new ConcurrentHashMap();
        this.loadMessages();
    }

    private void loadMessages() {
        for (String key : this.langConfig.getKeys(true)) {
            List list;
            if (key.startsWith(".")) {
                key = key.replaceFirst(".", "");
            }
            if ((list = this.langConfig.getStringList(key)).size() <= 1) {
                if (list.size() == 0) {
                    this.messages.put(key, this.langConfig.getString(key));
                    continue;
                }
                this.messages.put(key, (String)list.get(0));
                continue;
            }
            this.lists.put(key, list);
        }
    }
}

