/*
 * Decompiled with CFR 0.152.
 */
package me.bkrmt.bkteleport.bkcore.menu;

import me.bkrmt.bkteleport.bkcore.BkPlugin;
import me.bkrmt.bkteleport.bkcore.Utils;
import me.bkrmt.bkteleport.bkcore.menu.MenuListener;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public abstract class Menu {
    private final Inventory menu;
    private final String cleanTitle;
    private MenuListener listener;
    BkPlugin plugin;

    public Menu(BkPlugin plugin, String titleKey) {
        this.plugin = plugin;
        String title = plugin.getLangFile().get(titleKey);
        this.cleanTitle = Utils.cleanName(title);
        this.menu = plugin.getServer().createInventory(null, 54, title);
    }

    public MenuListener getListener() {
        return this.listener;
    }

    public void setListener(MenuListener listener) {
        this.listener = listener;
    }

    public boolean isValidClick(InventoryClickEvent event) {
        String inventoryName = ChatColor.stripColor((String)event.getView().getTitle()).trim();
        boolean returnValue = false;
        if (Utils.cleanName(inventoryName).equalsIgnoreCase(this.getCleanTitle())) {
            ItemStack button;
            event.setCancelled(true);
            if (event.getSlotType().equals((Object)InventoryType.SlotType.CONTAINER) && (button = event.getCurrentItem()) != null && !button.getType().equals((Object)Material.AIR)) {
                returnValue = true;
            }
        }
        return returnValue;
    }

    public String getCleanTitle() {
        return this.cleanTitle;
    }

    public Inventory getMenu() {
        return this.menu;
    }

    public void openMenu(CommandSender player) {
        ((Player)player).openInventory(this.menu);
    }

    public void setOnCoordinate(ItemStack item, int line, int colum) {
        Utils.setOnCoordinate(this.getMenu(), item, line, colum);
    }
}

