/*
 * Decompiled with CFR 0.152.
 */
package me.bkrmt.bkteleport.bkcore.config;

import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import me.bkrmt.bkteleport.bkcore.BkPlugin;
import me.bkrmt.bkteleport.bkcore.ItemManager;
import me.bkrmt.bkteleport.bkcore.Utils;
import me.bkrmt.bkteleport.bkcore.config.ConfigType;
import me.bkrmt.bkteleport.bkcore.config.ConfigUpdater;
import me.bkrmt.bkteleport.bkcore.message.InternalMessages;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.EnchantmentStorageMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionData;
import org.bukkit.potion.PotionType;

public class Configuration
extends YamlConfiguration {
    private final BkPlugin plugin;
    private final File file;
    private final ConfigType type;
    private long timeStamp;

    public Configuration(BkPlugin plugin, File newFile, ConfigType type) {
        this.plugin = plugin;
        this.type = type;
        this.file = newFile;
        this.timeStamp = this.file.lastModified();
        this.createData();
        this.loadFromFile();
        if (plugin.containsResource(this.file.getName()) || type.equals((Object)ConfigType.Lang) && !this.file.getName().equalsIgnoreCase("pt_BR.yml") && !this.file.getName().equalsIgnoreCase("en_US.yml")) {
            this.validateOptions();
        }
    }

    public Configuration(BkPlugin plugin, File newFile) {
        this.plugin = plugin;
        this.type = ConfigType.Config;
        this.file = newFile;
        this.createData();
        this.loadFromFile();
        if (plugin.containsResource(this.file.getName())) {
            this.validateOptions();
        }
    }

    private void validateOptions() {
        Set configKeys = this.getKeys(true);
        YamlConfiguration resourceConfig = null;
        if (this.type.equals((Object)ConfigType.Config)) {
            resourceConfig = YamlConfiguration.loadConfiguration((Reader)new InputStreamReader(this.plugin.getResource(this.file.getName())));
        } else if (this.type.equals((Object)ConfigType.Lang)) {
            String fileName = "en_US.yml";
            if (this.file.getName().equalsIgnoreCase("pt_BR.yml") || this.file.getName().equalsIgnoreCase("en_US.yml")) {
                fileName = this.file.getName();
            }
            resourceConfig = YamlConfiguration.loadConfiguration((Reader)new InputStreamReader(this.plugin.getResource(this.file.getName())));
        }
        if (resourceConfig != null) {
            Set resourceKeys = resourceConfig.getKeys(true);
            for (String resKey : resourceKeys) {
                if (configKeys.contains(resKey)) continue;
                this.set(resKey, resourceConfig.get(resKey));
            }
        }
    }

    public BkPlugin getPlugin() {
        return this.plugin;
    }

    public void loadFromFile() {
        if (this.file.exists()) {
            try {
                this.load(this.file);
            }
            catch (Exception e) {
                e.printStackTrace();
                this.plugin.sendConsoleMessage(InternalMessages.INVALID_CONFIG.getMessage(this.plugin).replace("{0}", Utils.translateColor("&7[&4" + this.plugin.getName() + "&7]&c")).replace("{1}", this.file.getName()));
                Bukkit.getPluginManager().disablePlugin((Plugin)this.plugin);
            }
        }
    }

    public File getFile() {
        return this.file;
    }

    public void saveToFile() {
        try {
            if (!this.file.exists()) {
                this.file.createNewFile();
            }
            this.save(this.file);
            if (this.type != ConfigType.Player_Data) {
                this.updateFromResource();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.plugin.sendConsoleMessage(InternalMessages.INVALID_CONFIG.getMessage(this.plugin).replace("{0}", Utils.translateColor("&7[&4" + this.plugin.getName() + "&7]&c")).replace("{1}", this.file.getName()));
            Bukkit.getPluginManager().disablePlugin((Plugin)this.plugin);
        }
    }

    public long getTimeStamp() {
        return this.timeStamp;
    }

    public void setTimeStamp(long timeStamp) {
        this.timeStamp = timeStamp;
    }

    private void createData() {
        if (!this.file.exists()) {
            File filePath = new File(Utils.getCleanPath(this.file));
            boolean pathExists = true;
            if (!filePath.exists()) {
                pathExists = filePath.mkdirs();
            }
            if (pathExists) {
                if (this.plugin.containsResource(this.file.getName())) {
                    try {
                        this.file.createNewFile();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        this.plugin.sendConsoleMessage(InternalMessages.INVALID_CONFIG.getMessage(this.plugin).replace("{0}", Utils.translateColor("&7[&4" + this.plugin.getName() + "&7]&c")).replace("{1}", this.file.getName()));
                        Bukkit.getPluginManager().disablePlugin((Plugin)this.plugin);
                    }
                } else {
                    this.updateFromResource();
                }
            } else {
                this.plugin.sendConsoleMessage(InternalMessages.INVALID_CONFIG.getMessage(this.plugin).replace("{0}", Utils.translateColor("&7[&4" + this.plugin.getName() + "&7]&c")).replace("{1}", this.file.getName()));
                Bukkit.getPluginManager().disablePlugin((Plugin)this.plugin);
            }
        }
    }

    public ConfigType getType() {
        return this.type;
    }

    public void setLocation(String path, Location location) {
        this.set(path + ".world", location.getWorld().getName());
        this.set(path + ".x", location.getX());
        this.set(path + ".y", location.getY());
        this.set(path + ".z", location.getZ());
        this.set(path + ".pitch", Float.valueOf(location.getPitch()));
        this.set(path + ".yaw", Float.valueOf(location.getYaw()));
    }

    public Location getLocation(String path) {
        if (this.getString(path + ".world") == null) {
            return null;
        }
        return new Location(Bukkit.getWorld((String)this.getString(path + ".world")), this.getDouble(path + ".x"), this.getDouble(path + ".y"), this.getDouble(path + ".z"), (float)this.getDouble(path + ".yaw"), (float)this.getDouble(path + ".pitch"));
    }

    public void setItemStack(String path, ItemStack item) {
        EnchantmentStorageMeta meta;
        if (item == null || item.getType().equals((Object)Material.AIR)) {
            return;
        }
        if (this.plugin.getNmsVer().number < 13) {
            this.set(path + ".byte", item.getData().getData());
            this.set(path + ".damage", item.getDurability());
        }
        this.set(path + ".material", item.getType().toString());
        this.set(path + ".ammount", item.getAmount());
        if (item.getItemMeta().getDisplayName() == null) {
            this.set(path + ".name", item.getType().toString());
        } else {
            this.set(path + ".name", item.getItemMeta().getDisplayName().replace("\u00a7", "&"));
        }
        ArrayList<String> lore = new ArrayList<String>();
        if (item.getItemMeta().getLore() != null) {
            for (String l : item.getItemMeta().getLore()) {
                lore.add(l.replace("\u00a7", "&"));
            }
        }
        this.set(path + ".lore", lore);
        for (Object e : item.getItemMeta().getEnchants().keySet()) {
            this.set(path + ".enchants." + e.getName() + ".level", item.getEnchantmentLevel((Enchantment)e));
            try {
                this.save(this.file);
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
        if (item.getItemMeta() instanceof EnchantmentStorageMeta) {
            meta = (EnchantmentStorageMeta)item.getItemMeta();
            for (Enchantment e : meta.getStoredEnchants().keySet()) {
                this.set(path + ".enchants." + e.getName() + ".level", meta.getStoredEnchantLevel(e));
                try {
                    this.save(this.file);
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
            }
        }
        if (item.getItemMeta() instanceof PotionMeta) {
            meta = (PotionMeta)item.getItemMeta();
            this.set(path + ".potionmeta.type", meta.getBasePotionData().getType().toString());
            this.set(path + ".potionmeta.isextended", meta.getBasePotionData().isExtended());
            this.set(path + ".potionmeta.isupgraded", meta.getBasePotionData().isUpgraded());
            try {
                this.save(this.file);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        try {
            this.save(this.file);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public List<String> getLore(String path) {
        ArrayList<String> translatedLore = new ArrayList<String>();
        List oldLore = this.getStringList(path);
        if (oldLore != null) {
            for (String line : oldLore) {
                translatedLore.add(Utils.translateColor(line));
            }
        }
        return translatedLore;
    }

    public ItemStack getItemStack(String path) {
        ItemStack item = null;
        item = this.plugin.getNmsVer().number < 13 ? new ItemStack(Material.valueOf((String)this.getString(path + ".material", "STONE")), this.getInt(path + ".ammount", 1), (short)this.getInt(path + ".damage", 0), Byte.valueOf((byte)this.getInt(path + ".byte", 0))) : new ItemStack(Material.valueOf((String)this.getString(path + ".material", "STONE")), this.getInt(path + ".ammount", 1));
        if (this.getString(path + ".material") == null) {
            return null;
        }
        ArrayList<String> lore = new ArrayList<String>();
        for (String l : this.getStringList(path + ".lore")) {
            lore.add(Utils.translateColor(l));
        }
        if (item.getType().equals((Object)Material.POTION)) {
            PotionMeta meta = (PotionMeta)item.getItemMeta();
            meta.setBasePotionData(new PotionData(PotionType.valueOf((String)this.getString(path + ".potionmeta.type")), this.getBoolean(path + ".potionmeta.isextended"), this.getBoolean(path + ".potionmeta.isupgraded")));
            item.setItemMeta((ItemMeta)meta);
        }
        if (this.getConfigurationSection(path + ".enchants") != null) {
            for (String l : this.getConfigurationSection(path + ".enchants").getKeys(false)) {
                EnchantmentStorageMeta meta;
                if (item.getItemMeta() instanceof EnchantmentStorageMeta) {
                    meta = (EnchantmentStorageMeta)item.getItemMeta();
                    meta.addStoredEnchant(Enchantment.getByName((String)l), this.getInt(path + ".enchants." + l + ".level"), false);
                    item.setItemMeta((ItemMeta)meta);
                    continue;
                }
                if (item.getItemMeta() == null) continue;
                meta = item.getItemMeta();
                meta.addEnchant(Enchantment.getByName((String)l), this.getInt(path + ".enchants." + l + ".level"), true);
                item.setItemMeta((ItemMeta)meta);
            }
        }
        if (this.getString(path + ".name") != null) {
            if (ChatColor.stripColor((String)this.getString(path + ".name").replace("&", "\u00a7")).equals(item.getType().toString())) {
                ItemManager.setLore(item, lore);
            } else {
                ItemManager.setNameAndLore(item, Utils.translateColor(this.getString(path + ".name")), lore);
            }
        }
        return item;
    }

    public void updateFromResource() {
        String fileName = this.file.getName();
        try {
            if (this.plugin.containsResource(this.file.getName())) {
                ConfigUpdater.update((Plugin)this.plugin, fileName, this.file);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.plugin.sendConsoleMessage(InternalMessages.INVALID_CONFIG.getMessage(this.plugin).replace("{0}", Utils.translateColor("&7[&4" + this.plugin.getName() + "&7]&c")).replace("{1}", fileName));
            Bukkit.getPluginManager().disablePlugin((Plugin)this.plugin);
        }
    }
}

