/*
 * Decompiled with CFR 0.152.
 */
package me.bkrmt.bkteleport.bkcore.config;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.configuration.serialization.ConfigurationSerializable;
import org.bukkit.plugin.Plugin;
import org.yaml.snakeyaml.Yaml;

public class ConfigUpdater {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void update(Plugin plugin, String resourceName, File toUpdate) throws IOException {
        List<String> newLines;
        try (BufferedReader newReader = new BufferedReader(new InputStreamReader(plugin.getResource(resourceName)));){
            newLines = newReader.lines().collect(Collectors.toList());
        }
        YamlConfiguration oldConfig = YamlConfiguration.loadConfiguration((File)toUpdate);
        YamlConfiguration newConfig = YamlConfiguration.loadConfiguration((Reader)new InputStreamReader(plugin.getResource(resourceName)));
        ArrayList<String> temp = new ArrayList<String>();
        try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(toUpdate)));){
            Yaml yaml = new Yaml();
            Map<String, String> comments = ConfigUpdater.parseComments(newLines, temp, (FileConfiguration)oldConfig, yaml);
            ConfigUpdater.write((FileConfiguration)newConfig, (FileConfiguration)oldConfig, comments, temp, writer, yaml);
        }
    }

    private static void write(FileConfiguration newConfig, FileConfiguration oldConfig, Map<String, String> comments, List<String> ignoredSections, BufferedWriter writer, Yaml yaml) throws IOException {
        block0: for (String key : newConfig.getKeys(true)) {
            String[] keys = key.split("\\.");
            String actualKey = keys[keys.length - 1];
            String comment = comments.remove(key);
            StringBuilder prefixBuilder = new StringBuilder();
            int indents = keys.length - 1;
            ConfigUpdater.appendPrefixSpaces(prefixBuilder, indents);
            String prefixSpaces = prefixBuilder.toString();
            if (comment != null) {
                writer.write(comment);
            }
            for (String ignoredSection : ignoredSections) {
                if (!key.startsWith(ignoredSection)) continue;
                continue block0;
            }
            Object newObj = newConfig.get(key);
            Object oldObj = oldConfig.get(key);
            if (newObj instanceof ConfigurationSection && oldObj instanceof ConfigurationSection) {
                ConfigUpdater.writeSection(writer, actualKey, prefixSpaces, (ConfigurationSection)oldObj);
                continue;
            }
            if (newObj instanceof ConfigurationSection) {
                ConfigUpdater.writeSection(writer, actualKey, prefixSpaces, (ConfigurationSection)newObj);
                continue;
            }
            if (oldObj != null) {
                ConfigUpdater.write(oldObj, actualKey, prefixSpaces, yaml, writer);
                continue;
            }
            ConfigUpdater.write(newObj, actualKey, prefixSpaces, yaml, writer);
        }
        String danglingComments = comments.get(null);
        if (danglingComments != null) {
            writer.write(danglingComments);
        }
        writer.close();
    }

    private static void write(Object obj, String actualKey, String prefixSpaces, Yaml yaml, BufferedWriter writer) throws IOException {
        if (obj instanceof ConfigurationSerializable) {
            writer.write(prefixSpaces + actualKey + ": " + yaml.dump((Object)((ConfigurationSerializable)obj).serialize()));
        } else if (obj instanceof String) {
            String s = ((String)obj).replace("\n", "\\n");
            writer.write(prefixSpaces + actualKey + ": " + ConfigUpdater.formatStringValue(s) + "\n");
        } else if (obj instanceof Character) {
            writer.write(prefixSpaces + actualKey + ": '" + obj + "'\n");
        } else if (obj instanceof List) {
            ConfigUpdater.writeList((List)obj, actualKey, prefixSpaces, yaml, writer);
        } else {
            writer.write(prefixSpaces + actualKey + ": " + yaml.dump(obj));
        }
    }

    private static void writeSection(BufferedWriter writer, String actualKey, String prefixSpaces, ConfigurationSection section) throws IOException {
        if (section.getKeys(false).isEmpty()) {
            writer.write(prefixSpaces + actualKey + ": {}");
        } else {
            writer.write(prefixSpaces + actualKey + ":");
        }
        writer.write("\n");
    }

    private static void writeList(List list, String actualKey, String prefixSpaces, Yaml yaml, BufferedWriter writer) throws IOException {
        writer.write(ConfigUpdater.getListAsString(list, actualKey, prefixSpaces, yaml));
    }

    private static String getListAsString(List list, String actualKey, String prefixSpaces, Yaml yaml) {
        StringBuilder builder = new StringBuilder(prefixSpaces).append(actualKey).append(":");
        if (list.isEmpty()) {
            builder.append(" []\n");
            return builder.toString();
        }
        builder.append("\n");
        for (int i = 0; i < list.size(); ++i) {
            Object o = list.get(i);
            if (o instanceof String) {
                String value = (String)o;
                builder.append(prefixSpaces).append("- ").append(ConfigUpdater.formatStringValue(value));
            } else if (o instanceof Character) {
                builder.append(prefixSpaces).append("- '").append(o).append("'");
            } else if (o instanceof List) {
                builder.append(prefixSpaces).append("- ").append(yaml.dump(o));
            } else {
                builder.append(prefixSpaces).append("- ").append(o);
            }
            if (i == list.size()) continue;
            builder.append("\n");
        }
        return builder.toString();
    }

    private static Map<String, String> parseComments(List<String> lines, List<String> ignoredSections, FileConfiguration oldConfig, Yaml yaml) {
        HashMap<String, String> comments = new HashMap<String, String>();
        StringBuilder builder = new StringBuilder();
        StringBuilder keyBuilder = new StringBuilder();
        int lastLineIndentCount = 0;
        block0: for (String line : lines) {
            if (line != null && line.trim().startsWith("-")) continue;
            if (line == null || line.trim().equals("") || line.trim().startsWith("#")) {
                builder.append(line).append("\n");
                continue;
            }
            lastLineIndentCount = ConfigUpdater.setFullKey(keyBuilder, line, lastLineIndentCount);
            for (String ignoredSection : ignoredSections) {
                if (!keyBuilder.toString().equals(ignoredSection)) continue;
                Object value = oldConfig.get(keyBuilder.toString());
                if (!(value instanceof ConfigurationSection)) continue block0;
                ConfigUpdater.appendSection(builder, (ConfigurationSection)value, new StringBuilder(ConfigUpdater.getPrefixSpaces(lastLineIndentCount)), yaml);
                continue block0;
            }
            if (keyBuilder.length() <= 0) continue;
            comments.put(keyBuilder.toString(), builder.toString());
            builder.setLength(0);
        }
        if (builder.length() > 0) {
            comments.put(null, builder.toString());
        }
        return comments;
    }

    private static void appendSection(StringBuilder builder, ConfigurationSection section, StringBuilder prefixSpaces, Yaml yaml) {
        builder.append((CharSequence)prefixSpaces).append(ConfigUpdater.getKeyFromFullKey(section.getCurrentPath())).append(":");
        Set keys = section.getKeys(false);
        if (keys.isEmpty()) {
            builder.append(" {}\n");
            return;
        }
        builder.append("\n");
        prefixSpaces.append("  ");
        for (String key : keys) {
            Object value = section.get(key);
            String actualKey = ConfigUpdater.getKeyFromFullKey(key);
            if (value instanceof ConfigurationSection) {
                ConfigUpdater.appendSection(builder, (ConfigurationSection)value, prefixSpaces, yaml);
                prefixSpaces.setLength(prefixSpaces.length() - 2);
                continue;
            }
            if (value instanceof List) {
                builder.append(ConfigUpdater.getListAsString((List)value, actualKey, prefixSpaces.toString(), yaml));
                continue;
            }
            builder.append(prefixSpaces.toString()).append(actualKey).append(": ").append(yaml.dump(value));
        }
    }

    private static int countIndents(String s) {
        int spaces = 0;
        for (char c : s.toCharArray()) {
            if (c != ' ') break;
            ++spaces;
        }
        return spaces / 2;
    }

    private static void removeLastKey(StringBuilder keyBuilder) {
        String temp = keyBuilder.toString();
        String[] keys = temp.split("\\.");
        if (keys.length == 1) {
            keyBuilder.setLength(0);
            return;
        }
        temp = temp.substring(0, temp.length() - keys[keys.length - 1].length() - 1);
        keyBuilder.setLength(temp.length());
    }

    private static String getKeyFromFullKey(String fullKey) {
        String[] keys = fullKey.split("\\.");
        return keys[keys.length - 1];
    }

    private static int setFullKey(StringBuilder keyBuilder, String configLine, int lastLineIndentCount) {
        int currentIndents = ConfigUpdater.countIndents(configLine);
        String key = configLine.trim().split(":")[0];
        if (keyBuilder.length() == 0) {
            keyBuilder.append(key);
        } else if (currentIndents == lastLineIndentCount) {
            ConfigUpdater.removeLastKey(keyBuilder);
            if (keyBuilder.length() > 0) {
                keyBuilder.append(".");
            }
            keyBuilder.append(key);
        } else if (currentIndents > lastLineIndentCount) {
            keyBuilder.append(".").append(key);
        } else {
            int difference = lastLineIndentCount - currentIndents;
            for (int i = 0; i < difference + 1; ++i) {
                ConfigUpdater.removeLastKey(keyBuilder);
            }
            if (keyBuilder.length() > 0) {
                keyBuilder.append(".");
            }
            keyBuilder.append(key);
        }
        return currentIndents;
    }

    private static String getPrefixSpaces(int indents) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < indents; ++i) {
            builder.append("  ");
        }
        return builder.toString();
    }

    private static void appendPrefixSpaces(StringBuilder builder, int indents) {
        builder.append(ConfigUpdater.getPrefixSpaces(indents));
    }

    private static String formatStringValue(String value) {
        if (value.contains("'") || value.contains("\"")) {
            return "'" + value.replace("'", "''") + "'";
        }
        return "'" + value + "'";
    }
}

