/*
 * Decompiled with CFR 0.152.
 */
package me.bkrmt.bkteleport.bkcore.config;

import java.io.File;
import java.util.concurrent.ConcurrentHashMap;
import me.bkrmt.bkteleport.bkcore.BkPlugin;
import me.bkrmt.bkteleport.bkcore.Utils;
import me.bkrmt.bkteleport.bkcore.config.ConfigType;
import me.bkrmt.bkteleport.bkcore.config.Configuration;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class ConfigManager {
    private final ConcurrentHashMap<String, Configuration> configs;
    private final BkPlugin plugin;
    private final String DATA_FOLDER;

    public ConfigManager(BkPlugin plugin) {
        this.plugin = plugin;
        this.configs = new ConcurrentHashMap();
        this.DATA_FOLDER = plugin.getDataFolder().getPath();
        File configFile = plugin.getFile("", "config.yml");
        Configuration config = new Configuration(plugin, configFile, ConfigType.Config);
        if (!config.getFile().exists()) {
            config.saveToFile();
        } else if (config.getFile().exists() && config.getFile().length() == 0L) {
            config.saveToFile();
        }
        this.addConfig(config);
        this.startModifiedChecker();
    }

    private void startModifiedChecker() {
        new BukkitRunnable(){

            public void run() {
                if (ConfigManager.this.configs.size() > 0) {
                    for (Configuration config : ConfigManager.this.configs.values()) {
                        long currentTimeStamp;
                        if (!config.getFile().exists() || (currentTimeStamp = config.getFile().lastModified()) == config.getTimeStamp()) continue;
                        config.setTimeStamp(currentTimeStamp);
                        config.loadFromFile();
                    }
                }
            }
        }.runTaskTimerAsynchronously((Plugin)this.plugin, 0L, 10L);
    }

    public Configuration getConfig() {
        return this.getConfig("config.yml");
    }

    public Configuration getConfig(String name) {
        return this.getConfig(this.DATA_FOLDER, name);
    }

    public Configuration getConfig(String path, String name) {
        Configuration returnConfig;
        String temp = path;
        if (!path.equals(this.DATA_FOLDER)) {
            path = this.DATA_FOLDER + File.separatorChar + path;
        }
        if (this.configs.size() > 0 && (returnConfig = this.configs.get(name + "@" + path)) != null) {
            return returnConfig;
        }
        File existingFile = this.plugin.getFile(temp, name);
        if (existingFile.exists()) {
            Configuration cachedConfig = new Configuration(this.plugin, existingFile);
            this.addConfig(cachedConfig);
            return cachedConfig;
        }
        return null;
    }

    public void addConfig(Configuration config) {
        this.configs.put(config.getFile().getName() + "@" + Utils.getCleanPath(config.getFile()), config);
    }

    public void removeConfig(String path, String name) {
        if (!path.equals(this.DATA_FOLDER)) {
            path = this.DATA_FOLDER + File.separatorChar + path;
        }
        this.configs.remove(name + "@" + path);
    }

    public boolean containsConfig(String name) {
        return this.containsConfig(this.DATA_FOLDER, name);
    }

    public boolean containsConfig(String path, String name) {
        if (!path.equals(this.DATA_FOLDER)) {
            path = this.DATA_FOLDER + File.separatorChar + path;
        }
        return this.configs.containsKey(name + "@" + path);
    }

    public BkPlugin getPlugin() {
        return this.plugin;
    }

    public void reloadConfigs() {
        for (Configuration config : this.configs.values()) {
            if (config.getType() == ConfigType.Player_Data) continue;
            config.loadFromFile();
        }
    }

    public void saveConfigs() {
        try {
            for (Configuration config : this.configs.values()) {
                if (config == null || !config.getFile().exists()) continue;
                config.saveToFile();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void loadAllConfigs() {
        File[] pluginFiles = this.plugin.getDataFolder().listFiles();
        if (pluginFiles.length > 0) {
            for (File file : pluginFiles) {
                if (!file.getName().endsWith(".yml") || file.getName().equalsIgnoreCase("config.yml") || file.getPath().contains("lang")) continue;
                this.addConfig(new Configuration(this.plugin, file, ConfigType.Config));
            }
        }
    }
}

