/*
 * Decompiled with CFR 0.152.
 */
package me.bkrmt.bkteleport.bkcore.command;

import java.util.Iterator;
import me.bkrmt.bkteleport.bkcore.BkPlugin;
import me.bkrmt.bkteleport.bkcore.Utils;
import me.bkrmt.bkteleport.bkcore.message.InternalMessages;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;

public abstract class Executor
implements CommandExecutor {
    private final String name;
    private final String description;
    private final String usage;
    private final String permission;
    private final BkPlugin plugin;
    private final String langKey;
    private final String permissionMessage;

    public Executor(BkPlugin plugin, String langKey, String permission) {
        this.plugin = plugin;
        this.langKey = langKey;
        this.name = plugin.getLangFile().get("commands." + langKey + ".command");
        this.description = plugin.getLangFile().get("commands." + langKey + ".description");
        this.usage = plugin.getLangFile().get("commands." + langKey + ".usage");
        this.permissionMessage = plugin.getLangFile().get("error.no-permission");
        this.permission = permission;
    }

    public String getLangKey() {
        return this.langKey;
    }

    public BkPlugin getPlugin() {
        return this.plugin;
    }

    public boolean blockConsole(CommandSender sender, String prefix) {
        if (!(sender instanceof Player)) {
            String message = InternalMessages.NO_CONSOLE_SENDER.getMessage(this.plugin).replace("{0}", Utils.translateColor(prefix));
            this.plugin.sendConsoleMessage(message);
            return true;
        }
        return false;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getUsage() {
        return this.usage;
    }

    public final void sendUsage(CommandSender sender) {
        ConfigurationSection section = this.plugin.getLangFile().getConfig().getConfigurationSection("commands." + this.langKey + ".subcommands");
        if (section != null) {
            StringBuilder subCommands = new StringBuilder();
            Iterator it = section.getKeys(false).iterator();
            while (it.hasNext()) {
                subCommands.append(section.getString((String)it.next() + ".command"));
                if (!it.hasNext()) continue;
                subCommands.append(" | ");
            }
            sender.sendMessage(this.plugin.getLangFile().get("commands.usage-format").replace("{usage}", this.getUsage()).replace("{subcommands}", subCommands.toString()));
        } else {
            sender.sendMessage(this.plugin.getLangFile().get("commands.usage-format").replace("{usage}", this.getUsage()));
        }
    }

    public String getPermissionMessage() {
        return this.permissionMessage;
    }

    public boolean hasPermission(CommandSender sender) {
        return !(sender instanceof Player) || sender.hasPermission(this.getPermission());
    }

    public boolean hasPermission(CommandSender sender, String sub) {
        String perm = this.permission + "." + sub;
        return sender.hasPermission(perm) || !(sender instanceof Player);
    }

    public String getPermission() {
        return this.permission;
    }
}

