/*
 * Decompiled with CFR 0.152.
 */
package me.bkrmt.bkteleport.bkcore.command;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.Hashtable;
import java.util.Set;
import me.bkrmt.bkteleport.bkcore.BkPlugin;
import me.bkrmt.bkteleport.bkcore.command.CommandModule;
import org.apache.commons.lang.reflect.FieldUtils;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandMap;
import org.bukkit.command.PluginCommand;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.SimplePluginManager;

public class CommandMapper {
    private final BkPlugin plugin;
    private final Hashtable<String, PluginCommand> commands;

    public CommandMapper(BkPlugin plugin) {
        this.plugin = plugin;
        this.commands = new Hashtable();
    }

    public final CommandMapper addCommand(CommandModule command) {
        this.commands.put(command.getCommand().getName(), command.getCommand());
        return this;
    }

    public final void register(String commandName) {
        CommandMap commandMap = this.getCommandMapInstance();
        commandMap.register(this.plugin.getDescription().getName(), (Command)this.commands.get(commandName));
        if (this.plugin.hasHandler()) {
            this.plugin.buildHandler();
        }
    }

    public final void registerAll() {
        Set<String> keys = this.commands.keySet();
        CommandMap commandMap = this.getCommandMapInstance();
        for (String key : keys) {
            if (commandMap == null) continue;
            commandMap.register(this.plugin.getDescription().getName(), (Command)this.commands.get(key));
        }
        if (this.plugin.hasHandler()) {
            this.plugin.buildHandler();
        }
    }

    public final CommandMap getCommandMapInstance() {
        if (Bukkit.getPluginManager() instanceof SimplePluginManager) {
            SimplePluginManager spm = (SimplePluginManager)Bukkit.getPluginManager();
            try {
                Field field = FieldUtils.getDeclaredField(spm.getClass(), (String)"commandMap", (boolean)true);
                return (CommandMap)field.get(spm);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException("Can't get the Bukkit CommandMap instance.");
            }
        }
        return null;
    }

    public final PluginCommand createPluginCommand(String name) {
        try {
            Constructor constructor = PluginCommand.class.getDeclaredConstructor(String.class, Plugin.class);
            constructor.setAccessible(true);
            return (PluginCommand)constructor.newInstance(new Object[]{name, this.plugin});
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            e.printStackTrace();
            return null;
        }
    }
}

