/*
 * Decompiled with CFR 0.152.
 */
package me.bkrmt.bkteleport.bkcore;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Array;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.Set;
import java.util.stream.Collectors;
import me.bkrmt.bkteleport.bkcore.BkPlugin;
import org.apache.commons.lang.StringUtils;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Color;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.LeatherArmorMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.permissions.PermissionAttachmentInfo;
import org.bukkit.util.io.BukkitObjectInputStream;
import org.bukkit.util.io.BukkitObjectOutputStream;
import org.yaml.snakeyaml.external.biz.base64Coder.Base64Coder;

public class Utils {
    public static String addHashCode(String string, int hashCode) {
        return !string.contains("@") ? string + "@" + Integer.toHexString(hashCode) : string;
    }

    public static <T> T[] concatenate(T[] a, T[] b) {
        int aLen = a.length;
        int bLen = b.length;
        Object[] c = (Object[])Array.newInstance(a.getClass().getComponentType(), aLen + bLen);
        System.arraycopy(a, 0, c, 0, aLen);
        System.arraycopy(b, 0, c, aLen, bLen);
        return c;
    }

    public static <T, E> Set<T> getKeysByValue(Map<T, E> map, E value) {
        return map.entrySet().stream().filter(entry -> Objects.equals(entry.getValue(), value)).map(Map.Entry::getKey).collect(Collectors.toSet());
    }

    public static int intFromPermission(Player player, String permission, String[] bypassPermissions) {
        if (player.isOp()) {
            return 0;
        }
        if (bypassPermissions != null) {
            for (String perm : bypassPermissions) {
                if (!player.hasPermission(perm)) continue;
                return 0;
            }
        }
        return (int)Utils.doubleFromPermission(player, permission);
    }

    public static String joinStringArray(String[] args) {
        StringBuilder argBuilder = new StringBuilder();
        for (String arg : args) {
            if (argBuilder.toString().isEmpty()) {
                argBuilder.append(arg);
                continue;
            }
            argBuilder.append(" ").append(arg);
        }
        String fullArg = argBuilder.toString();
        return fullArg;
    }

    public static String getCleanPath(File file) {
        return file.getPath().replace(File.separatorChar + file.getName(), "");
    }

    public static String capitalize(String line) {
        char[] chars = line.toLowerCase().toCharArray();
        boolean found = false;
        for (int i = 0; i < chars.length; ++i) {
            if (!found && Character.isLetter(chars[i])) {
                chars[i] = Character.toUpperCase(chars[i]);
                found = true;
                continue;
            }
            if (!Character.isWhitespace(chars[i]) && chars[i] != '.' && chars[i] != '\'') continue;
            found = false;
        }
        return String.valueOf(chars);
    }

    public static double doubleFromPermission(Player player, String permission) {
        if (player.isOp()) {
            return 0.0;
        }
        for (PermissionAttachmentInfo pio : player.getEffectivePermissions()) {
            String ending;
            String perm = pio.getPermission();
            if (!perm.startsWith(permission) || !StringUtils.isNumeric((String)(ending = perm.substring(perm.lastIndexOf(".")).replace(".", "")))) continue;
            return Double.parseDouble(ending);
        }
        return 5.0;
    }

    public static String itemStackArrayToBase64(ItemStack[] items) throws IllegalStateException {
        try {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            BukkitObjectOutputStream dataOutput = new BukkitObjectOutputStream((OutputStream)outputStream);
            dataOutput.writeInt(items.length);
            for (ItemStack item : items) {
                dataOutput.writeObject((Object)item);
            }
            dataOutput.close();
            return Base64Coder.encodeLines((byte[])outputStream.toByteArray());
        }
        catch (Exception e) {
            throw new IllegalStateException("Unable to save item stacks.", e);
        }
    }

    public static String[] playerInventoryToBase64(PlayerInventory playerInventory) throws IllegalStateException {
        String content = Utils.toBase64((Inventory)playerInventory);
        String armor = Utils.itemStackArrayToBase64(playerInventory.getArmorContents());
        return new String[]{content, armor};
    }

    public static Inventory fromBase64(String data) throws IOException {
        try {
            ByteArrayInputStream inputStream = new ByteArrayInputStream(Base64Coder.decodeLines((String)data));
            BukkitObjectInputStream dataInput = new BukkitObjectInputStream((InputStream)inputStream);
            Inventory inventory = Bukkit.getServer().createInventory(null, dataInput.readInt());
            for (int i = 0; i < inventory.getSize(); ++i) {
                inventory.setItem(i, (ItemStack)dataInput.readObject());
            }
            dataInput.close();
            return inventory;
        }
        catch (ClassNotFoundException e) {
            throw new IOException("Unable to decode class type.", e);
        }
    }

    public static String toBase64(Inventory inventory) throws IllegalStateException {
        try {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            BukkitObjectOutputStream dataOutput = new BukkitObjectOutputStream((OutputStream)outputStream);
            dataOutput.writeInt(inventory.getSize());
            for (int i = 0; i < inventory.getSize(); ++i) {
                dataOutput.writeObject((Object)inventory.getItem(i));
            }
            dataOutput.close();
            return Base64Coder.encodeLines((byte[])outputStream.toByteArray());
        }
        catch (Exception e) {
            throw new IllegalStateException("Unable to save item stacks.", e);
        }
    }

    public static ItemStack[] itemStackArrayFromBase64(String data) throws IOException {
        try {
            ByteArrayInputStream inputStream = new ByteArrayInputStream(Base64Coder.decodeLines((String)data));
            BukkitObjectInputStream dataInput = new BukkitObjectInputStream((InputStream)inputStream);
            ItemStack[] items = new ItemStack[dataInput.readInt()];
            for (int i = 0; i < items.length; ++i) {
                items[i] = (ItemStack)dataInput.readObject();
            }
            dataInput.close();
            return items;
        }
        catch (ClassNotFoundException e) {
            throw new IOException("Unable to decode class type.", e);
        }
    }

    public static String cleanName(String name) {
        name = ChatColor.stripColor((String)name);
        name = name.replace("0", "").replace("1", "").replace("2", "").replace("3", "").replace("4", "").replace("5", "").replace("6", "").replace("7", "").replace("8", "").replace("9", "").replace("{", "").replace("}", "").replace("/", "").replace("\\", "").replace("'", "").replace("-", "").replace("+", "").replace("currentpage", "").replace("totalpages", "").trim();
        return name;
    }

    public static boolean isValidColor(String string) {
        if (string.length() != 1) {
            return false;
        }
        char color = string.charAt(0);
        return color == 'a' || color == 'b' || color == 'c' || color == 'd' || color == 'e' || color == 'f' || Character.isDigit(color);
    }

    public static void sendPacket(Player player, Object packet) {
        try {
            Object handle = player.getClass().getMethod("getHandle", new Class[0]).invoke((Object)player, new Object[0]);
            Object playerConnection = handle.getClass().getField("playerConnection").get(handle);
            playerConnection.getClass().getMethod("sendPacket", Utils.getNMSClass("Packet")).invoke(playerConnection, packet);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static Class<?> getNMSClass(String name) {
        String version = Bukkit.getServer().getClass().getPackage().getName().split("\\.")[3];
        try {
            return Class.forName("net.minecraft.server." + version + "." + name);
        }
        catch (ClassNotFoundException exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public static String capsFirst(String message) {
        String result = message.toLowerCase();
        char firstLetter = message.charAt(0);
        result = result.replaceFirst(String.valueOf(Character.toLowerCase(firstLetter)), String.valueOf(Character.toUpperCase(firstLetter)));
        return result;
    }

    public static int getRandomInRange(int min, int max) {
        return (int)(Math.random() * (double)(max - min) + (double)min);
    }

    public static String randomColor() {
        return Utils.randomColor(false);
    }

    public static String randomColor(boolean blackAndWhite) {
        int colorInt = 0;
        if (blackAndWhite) {
            colorInt = new Random().nextInt(16);
        } else {
            colorInt = new Random().nextInt(15);
            while (colorInt == 0) {
                colorInt = new Random().nextInt(14);
            }
        }
        String color = colorInt == 10 ? "a" : (colorInt == 11 ? "b" : (colorInt == 12 ? "c" : (colorInt == 13 ? "d" : (colorInt == 14 ? "e" : (colorInt == 15 ? "f" : Integer.toString(colorInt))))));
        return color;
    }

    public static Player getPlayer(CommandSender commandSender) {
        return Utils.getPlayer(commandSender.getName());
    }

    public static Player getPlayer(String playerName) {
        return Bukkit.getServer().getPlayer(playerName);
    }

    public static String[] objectToString(Object[] objects) {
        String[] argsString = new String[objects.length];
        for (int i = 0; i <= objects.length - 1; ++i) {
            argsString[i] = objects[i].toString();
        }
        return argsString;
    }

    public static ItemStack createItem(BkPlugin plugin, String name, Material material, Object ... lore) {
        ArrayList<String> loreList = new ArrayList<String>();
        Collections.addAll(loreList, Utils.objectToString(lore));
        return Utils.createItem(plugin, name, material, loreList);
    }

    public static ItemStack getOnCoordinate(Inventory menu, int line, int colum) {
        for (int c = 0; c < menu.getSize() / 9; ++c) {
            int start = 9 * c;
            int end = start + 8;
            int i = start;
            while (i <= end) {
                for (int col = 0; col < 9; ++col) {
                    if (c == line - 1 && col == colum - 1) {
                        return menu.getItem(i);
                    }
                    ++i;
                }
            }
        }
        return null;
    }

    public static void setOnCoordinate(Inventory menu, ItemStack item, int line, int colum) {
        for (int c = 0; c < menu.getSize() / 9; ++c) {
            int start = 9 * c;
            int end = start + 8;
            int i = start;
            while (i <= end) {
                for (int col = 0; col < 9; ++col) {
                    if (c == line - 1 && col == colum - 1) {
                        menu.setItem(i, item);
                        return;
                    }
                    ++i;
                }
            }
        }
    }

    public static ItemStack createItem(Material material, boolean hideAttributes, String displayName, List<String> newLore) {
        return Utils.createItem(new ItemStack(material), hideAttributes, displayName, newLore);
    }

    public static ItemStack createItem(ItemStack item, boolean hideAttributes, String displayName, List<String> newLore) {
        ItemMeta tempMeta = item.getItemMeta();
        if (hideAttributes) {
            tempMeta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ATTRIBUTES});
        }
        ArrayList<String> tempLore = new ArrayList<String>();
        for (String line : newLore) {
            tempLore.add(Utils.translateColor(line));
        }
        tempMeta.setLore(tempLore);
        tempMeta.setDisplayName(displayName);
        item.setItemMeta(tempMeta);
        return item;
    }

    public static ItemStack getColoredLeather(Material leatherPiece, Color color, boolean hideAttributes, String displayName, List<String> lore) {
        ItemStack item = Utils.createItem(leatherPiece, hideAttributes, displayName, lore);
        LeatherArmorMeta meta = (LeatherArmorMeta)item.getItemMeta();
        meta.setDisplayName(displayName);
        meta.setColor(color);
        item.setItemMeta((ItemMeta)meta);
        return item;
    }

    public static String cleanString(String string) {
        return Normalizer.normalize(string, Normalizer.Form.NFD).replaceAll("[^\\p{ASCII}]", "");
    }

    public static String translateColor(String message) {
        return ChatColor.translateAlternateColorCodes((char)'&', (String)message);
    }

    public static ItemStack createItem(BkPlugin plugin, String name, Material material, ArrayList<String> lore) {
        ItemStack item = null;
        if (ChatColor.stripColor((String)name).contains(ChatColor.stripColor((String)plugin.getLangFile().get("info.next-name"))) || ChatColor.stripColor((String)name).contains(ChatColor.stripColor((String)plugin.getLangFile().get("info.return-name")))) {
            item = ChatColor.stripColor((String)name).contains(ChatColor.stripColor((String)plugin.getLangFile().get("info.next-name"))) ? plugin.getHandler().getItemManager().getGreenPane() : plugin.getHandler().getItemManager().getRedPane();
        } else if (material.equals((Object)plugin.getHandler().getItemManager().getHead().getType())) {
            item = plugin.getHandler().getItemManager().getHead();
            SkullMeta headMeta = (SkullMeta)item.getItemMeta();
            headMeta = plugin.getHandler().getMethodManager().setHeadOwner(headMeta, plugin.getServer().getOfflinePlayer(ChatColor.stripColor((String)name)));
            headMeta.setDisplayName(name);
            if (!lore.isEmpty()) {
                headMeta.setLore(lore);
            }
            headMeta.setLore(lore);
            if (plugin.getNmsVer().number > 7) {
                headMeta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ATTRIBUTES});
            }
            item.setItemMeta((ItemMeta)headMeta);
            return item;
        }
        if (item == null) {
            item = new ItemStack(material, 1);
        }
        ItemMeta itemMeta = item.getItemMeta();
        itemMeta.setDisplayName(name.trim());
        if (!lore.isEmpty()) {
            itemMeta.setLore(lore);
        }
        if (plugin.getNmsVer().number > 7) {
            itemMeta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ATTRIBUTES});
        }
        item.setItemMeta(itemMeta);
        return item;
    }
}

