/*
 * Decompiled with CFR 0.152.
 */
package me.bkrmt.bkteleport.bkcore;

import java.util.concurrent.TimeUnit;

public class Time {
    private final long milliseconds;
    private final long seconds;
    private final long minutes;
    private final long hours;
    private final long days;

    public Time(long milliseconds) {
        this.milliseconds = milliseconds;
        this.seconds = TimeUnit.MILLISECONDS.toSeconds(milliseconds);
        this.minutes = TimeUnit.MILLISECONDS.toMinutes(milliseconds);
        this.hours = TimeUnit.MILLISECONDS.toHours(milliseconds);
        this.days = TimeUnit.MILLISECONDS.toDays(milliseconds);
    }

    public String getFormatedTime() {
        return String.format("%s:%s:%s", this.getHours() < 10L ? "0" + this.getHours() : Long.valueOf(this.getHours()), this.getMinutes() < 10L ? "0" + this.getMinutes() : Long.valueOf(this.getMinutes()), this.getSeconds() < 10L ? "0" + this.getSeconds() : Long.valueOf(this.getSeconds()));
    }

    public long getMilliseconds() {
        return this.milliseconds;
    }

    public long getSeconds() {
        return this.seconds;
    }

    public long getMinutes() {
        return this.minutes;
    }

    public long getHours() {
        return this.hours;
    }

    public long getDays() {
        return this.days;
    }

    public static Time ticksToTime(long ticks) {
        long milliseconds = 50L * ticks;
        return new Time(milliseconds);
    }
}

