/*
 * Decompiled with CFR 0.152.
 */
package me.bkrmt.bkteleport.bkcore;

import java.util.ArrayList;
import java.util.List;
import me.bkrmt.bkteleport.bkcore.BkPlugin;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;

public class ItemManager {
    public static ItemStack setNameAndLore(ItemStack item, String name, String ... lore) {
        ItemMeta im = item.getItemMeta();
        im.setDisplayName(name);
        ArrayList<String> il = new ArrayList<String>();
        for (String l : lore) {
            il.add(l);
        }
        im.setLore(il);
        item.setItemMeta(im);
        return item;
    }

    public static ItemStack setNameAndLore(ItemStack item, String name, List<String> il) {
        ItemMeta im = item.getItemMeta();
        im.setDisplayName(name);
        im.setLore(il);
        item.setItemMeta(im);
        return item;
    }

    public static ItemStack setNameAndLoreAndEnchants(ItemStack item, String name, List<String> il, List<String> enchants) {
        ItemMeta im = item.getItemMeta();
        im.setDisplayName(name);
        im.setLore(il);
        for (String enchant : enchants) {
            String[] part = enchant.split(":");
            im.addEnchant(Enchantment.getByName((String)part[0]), Integer.getInteger(part[1]).intValue(), true);
        }
        item.setItemMeta(im);
        return item;
    }

    public static ItemStack setName(ItemStack item, String name) {
        ItemMeta im = item.getItemMeta();
        im.setDisplayName(name);
        item.setItemMeta(im);
        return item;
    }

    public static ItemStack setLore(ItemStack item, String ... lore) {
        ItemMeta im = item.getItemMeta();
        ArrayList<String> il = new ArrayList<String>();
        for (String l : lore) {
            il.add(l);
        }
        im.setLore(il);
        item.setItemMeta(im);
        return item;
    }

    public static ItemStack setLore(ItemStack item, List<String> lore) {
        ItemMeta im = item.getItemMeta();
        ArrayList<String> il = new ArrayList<String>();
        for (String l : lore) {
            il.add(l);
        }
        im.setLore(il);
        item.setItemMeta(im);
        return item;
    }

    public static ItemStack stripLore(BkPlugin plugin, ItemStack item) {
        if (item.getType().equals((Object)plugin.getHandler().getItemManager().getHead().getType())) {
            SkullMeta meta = (SkullMeta)item.getItemMeta();
            ArrayList lore = new ArrayList();
            meta.setLore(lore);
            item.setItemMeta((ItemMeta)meta);
            return item;
        }
        ItemMeta meta = item.getItemMeta();
        ArrayList lore = new ArrayList();
        meta.setLore(lore);
        item.setItemMeta(meta);
        return item;
    }

    public static boolean isEqual(BkPlugin plugin, ItemStack item1, ItemStack item2) {
        return ItemManager.stripLore(plugin, item1).equals((Object)ItemManager.stripLore(plugin, item2));
    }

    public static ItemStack setUnbreakable(ItemStack itemStack) {
        ItemMeta meta = itemStack.getItemMeta();
        meta.setUnbreakable(true);
        itemStack.setItemMeta(meta);
        return itemStack;
    }
}

