/*
 * Decompiled with CFR 0.152.
 */
package me.bkrmt.bkteleport.bkcore;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.logging.Level;
import me.bkrmt.bkteleport.bkcore.NMSVersion;
import me.bkrmt.bkteleport.bkcore.Utils;
import me.bkrmt.bkteleport.bkcore.actionbar.ActionBar;
import me.bkrmt.bkteleport.bkcore.command.CommandMapper;
import me.bkrmt.bkteleport.bkcore.config.ConfigManager;
import me.bkrmt.bkteleport.bkcore.message.InternalMessages;
import me.bkrmt.bkteleport.bkcore.message.LangFile;
import me.bkrmt.bkteleport.bkcore.textanimator.AnimatorManager;
import me.bkrmt.bkteleport.bkcore.title.Title;
import me.bkrmt.bkteleport.nms.api.NMS;
import net.md_5.bungee.api.ChatMessageType;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.ChatColor;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public abstract class BkPlugin
extends JavaPlugin {
    private CommandMapper commandMapper;
    private ConfigManager configManager;
    private LangFile langFile;
    private NMSVersion nmsVersion;
    private NMS nmsApi;
    private boolean hasHandler = false;
    private ArrayList<String> langList;
    private boolean running;

    public final CommandMapper start() {
        return this.start(false);
    }

    public final CommandMapper start(boolean hasHandler) {
        try {
            this.configManager = new ConfigManager(this);
            this.hasHandler = hasHandler;
            if (this.langList == null) {
                this.langList = new ArrayList();
            }
            this.langList.add("en_US");
            this.langList.add("pt_BR");
            this.running = false;
            this.langFile = new LangFile(this, this.langList);
            this.commandMapper = new CommandMapper(this);
            this.nmsVersion = new NMSVersion();
            if (this.nmsVersion.number <= 7) {
                this.getServer().getLogger().log(Level.SEVERE, InternalMessages.INCOMPATIBLE_VERSION.getMessage());
            }
            return this.getCommandMapper();
        }
        catch (Exception ignored) {
            return null;
        }
    }

    public final void addLanguage(String language) {
        if (this.langList == null) {
            this.langList = new ArrayList();
        }
        this.langList.add(language);
    }

    public final CommandMapper getCommandMapper() {
        return this.commandMapper;
    }

    public final File getFile(String filePath, String fileName) {
        if (!filePath.equals(this.getDataFolder().getPath())) {
            filePath = this.getDataFolder().getPath() + File.separatorChar + filePath;
        }
        File configPath = new File(filePath);
        return new File(configPath, fileName);
    }

    public final NMSVersion getNmsVer() {
        return this.nmsVersion;
    }

    public final void callEvent(Event event) {
        this.getServer().getPluginManager().callEvent(event);
    }

    public LangFile getLangFile() {
        return this.langFile;
    }

    public final NMS getHandler() {
        return this.nmsApi;
    }

    public final boolean isRunning() {
        return this.running;
    }

    public final void sendConsoleMessage(String message) {
        this.getServer().getConsoleSender().sendMessage(message);
    }

    public final void sendStartMessage(String prefix) {
        String message = Utils.translateColor(InternalMessages.PLUGIN_START.getMessage(this).replace("{0}", prefix));
        this.getServer().getConsoleSender().sendMessage(message);
    }

    public boolean containsResource(String resource) {
        return this.getResource(resource) != null;
    }

    public FileConfiguration getConfig() {
        return null;
    }

    public ConfigManager getConfigManager() {
        return this.configManager;
    }

    public boolean hasPlaceholderHook() {
        Plugin papi = this.getServer().getPluginManager().getPlugin("PlaceholderAPI");
        return papi != null && papi.isEnabled();
    }

    public AnimatorManager getAnimatorManager() {
        return null;
    }

    public final void setRunning(boolean running) {
        this.running = running;
    }

    public final void sendTitle(Player player, Integer fadeIn, Integer stay, Integer fadeOut, String title, String subtitle) {
        if (this.getNmsVer().number == 8) {
            this.getHandler().getTitleManager().sendTitle(player, fadeIn, stay, fadeOut, title, subtitle);
        } else if (this.getNmsVer().number > 8 && this.getNmsVer().number < 17) {
            new Title(this).sendTitle(player, fadeIn, stay, fadeOut, title, subtitle);
        } else {
            player.sendTitle(title, subtitle, fadeIn.intValue(), stay.intValue(), fadeOut.intValue());
        }
    }

    public final void sendActionBar(Player player, String message) {
        if (this.getNmsVer().number < 13) {
            new ActionBar(this, player).sendActionBar(message);
        } else {
            player.spigot().sendMessage(ChatMessageType.ACTION_BAR, TextComponent.fromLegacyText((String)message));
        }
    }

    public final boolean hasHandler() {
        return this.hasHandler;
    }

    public ItemStack createHead(UUID owner, String name, List<String> lore) {
        ItemStack item = this.getHandler().getItemManager().getHead();
        SkullMeta headMeta = (SkullMeta)item.getItemMeta();
        headMeta = this.getHandler().getMethodManager().setHeadOwner(headMeta, this.getServer().getOfflinePlayer(owner));
        headMeta.setDisplayName(name);
        if (!lore.isEmpty()) {
            headMeta.setLore(lore);
        }
        headMeta.setLore(lore);
        if (this.getNmsVer().number > 7) {
            headMeta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ATTRIBUTES});
        }
        item.setItemMeta((ItemMeta)headMeta);
        return item;
    }

    public final void buildHandler() {
        String apiVersion;
        switch (this.getNmsVer().number) {
            default: {
                this.sendConsoleMessage(ChatColor.RED + "-----------------------WARNING-------------------------");
                this.sendConsoleMessage(ChatColor.RED + this.getName() + " does not support this minecraft version.");
                this.sendConsoleMessage(ChatColor.RED + "The plugin will start with support for the version 1.14");
                this.sendConsoleMessage(ChatColor.RED + "but you will probably find problems.");
                this.sendConsoleMessage(ChatColor.RED + "Look for an update in: URL");
                this.sendConsoleMessage(ChatColor.RED + "-----------------------WARNING-------------------------");
                apiVersion = "me.bkrmt.bkteleport.nms.v1_14_R1.NMSHandler";
                break;
            }
            case 8: {
                apiVersion = "me.bkrmt.bkteleport.nms." + this.getNmsVer().full + ".NMSHandler";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                apiVersion = "me.bkrmt.bkteleport.nms.v1_9_R1.NMSHandler";
                break;
            }
            case 13: {
                apiVersion = "me.bkrmt.bkteleport.nms.v1_13_R1.NMSHandler";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                apiVersion = "me.bkrmt.bkteleport.nms.v1_14_R1.NMSHandler";
            }
        }
        try {
            if (this.running) {
                this.nmsApi = (NMS)Class.forName(apiVersion).getConstructor(new Class[0]).newInstance(new Object[0]);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.getServer().getLogger().log(Level.SEVERE, "The plugin could not be started...");
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
        }
    }
}

