/*
 * Decompiled with CFR 0.152.
 */
package me.bkrmt.bkteleport;

import me.bkrmt.bkteleport.BkTeleport;
import me.bkrmt.bkteleport.RequestType;
import me.bkrmt.bkteleport.bkcore.Utils;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.ComponentBuilder;
import net.md_5.bungee.api.chat.HoverEvent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;

public class TeleportRequest {
    Player senderPlayer;
    Player targetPlayer;
    TextComponent tpaMessage;
    RequestType type;

    public TeleportRequest(Player senderPlayer, Player targetPlayer, RequestType type) {
        this.senderPlayer = senderPlayer;
        this.targetPlayer = targetPlayer;
        this.type = type;
        this.tpaMessage = new TextComponent("");
        this.buildMessage();
    }

    public void sendMessage() {
        this.targetPlayer.spigot().sendMessage((BaseComponent)this.tpaMessage);
    }

    private void buildMessage() {
        String sectionName = this.type.equals((Object)RequestType.Tpa) ? "info.tpa-message" : "info.tpahere-message";
        String[] configSection = Utils.objectToString(BkTeleport.plugin.getLangFile().getConfig().getConfigurationSection(sectionName).getKeys(false).toArray());
        TextComponent buttonAccept = null;
        TextComponent buttonDeny = null;
        block10: for (int x = 0; x < configSection.length; ++x) {
            String hover;
            String tpaReply = "/";
            if (configSection[x].equals("accept-button")) {
                buttonAccept = new TextComponent(BkTeleport.plugin.getLangFile().get(sectionName + "." + configSection[x]));
                tpaReply = tpaReply + "tpaccept " + this.senderPlayer.getName();
                hover = BkTeleport.plugin.getLangFile().get(sectionName + ".accept-hover");
                buttonAccept.setClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, tpaReply));
                buttonAccept.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new ComponentBuilder(hover).create()));
                continue;
            }
            if (configSection[x].equals("deny-button")) {
                buttonDeny = new TextComponent(BkTeleport.plugin.getLangFile().get(sectionName + "." + configSection[x]));
                tpaReply = tpaReply + "tpdeny " + this.senderPlayer.getName();
                hover = BkTeleport.plugin.getLangFile().get(sectionName + ".deny-hover");
                buttonDeny.setClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, tpaReply));
                buttonDeny.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new ComponentBuilder(hover).create()));
                continue;
            }
            if (configSection[x].equals("accept-hover") || configSection[x].equals("deny-hover")) continue;
            switch (configSection[x]) {
                case "message1": {
                    this.tpaMessage.addExtra(BkTeleport.plugin.getLangFile().get(sectionName + "." + configSection[x]).replace("{player}", this.senderPlayer.getName()));
                    this.tpaMessage.addExtra("\n");
                    continue block10;
                }
                case "message2": {
                    String[] temp1 = BkTeleport.plugin.getLangFile().get(sectionName + "." + configSection[x]).split(" ");
                    StringBuilder temp2 = new StringBuilder();
                    for (int c = 0; c < temp1.length; ++c) {
                        if (temp1[c].equals("{accept-button}")) {
                            this.tpaMessage.addExtra(temp2.toString());
                            this.tpaMessage.addExtra((BaseComponent)buttonAccept);
                            this.tpaMessage.addExtra(" ");
                            temp2 = new StringBuilder();
                        } else if (temp1[c].equals("{deny-button}")) {
                            this.tpaMessage.addExtra(temp2.toString());
                            this.tpaMessage.addExtra((BaseComponent)buttonDeny);
                            this.tpaMessage.addExtra(" ");
                            temp2 = new StringBuilder();
                        } else {
                            temp2.append(ChatColor.translateAlternateColorCodes((char)'&', (String)(temp1[c] + " ")));
                        }
                        if (c != temp1.length - 1) continue;
                        this.tpaMessage.addExtra(temp2.toString());
                        this.tpaMessage.addExtra(" ");
                    }
                    this.tpaMessage.addExtra("\n");
                    continue block10;
                }
                case "message3": {
                    this.tpaMessage.addExtra(BkTeleport.plugin.getLangFile().get(sectionName + "." + configSection[x]).replace("{seconds}", String.valueOf(BkTeleport.plugin.getConfigManager().getConfig().getInt("tpa-expiration"))));
                    if (x == configSection.length - 1) continue block10;
                    this.tpaMessage.addExtra("\n");
                    continue block10;
                }
                default: {
                    String message = BkTeleport.plugin.getLangFile().get(sectionName + "." + configSection[x]);
                    if (message.isEmpty()) continue block10;
                    this.tpaMessage.addExtra(message);
                    if (x == configSection.length - 1) continue block10;
                    this.tpaMessage.addExtra("\n");
                }
            }
        }
    }
}

