/*
 * Decompiled with CFR 0.152.
 */
package me.bkrmt.bkteleport;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import me.bkrmt.bkteleport.BkTeleport;
import me.bkrmt.bkteleport.HomeType;
import me.bkrmt.bkteleport.UserType;
import me.bkrmt.bkteleport.bkcore.Utils;
import me.bkrmt.bkteleport.bkcore.config.Configuration;
import me.bkrmt.bkteleport.bkcore.teleport.Teleport;
import me.bkrmt.bkteleport.bkcore.teleport.TeleportType;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.ComponentBuilder;
import net.md_5.bungee.api.chat.HoverEvent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;

public class PluginUtils {
    public static List<String> getList(String name) {
        String[] temp = Utils.objectToString(BkTeleport.plugin.getConfigManager().getConfig().getStringList(name).toArray());
        ArrayList<String> returnValue = new ArrayList<String>();
        for (String temp2 : temp) {
            returnValue.add(temp2.replace("-", ":"));
        }
        return returnValue;
    }

    public static String[] getHomes(Player player) {
        ConfigurationSection section;
        Configuration playerConfig;
        String[] returnValue = new String[]{""};
        if (BkTeleport.plugin.getFile("userdata", player.getUniqueId().toString() + ".yml").exists() && (playerConfig = BkTeleport.plugin.getConfigManager().getConfig("userdata", player.getUniqueId().toString() + ".yml")).getConfigurationSection("homes") != null && (section = playerConfig.getConfigurationSection("homes")).getKeys(false).size() > 0) {
            returnValue = Utils.objectToString(section.getKeys(false).toArray());
        }
        return returnValue;
    }

    public static String[] getWarps() {
        File[] warps;
        String[] returnValue = new String[]{""};
        File warpsFolder = new File(BkTeleport.plugin.getDataFolder().getPath() + File.separator + "warps");
        if (warpsFolder.listFiles().length > 0 && (warps = warpsFolder.listFiles()).length > 0) {
            returnValue = new String[warps.length];
            for (int c = 0; c < warps.length; ++c) {
                returnValue[c] = warps[c].getName().replace(".yml", "");
            }
        }
        return returnValue;
    }

    public static void sendHomes(UserType type, HomeType homeType, File sendHomesFile, CommandSender sender) {
        String noHomeKey;
        String string = noHomeKey = type.equals((Object)UserType.User) ? "error.no-homes" : "error.no-home-spy";
        if (sendHomesFile.exists()) {
            Configuration sendHomes = BkTeleport.plugin.getConfigManager().getConfig("userdata", sendHomesFile.getName());
            if (sendHomes.getConfigurationSection("homes") != null) {
                ConfigurationSection section = sendHomes.getConfigurationSection("homes");
                if (section.getKeys(false).size() > 0 && section.getKeys(false).size() != 1) {
                    PluginUtils.openListMenu(type, homeType, (Player)sender, sendHomes, section);
                } else if (section.getKeys(false).size() == 1) {
                    if (homeType.equals((Object)HomeType.DelHome)) {
                        PluginUtils.openListMenu(type, homeType, (Player)sender, sendHomes, section);
                    } else {
                        int n = 0;
                        String[] keys = Utils.objectToString(section.getKeys(false).toArray());
                        String[] stringArray = keys;
                        int n2 = stringArray.length;
                        if (n < n2) {
                            String key = stringArray[n];
                            if (type.equals((Object)UserType.Spy)) {
                                ((Player)sender).teleport(sendHomes.getLocation("homes." + key));
                            } else {
                                new Teleport(BkTeleport.plugin, sender, key, TeleportType.Home);
                            }
                            return;
                        }
                    }
                } else {
                    sender.sendMessage(BkTeleport.plugin.getLangFile().get(noHomeKey));
                }
            } else {
                sender.sendMessage(BkTeleport.plugin.getLangFile().get(noHomeKey));
            }
        } else {
            sender.sendMessage(BkTeleport.plugin.getLangFile().get(noHomeKey));
        }
    }

    private static void openListMenu(UserType userType, HomeType homeType, Player sender, Configuration config, ConfigurationSection section) {
        String[] keys = Utils.objectToString(section.getKeys(false).toArray());
        int homeAmount = keys.length;
        if (BkTeleport.plugin.getConfigManager().getConfig().getBoolean("home-gui")) {
            Inventory homesMenu = BkTeleport.plugin.getServer().createInventory(null, (int)Math.ceil((double)homeAmount / 9.0) * 9, BkTeleport.plugin.getLangFile().get("info.home-list-title"));
            for (int c = 0; c < homeAmount; ++c) {
                ArrayList<String> lore = new ArrayList<String>();
                if (userType.equals((Object)UserType.User)) {
                    lore.add("/" + BkTeleport.plugin.getLangFile().get("commands.home.command") + " " + keys[c]);
                } else {
                    String playerName = config.getString("player");
                    if (playerName == null) {
                        config.set("player", BkTeleport.plugin.getServer().getOfflinePlayer(UUID.fromString(config.getFile().getName().replace(".yml", ""))).getName());
                        playerName = config.getString("player");
                    }
                    String commandString = homeType.equals((Object)HomeType.Home) ? "commands.home.command" : "commands.delhome.command";
                    lore.add(Utils.translateColor("&7&o/" + BkTeleport.plugin.getLangFile().get(commandString) + " " + playerName + ":" + keys[c]));
                    lore.add(Utils.translateColor(BkTeleport.plugin.getLangFile().get("info.spying").replace("{player}", playerName)));
                }
                homesMenu.setItem(c, Utils.createItem(BkTeleport.plugin, ChatColor.translateAlternateColorCodes((char)'&', (String)("&7&o" + keys[c])), BkTeleport.plugin.getHandler().getItemManager().getBed(), lore));
            }
            sender.openInventory(homesMenu);
        } else {
            String commandString;
            TextComponent line = new TextComponent(Utils.translateColor(BkTeleport.plugin.getLangFile().get("info.home-list.start")));
            int sizeChecker = 0;
            String string = commandString = homeType.equals((Object)HomeType.Home) ? BkTeleport.plugin.getLangFile().get("commands.home.command") : BkTeleport.plugin.getLangFile().get("commands.delhome.command");
            if (userType.equals((Object)UserType.Spy)) {
                String playerName = config.getString("player");
                if (playerName == null) {
                    config.set("player", BkTeleport.plugin.getServer().getOfflinePlayer(UUID.fromString(config.getFile().getName().replace(".yml", ""))).getName());
                    playerName = config.getString("player");
                }
                commandString = commandString + " " + playerName + ":";
            }
            for (String homeName : keys) {
                line.addExtra((BaseComponent)PluginUtils.getTextComponent(commandString, homeName, userType, TeleportType.Home));
                if (++sizeChecker != homeAmount) {
                    line.addExtra(Utils.translateColor(BkTeleport.plugin.getLangFile().get("info.home-list.separator")));
                    continue;
                }
                line.addExtra(Utils.translateColor(BkTeleport.plugin.getLangFile().get("info.home-list.end")));
            }
            sender.spigot().sendMessage((BaseComponent)line);
        }
    }

    public static TextComponent getTextComponent(String commandName, String buttonName, UserType userType, TeleportType tpType) {
        String keyword = tpType.equals((Object)TeleportType.Home) ? "home" : "warp";
        TextComponent buttonAccept = new TextComponent(Utils.translateColor(BkTeleport.plugin.getLangFile().get("info." + keyword + "-list." + keyword + "-format").replace("{" + keyword + "}", buttonName)));
        String hover = Utils.translateColor(BkTeleport.plugin.getLangFile().get("info." + keyword + "-list.hover"));
        String space = userType.equals((Object)UserType.Spy) ? "" : " ";
        buttonAccept.setClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/" + commandName + space + buttonName));
        buttonAccept.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new ComponentBuilder(hover).create()));
        return buttonAccept;
    }
}

