/*
 * Decompiled with CFR 0.152.
 */
package me.bkrmt.bkteleport;

import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Hashtable;
import java.util.List;
import java.util.logging.Level;
import me.bkrmt.bkteleport.ButtonFunctions;
import me.bkrmt.bkteleport.PluginUtils;
import me.bkrmt.bkteleport.TpaUtils;
import me.bkrmt.bkteleport.bkcore.BkPlugin;
import me.bkrmt.bkteleport.bkcore.command.CommandModule;
import me.bkrmt.bkteleport.bkcore.command.HelpCmd;
import me.bkrmt.bkteleport.bkcore.command.ReloadCmd;
import me.bkrmt.bkteleport.bkcore.message.InternalMessages;
import me.bkrmt.bkteleport.commands.CommandHandler;
import me.bkrmt.bkteleport.commands.home.DelHomeCmd;
import me.bkrmt.bkteleport.commands.home.HomeCmd;
import me.bkrmt.bkteleport.commands.home.SetHomeCmd;
import me.bkrmt.bkteleport.commands.tp.TpaAcceptCmd;
import me.bkrmt.bkteleport.commands.tp.TpaCmd;
import me.bkrmt.bkteleport.commands.tp.TpaDenyCmd;
import me.bkrmt.bkteleport.commands.tp.TpaHereCmd;
import me.bkrmt.bkteleport.commands.warp.DelWarpCmd;
import me.bkrmt.bkteleport.commands.warp.SetWarpCmd;
import me.bkrmt.bkteleport.commands.warp.WarpCmd;
import me.bkrmt.teleport.TeleportCore;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.StringUtil;

public final class BkTeleport
extends BkPlugin {
    public static BkPlugin plugin;
    public static Hashtable<String, List<String>> commands;

    public void onEnable() {
        File homesFolder;
        plugin = this;
        this.start(true);
        this.setRunning(true);
        this.getCommandMapper().addCommand(new CommandModule(new HelpCmd(plugin, "bkteleport", ""), (a, b, c, d) -> Collections.singletonList(""))).addCommand(new CommandModule(new ReloadCmd(plugin, "tpreload", "bkteleport.reload"), (a, b, c, d) -> Collections.singletonList(""))).addCommand(new CommandModule(new TpaCmd(plugin, "tpa", "bkteleport.tpa"), null)).addCommand(new CommandModule(new TpaHereCmd(plugin, "tpahere", "bkteleport.tpahere"), null)).addCommand(new CommandModule(new TpaAcceptCmd(plugin, "tpaccept", "bkteleport.tpaccept"), null)).addCommand(new CommandModule(new TpaDenyCmd(plugin, "tpdeny", "bkteleport.tpdeny"), null)).addCommand(new CommandModule(new SetHomeCmd(plugin, "sethome", "bkteleport.sethome"), (a, b, c, d) -> Collections.singletonList(""))).addCommand(new CommandModule(new DelHomeCmd(plugin, "delhome", "bkteleport.delhome"), (sender, b, c, args) -> this.homesTabCompleter(args, sender))).addCommand(new CommandModule(new HomeCmd(plugin, "home", "bkteleport.home"), (sender, b, c, args) -> this.homesTabCompleter(args, sender))).addCommand(new CommandModule(new HomeCmd(plugin, "homes", "bkteleport.home"), (a, b, c, d) -> Collections.singletonList(""))).addCommand(new CommandModule(new WarpCmd(plugin, "warp", "bkteleport.warp"), (sender, b, c, args) -> this.warpsTabCompleter(args, sender))).addCommand(new CommandModule(new WarpCmd(plugin, "warps", "bkteleport.warps"), (a, b, c, d) -> Collections.singletonList(""))).addCommand(new CommandModule(new SetWarpCmd(plugin, "setwarp", "bkteleport.setwarp"), (a, b, c, d) -> Collections.singletonList(""))).addCommand(new CommandModule(new DelWarpCmd(plugin, "delwarp", "bkteleport.delwarp"), (sender, b, c, args) -> this.warpsTabCompleter(args, sender))).registerAll();
        commands = new Hashtable();
        commands.put("tpa", PluginUtils.getList("commands.tpa"));
        commands.put("tpahere", PluginUtils.getList("commands.tpahere"));
        commands.put("tpaccept", PluginUtils.getList("commands.tpaccept"));
        commands.put("tpdeny", PluginUtils.getList("commands.tpdeny"));
        commands.put("home", PluginUtils.getList("commands.home"));
        commands.put("homes", PluginUtils.getList("commands.homes"));
        commands.put("sethome", PluginUtils.getList("commands.sethome"));
        commands.put("delhome", PluginUtils.getList("commands.delhome"));
        commands.put("warp", PluginUtils.getList("commands.warp"));
        commands.put("warps", PluginUtils.getList("commands.warps"));
        commands.put("setwarp", PluginUtils.getList("commands.setwarp"));
        commands.put("delwarp", PluginUtils.getList("commands.delwarp"));
        this.getServer().getPluginManager().registerEvents((Listener)new ButtonFunctions(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new CommandHandler(), (Plugin)this);
        File warpsFolder = new File(this.getDataFolder().getPath() + File.separator + "warps");
        if (!warpsFolder.exists()) {
            warpsFolder.mkdir();
        }
        if (!(homesFolder = new File(this.getDataFolder().getPath() + File.separator + "userdata")).exists()) {
            homesFolder.mkdir();
        }
        new TpaUtils();
        if (TeleportCore.INSTANCE.getPlayersInCooldown().get("Core-Started") == null) {
            TeleportCore.INSTANCE.start(this);
        }
        this.getConfigManager().loadAllConfigs();
        if (this.getConfigManager().getConfig().getBoolean("import-from-essentials")) {
            this.copyFromEss("warps");
            this.copyFromEss("userdata");
        }
    }

    public void onDisable() {
        this.getConfigManager().saveConfigs();
    }

    private void copyFromEss(String essFolderName) {
        File essFolder = new File("plugins" + File.separator + "Essentials" + File.separator + essFolderName);
        if (essFolder.exists() && essFolder.listFiles().length > 0) {
            File[] files = essFolder.listFiles();
            boolean warned = false;
            for (File file : files) {
                try {
                    File destFile = new File(this.getDataFolder().getPath() + File.separator + essFolderName + File.separator + file.getName());
                    if (destFile.exists()) continue;
                    if (!warned) {
                        String infoMessage = destFile.getPath().contains("userdata") ? InternalMessages.ESS_COPY_HOME.getMessage().replace("{0}", this.getName()) : InternalMessages.ESS_COPY_WARPS.getMessage().replace("{0}", this.getName());
                        this.getServer().getLogger().log(Level.INFO, infoMessage);
                        warned = true;
                    }
                    Files.copy(file.toPath(), destFile.toPath(), new CopyOption[0]);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (warned) {
                this.getServer().getLogger().log(Level.INFO, InternalMessages.ESS_COPY_DONE.getMessage().replace("{0}", this.getName()));
            }
        }
    }

    private List<String> warpsTabCompleter(String[] args, CommandSender sender) {
        ArrayList<String> completions = new ArrayList<String>();
        if (args.length == 1) {
            String partialCommand = args[0];
            List<String> warps = Arrays.asList(PluginUtils.getWarps());
            StringUtil.copyPartialMatches((String)partialCommand, warps, completions);
        } else if (args.length == 2 && sender.hasPermission("bkteleport.warp.others")) {
            String partialPlayer = args[1];
            ArrayList<String> playerList = new ArrayList<String>();
            for (Player player : plugin.getHandler().getMethodManager().getOnlinePlayers()) {
                playerList.add(player.getName());
            }
            StringUtil.copyPartialMatches((String)partialPlayer, playerList, completions);
        }
        completions.removeIf(completion -> !sender.hasPermission("bkteleport.warp.*") && !sender.hasPermission("bkteleport.warp." + completion));
        Collections.sort(completions);
        return completions;
    }

    private List<String> homesTabCompleter(String[] args, CommandSender sender) {
        ArrayList<String> completions = new ArrayList<String>();
        if (sender.hasPermission("bkteleport.home") && args.length == 1) {
            String partialCommand = args[0];
            List<String> homes = Arrays.asList(PluginUtils.getHomes((Player)sender));
            StringUtil.copyPartialMatches((String)partialCommand, homes, completions);
        }
        Collections.sort(completions);
        return completions;
    }
}

