/*
 * Decompiled with CFR 0.152.
 */
package me.helldiner.crafter.write;

import java.util.Map;
import me.helldiner.crafter.Crafter;
import me.helldiner.crafter.craft.CustomCraft;
import me.helldiner.crafter.versions_support.AttributeSupport;
import me.helldiner.crafter.versions_support.EnchantmentSupport;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.potion.PotionEffectType;

public class CraftWriter {
    public CraftWriter(CustomCraft recipe, Map<Material, Character> ingredients, String modelStr) {
        FileConfiguration config = Crafter.PLUGIN_INSTANCE.getConfig();
        ConfigurationSection craftsSection = config.getConfigurationSection("crafts");
        ConfigurationSection crafts_itemSection = craftsSection.createSection(recipe.key);
        crafts_itemSection.set("material", (Object)recipe.result_material.toString());
        String keysStr = "";
        int i = 0;
        while (i < recipe.ingredientsKeys.size()) {
            keysStr = i != recipe.ingredientsKeys.size() - 1 ? String.valueOf(keysStr) + recipe.ingredientsKeys.get(i) + " " : String.valueOf(keysStr) + recipe.ingredientsKeys.get(i);
            ++i;
        }
        crafts_itemSection.set("keys", (Object)keysStr);
        if (recipe.name != null) {
            crafts_itemSection.set("name", (Object)recipe.name);
        }
        if (recipe.permission != null) {
            crafts_itemSection.set("permission", (Object)recipe.permission);
        }
        crafts_itemSection.set("amount", (Object)recipe.amount);
        if (recipe.modelData != Integer.MAX_VALUE) {
            crafts_itemSection.set("model_data", (Object)recipe.modelData);
        }
        ConfigurationSection item_crafts_craftSection = crafts_itemSection.createSection("craft");
        item_crafts_craftSection.set("model", (Object)modelStr);
        for (Material material : ingredients.keySet()) {
            char c = ingredients.get(material).charValue();
            if (item_crafts_craftSection.contains("" + c)) continue;
            item_crafts_craftSection.set("" + c, (Object)material.toString());
        }
        if (recipe.attrs.size() != 0) {
            ConfigurationSection crafts_item_attrSection = crafts_itemSection.createSection("attributes");
            for (AttributeSupport attr : recipe.attrs.keySet()) {
                crafts_item_attrSection.set(attr.getName(), (Object)recipe.attrs.get(attr));
            }
        }
        if (recipe.enchants.size() != 0) {
            ConfigurationSection crafts_item_enchSection = crafts_itemSection.createSection("enchants");
            for (Enchantment ench : recipe.enchants.keySet()) {
                crafts_item_enchSection.set(EnchantmentSupport.getName(ench), (Object)recipe.enchants.get(ench));
            }
        }
        if (recipe.potionEffects.size() != 0) {
            ConfigurationSection crafts_item_potionsSection = crafts_itemSection.createSection("potion_effects");
            for (PotionEffectType potionEffect : recipe.potionEffects.keySet()) {
                crafts_item_potionsSection.set(potionEffect.getName(), (Object)recipe.potionEffects.get(potionEffect));
            }
        }
        Crafter.PLUGIN_INSTANCE.saveConfig();
    }
}

