/*
 * Decompiled with CFR 0.152.
 */
package me.helldiner.crafter.versions_support;

import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import me.helldiner.crafter.Crafter;
import me.helldiner.crafter.versions_support.FeatureSupport;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;

public class ItemDataContainerSupport {
    public static Map<String, Map<Key, String>> containers = new HashMap<String, Map<Key, String>>();

    public static ItemStack storeDataAsString(ItemStack item, Key key, String data) {
        if (item == null) {
            return item;
        }
        ItemMeta meta = item.getItemMeta();
        if (meta == null) {
            return item;
        }
        if (FeatureSupport.isFeatureSupported(FeatureSupport.Feature.PERSISTENT_DATA_CONTAINER)) {
            try {
                Class<?> namespacedKeyClass = Class.forName("org.bukkit.NamespacedKey");
                Object namespacedKey = namespacedKeyClass.getConstructor(Plugin.class, String.class).newInstance(Crafter.PLUGIN_INSTANCE, key.getKey());
                Class<?> persistentDataContainerClass = Class.forName("org.bukkit.persistence.PersistentDataContainer");
                Object persistentDataContainer = ItemMeta.class.getMethod("getPersistentDataContainer", new Class[0]).invoke((Object)meta, new Object[0]);
                Class<?> persistentDataTypeClass = Class.forName("org.bukkit.persistence.PersistentDataType");
                Object persistentDataTypeString = persistentDataTypeClass.getField("STRING").get(null);
                persistentDataContainerClass.getMethod("set", namespacedKeyClass, persistentDataTypeClass, Object.class).invoke(persistentDataContainer, namespacedKey, persistentDataTypeString, data);
                item.setItemMeta(meta);
            }
            catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchFieldException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                e.printStackTrace();
            }
        } else if (containers.containsKey(meta.getDisplayName()) && meta.hasItemFlag(ItemFlag.HIDE_ATTRIBUTES) && meta.hasItemFlag(ItemFlag.HIDE_ENCHANTS)) {
            Map<Key, String> container = containers.get(meta.getDisplayName());
            if (container.containsKey((Object)key)) {
                container.replace(key, data);
            } else {
                container.put(key, data);
            }
            containers.replace(meta.getDisplayName(), container);
        } else {
            HashMap<Key, String> container = new HashMap<Key, String>();
            container.put(key, data);
            containers.put(meta.getDisplayName(), container);
        }
        return item;
    }

    public static String loadDataAsString(ItemStack item, Key key) {
        Map<Key, String> container;
        String data = null;
        if (item == null) {
            return null;
        }
        ItemMeta meta = item.getItemMeta();
        if (meta == null) {
            return null;
        }
        if (FeatureSupport.isFeatureSupported(FeatureSupport.Feature.PERSISTENT_DATA_CONTAINER)) {
            try {
                Class<?> namespacedKeyClass = Class.forName("org.bukkit.NamespacedKey");
                Object namespacedKey = namespacedKeyClass.getConstructor(Plugin.class, String.class).newInstance(Crafter.PLUGIN_INSTANCE, key.getKey());
                Class<?> persistentDataContainerClass = Class.forName("org.bukkit.persistence.PersistentDataContainer");
                Object persistentDataContainer = ItemMeta.class.getMethod("getPersistentDataContainer", new Class[0]).invoke((Object)meta, new Object[0]);
                Class<?> persistentDataTypeClass = Class.forName("org.bukkit.persistence.PersistentDataType");
                Object persistentDataTypeString = persistentDataTypeClass.getField("STRING").get(null);
                data = (String)persistentDataContainerClass.getMethod("get", namespacedKeyClass, persistentDataTypeClass).invoke(persistentDataContainer, namespacedKey, persistentDataTypeString);
            }
            catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchFieldException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                e.printStackTrace();
            }
        } else if (containers.containsKey(meta.getDisplayName()) && meta.hasItemFlag(ItemFlag.HIDE_ATTRIBUTES) && meta.hasItemFlag(ItemFlag.HIDE_ENCHANTS) && (container = containers.get(meta.getDisplayName())).containsKey((Object)key)) {
            data = container.get((Object)key);
        }
        return data;
    }

    public static enum Key {
        NAME("name"),
        POTION_EFFECTS("potions");

        private String key;

        private Key(String key) {
            this.key = key;
        }

        public String getKey() {
            return this.key;
        }
    }
}

