/*
 * Decompiled with CFR 0.152.
 */
package me.helldiner.crafter.versions_support;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.UUID;
import me.helldiner.crafter.utils.Utils;
import me.helldiner.crafter.versions_support.FeatureSupport;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class AttributeSupport {
    private Object attribute;
    private String attributeName;

    public AttributeSupport(String attributeName) {
        this.attributeName = attributeName;
        if (FeatureSupport.isFeatureSupported(FeatureSupport.Feature.ADD_ATTRIBUTE_MODIFIER)) {
            try {
                Class<?> attributeClass = Class.forName("org.bukkit.attribute.Attribute");
                this.attribute = attributeClass.getMethod("valueOf", String.class).invoke(null, attributeName);
            }
            catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                e.printStackTrace();
            }
        } else {
            try {
                attributeName = Utils.convertEnchantName(attributeName);
                String packageVersion = Utils.getNMSPackageName();
                Class<?> nbtTagCompoundClass = Class.forName("net.minecraft.server." + packageVersion + ".NBTTagCompound");
                Class<?> nbtTagStringClass = Class.forName("net.minecraft.server." + packageVersion + ".NBTTagString");
                Class<?> nbtTagIntClass = Class.forName("net.minecraft.server." + packageVersion + ".NBTTagInt");
                Class<?> nbtBaseClass = Class.forName("net.minecraft.server." + packageVersion + ".NBTBase");
                Object name = nbtTagStringClass.getConstructor(String.class).newInstance(attributeName);
                Method setMethod = nbtTagCompoundClass.getMethod("set", String.class, nbtBaseClass);
                this.attribute = nbtTagCompoundClass.getConstructor(new Class[0]).newInstance(new Object[0]);
                setMethod.invoke(this.attribute, "AttributeName", name);
                setMethod.invoke(this.attribute, "Name", name);
                UUID uuid = UUID.randomUUID();
                setMethod.invoke(this.attribute, "UUIDLeast", nbtTagIntClass.getConstructor(Integer.TYPE).newInstance((int)uuid.getLeastSignificantBits()));
                setMethod.invoke(this.attribute, "UUIDMost", nbtTagIntClass.getConstructor(Integer.TYPE).newInstance((int)uuid.getMostSignificantBits()));
            }
            catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                e.printStackTrace();
            }
        }
    }

    public static ItemStack setAttribute(AttributeSupport attribute, ItemStack item, double value, EquipmentSlot slot) {
        if (FeatureSupport.isFeatureSupported(FeatureSupport.Feature.ADD_ATTRIBUTE_MODIFIER)) {
            ItemMeta meta = item.getItemMeta();
            try {
                Class<?> attributeClass = Class.forName("org.bukkit.attribute.Attribute");
                Class<?> attributeModifierClass = Class.forName("org.bukkit.attribute.AttributeModifier");
                Class<?> attributeModifierOperationClass = Class.forName("org.bukkit.attribute.AttributeModifier$Operation");
                Constructor<?> attributeModifierConstructor = attributeModifierClass.getConstructor(UUID.class, String.class, Double.TYPE, attributeModifierOperationClass, EquipmentSlot.class);
                Object attributeModifier = attributeModifierConstructor.newInstance(UUID.randomUUID(), attribute.getAttribute().toString(), value, attributeModifierOperationClass.getField("ADD_NUMBER").get(null), slot);
                ItemMeta.class.getMethod("addAttributeModifier", attributeClass, attributeModifierClass).invoke((Object)meta, attribute.getAttribute(), attributeModifier);
                item.setItemMeta(meta);
                return item;
            }
            catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchFieldException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                e.printStackTrace();
            }
        } else {
            try {
                Object modifiers;
                String packageVersion = Utils.getNMSPackageName();
                Class<?> nbtTagCompoundClass = Class.forName("net.minecraft.server." + packageVersion + ".NBTTagCompound");
                Class<?> nbtBaseClass = Class.forName("net.minecraft.server." + packageVersion + ".NBTBase");
                Class<?> nbtTagStringClass = Class.forName("net.minecraft.server." + packageVersion + ".NBTTagString");
                Class<?> nbtTagIntClass = Class.forName("net.minecraft.server." + packageVersion + ".NBTTagInt");
                Class<?> nbtTagDoubleClass = Class.forName("net.minecraft.server." + packageVersion + ".NBTTagDouble");
                Class<?> nbtTagListClass = Class.forName("net.minecraft.server." + packageVersion + ".NBTTagList");
                Class<?> itemStackClass = Class.forName("net.minecraft.server." + packageVersion + ".ItemStack");
                Class<?> craftItemStackClass = Class.forName("org.bukkit.craftbukkit." + packageVersion + ".inventory.CraftItemStack");
                Method setMethod = nbtTagCompoundClass.getMethod("set", String.class, nbtBaseClass);
                Object nmsStack = craftItemStackClass.getMethod("asNMSCopy", ItemStack.class).invoke(null, item);
                Object tagCompound = itemStackClass.getMethod("getTag", new Class[0]).invoke(nmsStack, new Object[0]);
                if (tagCompound == null) {
                    tagCompound = nbtTagCompoundClass.getConstructor(new Class[0]).newInstance(new Object[0]);
                }
                if ((modifiers = nbtTagCompoundClass.getMethod("get", String.class).invoke(tagCompound, "AttributeModifiers")) == null) {
                    modifiers = nbtTagListClass.getConstructor(new Class[0]).newInstance(new Object[0]);
                }
                setMethod.invoke(attribute.attribute, "Operation", nbtTagIntClass.getConstructor(Integer.TYPE).newInstance(0));
                setMethod.invoke(attribute.attribute, "Amount", nbtTagDoubleClass.getConstructor(Double.TYPE).newInstance(value));
                setMethod.invoke(attribute.attribute, "Slot", nbtTagStringClass.getConstructor(String.class).newInstance(slot.name().equals("HAND") ? "mainhand" : slot.name().toLowerCase()));
                nbtTagListClass.getMethod("add", nbtBaseClass).invoke(modifiers, attribute.attribute);
                setMethod.invoke(tagCompound, "AttributeModifiers", modifiers);
                itemStackClass.getMethod("setTag", nbtTagCompoundClass).invoke(nmsStack, tagCompound);
                item = (ItemStack)craftItemStackClass.getMethod("asBukkitCopy", itemStackClass).invoke(null, nmsStack);
                return item;
            }
            catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public String getName() {
        return this.attributeName;
    }

    public Object getAttribute() {
        return this.attribute;
    }
}

