/*
 * Decompiled with CFR 0.152.
 */
package me.helldiner.crafter.utils;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import me.helldiner.crafter.Crafter;
import me.helldiner.crafter.craft.CraftsLoader;
import me.helldiner.crafter.load.ConfigLoader;
import me.helldiner.crafter.load.PermissionLoader;
import me.helldiner.crafter.versions_support.AttributeSupport;
import me.helldiner.crafter.versions_support.FeatureSupport;
import me.helldiner.crafter.versions_support.ItemDataContainerSupport;
import me.helldiner.crafter.versions_support.Version;
import me.helldiner.crafter.write.PermissionWriter;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.permissions.PermissionAttachment;
import org.bukkit.plugin.Plugin;

public class Utils {
    public static OfflinePlayer getOfflinePlayer(String playerName) {
        OfflinePlayer[] offlinePlayerArray = Bukkit.getOfflinePlayers();
        int n = offlinePlayerArray.length;
        int n2 = 0;
        while (n2 < n) {
            OfflinePlayer player = offlinePlayerArray[n2];
            if (player.getName().equals(playerName)) {
                return player;
            }
            ++n2;
        }
        return null;
    }

    public static PermissionAttachment getPlayerPermissions(Player player) {
        HashMap<UUID, PermissionAttachment> perms = new HashMap<UUID, PermissionAttachment>();
        PermissionAttachment attachment = player.addAttachment(Crafter.PLUGIN_INSTANCE);
        perms.put(player.getUniqueId(), attachment);
        PermissionAttachment pperms = (PermissionAttachment)perms.get(player.getUniqueId());
        return pperms;
    }

    public static String buildCraftStr(ItemStack[] items) {
        String recipeStr = "";
        ItemStack[] itemStackArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            ItemStack item = itemStackArray[n2];
            if (item != null && item.getType() != null) {
                recipeStr = String.valueOf(recipeStr) + item.getType().toString();
            }
            ++n2;
        }
        return recipeStr;
    }

    public static String buildCraftStr(Material[] materials) {
        String recipeStr = "";
        Material[] materialArray = materials;
        int n = materials.length;
        int n2 = 0;
        while (n2 < n) {
            Material material = materialArray[n2];
            if (material != null) {
                recipeStr = String.valueOf(recipeStr) + material.toString();
            }
            ++n2;
        }
        return recipeStr;
    }

    public static List<String> buildIngredientsKeys(ItemStack[] items) {
        ArrayList<String> ingredientsKeys = new ArrayList<String>();
        ItemStack[] itemStackArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            ItemStack item = itemStackArray[n2];
            ingredientsKeys.add(ItemDataContainerSupport.loadDataAsString(item, ItemDataContainerSupport.Key.NAME));
            ++n2;
        }
        return ingredientsKeys;
    }

    public static void writeDefaultConfig() {
        File configFile = new File(Crafter.PLUGIN_INSTANCE.getDataFolder(), "config.yml");
        configFile.delete();
        new ConfigLoader();
    }

    public static void loadConfig(Plugin plugin) {
        plugin.reloadConfig();
        Bukkit.resetRecipes();
        new CraftsLoader();
    }

    public static boolean givePlayerPermission(Player player, OfflinePlayer offPlayer) {
        if (new PermissionLoader(offPlayer.getUniqueId().toString(), false).isGranted()) {
            return false;
        }
        if (player != null) {
            PermissionAttachment perms = Utils.getPlayerPermissions(player);
            perms.setPermission("crafter.admin", true);
        }
        new PermissionWriter(offPlayer.getUniqueId().toString(), "crafter.admin", true);
        return true;
    }

    public static boolean removePlayerPermission(Player player, OfflinePlayer offPlayer) {
        if (!new PermissionLoader(offPlayer.getUniqueId().toString(), false).isGranted()) {
            return false;
        }
        if (player != null) {
            PermissionAttachment perms = Utils.getPlayerPermissions(player);
            perms.setPermission("crafter.admin", false);
        }
        new PermissionWriter(player.getUniqueId().toString(), "crafter.admin", false);
        return true;
    }

    public static EquipmentSlot getEquipmentSlot(ItemStack stack) {
        Material material = stack.getType();
        try {
            if (FeatureSupport.isFeatureSupported(FeatureSupport.Feature.NETHERITE) && material == Material.class.getField("NETHERITE_HELMET").get(null) || material == Material.DIAMOND_HELMET || !(FeatureSupport.isFeatureSupported(FeatureSupport.Feature.GOLDEN) ? material != Material.class.getField("GOLDEN_HELMET").get(null) : material != Material.class.getField("GOLD_HELMET").get(null)) || material == Material.IRON_HELMET || material == Material.CHAINMAIL_HELMET || material == Material.LEATHER_HELMET) {
                return EquipmentSlot.HEAD;
            }
            if (FeatureSupport.isFeatureSupported(FeatureSupport.Feature.NETHERITE) && material == Material.class.getField("NETHERITE_CHESTPLATE").get(null) || FeatureSupport.isFeatureSupported(FeatureSupport.Feature.ELYTRA) && material == Material.class.getField("ELYTRA").get(null) || material == Material.DIAMOND_CHESTPLATE || !(FeatureSupport.isFeatureSupported(FeatureSupport.Feature.GOLDEN) ? material != Material.class.getField("GOLDEN_CHESTPLATE").get(null) : material != Material.class.getField("GOLD_CHESTPLATE").get(null)) || material == Material.IRON_CHESTPLATE || material == Material.CHAINMAIL_CHESTPLATE || material == Material.LEATHER_CHESTPLATE) {
                return EquipmentSlot.CHEST;
            }
            if (FeatureSupport.isFeatureSupported(FeatureSupport.Feature.NETHERITE) && material == Material.class.getField("NETHERITE_LEGGINGS").get(null) || material == Material.DIAMOND_LEGGINGS || !(FeatureSupport.isFeatureSupported(FeatureSupport.Feature.GOLDEN) ? material != Material.class.getField("GOLDEN_LEGGINGS").get(null) : material != Material.class.getField("GOLD_LEGGINGS").get(null)) || material == Material.IRON_LEGGINGS || material == Material.CHAINMAIL_LEGGINGS || material == Material.LEATHER_LEGGINGS) {
                return EquipmentSlot.LEGS;
            }
            if (FeatureSupport.isFeatureSupported(FeatureSupport.Feature.NETHERITE) && material == Material.class.getField("NETHERITE_BOOTS").get(null) || material == Material.DIAMOND_BOOTS || !(FeatureSupport.isFeatureSupported(FeatureSupport.Feature.GOLDEN) ? material != Material.class.getField("GOLDEN_BOOTS").get(null) : material != Material.class.getField("GOLD_BOOTS").get(null)) || material == Material.IRON_BOOTS || material == Material.CHAINMAIL_BOOTS || material == Material.LEATHER_BOOTS) {
                return EquipmentSlot.FEET;
            }
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
            e.printStackTrace();
        }
        return EquipmentSlot.HAND;
    }

    public static String getAttributeDisplayName(AttributeSupport attribute) {
        String attributeName = attribute.getName();
        HashMap<String, String> attributesNames = new HashMap<String, String>();
        attributesNames.put("GENERIC_ARMOR", "Armor");
        attributesNames.put("GENERIC_ARMOR_TOUGHNESS", "Armor Toughness");
        attributesNames.put("GENERIC_ATTACK_DAMAGE", "Attack Damage");
        attributesNames.put("GENERIC_ATTACK_KNOCKBACK", "Attack Knockback");
        attributesNames.put("GENERIC_ATTACK_SPEED", "Attack Speed");
        attributesNames.put("GENERIC_FLYING_SPEED", "Flying Speed");
        attributesNames.put("GENERIC_FOLLOW_RANGE", "Mob Follow Range");
        attributesNames.put("GENERIC_KNOCKBACK_RESISTANCE", "Knockback Resistance");
        attributesNames.put("GENERIC_LUCK", "Luck");
        attributesNames.put("GENERIC_MAX_HEALTH", "Max Health");
        attributesNames.put("GENERIC_MOVEMENT_SPEED", "Speed");
        attributesNames.put("HORSE_JUMP_STRENGTH", "Horse Jump Strength");
        attributesNames.put("ZOMBIE_SPAWN_REINFORCEMENTS", "Zombie Reinforcements");
        return (String)attributesNames.get(attributeName);
    }

    public static final Version getServerVersion() {
        String version = Bukkit.getServer().getBukkitVersion();
        if ((version = version.substring(0, version.indexOf("-"))).startsWith("1.8")) {
            return Version.V1_8;
        }
        if (version.startsWith("1.9")) {
            return Version.V1_9;
        }
        if (version.startsWith("1.10")) {
            return Version.V1_10;
        }
        if (version.startsWith("1.11")) {
            return Version.V1_11;
        }
        if (version.startsWith("1.12")) {
            return Version.V1_12;
        }
        if (version.startsWith("1.13")) {
            return Version.V1_13;
        }
        if (version.startsWith("1.14")) {
            return Version.V1_14;
        }
        if (version.startsWith("1.15")) {
            return Version.V1_15;
        }
        if (version.startsWith("1.16")) {
            return Version.V1_16;
        }
        return null;
    }

    public static String convertEnchantName(String name) {
        String[] parts = name.split("_");
        name = String.valueOf(parts[0].toLowerCase()) + "." + parts[1].toLowerCase();
        int i = 2;
        while (i < parts.length) {
            name = String.valueOf(name) + parts[i].substring(0, 1) + parts[i].substring(1).toLowerCase();
            ++i;
        }
        return name;
    }

    public static final String getNMSPackageName() {
        File jarFile = new File(Bukkit.class.getProtectionDomain().getCodeSource().getLocation().getPath());
        try {
            if (jarFile.isFile()) {
                JarFile jar = new JarFile(jarFile);
                Enumeration<JarEntry> entries = jar.entries();
                while (entries.hasMoreElements()) {
                    String name = entries.nextElement().getName();
                    if (!name.startsWith("net/minecraft/server/") || name.equals("net/minecraft/server/")) continue;
                    jar.close();
                    return name.substring(name.indexOf("/server/") + 8, name.length() - 1);
                }
                jar.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }
}

