/*
 * Decompiled with CFR 0.152.
 */
package me.helldiner.crafter.library;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.net.ssl.HttpsURLConnection;
import me.helldiner.crafter.library.ILibraryLoader;

public class LibraryLoader {
    private final String LIBRARIES_PATH = "./plugins/helldiner_libs/";
    private final String discord_support_server = "https://discord.gg/bNNWBnk";
    private final String version_file_name = "versions.txt";
    private final String current_versions_url = "https://docs.google.com/document/d/1ZUHbyumqjbLq4syV_x_ZX5GDYDWv4Jx49vzfeeYnL_o/edit";
    private final String current_links_url = "https://docs.google.com/document/d/1my7yAhcnPozy_RdZ4Sbu53sWrgF86FaHM-6PcibDZwE/edit";
    private List<String> classes = new ArrayList<String>();
    private Logger logger;
    private String name;
    private File libraryFile;
    private File versionFile;
    private ClassLoader loader;
    private ILibraryLoader listener;

    public LibraryLoader(String name, Logger logger, ClassLoader loader) {
        this(name, logger, loader, null);
    }

    public LibraryLoader(String name, Logger logger, ClassLoader loader, ILibraryLoader listener) {
        this.listener = listener;
        this.name = name;
        this.logger = logger;
        this.loader = loader;
        this.libraryFile = new File(String.valueOf("./plugins/helldiner_libs/") + this.name + ".jar");
        boolean up_to_date = false;
        String currentVersion = this.findCurrentVersion();
        this.log(Level.INFO, "Checking library " + this.name + "...");
        this.versionFile = new File(String.valueOf("./plugins/helldiner_libs/") + "versions.txt");
        if (this.libraryFile.exists()) {
            if (!this.versionFile.exists()) {
                this.log(Level.INFO, "Version file not found !");
            } else {
                try {
                    String line;
                    BufferedReader reader = new BufferedReader(new FileReader(this.versionFile));
                    while ((line = reader.readLine()) != null) {
                        if (!line.startsWith(this.name)) continue;
                        String version = line.substring(line.indexOf("\"") + 1, line.lastIndexOf("\""));
                        if (version.equals(currentVersion)) {
                            up_to_date = true;
                            break;
                        }
                        this.log(Level.INFO, "Library is not up to date !");
                        break;
                    }
                    reader.close();
                    if (line == null) {
                        this.log(Level.INFO, "Library not found in version file !");
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (!up_to_date) {
                this.libraryFile.delete();
            }
        } else {
            this.log(Level.INFO, "Library not found !");
        }
        if (!up_to_date) {
            this.log(Level.INFO, "Starting download...");
            File path = new File("./plugins/helldiner_libs/");
            path.mkdirs();
            String downloadLink = this.findDownloadLink();
            if (downloadLink == null || !this.downloadLibrary(downloadLink)) {
                return;
            }
            this.log(Level.INFO, "Writing library version...");
            try {
                String line;
                if (!this.versionFile.exists()) {
                    this.versionFile.createNewFile();
                }
                BufferedReader reader = new BufferedReader(new FileReader(this.versionFile));
                ArrayList<String> lines = new ArrayList<String>();
                while ((line = reader.readLine()) != null) {
                    if (line.startsWith(this.name)) continue;
                    lines.add(line);
                }
                reader.close();
                BufferedWriter writer = new BufferedWriter(new FileWriter(this.versionFile));
                for (String l : lines) {
                    writer.write(String.valueOf(l) + System.lineSeparator());
                }
                writer.write(String.valueOf(this.name) + "=\"" + currentVersion + "\"");
                writer.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            this.log(Level.INFO, String.valueOf(this.name) + " library exists and is up to date !");
        }
        this.log(Level.INFO, "Loading library...");
        this.listClasses();
        this.log(Level.INFO, "Library loaded !");
    }

    private String findCurrentVersion() {
        try {
            String line;
            URL url = new URL("https://docs.google.com/document/d/1ZUHbyumqjbLq4syV_x_ZX5GDYDWv4Jx49vzfeeYnL_o/edit");
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.addRequestProperty("User-Agent", "Mozilla/5.0 (Windows NT 6.1; WOW64; rv:54.0) Gecko/20100101 Firefox/74.0");
            BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream()));
            while ((line = reader.readLine()) != null) {
                if (!line.contains(this.name)) continue;
                line = line.replace("&quot;", "\"");
                String version = line.substring(line.indexOf(this.name) + this.name.length() + 2);
                version = version.substring(0, version.indexOf("\""));
                reader.close();
                return version;
            }
            reader.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            this.log(Level.SEVERE, "An error occured while trying to download " + this.name + ".jar. Please make sure you have a stable internet connection and if it's the case, report that error to our Discord support server : \"" + "https://discord.gg/bNNWBnk" + "\".");
        }
        return null;
    }

    private String findDownloadLink() {
        String downloadLink = null;
        try {
            String line;
            URL url = new URL(this.findMediafireLink());
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.addRequestProperty("User-Agent", "Mozilla/5.0 (Windows NT 6.1; WOW64; rv:54.0) Gecko/20100101 Firefox/74.0");
            BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream()));
            boolean found = false;
            while ((line = reader.readLine()) != null) {
                if (found) {
                    line = line.replace(" ", "");
                    downloadLink = line.substring(6, line.length() - 2);
                    break;
                }
                if (!line.contains("aria-label=\"Download file\"")) continue;
                found = true;
            }
            reader.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            this.log(Level.SEVERE, "An error occured while trying to download " + this.name + ".jar. Please make sure you have a stable internet connection and if it's the case, report that error to our Discord support server : \"" + "https://discord.gg/bNNWBnk" + "\".");
        }
        return downloadLink;
    }

    private String findMediafireLink() {
        try {
            String line;
            URL url = new URL("https://docs.google.com/document/d/1my7yAhcnPozy_RdZ4Sbu53sWrgF86FaHM-6PcibDZwE/edit");
            HttpsURLConnection connection = (HttpsURLConnection)url.openConnection();
            connection.addRequestProperty("User-Agent", "Mozilla/5.0 (Windows NT 6.1; WOW64; rv:54.0) Gecko/20100101 Firefox/74.0");
            BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream()));
            boolean firstLine = true;
            while ((line = reader.readLine()) != null) {
                if (!line.contains(this.name)) continue;
                if (firstLine) {
                    firstLine = false;
                    continue;
                }
                line = line.replace("\\u003d\\\"", "\"");
                String link = line.substring(line.indexOf(this.name) + this.name.length() + 1);
                link = link.substring(0, link.indexOf("\""));
                reader.close();
                return link;
            }
            reader.close();
        }
        catch (IOException e) {
            this.log(Level.SEVERE, "An error occured while trying to download " + this.name + ".jar. Please make sure you have a stable internet connection and if it's the case, report that error to our Discord support server : \"" + "https://discord.gg/bNNWBnk" + "\".");
            e.printStackTrace();
        }
        return null;
    }

    private boolean downloadLibrary(String downloadLink) {
        try {
            int length;
            URL url = new URL(downloadLink);
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.addRequestProperty("User-Agent", "Mozilla/5.0 (Windows NT 6.1; WOW64; rv:54.0) Gecko/20100101 Firefox/74.0");
            int contentLength = connection.getContentLength();
            InputStream reader = connection.getInputStream();
            FileOutputStream writer = new FileOutputStream(this.libraryFile);
            int downloaded = 0;
            byte[] buffer = new byte[2048];
            while ((length = reader.read(buffer)) != -1) {
                writer.write(buffer, 0, length);
                double progress = (double)((downloaded += length) * 100) / ((double)contentLength * 1.0);
                this.log(Level.INFO, "Download status : " + (double)Math.round(progress * 100.0) / 100.0 + "%");
            }
            this.log(Level.INFO, "Successfully downloaded " + this.name + ".jar");
            writer.close();
            reader.close();
        }
        catch (IOException e) {
            this.log(Level.SEVERE, "An error occured while trying to download " + this.name + ".jar. Please make sure you have a stable internet connection and if it's the case, report that error to our Discord support server : \"" + "https://discord.gg/bNNWBnk" + "\".");
            e.printStackTrace();
            return false;
        }
        return true;
    }

    private void log(Level level, String message) {
        this.logger.log(level, message);
        if (this.listener != null) {
            this.listener.onMessage(level, message);
        }
    }

    private void listClasses() {
        try {
            ZipInputStream zip = new ZipInputStream(new FileInputStream(this.libraryFile));
            ZipEntry entry = zip.getNextEntry();
            while (entry != null) {
                if (!entry.isDirectory() && entry.getName().endsWith(".class")) {
                    String className = entry.getName().replace('/', '.');
                    this.classes.add(className.substring(0, className.length() - ".class".length()));
                }
                entry = zip.getNextEntry();
            }
            zip.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public URLClassLoader getLibraryLoader() {
        try {
            URLClassLoader child = new URLClassLoader(new URL[]{this.libraryFile.toURI().toURL()}, this.loader);
            return child;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }
}

