/*
 * Decompiled with CFR 0.152.
 */
package me.helldiner.crafter.lang;

import java.io.File;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import me.helldiner.crafter.Crafter;
import me.helldiner.crafter.lang.TextValues;

public class PluginTranslator {
    public static void downloadValues(String languageCode) {
        try {
            Class<?> translationFileLoaderClass = Class.forName("me.helldiner.plugin_translator.load.TranslationFileLoader", false, Crafter.translationLibraryLoader);
            Object translationFileLoader = translationFileLoaderClass.getConstructor(String.class, String.class).newInstance(Crafter.PLUGIN_INSTANCE.getName(), languageCode);
            Map values = (Map)translationFileLoaderClass.getMethod("getValues", new Class[0]).invoke(translationFileLoader, new Object[0]);
            PluginTranslator.loadValues(values);
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    public static void readValues() {
        File config = new File("./plugins/" + Crafter.PLUGIN_INSTANCE.getName() + "/lang.yml");
        if (config.exists()) {
            try {
                Class<?> translationFileReaderClass = Class.forName("me.helldiner.plugin_translator.read.TranslationFileReader", false, Crafter.translationLibraryLoader);
                Object translationFileReader = translationFileReaderClass.getConstructor(File.class).newInstance(config);
                Map values = (Map)translationFileReaderClass.getMethod("getValues", new Class[0]).invoke(translationFileReader, new Object[0]);
                PluginTranslator.loadValues(values);
            }
            catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                e.printStackTrace();
            }
        }
    }

    private static void loadValues(Map<String, String> values) {
        for (String valueName : values.keySet()) {
            try {
                Field valueField = TextValues.class.getField(valueName.toUpperCase().replace(".", "_"));
                if (valueField == null) continue;
                valueField.set(null, values.get(valueName));
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
                e.printStackTrace();
            }
        }
    }
}

