/*
 * Decompiled with CFR 0.152.
 */
package me.helldiner.crafter.craft;

import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import me.helldiner.crafter.Crafter;
import me.helldiner.crafter.craft.CraftGenerator;
import me.helldiner.crafter.craft.CustomCraft;
import me.helldiner.crafter.lang.TextValues;
import me.helldiner.crafter.log.Logger;
import me.helldiner.crafter.utils.Utils;
import me.helldiner.crafter.versions_support.AttributeSupport;
import me.helldiner.crafter.versions_support.EnchantmentSupport;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffectType;

public class CraftsLoader
extends Logger {
    private Map<String, String> recipes = new HashMap<String, String>();

    public CraftsLoader() {
        super("CraftsLoader");
        Plugin plugin = Crafter.PLUGIN_INSTANCE;
        super.log(Level.INFO, String.valueOf(TextValues.LOADER_START) + "...");
        FileConfiguration config = plugin.getConfig();
        ConfigurationSection craftsSection = config.getConfigurationSection("crafts");
        for (String craft_name : craftsSection.getKeys(true)) {
            CustomCraft craft = new CustomCraft();
            craft.key = craft_name;
            if (craft_name.contains(".")) continue;
            ConfigurationSection itemSection = craftsSection.getConfigurationSection(craft_name);
            if (itemSection.contains("name")) {
                craft.name = itemSection.getString("name");
            }
            if (itemSection.contains("permission")) {
                craft.permission = itemSection.getString("permission");
            }
            if (itemSection.contains("amount")) {
                craft.amount = itemSection.getInt("amount");
            }
            if (itemSection.contains("model_data")) {
                craft.modelData = itemSection.getInt("model_data");
            }
            if (itemSection.contains("keys")) {
                String[] stringArray = itemSection.getString("keys").split(" ");
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String key = stringArray[n2];
                    if (key.equalsIgnoreCase("null")) {
                        craft.ingredientsKeys.add(null);
                    } else {
                        craft.ingredientsKeys.add(key);
                    }
                    ++n2;
                }
            }
            if (!itemSection.contains("material")) {
                this.reportError(String.valueOf(TextValues.LOADER_MISSING_MATERIAL) + " " + craft_name + " !");
                continue;
            }
            craft.result_material = Material.valueOf((String)itemSection.getString("material").toUpperCase());
            if (itemSection.contains("attributes")) {
                ConfigurationSection attrSection = itemSection.getConfigurationSection("attributes");
                for (String attr : attrSection.getKeys(true)) {
                    craft.attrs.put(new AttributeSupport(attr), attrSection.getDouble(attr));
                }
            }
            if (itemSection.contains("enchants")) {
                ConfigurationSection enchSection = itemSection.getConfigurationSection("enchants");
                for (String ench : enchSection.getKeys(true)) {
                    craft.enchants.put(EnchantmentSupport.getByName(ench), enchSection.getInt(ench));
                }
            }
            if (itemSection.contains("potion_effects")) {
                ConfigurationSection potionsSection = itemSection.getConfigurationSection("potion_effects");
                for (String potionEffect : potionsSection.getKeys(true)) {
                    craft.potionEffects.put(PotionEffectType.getByName((String)potionEffect), potionsSection.getInt(potionEffect) - 1);
                }
            }
            if (itemSection.contains("craft")) {
                ConfigurationSection craftSection = itemSection.getConfigurationSection("craft");
                if (craftSection.contains("model")) {
                    String model = craftSection.getString("model");
                    boolean all_found = true;
                    int i = 0;
                    char[] cArray = model.toCharArray();
                    int n = cArray.length;
                    int n3 = 0;
                    while (n3 < n) {
                        char c = cArray[n3];
                        if (c == '_') {
                            craft.materials[i] = Material.AIR;
                            ++i;
                        } else {
                            if (!craftSection.contains("" + c)) {
                                this.reportError(String.valueOf(TextValues.LOADER_MISSING_MATERIAL_FOR_CHAR) + " " + c + " " + TextValues.LOADER_FROM_CRAFT_OF + " " + craft_name + " !");
                                all_found = false;
                                break;
                            }
                            craft.materials[i] = Material.valueOf((String)craftSection.getString("" + c).toUpperCase());
                            ++i;
                        }
                        ++n3;
                    }
                    if (!all_found) continue;
                    craft.recipeStr = Utils.buildCraftStr(craft.materials);
                    new CraftGenerator(craft, false);
                    continue;
                }
                this.reportError(String.valueOf(TextValues.LOADER_MISSING_MODEL) + " " + craft_name + " !");
                continue;
            }
            this.reportError(String.valueOf(TextValues.LOADER_MISSING_CRAFT) + " " + craft_name + " !");
        }
    }

    private void reportError(String error) {
        super.log(Level.SEVERE, error);
    }

    public Map<String, String> getRecipes() {
        return this.recipes;
    }
}

