/*
 * Decompiled with CFR 0.152.
 */
package me.helldiner.crafter.craft;

import java.util.HashMap;
import java.util.Map;
import me.helldiner.crafter.Crafter;
import me.helldiner.crafter.craft.CraftGenerator;
import me.helldiner.crafter.craft.CustomCraft;
import me.helldiner.crafter.lang.TextValues;
import me.helldiner.crafter.versions_support.AttributeSupport;
import me.helldiner.crafter.versions_support.EnchantmentSupport;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.potion.PotionEffectType;

public class CraftsCreationHandler {
    private Map<HumanEntity, CustomCraft> recipes = new HashMap<HumanEntity, CustomCraft>();
    private Map<HumanEntity, CraftCreationStatus> craftStatutes = new HashMap<HumanEntity, CraftCreationStatus>();

    public void addCrafter(HumanEntity player) {
        this.recipes.put(player, null);
    }

    public void removeCrafter(HumanEntity player) {
        this.recipes.remove(player);
    }

    public boolean isCrafter(HumanEntity player) {
        return this.recipes.containsKey(player);
    }

    public void beginCraft(HumanEntity player, Inventory craftInventory) {
        ItemStack[] materials = craftInventory.getContents();
        CustomCraft recipe = new CustomCraft();
        int i = 1;
        while (i < 10) {
            Material material;
            recipe.materials[i - 1] = material = materials[i].getType();
            recipe.recipeStr = String.valueOf(recipe.recipeStr) + material.toString();
            ++i;
        }
        this.recipes.replace(player, recipe);
        this.craftStatutes.put(player, CraftCreationStatus.ASK_INGREDIENTS_KEYS);
        ((Player)player).sendMessage(String.valueOf(Crafter.CHAT_PREFIX) + ChatColor.GOLD + TextValues.CRAFT_CREATION_QUESTIONS_INGREDIENTS_KEYS_YN + " :");
    }

    public void onInput(Player player, String message) {
        CustomCraft recipe = this.recipes.get(player);
        switch (this.craftStatutes.get(player)) {
            case ASK_INGREDIENTS_KEYS: {
                if (message.equalsIgnoreCase(TextValues.CRAFT_CREATION_QUESTIONS_Y) || message.equalsIgnoreCase(TextValues.CRAFT_CREATION_QUESTIONS_N)) {
                    if (message.equalsIgnoreCase(TextValues.CRAFT_CREATION_QUESTIONS_Y)) {
                        this.craftStatutes.put((HumanEntity)player, CraftCreationStatus.INGREDIENTS_KEYS);
                        Material[] materialArray = recipe.materials;
                        int n = recipe.materials.length;
                        int n2 = 0;
                        while (n2 < n) {
                            Material material = materialArray[n2];
                            if (material != Material.AIR) break;
                            recipe.ingredientsKeys.add(null);
                            ++n2;
                        }
                        int index = recipe.ingredientsKeys.size();
                        this.askValue((HumanEntity)player, String.valueOf(TextValues.CRAFT_CREATION_QUESTIONS_INGREDIENTS_KEYS_KEY_FOR) + " " + ChatColor.BOLD + recipe.materials[index].name() + ChatColor.GOLD + " " + TextValues.CRAFT_CREATION_QUESTIONS_INGREDIENTS_KEYS_IN_SLOT + " " + ChatColor.BOLD + (index + 1) + ChatColor.GOLD + " (" + TextValues.CRAFT_CREATION_QUESTIONS_INGREDIENTS_KEYS_N_IF_NONE + ")");
                        break;
                    }
                    this.craftStatutes.put((HumanEntity)player, CraftCreationStatus.KEY);
                    this.askValue((HumanEntity)player, TextValues.CRAFT_CREATION_QUESTIONS_A_RECIPE_KEY);
                    break;
                }
                player.sendMessage(String.valueOf(Crafter.CHAT_PREFIX) + ChatColor.GOLD + TextValues.CRAFT_CREATION_QUESTIONS_INVALID_INPUT + " ! " + TextValues.CRAFT_CREATION_QUESTIONS_INGREDIENTS_KEYS_YN + " :");
                break;
            }
            case INGREDIENTS_KEYS: {
                int index;
                if (!this.checkNone(message)) {
                    recipe.ingredientsKeys.add(message.toLowerCase().replace(" ", "_"));
                } else {
                    recipe.ingredientsKeys.add(null);
                }
                int i = recipe.ingredientsKeys.size();
                while (i < recipe.materials.length) {
                    if (recipe.materials[i] != Material.AIR) break;
                    recipe.ingredientsKeys.add(null);
                    ++i;
                }
                if ((index = recipe.ingredientsKeys.size()) < recipe.materials.length) {
                    this.askValue((HumanEntity)player, String.valueOf(TextValues.CRAFT_CREATION_QUESTIONS_INGREDIENTS_KEYS_KEY_FOR) + " " + ChatColor.BOLD + recipe.materials[index].name() + ChatColor.GOLD + " " + TextValues.CRAFT_CREATION_QUESTIONS_INGREDIENTS_KEYS_IN_SLOT + " " + ChatColor.BOLD + (index + 1) + ChatColor.GOLD + " (" + TextValues.CRAFT_CREATION_QUESTIONS_INGREDIENTS_KEYS_N_IF_NONE + ")");
                    break;
                }
                this.craftStatutes.put((HumanEntity)player, CraftCreationStatus.KEY);
                this.askValue((HumanEntity)player, TextValues.CRAFT_CREATION_QUESTIONS_A_RECIPE_KEY);
                break;
            }
            case KEY: {
                recipe.key = message.toLowerCase().replace(" ", "_");
                this.craftStatutes.replace((HumanEntity)player, CraftCreationStatus.MATERIAL);
                this.askValue((HumanEntity)player, TextValues.CRAFT_CREATION_QUESTIONS_A_MATERIAL_NAME);
                break;
            }
            case MATERIAL: {
                recipe.recipeStr = recipe.recipeStr;
                recipe.result_material = Material.getMaterial((String)message.toUpperCase());
                this.craftStatutes.replace((HumanEntity)player, CraftCreationStatus.NAME);
                this.askValue((HumanEntity)player, TextValues.CRAFT_CREATION_QUESTIONS_AN_ITEM_NAME);
                break;
            }
            case NAME: {
                if (!this.checkNone(message)) {
                    recipe.name = message;
                }
                this.craftStatutes.replace((HumanEntity)player, CraftCreationStatus.AMOUNT);
                this.askValue((HumanEntity)player, TextValues.CRAFT_CREATION_QUESTIONS_AN_ITEM_AMOUNT);
                break;
            }
            case AMOUNT: {
                if (!this.checkNone(message)) {
                    recipe.amount = Integer.parseInt(message);
                }
                this.craftStatutes.replace((HumanEntity)player, CraftCreationStatus.MODEL_DATA);
                this.askValue((HumanEntity)player, TextValues.CRAFT_CREATION_QUESTIONS_A_MODEL_INDEX);
                break;
            }
            case MODEL_DATA: {
                if (!this.checkNone(message)) {
                    recipe.modelData = Integer.parseInt(message);
                }
                this.craftStatutes.replace((HumanEntity)player, CraftCreationStatus.ATTR);
                this.askValue((HumanEntity)player, String.valueOf(TextValues.CRAFT_CREATION_QUESTIONS_AN_ATTRIBUTE) + ". " + TextValues.CRAFT_CREATION_QUESTIONS_ATTRIBUTE_FORMAT);
                break;
            }
            case ATTR: {
                if (!this.checkNone(message)) {
                    String[] args = message.split(" ");
                    if (args.length < 2) {
                        player.sendMessage(String.valueOf(Crafter.CHAT_PREFIX) + ChatColor.DARK_RED + TextValues.CRAFT_CREATION_QUESTIONS_ATTRIBUTE_FORMAT + " !");
                    } else {
                        AttributeSupport attr = new AttributeSupport(args[0].toUpperCase());
                        if (attr.getAttribute() == null) {
                            player.sendMessage(String.valueOf(Crafter.CHAT_PREFIX) + ChatColor.DARK_RED + TextValues.CRAFT_CREATION_QUESTIONS_ATTRIBUTE + " " + ChatColor.GOLD + args[0].toUpperCase() + " " + TextValues.CRAFT_CREATION_QUESTIONS_DOESNT_EXISTS + " !");
                        } else {
                            recipe.attrs.put(attr, Double.parseDouble(args[1]));
                        }
                    }
                    this.askValue((HumanEntity)player, String.valueOf(TextValues.CRAFT_CREATION_QUESTIONS_AN_ATTRIBUTE) + ". " + TextValues.CRAFT_CREATION_QUESTIONS_ATTRIBUTE_FORMAT);
                    break;
                }
                this.askValue((HumanEntity)player, String.valueOf(TextValues.CRAFT_CREATION_QUESTIONS_AN_ENCHANTMENT) + ". " + TextValues.CRAFT_CREATION_QUESTIONS_ENCHANTMENT_FORMAT);
                this.craftStatutes.replace((HumanEntity)player, CraftCreationStatus.ENCHANT);
                break;
            }
            case ENCHANT: {
                if (!this.checkNone(message)) {
                    String[] args = message.split(" ");
                    if (args.length < 2) {
                        player.sendMessage(String.valueOf(Crafter.CHAT_PREFIX) + ChatColor.DARK_RED + TextValues.CRAFT_CREATION_QUESTIONS_ENCHANTMENT_FORMAT + " !");
                    } else {
                        Enchantment enchant = EnchantmentSupport.getByName(args[0].toLowerCase());
                        if (enchant == null) {
                            player.sendMessage(String.valueOf(Crafter.CHAT_PREFIX) + ChatColor.DARK_RED + TextValues.CRAFT_CREATION_QUESTIONS_ENCHANTMENT + " " + ChatColor.GOLD + args[0].toLowerCase() + " " + TextValues.CRAFT_CREATION_QUESTIONS_DOESNT_EXISTS + " !");
                        } else {
                            recipe.enchants.put(enchant, Integer.parseInt(args[1]));
                        }
                    }
                    this.askValue((HumanEntity)player, String.valueOf(TextValues.CRAFT_CREATION_QUESTIONS_AN_ENCHANTMENT) + ". " + TextValues.CRAFT_CREATION_QUESTIONS_ENCHANTMENT_FORMAT);
                    break;
                }
                this.askValue((HumanEntity)player, String.valueOf(TextValues.CRAFT_CREATION_QUESTIONS_A_POTION_EFFECT) + ". " + TextValues.CRAFT_CREATION_QUESTIONS_POTION_EFFECT_FORMAT);
                this.craftStatutes.replace((HumanEntity)player, CraftCreationStatus.POTION);
                break;
            }
            case POTION: {
                if (!this.checkNone(message)) {
                    String[] args = message.split(" ");
                    if (args.length < 2) {
                        player.sendMessage(String.valueOf(Crafter.CHAT_PREFIX) + ChatColor.DARK_RED + TextValues.CRAFT_CREATION_QUESTIONS_POTION_EFFECT_FORMAT + " !");
                    } else {
                        PotionEffectType potionEffect = PotionEffectType.getByName((String)args[0].toUpperCase());
                        if (potionEffect == null) {
                            player.sendMessage(String.valueOf(Crafter.CHAT_PREFIX) + ChatColor.DARK_RED + TextValues.CRAFT_CREATION_QUESTIONS_POTION_EFFECT + " " + ChatColor.GOLD + args[0].toUpperCase() + " " + TextValues.CRAFT_CREATION_QUESTIONS_DOESNT_EXISTS + " !");
                        } else {
                            recipe.potionEffects.put(potionEffect, Integer.parseInt(args[1]) - 1);
                        }
                    }
                    this.askValue((HumanEntity)player, String.valueOf(TextValues.CRAFT_CREATION_QUESTIONS_A_POTION_EFFECT) + ". " + TextValues.CRAFT_CREATION_QUESTIONS_POTION_EFFECT_FORMAT);
                    break;
                }
                this.askValue((HumanEntity)player, TextValues.CRAFT_CREATION_QUESTIONS_A_PERMISSION);
                this.craftStatutes.replace((HumanEntity)player, CraftCreationStatus.PERMISSION);
                break;
            }
            case PERMISSION: {
                if (!this.checkNone(message)) {
                    recipe.permission = message;
                }
                this.craftStatutes.remove(player);
                this.recipes.remove(player);
                player.sendMessage(String.valueOf(Crafter.CHAT_PREFIX) + ChatColor.GREEN + TextValues.CRAFT_CREATION_QUESTIONS_GENERATING_RECIPE + "...");
                CraftGenerator generator = new CraftGenerator(recipe, true);
                if (generator.wasSuccess()) {
                    player.sendMessage(String.valueOf(Crafter.CHAT_PREFIX) + ChatColor.GREEN + TextValues.CRAFT_CREATION_QUESTIONS_RECIPE_SUCCESS + " !");
                    break;
                }
                player.sendMessage(String.valueOf(Crafter.CHAT_PREFIX) + ChatColor.DARK_RED + TextValues.CRAFT_CREATION_QUESTIONS_RECIPE_FAIL + ".");
            }
        }
        this.recipes.replace((HumanEntity)player, recipe);
    }

    private boolean checkNone(String message) {
        return message.length() == 1 && message.charAt(0) == TextValues.CRAFT_CREATION_QUESTIONS_N.charAt(0);
    }

    private void askValue(HumanEntity player, String valueName) {
        ((Player)player).sendMessage(String.valueOf(Crafter.CHAT_PREFIX) + ChatColor.GOLD + TextValues.CRAFT_CREATION_QUESTIONS_PLEASE_INPUT + " " + valueName + " :");
    }

    private static enum CraftCreationStatus {
        ASK_INGREDIENTS_KEYS,
        INGREDIENTS_KEYS,
        KEY,
        MATERIAL,
        NAME,
        AMOUNT,
        MODEL_DATA,
        ATTR,
        ENCHANT,
        POTION,
        PERMISSION;

    }
}

