/*
 * Decompiled with CFR 0.152.
 */
package me.helldiner.crafter.craft;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import me.helldiner.crafter.Crafter;
import me.helldiner.crafter.craft.CraftsRegister;
import me.helldiner.crafter.craft.CustomCraft;
import me.helldiner.crafter.lang.TextValues;
import me.helldiner.crafter.log.CraftLogger;
import me.helldiner.crafter.utils.Utils;
import me.helldiner.crafter.versions_support.AttributeSupport;
import me.helldiner.crafter.versions_support.EnchantmentSupport;
import me.helldiner.crafter.versions_support.FeatureSupport;
import me.helldiner.crafter.versions_support.ItemDataContainerSupport;
import me.helldiner.crafter.versions_support.ItemMetaSupport;
import me.helldiner.crafter.write.CraftWriter;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.ShapedRecipe;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffectType;

public class CraftGenerator
extends CraftLogger {
    private boolean wasSuccess = true;
    private CustomCraft craft;
    private Map<Material, Character> ingredients = new HashMap<Material, Character>();
    private boolean writeCraft;

    public CraftGenerator(CustomCraft craft, boolean writeCraft) {
        super("CraftGenerator");
        this.craft = craft;
        this.writeCraft = writeCraft;
        try {
            ItemStack result = new ItemStack(craft.result_material, craft.amount);
            result = this.setMeta(result);
            String[] model_lines = null;
            model_lines = this.createCraft(result);
            this.registerCraft(result, model_lines);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.wasSuccess = false;
        }
    }

    private ItemStack setMeta(ItemStack result) {
        ItemMeta meta = result.getItemMeta();
        meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ATTRIBUTES});
        meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
        if (this.craft.modelData != Integer.MAX_VALUE) {
            ItemMetaSupport.setCustomModelData(meta, this.craft.modelData);
        }
        if (this.craft.name != null) {
            meta.setDisplayName(this.craft.name);
        }
        result.setItemMeta(meta);
        meta = result.getItemMeta();
        ArrayList<String> lores = new ArrayList<String>();
        if (this.craft.attrs.size() > 0) {
            lores.add(ChatColor.GOLD + ChatColor.BOLD + TextValues.ITEM_META_ATTRIBUTES + " :");
        }
        for (AttributeSupport attr : this.craft.attrs.keySet()) {
            lores.add(ChatColor.GOLD + Utils.getAttributeDisplayName(attr) + " : " + ChatColor.YELLOW + "+" + this.craft.attrs.get(attr));
            result = AttributeSupport.setAttribute(attr, result, this.craft.attrs.get(attr), Utils.getEquipmentSlot(result));
            meta = result.getItemMeta();
        }
        String potionEffects = "";
        if (this.craft.potionEffects.size() > 0) {
            lores.add(ChatColor.DARK_RED + ChatColor.BOLD + TextValues.ITEM_META_POTION_EFFECTS + " :");
        }
        for (PotionEffectType potionEffect : this.craft.potionEffects.keySet()) {
            String effectName = potionEffect.getName().toLowerCase().replace("_", " ");
            effectName = String.valueOf(effectName.substring(0, 1).toUpperCase()) + effectName.substring(1);
            lores.add(ChatColor.DARK_RED + effectName + " : " + ChatColor.RED + (this.craft.potionEffects.get(potionEffect) + 1));
            potionEffects = String.valueOf(potionEffects) + " " + potionEffect.getName() + "," + this.craft.potionEffects.get(potionEffect);
        }
        if (potionEffects.length() > 0) {
            potionEffects = potionEffects.substring(1);
            result = ItemDataContainerSupport.storeDataAsString(result, ItemDataContainerSupport.Key.POTION_EFFECTS, potionEffects);
            meta = result.getItemMeta();
        }
        if (this.craft.enchants.size() > 0) {
            lores.add(ChatColor.DARK_PURPLE + ChatColor.BOLD + TextValues.ITEM_META_ENCHANTMENTS + " :");
        }
        for (Enchantment enchant : this.craft.enchants.keySet()) {
            String enchantName = EnchantmentSupport.getName(enchant).toLowerCase().replace("_", " ");
            enchantName = String.valueOf(enchantName.substring(0, 1).toUpperCase()) + enchantName.substring(1);
            lores.add(ChatColor.DARK_PURPLE + enchantName + " : " + ChatColor.LIGHT_PURPLE + this.craft.enchants.get(enchant));
            meta.addEnchant(enchant, this.craft.enchants.get(enchant).intValue(), true);
        }
        meta.setLore(lores);
        result.setItemMeta(meta);
        result = ItemDataContainerSupport.storeDataAsString(result, ItemDataContainerSupport.Key.NAME, this.craft.key);
        return result;
    }

    private String[] createCraft(ItemStack result) {
        String[] model_lines = new String[3];
        int i = 0;
        while (i < 9) {
            Material material = this.craft.materials[i];
            char c = this.convertMaterialChar(material);
            int index = Math.floorDiv(i, 3);
            if (model_lines[index] == null) {
                model_lines[index] = "" + c;
            } else {
                int n = index;
                model_lines[n] = String.valueOf(model_lines[n]) + c;
            }
            ++i;
        }
        return model_lines;
    }

    private void registerCraft(ItemStack result, String[] model_lines) {
        ShapedRecipe recipe = null;
        if (FeatureSupport.isFeatureSupported(FeatureSupport.Feature.NAMESPACED_KEY)) {
            try {
                Class<?> namespacedKeyClass = Class.forName("org.bukkit.NamespacedKey");
                Iterator<Object> namespacedKey = namespacedKeyClass.getConstructor(Plugin.class, String.class).newInstance(Crafter.PLUGIN_INSTANCE, this.craft.key);
                recipe = (ShapedRecipe)ShapedRecipe.class.getConstructor(namespacedKeyClass, ItemStack.class).newInstance(namespacedKey, result);
            }
            catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                e.printStackTrace();
            }
        } else {
            try {
                recipe = (ShapedRecipe)ShapedRecipe.class.getConstructor(ItemStack.class).newInstance(result);
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                e.printStackTrace();
            }
        }
        recipe.shape(model_lines);
        for (Material material : this.ingredients.keySet()) {
            recipe.setIngredient(this.ingredients.get(material).charValue(), material);
        }
        Bukkit.addRecipe((Recipe)recipe);
        CraftsRegister.addRecipe(this.craft.recipeStr, this.craft.permission, this.craft.ingredientsKeys);
        if (this.writeCraft) {
            String modelStr = "";
            String[] stringArray = model_lines;
            int n = model_lines.length;
            int n2 = 0;
            while (n2 < n) {
                String line = stringArray[n2];
                modelStr = String.valueOf(modelStr) + line.replace(" ", "_");
                ++n2;
            }
            new CraftWriter(this.craft, this.ingredients, modelStr);
        }
        super.onCraftLoaded(this.craft.key);
    }

    private char convertMaterialChar(Material material) {
        char c;
        if (material == null || material == Material.AIR) {
            c = ' ';
        } else if (!this.ingredients.containsKey(material)) {
            c = (char)(65 + this.ingredients.size());
            this.ingredients.put(material, Character.valueOf(c));
        } else {
            c = this.ingredients.get(material).charValue();
        }
        return c;
    }

    public boolean wasSuccess() {
        return this.wasSuccess;
    }
}

