/*
 * Decompiled with CFR 0.152.
 */
package me.helldiner.crafter;

import java.util.Arrays;
import java.util.List;
import me.helldiner.crafter.Crafter;
import me.helldiner.crafter.craft.CraftsCreationHandler;
import me.helldiner.crafter.craft.CraftsRegister;
import me.helldiner.crafter.highlight.HighlightManagerProxy;
import me.helldiner.crafter.load.PermissionLoader;
import me.helldiner.crafter.utils.Utils;
import me.helldiner.crafter.versions_support.FeatureSupport;
import me.helldiner.crafter.versions_support.InventorySupport;
import me.helldiner.crafter.versions_support.ItemDataContainerSupport;
import org.bukkit.Material;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.enchantment.EnchantItemEvent;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.event.inventory.PrepareItemCraftEvent;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerItemHeldEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.scheduler.BukkitRunnable;

public class EventsListener
implements Listener {
    private CraftsCreationHandler craftsHandler = new CraftsCreationHandler();

    @EventHandler
    public void onPlayerJoins(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        new PermissionLoader(player.getUniqueId().toString(), true);
        this.checkUpdate(player);
    }

    private void checkUpdate(final Player player) {
        if (player.isOp()) {
            new BukkitRunnable(){

                public void run() {
                    new HighlightManagerProxy(player);
                }
            }.runTaskAsynchronously(Crafter.PLUGIN_INSTANCE);
        }
    }

    @EventHandler
    public void onItemCrafted(PrepareItemCraftEvent event) {
        List humans = event.getViewers();
        ItemStack[] items = Arrays.copyOfRange(event.getInventory().getContents(), 1, 10);
        String recipeStr = Utils.buildCraftStr(items);
        if (CraftsRegister.hasRecipe(recipeStr)) {
            for (HumanEntity human : humans) {
                if ((CraftsRegister.getIngredientsKeys(recipeStr).size() != 9 || CraftsRegister.getIngredientsKeys(recipeStr).equals(Utils.buildIngredientsKeys(items))) && (CraftsRegister.getPermission(recipeStr) == null || human.hasPermission(CraftsRegister.getPermission(recipeStr)))) continue;
                event.getInventory().setResult(new ItemStack(Material.AIR));
            }
        }
    }

    @EventHandler
    public void onItemEnchanted(EnchantItemEvent event) {
        ItemMeta meta;
        ItemStack item = event.getItem();
        if (item != null && (meta = item.getItemMeta()) != null) {
            if (meta.hasItemFlag(ItemFlag.HIDE_ENCHANTS)) {
                meta.removeItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
            }
            meta.setLore(null);
            item.setItemMeta(meta);
        }
    }

    @EventHandler
    public void onInventoryClosed(InventoryCloseEvent event) {
        HumanEntity player = event.getPlayer();
        if (this.craftsHandler.isCrafter(player)) {
            this.craftsHandler.beginCraft(player, event.getInventory());
        }
    }

    @EventHandler
    public void onPlayerChat(AsyncPlayerChatEvent event) {
        final Player player = event.getPlayer();
        final String message = event.getMessage();
        if (this.craftsHandler.isCrafter((HumanEntity)player)) {
            event.setCancelled(true);
            new BukkitRunnable(){

                public void run() {
                    EventsListener.this.craftsHandler.onInput(player, message);
                }
            }.runTask(Crafter.PLUGIN_INSTANCE);
        }
    }

    @EventHandler
    public void onItemUsed(PlayerInteractEvent event) {
        String potionEffects;
        Player player;
        PlayerInventory inventory;
        ItemStack item;
        EquipmentSlot slot;
        if ((event.getAction() == Action.RIGHT_CLICK_AIR || event.getAction() == Action.RIGHT_CLICK_BLOCK) && (slot = Utils.getEquipmentSlot(item = InventorySupport.getItemInHand(inventory = (player = event.getPlayer()).getInventory()))) != EquipmentSlot.HAND && inventory.getItem(34 + slot.ordinal() + (FeatureSupport.isFeatureSupported(FeatureSupport.Feature.MAIN_HAND) ? 0 : 1)) == null && (potionEffects = this.getPotionEffects(item)) != null) {
            this.addPotionEffects(potionEffects, player);
        }
    }

    @EventHandler
    public void onItemHeld(PlayerItemHeldEvent event) {
        String potionEffects;
        Player player = event.getPlayer();
        ItemStack previousItem = player.getInventory().getItem(event.getPreviousSlot());
        ItemStack currentItem = player.getInventory().getItem(event.getNewSlot());
        if (previousItem != null && Utils.getEquipmentSlot(previousItem) == EquipmentSlot.HAND && (potionEffects = this.getPotionEffects(previousItem)) != null) {
            this.removePotionEffects(potionEffects, player);
        }
        if (currentItem != null && Utils.getEquipmentSlot(currentItem) == EquipmentSlot.HAND && (potionEffects = this.getPotionEffects(currentItem)) != null) {
            this.addPotionEffects(potionEffects, player);
        }
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        if (event.getSlotType() == InventoryType.SlotType.ARMOR && event.getWhoClicked() instanceof Player) {
            Player player = (Player)event.getWhoClicked();
            ItemStack previousItem = event.getCurrentItem();
            ItemStack currentItem = event.getCursor();
            String potionEffects = this.getPotionEffects(previousItem);
            if (potionEffects != null) {
                this.removePotionEffects(potionEffects, player);
            }
            if ((potionEffects = this.getPotionEffects(currentItem)) != null) {
                this.addPotionEffects(potionEffects, player);
            }
        }
    }

    private String getPotionEffects(ItemStack item) {
        return ItemDataContainerSupport.loadDataAsString(item, ItemDataContainerSupport.Key.POTION_EFFECTS);
    }

    private void addPotionEffects(String potionEffects, Player player) {
        String[] stringArray = potionEffects.split(" ");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String potionEffect = stringArray[n2];
            String[] args = potionEffect.split(",");
            player.addPotionEffect(new PotionEffect(PotionEffectType.getByName((String)args[0]), Integer.MAX_VALUE, Integer.parseInt(args[1])));
            ++n2;
        }
    }

    private void removePotionEffects(String potionEffects, Player player) {
        String[] stringArray = potionEffects.split(" ");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String potionEffect = stringArray[n2];
            String[] args = potionEffect.split(",");
            if (player.hasPotionEffect(PotionEffectType.getByName((String)args[0]))) {
                player.removePotionEffect(PotionEffectType.getByName((String)args[0]));
            }
            ++n2;
        }
    }

    public void addCrafter(Player player) {
        this.craftsHandler.addCrafter((HumanEntity)player);
    }
}

