/*
 * Decompiled with CFR 0.152.
 */
package me.helldiner.crafter;

import java.lang.reflect.InvocationTargetException;
import java.net.URLClassLoader;
import java.util.HashMap;
import java.util.Map;
import me.helldiner.crafter.CommandsExecutor;
import me.helldiner.crafter.EventsListener;
import me.helldiner.crafter.craft.CraftsLoader;
import me.helldiner.crafter.lang.PluginTranslator;
import me.helldiner.crafter.library.LibraryLoader;
import me.helldiner.crafter.load.ConfigLoader;
import me.helldiner.crafter.load.PermissionLoader;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.PluginCommand;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class Crafter
extends JavaPlugin {
    public static final String CHAT_PREFIX = ChatColor.GOLD + ChatColor.WHITE + "[" + ChatColor.GOLD + ChatColor.GOLD + "Crafter" + ChatColor.GOLD + ChatColor.WHITE + "] " + ChatColor.RESET;
    public static final String PERMISSION = "crafter.admin";
    public static URLClassLoader highlightLibraryLoader;
    public static URLClassLoader syntaxLibraryLoader;
    public static URLClassLoader translationLibraryLoader;
    public static Plugin PLUGIN_INSTANCE;

    public void onEnable() {
        highlightLibraryLoader = new LibraryLoader("HighlightLibrary", this.getLogger(), this.getClassLoader()).getLibraryLoader();
        syntaxLibraryLoader = new LibraryLoader("SyntaxHelper", this.getLogger(), this.getClassLoader()).getLibraryLoader();
        translationLibraryLoader = new LibraryLoader("PluginTranslator", this.getLogger(), this.getClassLoader()).getLibraryLoader();
        PLUGIN_INSTANCE = this;
        new ConfigLoader();
        PluginTranslator.readValues();
        for (Player player : Bukkit.getOnlinePlayers()) {
            new PermissionLoader(player.getUniqueId().toString(), true);
        }
        EventsListener listener = new EventsListener();
        new CraftsLoader();
        this.getServer().getPluginManager().registerEvents((Listener)listener, (Plugin)this);
        CommandsExecutor executor = new CommandsExecutor(listener);
        PluginCommand command = this.getCommand("crafter");
        command.setExecutor((CommandExecutor)executor);
        this.configureTabCompletion(command);
    }

    private void configureTabCompletion(PluginCommand command) {
        try {
            Class<?> tabCompletionClass = Class.forName("me.helldiner.syntaxhelper.tabcompletion.TabCompletion", false, syntaxLibraryLoader);
            Class<?> tabCompletionFieldClass = Class.forName("me.helldiner.syntaxhelper.tabcompletion.Field", false, syntaxLibraryLoader);
            Object tabCompletion = tabCompletionClass.getConstructor(String.class).newInstance(command.getName());
            command.setTabCompleter((TabCompleter)tabCompletion);
            Object DEFINED_VALUE_FIELD = tabCompletionFieldClass.getField("DEFINED_VALUE").get(null);
            Object PLAYER_FIELD = tabCompletionFieldClass.getField("PLAYER").get(null);
            HashMap<Integer, Integer> indexes = new HashMap<Integer, Integer>();
            tabCompletionClass.getMethod("registerSubCommand", String.class, Object[].class).invoke(tabCompletion, "create", new Object[0]);
            indexes.put(0, 0);
            tabCompletionClass.getMethod("registerSubCommand", String.class, Object[].class, String[][].class, Map.class).invoke(tabCompletion, new Object[]{"config", new Object[]{DEFINED_VALUE_FIELD}, new String[][]{{"load", "reset"}}, indexes});
            indexes.clear();
            indexes.put(0, 0);
            tabCompletionClass.getMethod("registerSubCommand", String.class, Object[].class, String[][].class, Map.class).invoke(tabCompletion, new Object[]{"permission", new Object[]{DEFINED_VALUE_FIELD, PLAYER_FIELD}, new String[][]{{"give", "remove"}}, indexes});
            indexes.clear();
            indexes.put(0, 0);
            tabCompletionClass.getMethod("registerSubCommand", String.class, Object[].class, String[][].class, Map.class).invoke(tabCompletion, new Object[]{"lang", new Object[]{DEFINED_VALUE_FIELD, PLAYER_FIELD}, new String[][]{{"FR", "EN", "ES"}}, indexes});
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchFieldException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            e.printStackTrace();
        }
    }
}

