/*
 * Decompiled with CFR 0.152.
 */
package me.helldiner.crafter;

import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import me.helldiner.crafter.Crafter;
import me.helldiner.crafter.EventsListener;
import me.helldiner.crafter.lang.PluginTranslator;
import me.helldiner.crafter.lang.TextValues;
import me.helldiner.crafter.utils.Utils;
import org.bukkit.ChatColor;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.BlockCommandSender;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class CommandsExecutor
implements CommandExecutor {
    private EventsListener listener;
    private Plugin plugin;
    private Class<?> errorUtilsClass;

    public CommandsExecutor(EventsListener listener) {
        this.listener = listener;
        this.plugin = Crafter.PLUGIN_INSTANCE;
        try {
            this.errorUtilsClass = Class.forName("me.helldiner.syntaxhelper.error.ErrorUtils", false, Crafter.syntaxLibraryLoader);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!this.checkPermission(sender)) {
            return true;
        }
        try {
            switch (command.getName()) {
                case "crafter": {
                    if (args.length < 1) {
                        this.errorUtilsClass.getMethod("sendMissingArgError", CommandSender.class, String.class, String[].class).invoke(null, sender, "/crafter", new String[]{"subcommand"});
                        return true;
                    }
                    switch (args[0]) {
                        case "config": {
                            if (args.length < 2) {
                                this.errorUtilsClass.getMethod("sendMissingArgError", CommandSender.class, String.class, String[].class).invoke(null, sender, "/crafter config", new String[]{"action"});
                                return true;
                            }
                            if (!args[1].equals("load") && !args[1].equals("reset")) {
                                this.errorUtilsClass.getMethod("sendWrongArgError", CommandSender.class, String.class, String.class, String[].class, String[].class, Integer.TYPE).invoke(null, sender, "action", "crafter", new String[]{"load", "reset"}, args, 1);
                                return true;
                            }
                            if (args[1].equals("reset")) {
                                Utils.writeDefaultConfig();
                                sender.sendMessage(String.valueOf(Crafter.CHAT_PREFIX) + ChatColor.GREEN + TextValues.COMMAND_RESET_SUCCESS + " !");
                            }
                            Utils.loadConfig(this.plugin);
                            sender.sendMessage(String.valueOf(Crafter.CHAT_PREFIX) + ChatColor.GREEN + TextValues.COMMAND_RELOAD_SUCCESS + " !");
                            return true;
                        }
                        case "permission": {
                            if (args.length < 3) {
                                if (args.length < 2) {
                                    this.errorUtilsClass.getMethod("sendMissingArgError", CommandSender.class, String.class, String[].class).invoke(null, sender, "/crafter permission", new String[]{"action"});
                                    return true;
                                }
                                this.errorUtilsClass.getMethod("sendMissingArgError", CommandSender.class, String.class, String[].class).invoke(null, sender, "/crafter permission " + args[1], new String[]{"player_name"});
                                return true;
                            }
                            if (!args[1].equals("give") && !args[1].equals("remove")) {
                                this.errorUtilsClass.getMethod("sendWrongArgError", CommandSender.class, String.class, String.class, String[].class, String[].class, Integer.TYPE).invoke(null, sender, "action", "crafter", new String[]{"give", "remove"}, args, 1);
                                return true;
                            }
                            OfflinePlayer offPlayer = Utils.getOfflinePlayer(args[2]);
                            if (offPlayer == null) {
                                this.errorUtilsClass.getMethod("sendCustomError", CommandSender.class, String.class).invoke(null, sender, "Player " + ChatColor.DARK_RED + args[2] + ChatColor.RED + " not found !");
                                return true;
                            }
                            Player player = offPlayer.getPlayer();
                            if (args[1].equals("give")) {
                                if (!Utils.givePlayerPermission(player, offPlayer)) {
                                    this.errorUtilsClass.getMethod("sendCustomError", CommandSender.class, String.class).invoke(null, sender, "Player was already given the permission !");
                                    return true;
                                }
                                sender.sendMessage(String.valueOf(Crafter.CHAT_PREFIX) + ChatColor.GREEN + TextValues.COMMAND_ADD_PERMISSION_SUCCESS + " !");
                                return true;
                            }
                            if (!Utils.removePlayerPermission(player, offPlayer)) {
                                this.errorUtilsClass.getMethod("sendCustomError", CommandSender.class, String.class).invoke(null, sender, "Player doesn't own the permission !");
                                return true;
                            }
                            sender.sendMessage(String.valueOf(Crafter.CHAT_PREFIX) + ChatColor.GREEN + TextValues.COMMAND_REMOVE_PERMISSION_SUCCESS + " !");
                            return true;
                        }
                        case "create": {
                            if (!(sender instanceof Player)) {
                                this.errorUtilsClass.getMethod("sendMustBePlayerError", CommandSender.class).invoke(null, sender);
                                return true;
                            }
                            Player player = (Player)sender;
                            player.openWorkbench(null, true);
                            this.listener.addCrafter(player);
                            return true;
                        }
                        case "lang": {
                            if (args.length < 2) {
                                this.errorUtilsClass.getMethod("sendMissingArgError", CommandSender.class, String.class, String[].class).invoke(null, sender, "/crafter lang", new String[]{"lang_code"});
                                return true;
                            }
                            String languageCode = args[1].toUpperCase();
                            if (!Arrays.asList("FR", "EN", "ES").contains(languageCode)) {
                                this.errorUtilsClass.getMethod("sendWrongArgError", CommandSender.class, String.class, String.class, String[].class, String[].class, Integer.TYPE).invoke(null, sender, "lang_code", "crafter", new String[]{"FR", "EN", "ES"}, args, 1);
                                return true;
                            }
                            sender.sendMessage(String.valueOf(Crafter.CHAT_PREFIX) + ChatColor.GOLD + TextValues.COMMAND_START_LANG_DOWNLOAD + "...");
                            PluginTranslator.downloadValues(languageCode);
                            sender.sendMessage(String.valueOf(Crafter.CHAT_PREFIX) + ChatColor.GREEN + TextValues.COMMAND_LANG_SETUP_SUCCESS + " !");
                            return true;
                        }
                        default: {
                            this.errorUtilsClass.getMethod("sendWrongArgError", CommandSender.class, String.class, String.class, String[].class, String[].class, Integer.TYPE).invoke(null, sender, "subcommand", "crafter", new String[]{"create", "config", "permission", "lang"}, args, 0);
                            return true;
                        }
                        case "list": 
                    }
                    return false;
                }
            }
            return false;
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            e.printStackTrace();
        }
        return false;
    }

    private boolean checkPermission(CommandSender sender) {
        boolean isPermEnabled = Crafter.PLUGIN_INSTANCE.getConfig().getBoolean("enable-permission");
        if ((isPermEnabled ? !sender.hasPermission("crafter.admin") : !sender.isOp()) && !(sender instanceof ConsoleCommandSender) && !(sender instanceof BlockCommandSender)) {
            sender.sendMessage(String.valueOf(Crafter.CHAT_PREFIX) + ChatColor.RED + TextValues.COMMAND_UNAUTHORIZED + " !");
            return false;
        }
        return true;
    }
}

