/*
 * Decompiled with CFR 0.152.
 */
package phonon.puppet.utils.file;

import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import phonon.puppet.utils.file.FileKt;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=2, d1={"\u0000$\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a \u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u0006\u001a\u000e\u0010\b\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\u0006\u001a\u0016\u0010\n\u001a\u00020\u00012\u0006\u0010\t\u001a\u00020\u00062\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u0016\u0010\u000b\u001a\u00020\u00012\u0006\u0010\f\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u0003\u001a \u0010\u000e\u001a\b\u0012\u0004\u0012\u0002H\u000f0\u0005\"\b\b\u0000\u0010\u000f*\u00020\u0010*\b\u0012\u0004\u0012\u0002H\u000f0\u0011\u00a8\u0006\u0012"}, d2={"deleteDirectory", "", "path", "Ljava/nio/file/Path;", "listFilesInDir", "", "", "ext", "removeFileExtension", "s", "writeStringToFile", "zipDirectory", "folder", "outputPath", "toList", "T", "", "Ljava/util/stream/Stream;", "phonon-puppet"})
public final class FileKt {
    @NotNull
    public static final <T> List<T> toList(@NotNull Stream<T> $this$toList) {
        Intrinsics.checkParameterIsNotNull($this$toList, "$this$toList");
        List list = $this$toList.collect(Collectors.toList());
        Intrinsics.checkExpressionValueIsNotNull(list, "this.collect(Collectors.toList<T>())");
        return list;
    }

    @NotNull
    public static final String removeFileExtension(@NotNull String s) {
        String string;
        Intrinsics.checkParameterIsNotNull(s, "s");
        int index = StringsKt.lastIndexOf$default((CharSequence)s, ".", 0, false, 6, null);
        if (index == -1) {
            string = s;
        } else {
            String string2 = s;
            int n = 0;
            boolean bl = false;
            String string3 = string2.substring(n, index);
            string = string3;
            Intrinsics.checkExpressionValueIsNotNull(string3, "(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        }
        String withoutExt = string;
        return withoutExt;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<String> listFilesInDir(@NotNull Path path, @Nullable String ext) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkParameterIsNotNull(path, "path");
        Stream<Path> stream2 = Files.walk(path, 1, new FileVisitOption[0]).filter(listFilesInDir.stream.1.INSTANCE);
        if (ext != null) {
            stream2 = stream2.filter(new Predicate<Path>(ext){
                final /* synthetic */ String $ext;

                public final boolean test(Path item) {
                    return StringsKt.endsWith$default(((Object)item).toString(), this.$ext, false, 2, null);
                }
                {
                    this.$ext = string;
                }
            });
        }
        Stream<Path> stream3 = stream2;
        Intrinsics.checkExpressionValueIsNotNull(stream3, "stream");
        Iterable $this$map$iv = FileKt.toList(stream3);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void item;
            Path path2 = (Path)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String string = item.toString();
            collection.add(string);
        }
        List files = (List)destination$iv$iv;
        return files;
    }

    public static /* synthetic */ List listFilesInDir$default(Path path, String string, int n, Object object) {
        if ((n & 2) != 0) {
            string = null;
        }
        return FileKt.listFilesInDir(path, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void writeStringToFile(@NotNull String s, @NotNull Path path) {
        Intrinsics.checkParameterIsNotNull(s, "s");
        Intrinsics.checkParameterIsNotNull(path, "path");
        Closeable closeable = Files.newBufferedWriter(path, StandardCharsets.UTF_8, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
        boolean bl = false;
        Throwable throwable = null;
        try {
            BufferedWriter writer = (BufferedWriter)closeable;
            boolean bl2 = false;
            try {
                writer.write(s);
                writer.close();
            }
            catch (Exception err) {
                err.printStackTrace();
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally(closeable, throwable);
        }
    }

    public static final void deleteDirectory(@NotNull Path path) {
        Intrinsics.checkParameterIsNotNull(path, "path");
        if (!Files.exists(path, new LinkOption[0])) {
            return;
        }
        Files.walk(path, new FileVisitOption[0]).sorted(Comparator.reverseOrder()).map(deleteDirectory.1.INSTANCE).forEach(deleteDirectory.2.INSTANCE);
    }

    public static final void zipDirectory(@NotNull Path folder, @NotNull Path outputPath) {
        Intrinsics.checkParameterIsNotNull(folder, "folder");
        Intrinsics.checkParameterIsNotNull(outputPath, "outputPath");
        ZipOutputStream zos = new ZipOutputStream(new FileOutputStream(outputPath.toFile()));
        zos.setMethod(8);
        zos.setLevel(4);
        Files.walkFileTree(folder, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(folder, zos){
            final /* synthetic */ Path $folder;
            final /* synthetic */ ZipOutputStream $zos;

            @NotNull
            public FileVisitResult visitFile(@NotNull Path file, @NotNull BasicFileAttributes attrs) {
                Intrinsics.checkParameterIsNotNull(file, "file");
                Intrinsics.checkParameterIsNotNull(attrs, "attrs");
                String f = ((Object)this.$folder.relativize(file)).toString();
                if (File.separatorChar != '/') {
                    f = StringsKt.replace$default(f, "\\", "/", false, 4, null);
                }
                this.$zos.putNextEntry(new ZipEntry(f));
                Files.copy(file, this.$zos);
                this.$zos.closeEntry();
                return FileVisitResult.CONTINUE;
            }
            {
                this.$folder = $captured_local_variable$0;
                this.$zos = $captured_local_variable$1;
            }
        });
        zos.finish();
        zos.close();
    }
}

