/*
 * Decompiled with CFR 0.152.
 */
package phonon.puppet.resourcepack;

import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Stream;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import phonon.puppet.Config;
import phonon.puppet.animation.AnimationTrack;
import phonon.puppet.objects.Skeleton;
import phonon.puppet.resourcepack.BoneAnimationData;
import phonon.puppet.resourcepack.LoadCustomModelDataFromJsonKt;
import phonon.puppet.resourcepack.LoadSkeletonAnimationFromJsonKt;
import phonon.puppet.resourcepack.ModelData;
import phonon.puppet.resourcepack.ModelFileData;
import phonon.puppet.resourcepack.Resource;
import phonon.puppet.resourcepack.ResourceKt;
import phonon.puppet.utils.file.FileKt;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006J\u0006\u0010\b\u001a\u00020\u0004J\u0006\u0010\t\u001a\u00020\nJ\u0016\u0010\u000b\u001a\u00020\f2\u000e\b\u0002\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006J\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\u000f\u001a\u00020\u0010J\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000f\u001a\u00020\u0010J\u001c\u0010\u0013\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\u0014\u001a\u00020\u0010\u00a8\u0006\u0015"}, d2={"Lphonon/puppet/resourcepack/Resource;", "", "()V", "generateResourcePack", "", "customModelData", "", "", "initialize", "load", "Lphonon/puppet/resourcepack/ModelData;", "loadCustomModelData", "Lphonon/puppet/resourcepack/ModelFileData;", "existingData", "loadCustomModelDataCache", "path", "Ljava/nio/file/Path;", "loadSkeletonAnimation", "Lphonon/puppet/resourcepack/BoneAnimationData;", "saveCustomModelDataCache", "outputPath", "phonon-puppet"})
public final class Resource {
    public static final Resource INSTANCE;

    public final void initialize() {
        Path pathModels = Paths.get(Config.INSTANCE.getPathPlugin(), Config.INSTANCE.getPathModels());
        Path pathResourcePack = Paths.get(Config.INSTANCE.getPathPlugin(), Config.INSTANCE.getPathResourcePack());
        Files.createDirectories(pathModels, new FileAttribute[0]);
        Files.createDirectories(pathResourcePack, new FileAttribute[0]);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final ModelData load() {
        void customModelData;
        Path pathCustomModelData;
        Path pathModels = Paths.get(Config.INSTANCE.getPathPlugin(), Config.INSTANCE.getPathModels());
        Path path = pathCustomModelData = pathModels.resolve(Config.INSTANCE.getPathCustomModelData());
        Intrinsics.checkExpressionValueIsNotNull(path, "pathCustomModelData");
        List<String> existingCustomModelData = this.loadCustomModelDataCache(path);
        ModelFileData modelFileData = this.loadCustomModelData(existingCustomModelData);
        List<String> list = modelFileData.component1();
        List<Path> animationFiles = modelFileData.component2();
        INSTANCE.generateResourcePack((List<String>)customModelData);
        INSTANCE.saveCustomModelDataCache((List<String>)customModelData, pathCustomModelData);
        boolean bl = false;
        List skeletons = new ArrayList();
        boolean bl2 = false;
        List animations = new ArrayList();
        for (Path animData : animationFiles) {
            try {
                void modelSkeleton;
                BoneAnimationData boneAnimationData = INSTANCE.loadSkeletonAnimation(animData);
                List<Skeleton> list2 = boneAnimationData.component1();
                List<AnimationTrack> modelAnimations = boneAnimationData.component2();
                skeletons.addAll((Collection)modelSkeleton);
                animations.addAll((Collection)modelAnimations);
            }
            catch (Exception err) {
                System.err.println("[Puppet] Failed to parse " + animData);
                err.printStackTrace();
            }
        }
        return new ModelData((List<String>)customModelData, CollectionsKt.toList(skeletons), CollectionsKt.toList(animations));
    }

    @NotNull
    public final List<String> loadCustomModelDataCache(@NotNull Path path) {
        Intrinsics.checkParameterIsNotNull(path, "path");
        if (Files.exists(path, new LinkOption[0])) {
            return LoadCustomModelDataFromJsonKt.loadCustomModelDataFromJson(path);
        }
        boolean bl = false;
        return CollectionsKt.emptyList();
    }

    /*
     * WARNING - void declaration
     */
    public final void saveCustomModelDataCache(@NotNull List<String> customModelData, @NotNull Path outputPath) {
        Intrinsics.checkParameterIsNotNull(customModelData, "customModelData");
        Intrinsics.checkParameterIsNotNull(outputPath, "outputPath");
        try {
            StringBuilder json = new StringBuilder();
            json.append("{\n  \"models\": [\n");
            boolean bl = false;
            for (String s : (Iterable)customModelData) {
                void i;
                json.append("    \"" + s + '\"');
                if (i < customModelData.size() - 1) {
                    json.append(",\n");
                }
                ++i;
            }
            json.append("\n  ]\n}");
            String string = json.toString();
            Intrinsics.checkExpressionValueIsNotNull(string, "json.toString()");
            FileKt.writeStringToFile(string, outputPath);
        }
        catch (Exception err) {
            err.printStackTrace();
        }
    }

    @NotNull
    public final BoneAnimationData loadSkeletonAnimation(@NotNull Path path) {
        Intrinsics.checkParameterIsNotNull(path, "path");
        return LoadSkeletonAnimationFromJsonKt.loadSkeletonAnimationFromJson(path);
    }

    @NotNull
    public final ModelFileData loadCustomModelData(@NotNull List<String> existingData) {
        Intrinsics.checkParameterIsNotNull(existingData, "existingData");
        Set existingDataSet = CollectionsKt.toSet((Iterable)existingData);
        boolean bl = false;
        List modelsToAdd = new ArrayList();
        Path pathPlugin = Paths.get(Config.INSTANCE.getPathPlugin(), new String[0]);
        Path pathModels = pathPlugin.resolve(Config.INSTANCE.getPathModels());
        Stream<Path> modelDirectories2 = Files.walk(pathModels, 1, new FileVisitOption[0]).filter(new Predicate<Path>(pathModels){
            final /* synthetic */ Path $pathModels;

            public final boolean test(Path item) {
                return Files.isDirectory(item, new LinkOption[0]) && !((Object)item).equals(this.$pathModels);
            }
            {
                this.$pathModels = path;
            }
        });
        boolean bl2 = false;
        List animationFiles = new ArrayList();
        Iterator iterator2 = modelDirectories2.iterator();
        while (iterator2.hasNext()) {
            Path dir = (Path)iterator2.next();
            Files.walk(dir, 1, new FileVisitOption[0]).filter(loadCustomModelData.1.INSTANCE).map(loadCustomModelData.2.INSTANCE).filter((Predicate)new Predicate<String>(animationFiles, dir){
                final /* synthetic */ List $animationFiles;
                final /* synthetic */ Path $dir;

                public final boolean test(String s) {
                    boolean bl;
                    String string = s;
                    Intrinsics.checkExpressionValueIsNotNull(string, "s");
                    if (StringsKt.endsWith$default(string, ".json", false, 2, null)) {
                        if (StringsKt.endsWith$default(s, ResourceKt.access$getMODEL_DATA_FILE_EXT$p(), false, 2, null)) {
                            Path path = this.$dir.resolve(s);
                            Intrinsics.checkExpressionValueIsNotNull(path, "dir.resolve(s)");
                            this.$animationFiles.add(path);
                            bl = false;
                        } else {
                            bl = true;
                        }
                    } else {
                        bl = false;
                    }
                    return bl;
                }
                {
                    this.$animationFiles = list;
                    this.$dir = path;
                }
            }).map(loadCustomModelData.4.INSTANCE).filter((Predicate)new Predicate<String>(existingDataSet){
                final /* synthetic */ Set $existingDataSet;

                public final boolean test(String s) {
                    return !this.$existingDataSet.contains(s);
                }
                {
                    this.$existingDataSet = set;
                }
            }).forEach((Consumer)new Consumer<String>(modelsToAdd){
                final /* synthetic */ List $modelsToAdd;

                public final void accept(String s) {
                    String string = s;
                    Intrinsics.checkExpressionValueIsNotNull(string, "s");
                    this.$modelsToAdd.add(string);
                }
                {
                    this.$modelsToAdd = list;
                }
            });
        }
        List<String> customModelData = CollectionsKt.plus((Collection)existingData, (Iterable)modelsToAdd);
        return new ModelFileData(customModelData, animationFiles);
    }

    public static /* synthetic */ ModelFileData loadCustomModelData$default(Resource resource, List list, int n, Object object) {
        if ((n & 1) != 0) {
            boolean bl = false;
            list = CollectionsKt.emptyList();
        }
        return resource.loadCustomModelData(list);
    }

    /*
     * WARNING - void declaration
     */
    public final void generateResourcePack(@NotNull List<String> customModelData) {
        Path pathZip;
        Path pathBuild;
        Intrinsics.checkParameterIsNotNull(customModelData, "customModelData");
        Path pathPlugin = Paths.get(Config.INSTANCE.getPathPlugin(), new String[0]);
        Path pathResourcePack = pathPlugin.resolve(Config.INSTANCE.getPathResourcePack());
        Path path = pathBuild = pathResourcePack.resolve("build");
        Intrinsics.checkExpressionValueIsNotNull(path, "pathBuild");
        FileKt.deleteDirectory(path);
        Files.createDirectories(pathBuild, new FileAttribute[0]);
        Path pathMetadataInput = pathResourcePack.resolve(Config.INSTANCE.getPathResourcePackMeta());
        Path pathIconInput = pathResourcePack.resolve(Config.INSTANCE.getPathResourcePackIcon());
        Path pathMetadataOutput = pathBuild.resolve("pack.mcmeta");
        Path pathIconOutput = pathBuild.resolve("pack.png");
        if (Files.exists(pathMetadataInput, new LinkOption[0]) && Files.isRegularFile(pathMetadataInput, new LinkOption[0])) {
            Files.copy(pathMetadataInput, pathMetadataOutput, StandardCopyOption.REPLACE_EXISTING);
        } else {
            String string = ResourceKt.access$getPACK_METADATA$p();
            Path path2 = pathMetadataOutput;
            Intrinsics.checkExpressionValueIsNotNull(path2, "pathMetadataOutput");
            FileKt.writeStringToFile(string, path2);
        }
        if (Files.exists(pathIconInput, new LinkOption[0]) && Files.isRegularFile(pathIconInput, new LinkOption[0])) {
            Files.copy(pathIconInput, pathIconOutput, StandardCopyOption.REPLACE_EXISTING);
        }
        Path pathBuildModels = pathBuild.resolve(Paths.get("assets", "minecraft", "models", "item"));
        Path pathBuildTextures = pathBuild.resolve(Paths.get("assets", "minecraft", "textures"));
        Files.createDirectories(pathBuildModels, new FileAttribute[0]);
        Files.createDirectories(pathBuildTextures, new FileAttribute[0]);
        Path pathModels = pathPlugin.resolve(Config.INSTANCE.getPathModels());
        Stream<Path> modelDirectories2 = Files.walk(pathModels, 1, new FileVisitOption[0]).filter(new Predicate<Path>(pathModels){
            final /* synthetic */ Path $pathModels;

            public final boolean test(Path item) {
                return Files.isDirectory(item, new LinkOption[0]) && !((Object)item).equals(this.$pathModels);
            }
            {
                this.$pathModels = path;
            }
        });
        boolean bl = false;
        HashMap<String, String> modelPartToName = new HashMap<String, String>();
        Object object = modelDirectories2.iterator();
        while (object.hasNext()) {
            Object pathModelOutput;
            Path dir = (Path)object.next();
            boolean bl2 = false;
            List jsonFiles = new ArrayList();
            boolean bl3 = false;
            HashMap textures = new HashMap();
            Files.walk(dir, 1, new FileVisitOption[0]).filter(generateResourcePack.1.INSTANCE).forEach(new Consumer<Path>(jsonFiles, textures){
                final /* synthetic */ List $jsonFiles;
                final /* synthetic */ HashMap $textures;

                public final void accept(Path item) {
                    String s = ((Object)item).toString();
                    if (StringsKt.endsWith$default(s, ".json", false, 2, null) && !StringsKt.endsWith$default(s, ResourceKt.access$getMODEL_DATA_FILE_EXT$p(), false, 2, null)) {
                        Path path = item;
                        Intrinsics.checkExpressionValueIsNotNull(path, "item");
                        this.$jsonFiles.add(path);
                    } else if (StringsKt.endsWith$default(s, ".png", false, 2, null) || StringsKt.endsWith$default(s, ".jpg", false, 2, null) || StringsKt.endsWith$default(s, ".jpeg", false, 2, null)) {
                        String textureName = FileKt.removeFileExtension(((Object)item.getName(item.getNameCount() - 1)).toString());
                        this.$textures.put(textureName, item);
                    }
                }
                {
                    this.$jsonFiles = list;
                    this.$textures = hashMap;
                }
            });
            if (jsonFiles.size() == 0) continue;
            String modelName = ((Object)dir.getName(dir.getNameCount() - 1)).toString();
            Files.createDirectories(pathBuildModels.resolve(modelName), new FileAttribute[0]);
            boolean bl4 = false;
            HashMap<Path, Path> texturesToCopy = new HashMap<Path, Path>();
            for (Path modelPart : jsonFiles) {
                pathModelOutput = pathBuildModels.resolve(pathModels.relativize(modelPart));
                Files.copy(modelPart, (Path)pathModelOutput, StandardCopyOption.REPLACE_EXISTING);
                String chunkName = FileKt.removeFileExtension(((Object)modelPart.getName(modelPart.getNameCount() - 1)).toString());
                modelPartToName.put(chunkName, modelName);
                try {
                    List texturePaths = ResourceKt.access$readModelTextures(modelPart);
                    for (Path texture : texturePaths) {
                        String textureName = FileKt.removeFileExtension(((Object)texture.getName(texture.getNameCount() - 1)).toString());
                        Path pathTextureIn = (Path)textures.get(textureName);
                        if (pathTextureIn == null) continue;
                        Path textureFileName = pathTextureIn.getName(pathTextureIn.getNameCount() - 1);
                        Path pathTextureOut = pathBuildTextures.resolve(texture.getParent()).resolve(textureFileName);
                        texturesToCopy.put(pathTextureOut, pathTextureIn);
                    }
                }
                catch (Exception err) {
                    err.printStackTrace();
                }
            }
            pathModelOutput = texturesToCopy;
            boolean chunkName = false;
            Iterator<Object> iterator2 = pathModelOutput.entrySet().iterator();
            while (iterator2.hasNext()) {
                Map.Entry modelPart;
                Map.Entry err = modelPart = (Map.Entry)iterator2.next();
                boolean bl5 = false;
                Path pathTextureOut = (Path)err.getKey();
                err = modelPart;
                bl5 = false;
                Path pathTextureIn = (Path)err.getValue();
                Path textureOutDir = pathTextureOut.getParent();
                Files.createDirectories(textureOutDir, new FileAttribute[0]);
                Files.copy(pathTextureIn, pathTextureOut, StandardCopyOption.REPLACE_EXISTING);
            }
        }
        object = Config.INSTANCE.getModelItem().toString();
        boolean jsonFiles = false;
        Object object2 = object;
        if (object2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string = ((String)object2).toLowerCase();
        Intrinsics.checkExpressionValueIsNotNull(string, "(this as java.lang.String).toLowerCase()");
        String itemName = string;
        Path pathCustomModelItem = pathBuildModels.resolve(itemName + ".json");
        StringBuilder itemJsonOverride = new StringBuilder(ResourceKt.access$generateItemOverrideJsonHeader(Config.INSTANCE.getModelItem()));
        boolean textures = false;
        for (String modelPart : (Iterable)customModelData) {
            void i;
            String modelName = (String)modelPartToName.get(modelPart);
            itemJsonOverride.append("        {\"predicate\": { \"custom_model_data\": " + (int)(i + true) + " }, \"model\": \"item/" + modelName + '/' + modelPart + "\"}");
            if (i < customModelData.size() - 1) {
                itemJsonOverride.append(",\n");
            }
            ++i;
        }
        itemJsonOverride.append("\n]}");
        String string2 = itemJsonOverride.toString();
        Intrinsics.checkExpressionValueIsNotNull(string2, "itemJsonOverride.toString()");
        Path path3 = pathCustomModelItem;
        Intrinsics.checkExpressionValueIsNotNull(path3, "pathCustomModelItem");
        FileKt.writeStringToFile(string2, path3);
        Path path4 = pathZip = pathResourcePack.resolve(Config.INSTANCE.getResourcePackName());
        Intrinsics.checkExpressionValueIsNotNull(path4, "pathZip");
        FileKt.zipDirectory(pathBuild, path4);
    }

    private Resource() {
    }

    static {
        Resource resource;
        INSTANCE = resource = new Resource();
    }
}

