/*
 * Decompiled with CFR 0.152.
 */
package phonon.puppet.resourcepack;

import java.io.Closeable;
import java.io.FileReader;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import phonon.puppet.animation.AnimationTrack;
import phonon.puppet.animation.Keyframe;
import phonon.puppet.math.Matrix4f;
import phonon.puppet.math.Quaternion;
import phonon.puppet.math.Vector3f;
import phonon.puppet.objects.Bone;
import phonon.puppet.objects.Skeleton;
import phonon.puppet.resourcepack.BoneAnimationData;
import phonon.puppet.resourcepack.LoadSkeletonAnimationFromJsonKt;
import shadow.gson.gson.JsonArray;
import shadow.gson.gson.JsonElement;
import shadow.gson.gson.JsonObject;
import shadow.gson.gson.JsonParser;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=2, d1={"\u0000 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0000\u00a8\u0006\n"}, d2={"loadSkeletonAnimationFromJson", "Lphonon/puppet/resourcepack/BoneAnimationData;", "path", "Ljava/nio/file/Path;", "parseBoneNode", "", "parent", "Lphonon/puppet/objects/Bone;", "current", "Lshadow/gson/gson/JsonElement;", "phonon-puppet"})
public final class LoadSkeletonAnimationFromJsonKt {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static final BoneAnimationData loadSkeletonAnimationFromJson(@NotNull Path path) {
        BoneAnimationData boneAnimationData;
        Intrinsics.checkParameterIsNotNull(path, "path");
        Closeable closeable = new FileReader(path.toFile());
        boolean bl = false;
        Throwable throwable = null;
        try {
            JsonObject jsonAnimations;
            List<Skeleton> list;
            JsonObject jsonBoneRoot;
            String modelName;
            FileReader reader = (FileReader)closeable;
            boolean bl2 = false;
            JsonElement json = new JsonParser().parse(reader);
            JsonObject jsonObj = json.getAsJsonObject();
            JsonElement jsonElement = jsonObj.get("name");
            String string = modelName = jsonElement != null ? jsonElement.getAsString() : null;
            if (modelName == null) {
                List<AnimationTrack> list2;
                System.err.println("Invalid model name while loading " + path);
                boolean bl3 = false;
                List<Skeleton> list3 = CollectionsKt.emptyList();
                bl3 = false;
                List<AnimationTrack> list4 = list2 = CollectionsKt.emptyList();
                List<Skeleton> list5 = list3;
                BoneAnimationData boneAnimationData2 = new BoneAnimationData(list5, list4);
                return boneAnimationData2;
            }
            JsonElement jsonElement2 = jsonObj.get("bones");
            JsonObject jsonObject = jsonBoneRoot = jsonElement2 != null ? jsonElement2.getAsJsonObject() : null;
            if (jsonBoneRoot != null) {
                JsonElement jsonElement3 = jsonBoneRoot.get("name");
                if (jsonElement3 == null) {
                    Intrinsics.throwNpe();
                }
                String rootName = jsonElement3.getAsString();
                Matrix4f rootMatrix = Matrix4f.Companion.identity();
                Matrix4f rootMatrixLocal = Matrix4f.Companion.identity();
                String string2 = rootName;
                Intrinsics.checkExpressionValueIsNotNull(string2, "rootName");
                Bone boneRoot = new Bone(string2, rootMatrix, rootMatrixLocal, null);
                JsonElement jsonElement4 = jsonBoneRoot.get("children");
                if (jsonElement4 == null) {
                    Intrinsics.throwNpe();
                }
                Iterator<JsonElement> iterator2 = jsonElement4.getAsJsonArray().iterator();
                while (iterator2.hasNext()) {
                    JsonElement child;
                    JsonElement jsonElement5 = child = iterator2.next();
                    Intrinsics.checkExpressionValueIsNotNull(jsonElement5, "child");
                    LoadSkeletonAnimationFromJsonKt.parseBoneNode(boneRoot, jsonElement5);
                }
                list = CollectionsKt.listOf(new Skeleton(modelName, boneRoot));
            } else {
                boolean rootName = false;
                list = CollectionsKt.emptyList();
            }
            List<Skeleton> skeleton = list;
            boolean rootMatrix = false;
            List animations = new ArrayList();
            JsonElement jsonElement6 = jsonObj.get("animation");
            JsonObject jsonObject2 = jsonAnimations = jsonElement6 != null ? jsonElement6.getAsJsonObject() : null;
            if (jsonAnimations != null) {
                for (String actionName : jsonAnimations.keySet()) {
                    JsonElement jsonElement7 = jsonAnimations.get(actionName);
                    if (jsonElement7 == null) {
                        Intrinsics.throwNpe();
                    }
                    JsonObject jsonAnimAction = jsonElement7.getAsJsonObject();
                    boolean bl4 = false;
                    HashMap<String, List<Keyframe<Vector3f>>> keyframesPosition = new HashMap<String, List<Keyframe<Vector3f>>>();
                    boolean bl5 = false;
                    HashMap<String, List<Keyframe<Quaternion>>> keyframesQuaternion = new HashMap<String, List<Keyframe<Quaternion>>>();
                    for (String boneName : jsonAnimAction.keySet()) {
                        JsonArray jsonQuaternionTrack;
                        JsonObject jsonBoneTrack;
                        JsonArray jsonPositionTrack;
                        JsonElement jsonElement8 = jsonAnimAction.get(boneName);
                        if (jsonElement8 == null) {
                            Intrinsics.throwNpe();
                        }
                        if ((jsonPositionTrack = (jsonBoneTrack = jsonElement8.getAsJsonObject()).get("position").getAsJsonArray()) != null) {
                            List track2 = SequencesKt.toList(SequencesKt.map(CollectionsKt.asSequence(jsonPositionTrack), loadSkeletonAnimationFromJson.1.track.1.INSTANCE));
                            keyframesPosition.put(boneName, track2);
                        }
                        if ((jsonQuaternionTrack = jsonBoneTrack.get("quaternion").getAsJsonArray()) == null) continue;
                        List track3 = SequencesKt.toList(SequencesKt.map(CollectionsKt.asSequence(jsonQuaternionTrack), loadSkeletonAnimationFromJson.1.track.2.INSTANCE));
                        keyframesQuaternion.put(boneName, track3);
                    }
                    String string3 = actionName;
                    Intrinsics.checkExpressionValueIsNotNull(string3, "actionName");
                    animations.add(new AnimationTrack(string3, keyframesPosition, keyframesQuaternion));
                }
            }
            boneAnimationData = new BoneAnimationData(skeleton, CollectionsKt.toList(animations));
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally(closeable, throwable);
        }
        return boneAnimationData;
    }

    /*
     * WARNING - void declaration
     */
    public static final void parseBoneNode(@NotNull Bone parent, @NotNull JsonElement current) {
        void $this$mapTo$iv$iv;
        Float f;
        Collection collection;
        Object object;
        void $this$mapTo$iv$iv2;
        Intrinsics.checkParameterIsNotNull(parent, "parent");
        Intrinsics.checkParameterIsNotNull(current, "current");
        JsonObject jsonBoneNode = current.getAsJsonObject();
        JsonElement jsonElement = jsonBoneNode.get("name");
        if (jsonElement == null) {
            Intrinsics.throwNpe();
        }
        String boneName = jsonElement.getAsString();
        JsonElement jsonElement2 = jsonBoneNode.get("matrix");
        if (jsonElement2 == null) {
            Intrinsics.throwNpe();
        }
        JsonArray jsonArray = jsonElement2.getAsJsonArray();
        Intrinsics.checkExpressionValueIsNotNull(jsonArray, "jsonBoneNode.get(\"matrix\")!!.getAsJsonArray()");
        Iterable $this$map$iv = jsonArray;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            void elem;
            object = (JsonElement)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            f = Float.valueOf(elem.getAsFloat());
            collection.add(f);
        }
        List jsonMatrix = (List)destination$iv$iv;
        JsonElement jsonElement3 = jsonBoneNode.get("matrix_world");
        if (jsonElement3 == null) {
            Intrinsics.throwNpe();
        }
        JsonArray jsonArray2 = jsonElement3.getAsJsonArray();
        Intrinsics.checkExpressionValueIsNotNull(jsonArray2, "jsonBoneNode.get(\"matrix\u2026orld\")!!.getAsJsonArray()");
        Iterable $this$map$iv2 = jsonArray2;
        boolean $i$f$map2 = false;
        destination$iv$iv = $this$map$iv2;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv2, 10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void elem;
            JsonElement bl = (JsonElement)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl2 = false;
            f = Float.valueOf(elem.getAsFloat());
            collection.add(f);
        }
        List jsonMatrixWorld = (List)destination$iv$iv2;
        List m = jsonMatrix;
        List mw = jsonMatrixWorld;
        Matrix4f boneMatrix = Matrix4f.Companion.of(((Number)m.get(0)).floatValue(), ((Number)m.get(1)).floatValue(), ((Number)m.get(2)).floatValue(), ((Number)m.get(3)).floatValue(), ((Number)m.get(4)).floatValue(), ((Number)m.get(5)).floatValue(), ((Number)m.get(6)).floatValue(), ((Number)m.get(7)).floatValue(), ((Number)m.get(8)).floatValue(), ((Number)m.get(9)).floatValue(), ((Number)m.get(10)).floatValue(), ((Number)m.get(11)).floatValue(), ((Number)m.get(12)).floatValue(), ((Number)m.get(13)).floatValue(), ((Number)m.get(14)).floatValue(), ((Number)m.get(15)).floatValue());
        Matrix4f boneMatrixWorld = Matrix4f.Companion.of(((Number)mw.get(0)).floatValue(), ((Number)mw.get(1)).floatValue(), ((Number)mw.get(2)).floatValue(), ((Number)mw.get(3)).floatValue(), ((Number)mw.get(4)).floatValue(), ((Number)mw.get(5)).floatValue(), ((Number)mw.get(6)).floatValue(), ((Number)mw.get(7)).floatValue(), ((Number)mw.get(8)).floatValue(), ((Number)mw.get(9)).floatValue(), ((Number)mw.get(10)).floatValue(), ((Number)mw.get(11)).floatValue(), ((Number)mw.get(12)).floatValue(), ((Number)mw.get(13)).floatValue(), ((Number)mw.get(14)).floatValue(), ((Number)mw.get(15)).floatValue());
        String string = boneName;
        Intrinsics.checkExpressionValueIsNotNull(string, "boneName");
        Bone boneNode = new Bone(string, boneMatrix, boneMatrixWorld, parent);
        JsonElement jsonElement4 = jsonBoneNode.get("children");
        if (jsonElement4 == null) {
            Intrinsics.throwNpe();
        }
        object = jsonElement4.getAsJsonArray().iterator();
        while (object.hasNext()) {
            JsonElement child;
            JsonElement jsonElement5 = child = (JsonElement)object.next();
            Intrinsics.checkExpressionValueIsNotNull(jsonElement5, "child");
            LoadSkeletonAnimationFromJsonKt.parseBoneNode(boneNode, jsonElement5);
        }
        parent.getChildren().add(boneNode);
    }
}

