/*
 * Decompiled with CFR 0.152.
 */
package phonon.puppet.objects;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Entity;
import org.bukkit.inventory.EntityEquipment;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.util.EulerAngle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import phonon.puppet.Config;
import phonon.puppet.Message;
import phonon.puppet.math.Euler;
import phonon.puppet.math.Matrix4f;
import phonon.puppet.math.Quaternion;
import phonon.puppet.math.Vector3f;
import phonon.puppet.objects.TransformGraphNode;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0002\b\u0005\u0018\u0000 J2\u00020\u0001:\u0002IJBC\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u000e\u00a2\u0006\u0002\u0010\u000fJ\b\u0010E\u001a\u00020FH\u0016J\u0006\u0010G\u001a\u00020FJ\b\u0010H\u001a\u00020FH\u0016R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0015\u001a\u00020\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R$\u0010\u0019\u001a\u0012\u0012\u0004\u0012\u00020\u00010\u001aj\b\u0012\u0004\u0012\u00020\u0001`\u001bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u001a\u0010\u0007\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!R\u0014\u0010\"\u001a\u00020\u000eX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$R\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010&R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010&R\u0014\u0010(\u001a\u00020)X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b*\u0010+R\u001c\u0010,\u001a\u0004\u0018\u00010\u0001X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b-\u0010.\"\u0004\b/\u00100R\u0014\u00101\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b2\u00103R\u0014\u00104\u001a\u000205X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b6\u00107R\u0014\u00108\u001a\u00020\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b9\u0010:R\u0011\u0010;\u001a\u00020<\u00a2\u0006\b\n\u0000\u001a\u0004\b=\u0010>R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b?\u0010@\"\u0004\bA\u0010BR\u0014\u0010C\u001a\u00020\u000eX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bD\u0010$\u00a8\u0006K"}, d2={"Lphonon/puppet/objects/Mesh;", "Lphonon/puppet/objects/TransformGraphNode;", "name", "", "world", "Lorg/bukkit/World;", "model", "customModelData", "", "initialPosition", "Lphonon/puppet/math/Vector3f;", "initialRotation", "Lphonon/puppet/math/Euler;", "initialMatrix", "Lphonon/puppet/math/Matrix4f;", "(Ljava/lang/String;Lorg/bukkit/World;Ljava/lang/String;ILphonon/puppet/math/Vector3f;Lphonon/puppet/math/Euler;Lphonon/puppet/math/Matrix4f;)V", "_locationBuffer", "Lorg/bukkit/Location;", "_rotationBuffer", "_rotationBuffer1", "Lorg/bukkit/util/EulerAngle;", "armorStand", "Lorg/bukkit/entity/ArmorStand;", "getArmorStand", "()Lorg/bukkit/entity/ArmorStand;", "children", "Ljava/util/ArrayList;", "Lkotlin/collections/ArrayList;", "getChildren", "()Ljava/util/ArrayList;", "getCustomModelData", "()I", "setCustomModelData", "(I)V", "matrix", "getMatrix", "()Lphonon/puppet/math/Matrix4f;", "getModel", "()Ljava/lang/String;", "getName", "needsUpdate", "", "getNeedsUpdate", "()Z", "parent", "getParent", "()Lphonon/puppet/objects/TransformGraphNode;", "setParent", "(Lphonon/puppet/objects/TransformGraphNode;)V", "position", "getPosition", "()Lphonon/puppet/math/Vector3f;", "quaternion", "Lphonon/puppet/math/Quaternion;", "getQuaternion", "()Lphonon/puppet/math/Quaternion;", "rotation", "getRotation", "()Lphonon/puppet/math/Euler;", "uuid", "Ljava/util/UUID;", "getUuid", "()Ljava/util/UUID;", "getWorld", "()Lorg/bukkit/World;", "setWorld", "(Lorg/bukkit/World;)V", "worldMatrix", "getWorldMatrix", "destroy", "", "render", "updateTransform", "Builder", "Companion", "phonon-puppet"})
public final class Mesh
implements TransformGraphNode {
    @Nullable
    private TransformGraphNode parent;
    @NotNull
    private final ArrayList<TransformGraphNode> children;
    @NotNull
    private final Matrix4f matrix;
    @NotNull
    private final Matrix4f worldMatrix;
    @NotNull
    private final Vector3f position;
    @NotNull
    private final Euler rotation;
    @NotNull
    private final Quaternion quaternion;
    private final boolean needsUpdate = false;
    @NotNull
    private final UUID uuid;
    @NotNull
    private final ArmorStand armorStand;
    private final Location _locationBuffer;
    private final Euler _rotationBuffer;
    private final EulerAngle _rotationBuffer1;
    @NotNull
    private final String name;
    @NotNull
    private World world;
    @NotNull
    private final String model;
    private int customModelData;
    @NotNull
    private static final HashMap<String, Integer> library;
    @NotNull
    private static List<String> libraryList;
    public static final Companion Companion;

    @Override
    @Nullable
    public TransformGraphNode getParent() {
        return this.parent;
    }

    @Override
    public void setParent(@Nullable TransformGraphNode transformGraphNode) {
        this.parent = transformGraphNode;
    }

    @Override
    @NotNull
    public ArrayList<TransformGraphNode> getChildren() {
        return this.children;
    }

    @Override
    @NotNull
    public Matrix4f getMatrix() {
        return this.matrix;
    }

    @Override
    @NotNull
    public Matrix4f getWorldMatrix() {
        return this.worldMatrix;
    }

    @Override
    @NotNull
    public Vector3f getPosition() {
        return this.position;
    }

    @Override
    @NotNull
    public Euler getRotation() {
        return this.rotation;
    }

    @Override
    @NotNull
    public Quaternion getQuaternion() {
        return this.quaternion;
    }

    @Override
    public boolean getNeedsUpdate() {
        return this.needsUpdate;
    }

    @NotNull
    public final UUID getUuid() {
        return this.uuid;
    }

    @NotNull
    public final ArmorStand getArmorStand() {
        return this.armorStand;
    }

    @Override
    public void destroy() {
        for (TransformGraphNode child : this.getChildren()) {
            child.destroy();
        }
        this.armorStand.remove();
    }

    @Override
    public void updateTransform() {
        this.getMatrix().compose(this.getPosition(), this.getQuaternion());
        TransformGraphNode parent = this.getParent();
        if (parent != null) {
            this.getWorldMatrix().multiplyMatrices(parent.getWorldMatrix(), this.getMatrix());
        } else {
            this.getWorldMatrix().copy(this.getMatrix());
        }
        for (TransformGraphNode child : this.getChildren()) {
            child.updateTransform();
        }
    }

    public final void render() {
        Vector3f armorStandOffset = new Vector3f(0.0f, 0.253731f, 0.0f).applyRotationMatrix4(this.getWorldMatrix());
        this._locationBuffer.setX((double)(this.getWorldMatrix().get(12) - armorStandOffset.getX()));
        this._locationBuffer.setY((double)(this.getWorldMatrix().get(13) - armorStandOffset.getY() - 1.43f));
        this._locationBuffer.setZ((double)(this.getWorldMatrix().get(14) - armorStandOffset.getZ()));
        this._rotationBuffer.setFromRotationMatrix(this.getWorldMatrix(), Euler.Companion.getZYX());
        EulerAngle rotationBufferOut = new EulerAngle((double)this._rotationBuffer.getX(), -((double)this._rotationBuffer.getY()), -((double)this._rotationBuffer.getZ()));
        ArmorStand stand = this.armorStand;
        stand.teleport(this._locationBuffer);
        stand.setHeadPose(rotationBufferOut);
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    @NotNull
    public final World getWorld() {
        return this.world;
    }

    public final void setWorld(@NotNull World world) {
        Intrinsics.checkParameterIsNotNull(world, "<set-?>");
        this.world = world;
    }

    @NotNull
    public final String getModel() {
        return this.model;
    }

    public final int getCustomModelData() {
        return this.customModelData;
    }

    public final void setCustomModelData(int n) {
        this.customModelData = n;
    }

    public Mesh(@NotNull String name, @NotNull World world, @NotNull String model, int customModelData, @NotNull Vector3f initialPosition, @NotNull Euler initialRotation, @Nullable Matrix4f initialMatrix) {
        Integer customModelData2;
        Intrinsics.checkParameterIsNotNull(name, "name");
        Intrinsics.checkParameterIsNotNull(world, "world");
        Intrinsics.checkParameterIsNotNull(model, "model");
        Intrinsics.checkParameterIsNotNull(initialPosition, "initialPosition");
        Intrinsics.checkParameterIsNotNull(initialRotation, "initialRotation");
        this.name = name;
        this.world = world;
        this.model = model;
        this.customModelData = customModelData;
        Mesh mesh = this;
        boolean bl = false;
        ArrayList arrayList = new ArrayList();
        mesh.children = arrayList;
        this.matrix = Matrix4f.Companion.identity();
        this.worldMatrix = Matrix4f.Companion.identity();
        this.position = Vector3f.Companion.zero();
        this.rotation = Euler.Companion.zero();
        this.quaternion = Quaternion.Companion.new();
        UUID uUID = UUID.randomUUID();
        Intrinsics.checkExpressionValueIsNotNull(uUID, "UUID.randomUUID()");
        this.uuid = uUID;
        this._rotationBuffer = Euler.Companion.zero();
        this._rotationBuffer1 = new EulerAngle(0.0, 0.0, 0.0);
        if (initialMatrix != null) {
            this.getMatrix().copy(initialMatrix);
            initialMatrix.decompose(this.getPosition(), this.getQuaternion());
            this.getRotation().setFromQuaternion(this.getQuaternion(), this.getRotation().getOrder());
        } else {
            this.getPosition().copy(initialPosition);
            this.getRotation().copy(initialRotation);
            this.getQuaternion().setFromEuler(initialRotation);
            this.getMatrix().compose(this.getPosition(), this.getQuaternion());
        }
        if (this.customModelData == 0 && (customModelData2 = Companion.get(this.model)) != null) {
            this.customModelData = customModelData2;
        }
        Location loc = new Location(this.world, (double)this.getPosition().getX(), (double)this.getPosition().getY(), (double)this.getPosition().getZ());
        Entity entity = this.world.spawn(loc, ArmorStand.class);
        Intrinsics.checkExpressionValueIsNotNull(entity, "world.spawn(loc, ArmorStand::class.java)");
        ArmorStand stand = (ArmorStand)entity;
        stand.setGravity(false);
        stand.setSilent(true);
        stand.setBasePlate(false);
        stand.setArms(false);
        stand.setVisible(false);
        ItemStack itemStack = new ItemStack(Config.INSTANCE.getModelItem(), 1);
        ItemMeta itemMeta = itemStack.getItemMeta();
        if (itemMeta == null) {
            Intrinsics.throwNpe();
        }
        ItemMeta meta = itemMeta;
        meta.setCustomModelData(Integer.valueOf(this.customModelData));
        itemStack.setItemMeta(meta);
        EntityEquipment entityEquipment = stand.getEquipment();
        if (entityEquipment == null) {
            Intrinsics.throwNpe();
        }
        Intrinsics.checkExpressionValueIsNotNull(entityEquipment, "stand.getEquipment()!!");
        EntityEquipment equipment = entityEquipment;
        equipment.setHelmet(itemStack);
        this.armorStand = stand;
        this._locationBuffer = loc;
        this.render();
    }

    public /* synthetic */ Mesh(String string, World world, String string2, int n, Vector3f vector3f, Euler euler, Matrix4f matrix4f, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 8) != 0) {
            n = 0;
        }
        if ((n2 & 0x40) != 0) {
            matrix4f = null;
        }
        this(string, world, string2, n, vector3f, euler, matrix4f);
    }

    static {
        Companion = new Companion(null);
        boolean bl = false;
        library = new HashMap();
        bl = false;
        libraryList = CollectionsKt.emptyList();
    }

    @Override
    public void add(@NotNull TransformGraphNode obj) {
        Intrinsics.checkParameterIsNotNull(obj, "obj");
        TransformGraphNode.DefaultImpls.add(this, obj);
    }

    @Override
    public void remove(@NotNull TransformGraphNode obj) {
        Intrinsics.checkParameterIsNotNull(obj, "obj");
        TransformGraphNode.DefaultImpls.remove(this, obj);
    }

    @Override
    public void setPosition(double x, double y, double z, boolean update) {
        TransformGraphNode.DefaultImpls.setPosition(this, x, y, z, update);
    }

    @Override
    public void setQuaternion(double x, double y, double z, double w, boolean update) {
        TransformGraphNode.DefaultImpls.setQuaternion(this, x, y, z, w, update);
    }

    @Override
    public void setRotation(double x, double y, double z, boolean update) {
        TransformGraphNode.DefaultImpls.setRotation((TransformGraphNode)this, x, y, z, update);
    }

    @Override
    public void setRotation(float x, float y, float z, boolean update) {
        TransformGraphNode.DefaultImpls.setRotation((TransformGraphNode)this, x, y, z, update);
    }

    @Override
    public void traverse(@NotNull Function1<? super TransformGraphNode, Unit> fn) {
        Intrinsics.checkParameterIsNotNull(fn, "fn");
        TransformGraphNode.DefaultImpls.traverse(this, fn);
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010'\u001a\u00020(J\u000e\u0010)\u001a\u00020\u00002\u0006\u0010*\u001a\u00020\u0004J\u000e\u0010+\u001a\u00020\u00002\u0006\u0010,\u001a\u00020\nJ\u000e\u0010-\u001a\u00020\u00002\u0006\u0010.\u001a\u00020\u0010J\u000e\u0010/\u001a\u00020\u00002\u0006\u0010.\u001a\u00020\u0010J\u001e\u00100\u001a\u00020\u00002\u0006\u00101\u001a\u0002022\u0006\u00103\u001a\u0002022\u0006\u00104\u001a\u000202J\u001e\u00100\u001a\u00020\u00002\u0006\u00101\u001a\u0002052\u0006\u00103\u001a\u0002052\u0006\u00104\u001a\u000205J\u001e\u00106\u001a\u00020\u00002\u0006\u00101\u001a\u0002022\u0006\u00103\u001a\u0002022\u0006\u00104\u001a\u000202J\u001e\u00106\u001a\u00020\u00002\u0006\u00101\u001a\u0002052\u0006\u00103\u001a\u0002052\u0006\u00104\u001a\u000205J\u000e\u00107\u001a\u00020\u00002\u0006\u00108\u001a\u00020!R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001c\u0010\t\u001a\u0004\u0018\u00010\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\u00020\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u001a\u0010\u0015\u001a\u00020\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0012\"\u0004\b\u0017\u0010\u0014R\u0011\u0010\u0018\u001a\u00020\u0019\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0011\u0010\u001c\u001a\u00020\u001d\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\"\u0010 \u001a\n \"*\u0004\u0018\u00010!0!X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010$\"\u0004\b%\u0010&\u00a8\u00069"}, d2={"Lphonon/puppet/objects/Mesh$Builder;", "", "()V", "_customModelData", "", "get_customModelData", "()I", "set_customModelData", "(I)V", "_matrix", "Lphonon/puppet/math/Matrix4f;", "get_matrix", "()Lphonon/puppet/math/Matrix4f;", "set_matrix", "(Lphonon/puppet/math/Matrix4f;)V", "_model", "", "get_model", "()Ljava/lang/String;", "set_model", "(Ljava/lang/String;)V", "_name", "get_name", "set_name", "_position", "Lphonon/puppet/math/Vector3f;", "get_position", "()Lphonon/puppet/math/Vector3f;", "_rotation", "Lphonon/puppet/math/Euler;", "get_rotation", "()Lphonon/puppet/math/Euler;", "_world", "Lorg/bukkit/World;", "kotlin.jvm.PlatformType", "get_world", "()Lorg/bukkit/World;", "set_world", "(Lorg/bukkit/World;)V", "build", "Lphonon/puppet/objects/Mesh;", "customModelData", "id", "matrix", "m", "model", "s", "name", "position", "x", "", "y", "z", "", "rotation", "world", "w", "phonon-puppet"})
    public static final class Builder {
        private World _world = (World)Bukkit.getWorlds().get(0);
        @NotNull
        private String _name = "";
        @NotNull
        private String _model = "";
        private int _customModelData;
        @NotNull
        private final Vector3f _position = Vector3f.Companion.zero();
        @NotNull
        private final Euler _rotation = Euler.Companion.zero();
        @Nullable
        private Matrix4f _matrix;

        public final World get_world() {
            return this._world;
        }

        public final void set_world(World world) {
            this._world = world;
        }

        @NotNull
        public final String get_name() {
            return this._name;
        }

        public final void set_name(@NotNull String string) {
            Intrinsics.checkParameterIsNotNull(string, "<set-?>");
            this._name = string;
        }

        @NotNull
        public final String get_model() {
            return this._model;
        }

        public final void set_model(@NotNull String string) {
            Intrinsics.checkParameterIsNotNull(string, "<set-?>");
            this._model = string;
        }

        public final int get_customModelData() {
            return this._customModelData;
        }

        public final void set_customModelData(int n) {
            this._customModelData = n;
        }

        @NotNull
        public final Vector3f get_position() {
            return this._position;
        }

        @NotNull
        public final Euler get_rotation() {
            return this._rotation;
        }

        @Nullable
        public final Matrix4f get_matrix() {
            return this._matrix;
        }

        public final void set_matrix(@Nullable Matrix4f matrix4f) {
            this._matrix = matrix4f;
        }

        @NotNull
        public final Builder world(@NotNull World w) {
            Intrinsics.checkParameterIsNotNull(w, "w");
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply._world = w;
            return builder;
        }

        @NotNull
        public final Builder name(@NotNull String s) {
            Intrinsics.checkParameterIsNotNull(s, "s");
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply._name = s;
            return builder;
        }

        @NotNull
        public final Builder model(@NotNull String s) {
            Intrinsics.checkParameterIsNotNull(s, "s");
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply._model = s;
            return builder;
        }

        @NotNull
        public final Builder customModelData(int id) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply._customModelData = id;
            return builder;
        }

        @NotNull
        public final Builder position(float x, float y, float z) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply._position.set(x, y, z);
            return builder;
        }

        @NotNull
        public final Builder position(double x, double y, double z) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply._position.set(x, y, z);
            return builder;
        }

        @NotNull
        public final Builder rotation(float x, float y, float z) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply._rotation.set(x, y, z, $this$apply._rotation.getOrder());
            return builder;
        }

        @NotNull
        public final Builder rotation(double x, double y, double z) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply._rotation.set(x, y, z, $this$apply._rotation.getOrder());
            return builder;
        }

        @NotNull
        public final Builder matrix(@NotNull Matrix4f m) {
            Intrinsics.checkParameterIsNotNull(m, "m");
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply._matrix = m;
            return builder;
        }

        @NotNull
        public final Mesh build() {
            World world = this._world;
            Intrinsics.checkExpressionValueIsNotNull(world, "this._world");
            return new Mesh(this._name, world, this._model, this._customModelData, this._position, this._rotation, this._matrix);
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0010\u001a\u00020\u0011J\u0015\u0010\u0012\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0013\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0014J\u000e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0005J\u0014\u0010\u0018\u001a\u00020\u00112\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00050\u000bJ\u000e\u0010\u001a\u001a\u00020\u00112\u0006\u0010\u001b\u001a\u00020\u001cR-\u0010\u0003\u001a\u001e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004j\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0006`\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR \u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00050\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001d"}, d2={"Lphonon/puppet/objects/Mesh$Companion;", "", "()V", "library", "Ljava/util/HashMap;", "", "", "Lkotlin/collections/HashMap;", "getLibrary", "()Ljava/util/HashMap;", "libraryList", "", "getLibraryList", "()Ljava/util/List;", "setLibraryList", "(Ljava/util/List;)V", "clear", "", "get", "name", "(Ljava/lang/String;)Ljava/lang/Integer;", "has", "", "type", "loadCustomModelData", "models", "printInfo", "target", "Lorg/bukkit/command/CommandSender;", "phonon-puppet"})
    public static final class Companion {
        @NotNull
        public final HashMap<String, Integer> getLibrary() {
            return library;
        }

        @NotNull
        public final List<String> getLibraryList() {
            return libraryList;
        }

        public final void setLibraryList(@NotNull List<String> list) {
            Intrinsics.checkParameterIsNotNull(list, "<set-?>");
            libraryList = list;
        }

        /*
         * WARNING - void declaration
         */
        public final void loadCustomModelData(@NotNull List<String> models) {
            Intrinsics.checkParameterIsNotNull(models, "models");
            Companion.getLibrary().clear();
            boolean bl = false;
            for (String name : (Iterable)models) {
                void i;
                ((Map)Companion.getLibrary()).put(name, (int)(i + true));
                ++i;
            }
            Companion.setLibraryList(models);
        }

        public final void clear() {
            Companion.getLibrary().clear();
            Companion companion = Companion;
            boolean bl = false;
            List<String> list = CollectionsKt.emptyList();
            companion.setLibraryList(list);
        }

        public final boolean has(@NotNull String type) {
            Intrinsics.checkParameterIsNotNull(type, "type");
            Map map = Companion.getLibrary();
            boolean bl = false;
            Map map2 = map;
            boolean bl2 = false;
            return map2.containsKey(type);
        }

        @Nullable
        public final Integer get(@NotNull String name) {
            Intrinsics.checkParameterIsNotNull(name, "name");
            return Companion.getLibrary().get(name);
        }

        /*
         * WARNING - void declaration
         */
        public final void printInfo(@NotNull CommandSender target) {
            Intrinsics.checkParameterIsNotNull(target, "target");
            boolean bl = false;
            for (String name : (Iterable)Companion.getLibraryList()) {
                void i;
                Message.INSTANCE.print(target, "" + '[' + (int)(i + true) + "]: " + name);
                ++i;
            }
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

