/*
 * Decompiled with CFR 0.152.
 */
package phonon.puppet.objects;

import java.util.ArrayList;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import phonon.puppet.Message;
import phonon.puppet.math.Euler;
import phonon.puppet.math.Matrix4f;
import phonon.puppet.math.Quaternion;
import phonon.puppet.math.Vector3f;
import phonon.puppet.objects.Mesh;
import phonon.puppet.objects.TransformGraphNode;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u0001\u00a2\u0006\u0002\u0010\bJ\b\u0010;\u001a\u00020<H\u0016J\u000e\u0010=\u001a\u00020<2\u0006\u0010>\u001a\u00020?J\u0006\u0010@\u001a\u00020<J\b\u0010A\u001a\u00020\u0003H\u0016J\b\u0010B\u001a\u00020<H\u0016R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0013\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0012R\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0012R$\u0010\u0016\u001a\u0012\u0012\u0004\u0012\u00020\u00010\u0017j\b\u0012\u0004\u0012\u00020\u0001`\u0018X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0014\u0010\u001b\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u0012R\u001c\u0010\u001d\u001a\u0004\u0018\u00010\u001eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010 \"\u0004\b!\u0010\"R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$R\u0014\u0010%\u001a\u00020&X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010(R\u001c\u0010\u0007\u001a\u0004\u0018\u00010\u0001X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b)\u0010*\"\u0004\b+\u0010,R\u0014\u0010-\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b.\u0010\fR\u0014\u0010/\u001a\u00020\u000eX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b0\u0010\u0010R\u0014\u00101\u001a\u000202X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b3\u00104R\u0011\u00105\u001a\u000206\u00a2\u0006\b\n\u0000\u001a\u0004\b7\u00108R\u0014\u00109\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b:\u0010\u0012\u00a8\u0006C"}, d2={"Lphonon/puppet/objects/Bone;", "Lphonon/puppet/objects/TransformGraphNode;", "name", "", "boneMatrix", "Lphonon/puppet/math/Matrix4f;", "boneMatrixWorld", "parent", "(Ljava/lang/String;Lphonon/puppet/math/Matrix4f;Lphonon/puppet/math/Matrix4f;Lphonon/puppet/objects/TransformGraphNode;)V", "bindPosition", "Lphonon/puppet/math/Vector3f;", "getBindPosition", "()Lphonon/puppet/math/Vector3f;", "bindQuaternion", "Lphonon/puppet/math/Quaternion;", "getBindQuaternion", "()Lphonon/puppet/math/Quaternion;", "getBoneMatrix", "()Lphonon/puppet/math/Matrix4f;", "boneMatrixInverse", "getBoneMatrixInverse", "getBoneMatrixWorld", "children", "Ljava/util/ArrayList;", "Lkotlin/collections/ArrayList;", "getChildren", "()Ljava/util/ArrayList;", "matrix", "getMatrix", "mesh", "Lphonon/puppet/objects/Mesh;", "getMesh", "()Lphonon/puppet/objects/Mesh;", "setMesh", "(Lphonon/puppet/objects/Mesh;)V", "getName", "()Ljava/lang/String;", "needsUpdate", "", "getNeedsUpdate", "()Z", "getParent", "()Lphonon/puppet/objects/TransformGraphNode;", "setParent", "(Lphonon/puppet/objects/TransformGraphNode;)V", "position", "getPosition", "quaternion", "getQuaternion", "rotation", "Lphonon/puppet/math/Euler;", "getRotation", "()Lphonon/puppet/math/Euler;", "uuid", "Ljava/util/UUID;", "getUuid", "()Ljava/util/UUID;", "worldMatrix", "getWorldMatrix", "destroy", "", "printInfo", "target", "Lorg/bukkit/command/CommandSender;", "reset", "toString", "updateTransform", "phonon-puppet"})
public final class Bone
implements TransformGraphNode {
    @NotNull
    private final ArrayList<TransformGraphNode> children;
    @NotNull
    private final Matrix4f matrix;
    @NotNull
    private final Matrix4f worldMatrix;
    @NotNull
    private final Vector3f position;
    @NotNull
    private final Euler rotation;
    @NotNull
    private final Quaternion quaternion;
    @NotNull
    private final Vector3f bindPosition;
    @NotNull
    private final Quaternion bindQuaternion;
    @NotNull
    private final Matrix4f boneMatrixInverse;
    private final boolean needsUpdate = false;
    @NotNull
    private final UUID uuid;
    @Nullable
    private Mesh mesh;
    @NotNull
    private final String name;
    @NotNull
    private final Matrix4f boneMatrix;
    @NotNull
    private final Matrix4f boneMatrixWorld;
    @Nullable
    private TransformGraphNode parent;

    @Override
    @NotNull
    public ArrayList<TransformGraphNode> getChildren() {
        return this.children;
    }

    @Override
    @NotNull
    public Matrix4f getMatrix() {
        return this.matrix;
    }

    @Override
    @NotNull
    public Matrix4f getWorldMatrix() {
        return this.worldMatrix;
    }

    @Override
    @NotNull
    public Vector3f getPosition() {
        return this.position;
    }

    @Override
    @NotNull
    public Euler getRotation() {
        return this.rotation;
    }

    @Override
    @NotNull
    public Quaternion getQuaternion() {
        return this.quaternion;
    }

    @NotNull
    public final Vector3f getBindPosition() {
        return this.bindPosition;
    }

    @NotNull
    public final Quaternion getBindQuaternion() {
        return this.bindQuaternion;
    }

    @NotNull
    public final Matrix4f getBoneMatrixInverse() {
        return this.boneMatrixInverse;
    }

    @Override
    public boolean getNeedsUpdate() {
        return this.needsUpdate;
    }

    @NotNull
    public final UUID getUuid() {
        return this.uuid;
    }

    @Nullable
    public final Mesh getMesh() {
        return this.mesh;
    }

    public final void setMesh(@Nullable Mesh mesh) {
        this.mesh = mesh;
    }

    @Override
    public void destroy() {
    }

    @Override
    public void updateTransform() {
        this.getMatrix().compose(this.getPosition(), this.getQuaternion());
        TransformGraphNode parent = this.getParent();
        if (parent != null) {
            this.getWorldMatrix().multiplyMatrices(parent.getWorldMatrix(), this.getMatrix());
        } else {
            this.getWorldMatrix().copy(this.getMatrix());
        }
        for (TransformGraphNode child : this.getChildren()) {
            child.updateTransform();
        }
        Mesh mesh = this.mesh;
        if (mesh != null) {
            Matrix4f matrix4f;
            Matrix4f meshLocalInv = Matrix4f.Companion.zero().inv(mesh.getMatrix());
            if (mesh.getParent() != null) {
                Matrix4f matrix4f2 = mesh.getWorldMatrix();
                TransformGraphNode transformGraphNode = mesh.getParent();
                if (transformGraphNode == null) {
                    Intrinsics.throwNpe();
                }
                matrix4f = matrix4f2.multiplyMatrices(transformGraphNode.getWorldMatrix(), mesh.getMatrix()).clone();
            } else {
                matrix4f = mesh.getMatrix().clone();
            }
            Matrix4f meshWorldMatrix = matrix4f;
            mesh.getWorldMatrix().multiplyMatrices(this.boneMatrixInverse, mesh.getMatrix());
            mesh.getWorldMatrix().multiplyMatrices(this.getWorldMatrix(), mesh.getWorldMatrix());
            mesh.getWorldMatrix().multiplyMatrices(meshLocalInv, mesh.getWorldMatrix());
            mesh.getWorldMatrix().multiplyMatrices(meshWorldMatrix, mesh.getWorldMatrix());
        }
    }

    @NotNull
    public String toString() {
        String children = this.getChildren().size() > 0 ? CollectionsKt.joinToString$default(this.getChildren(), ",\n", "[\n", "\n]", 0, null, null, 56, null) : "[]";
        return "Bone { name=" + this.name + ", children=" + children + " }";
    }

    public final void printInfo(@NotNull CommandSender target) {
        Intrinsics.checkParameterIsNotNull(target, "target");
        TransformGraphNode parent = this.getParent();
        Message.INSTANCE.print(target, "Bone " + this.name + ':');
        Message.INSTANCE.print(target, "- parent: " + (parent != null && parent instanceof Bone ? ((Bone)parent).name : ChatColor.DARK_GRAY + "none"));
        Message.INSTANCE.print(target, "- position: [ " + this.getPosition().getX() + ", " + this.getPosition().getY() + ", " + this.getPosition().getZ() + " ]");
        Message.INSTANCE.print(target, "- rotation: [ " + this.getRotation().getX() + ", " + this.getRotation().getY() + ", " + this.getRotation().getZ() + " ]");
        Message.INSTANCE.print(target, "- quaternion: [ " + this.getQuaternion().getX() + ", " + this.getQuaternion().getY() + ", " + this.getQuaternion().getZ() + ' ' + this.getQuaternion().getW() + " ]");
    }

    public final void reset() {
        this.getPosition().copy(this.bindPosition);
        this.getQuaternion().copy(this.bindQuaternion);
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    @NotNull
    public final Matrix4f getBoneMatrix() {
        return this.boneMatrix;
    }

    @NotNull
    public final Matrix4f getBoneMatrixWorld() {
        return this.boneMatrixWorld;
    }

    @Override
    @Nullable
    public TransformGraphNode getParent() {
        return this.parent;
    }

    @Override
    public void setParent(@Nullable TransformGraphNode transformGraphNode) {
        this.parent = transformGraphNode;
    }

    public Bone(@NotNull String name, @NotNull Matrix4f boneMatrix, @NotNull Matrix4f boneMatrixWorld, @Nullable TransformGraphNode parent) {
        Intrinsics.checkParameterIsNotNull(name, "name");
        Intrinsics.checkParameterIsNotNull(boneMatrix, "boneMatrix");
        Intrinsics.checkParameterIsNotNull(boneMatrixWorld, "boneMatrixWorld");
        this.name = name;
        this.boneMatrix = boneMatrix;
        this.boneMatrixWorld = boneMatrixWorld;
        this.parent = parent;
        Bone bone = this;
        boolean bl = false;
        ArrayList arrayList = new ArrayList();
        bone.children = arrayList;
        this.matrix = Matrix4f.Companion.identity();
        this.worldMatrix = Matrix4f.Companion.identity();
        this.position = Vector3f.Companion.zero();
        this.rotation = Euler.Companion.zero();
        this.quaternion = Quaternion.Companion.new();
        this.boneMatrixInverse = Matrix4f.Companion.identity();
        UUID uUID = UUID.randomUUID();
        Intrinsics.checkExpressionValueIsNotNull(uUID, "UUID.randomUUID()");
        this.uuid = uUID;
        this.getWorldMatrix().copy(this.boneMatrixWorld);
        this.boneMatrixInverse.inv(this.boneMatrixWorld);
        TransformGraphNode parent2 = this.getParent();
        Matrix4f parentWorldMatrixInverse = parent2 != null ? Matrix4f.Companion.zero().inv(parent2.getWorldMatrix()) : Matrix4f.Companion.identity();
        this.getMatrix().multiplyMatrices(parentWorldMatrixInverse, this.getWorldMatrix());
        this.getMatrix().decompose(this.getPosition(), this.getQuaternion());
        this.getRotation().setFromQuaternion(this.getQuaternion(), this.getRotation().getOrder());
        this.bindPosition = this.getPosition().clone();
        this.bindQuaternion = this.getQuaternion().clone();
    }

    public /* synthetic */ Bone(String string, Matrix4f matrix4f, Matrix4f matrix4f2, TransformGraphNode transformGraphNode, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            transformGraphNode = null;
        }
        this(string, matrix4f, matrix4f2, transformGraphNode);
    }

    @Override
    public void add(@NotNull TransformGraphNode obj) {
        Intrinsics.checkParameterIsNotNull(obj, "obj");
        TransformGraphNode.DefaultImpls.add(this, obj);
    }

    @Override
    public void remove(@NotNull TransformGraphNode obj) {
        Intrinsics.checkParameterIsNotNull(obj, "obj");
        TransformGraphNode.DefaultImpls.remove(this, obj);
    }

    @Override
    public void setPosition(double x, double y, double z, boolean update) {
        TransformGraphNode.DefaultImpls.setPosition(this, x, y, z, update);
    }

    @Override
    public void setQuaternion(double x, double y, double z, double w, boolean update) {
        TransformGraphNode.DefaultImpls.setQuaternion(this, x, y, z, w, update);
    }

    @Override
    public void setRotation(double x, double y, double z, boolean update) {
        TransformGraphNode.DefaultImpls.setRotation((TransformGraphNode)this, x, y, z, update);
    }

    @Override
    public void setRotation(float x, float y, float z, boolean update) {
        TransformGraphNode.DefaultImpls.setRotation((TransformGraphNode)this, x, y, z, update);
    }

    @Override
    public void traverse(@NotNull Function1<? super TransformGraphNode, Unit> fn) {
        Intrinsics.checkParameterIsNotNull(fn, "fn");
        TransformGraphNode.DefaultImpls.traverse(this, fn);
    }
}

