/*
 * Decompiled with CFR 0.152.
 */
package phonon.puppet.objects;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import phonon.puppet.animation.AnimationMixer;
import phonon.puppet.math.Euler;
import phonon.puppet.math.Matrix4f;
import phonon.puppet.math.Quaternion;
import phonon.puppet.math.Vector3f;
import phonon.puppet.objects.Actor;
import phonon.puppet.objects.ActorPrototype;
import phonon.puppet.objects.Bone;
import phonon.puppet.objects.Skeleton;
import phonon.puppet.objects.TransformGraphNode;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\u0018\u0000 @2\u00020\u0001:\u0002?@B=\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\r\u00a2\u0006\u0002\u0010\u000eJ\b\u00108\u001a\u000209H\u0016J\b\u0010:\u001a\u00020;H\u0016J\u0006\u0010<\u001a\u000209J\u0006\u0010=\u001a\u000209J\b\u0010>\u001a\u000209H\u0016R\u0011\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R$\u0010\u0013\u001a\u0012\u0012\u0004\u0012\u00020\u00010\u0014j\b\u0012\u0004\u0012\u00020\u0001`\u0015X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0014\u0010\u0018\u001a\u00020\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0014\u0010\u001d\u001a\u00020\u001eX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u001c\u0010!\u001a\u0004\u0018\u00010\u0001X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010#\"\u0004\b$\u0010%R\u0014\u0010&\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010(R\u0014\u0010)\u001a\u00020*X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b+\u0010,R\u0014\u0010-\u001a\u00020\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b.\u0010/R\u001c\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b0\u00101\"\u0004\b2\u00103R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b4\u00105R\u0014\u00106\u001a\u00020\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b7\u0010\u001a\u00a8\u0006A"}, d2={"Lphonon/puppet/objects/Actor;", "Lphonon/puppet/objects/TransformGraphNode;", "name", "", "uuid", "Ljava/util/UUID;", "skeleton", "Lphonon/puppet/objects/Skeleton;", "initialPosition", "Lphonon/puppet/math/Vector3f;", "initialRotation", "Lphonon/puppet/math/Euler;", "initialMatrix", "Lphonon/puppet/math/Matrix4f;", "(Ljava/lang/String;Ljava/util/UUID;Lphonon/puppet/objects/Skeleton;Lphonon/puppet/math/Vector3f;Lphonon/puppet/math/Euler;Lphonon/puppet/math/Matrix4f;)V", "animation", "Lphonon/puppet/animation/AnimationMixer;", "getAnimation", "()Lphonon/puppet/animation/AnimationMixer;", "children", "Ljava/util/ArrayList;", "Lkotlin/collections/ArrayList;", "getChildren", "()Ljava/util/ArrayList;", "matrix", "getMatrix", "()Lphonon/puppet/math/Matrix4f;", "getName", "()Ljava/lang/String;", "needsUpdate", "", "getNeedsUpdate", "()Z", "parent", "getParent", "()Lphonon/puppet/objects/TransformGraphNode;", "setParent", "(Lphonon/puppet/objects/TransformGraphNode;)V", "position", "getPosition", "()Lphonon/puppet/math/Vector3f;", "quaternion", "Lphonon/puppet/math/Quaternion;", "getQuaternion", "()Lphonon/puppet/math/Quaternion;", "rotation", "getRotation", "()Lphonon/puppet/math/Euler;", "getSkeleton", "()Lphonon/puppet/objects/Skeleton;", "setSkeleton", "(Lphonon/puppet/objects/Skeleton;)V", "getUuid", "()Ljava/util/UUID;", "worldMatrix", "getWorldMatrix", "destroy", "", "hashCode", "", "render", "update", "updateTransform", "Builder", "Companion", "phonon-puppet"})
public final class Actor
implements TransformGraphNode {
    @Nullable
    private TransformGraphNode parent;
    @NotNull
    private final ArrayList<TransformGraphNode> children;
    @NotNull
    private final Matrix4f matrix;
    @NotNull
    private final Matrix4f worldMatrix;
    @NotNull
    private final Vector3f position;
    @NotNull
    private final Euler rotation;
    @NotNull
    private final Quaternion quaternion;
    private final boolean needsUpdate = false;
    @NotNull
    private final AnimationMixer animation;
    @NotNull
    private final String name;
    @NotNull
    private final UUID uuid;
    @Nullable
    private Skeleton skeleton;
    @NotNull
    private static final HashMap<String, ActorPrototype> library;
    public static final Companion Companion;

    @Override
    @Nullable
    public TransformGraphNode getParent() {
        return this.parent;
    }

    @Override
    public void setParent(@Nullable TransformGraphNode transformGraphNode) {
        this.parent = transformGraphNode;
    }

    @Override
    @NotNull
    public ArrayList<TransformGraphNode> getChildren() {
        return this.children;
    }

    @Override
    @NotNull
    public Matrix4f getMatrix() {
        return this.matrix;
    }

    @Override
    @NotNull
    public Matrix4f getWorldMatrix() {
        return this.worldMatrix;
    }

    @Override
    @NotNull
    public Vector3f getPosition() {
        return this.position;
    }

    @Override
    @NotNull
    public Euler getRotation() {
        return this.rotation;
    }

    @Override
    @NotNull
    public Quaternion getQuaternion() {
        return this.quaternion;
    }

    @Override
    public boolean getNeedsUpdate() {
        return this.needsUpdate;
    }

    @NotNull
    public final AnimationMixer getAnimation() {
        return this.animation;
    }

    public int hashCode() {
        return this.uuid.hashCode();
    }

    @Override
    public void destroy() {
        for (TransformGraphNode child : this.getChildren()) {
            child.destroy();
        }
    }

    @Override
    public void updateTransform() {
        this.getMatrix().compose(this.getPosition(), this.getQuaternion());
        TransformGraphNode parent = this.getParent();
        if (parent != null) {
            this.getWorldMatrix().multiplyMatrices(parent.getWorldMatrix(), this.getMatrix());
        } else {
            this.getWorldMatrix().copy(this.getMatrix());
        }
        for (TransformGraphNode child : this.getChildren()) {
            child.updateTransform();
        }
    }

    public final void update() {
        Skeleton skeleton;
        this.updateTransform();
        if (this.animation.getEnabled()) {
            this.animation.update();
        }
        if ((skeleton = this.skeleton) != null) {
            Collection<Bone> collection = skeleton.getBones().values();
            Intrinsics.checkExpressionValueIsNotNull(collection, "skeleton.bones.values");
            this.animation.writeBoneTransforms((Iterable<Bone>)collection);
            skeleton.update();
        }
    }

    public final void render() {
        this.traverse(render.1.INSTANCE);
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    @NotNull
    public final UUID getUuid() {
        return this.uuid;
    }

    @Nullable
    public final Skeleton getSkeleton() {
        return this.skeleton;
    }

    public final void setSkeleton(@Nullable Skeleton skeleton) {
        this.skeleton = skeleton;
    }

    public Actor(@NotNull String name, @NotNull UUID uuid, @Nullable Skeleton skeleton, @NotNull Vector3f initialPosition, @NotNull Euler initialRotation, @Nullable Matrix4f initialMatrix) {
        Intrinsics.checkParameterIsNotNull(name, "name");
        Intrinsics.checkParameterIsNotNull(uuid, "uuid");
        Intrinsics.checkParameterIsNotNull(initialPosition, "initialPosition");
        Intrinsics.checkParameterIsNotNull(initialRotation, "initialRotation");
        this.name = name;
        this.uuid = uuid;
        this.skeleton = skeleton;
        Actor actor = this;
        boolean bl = false;
        ArrayList arrayList = new ArrayList();
        actor.children = arrayList;
        this.matrix = Matrix4f.Companion.identity();
        this.worldMatrix = Matrix4f.Companion.identity();
        this.position = Vector3f.Companion.zero();
        this.rotation = Euler.Companion.zero();
        this.quaternion = Quaternion.Companion.new();
        this.animation = new AnimationMixer();
        if (initialMatrix != null) {
            this.getMatrix().copy(initialMatrix);
            initialMatrix.decompose(this.getPosition(), this.getQuaternion());
            this.getRotation().setFromQuaternion(this.getQuaternion(), this.getRotation().getOrder());
        } else {
            this.getPosition().copy(initialPosition);
            this.getRotation().copy(initialRotation);
            this.getQuaternion().setFromEuler(initialRotation);
            this.getMatrix().compose(this.getPosition(), this.getQuaternion());
        }
    }

    public /* synthetic */ Actor(String string, UUID uUID, Skeleton skeleton, Vector3f vector3f, Euler euler, Matrix4f matrix4f, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            skeleton = null;
        }
        if ((n & 0x20) != 0) {
            matrix4f = null;
        }
        this(string, uUID, skeleton, vector3f, euler, matrix4f);
    }

    static {
        Companion = new Companion(null);
        boolean bl = false;
        library = new HashMap();
    }

    @Override
    public void add(@NotNull TransformGraphNode obj) {
        Intrinsics.checkParameterIsNotNull(obj, "obj");
        TransformGraphNode.DefaultImpls.add(this, obj);
    }

    @Override
    public void remove(@NotNull TransformGraphNode obj) {
        Intrinsics.checkParameterIsNotNull(obj, "obj");
        TransformGraphNode.DefaultImpls.remove(this, obj);
    }

    @Override
    public void setPosition(double x, double y, double z, boolean update) {
        TransformGraphNode.DefaultImpls.setPosition(this, x, y, z, update);
    }

    @Override
    public void setQuaternion(double x, double y, double z, double w, boolean update) {
        TransformGraphNode.DefaultImpls.setQuaternion(this, x, y, z, w, update);
    }

    @Override
    public void setRotation(double x, double y, double z, boolean update) {
        TransformGraphNode.DefaultImpls.setRotation((TransformGraphNode)this, x, y, z, update);
    }

    @Override
    public void setRotation(float x, float y, float z, boolean update) {
        TransformGraphNode.DefaultImpls.setRotation((TransformGraphNode)this, x, y, z, update);
    }

    @Override
    public void traverse(@NotNull Function1<? super TransformGraphNode, Unit> fn) {
        Intrinsics.checkParameterIsNotNull(fn, "fn");
        TransformGraphNode.DefaultImpls.traverse(this, fn);
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010#\u001a\u00020$J\u000e\u0010%\u001a\u00020\u00002\u0006\u0010&\u001a\u00020\u0004J\u000e\u0010'\u001a\u00020\u00002\u0006\u0010(\u001a\u00020\nJ\u001e\u0010)\u001a\u00020\u00002\u0006\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020+2\u0006\u0010-\u001a\u00020+J\u001e\u0010)\u001a\u00020\u00002\u0006\u0010*\u001a\u00020.2\u0006\u0010,\u001a\u00020.2\u0006\u0010-\u001a\u00020.J\u001e\u0010/\u001a\u00020\u00002\u0006\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020+2\u0006\u0010-\u001a\u00020+J\u001e\u0010/\u001a\u00020\u00002\u0006\u0010*\u001a\u00020.2\u0006\u0010,\u001a\u00020.2\u0006\u0010-\u001a\u00020.J\u000e\u00100\u001a\u00020\u00002\u0006\u0010(\u001a\u00020\u0018R\u001c\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u0011\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0013\u001a\u00020\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u001c\u0010\u0017\u001a\u0004\u0018\u00010\u0018X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cR\u001a\u0010\u001d\u001a\u00020\u001eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010 \"\u0004\b!\u0010\"\u00a8\u00061"}, d2={"Lphonon/puppet/objects/Actor$Builder;", "", "()V", "_matrix", "Lphonon/puppet/math/Matrix4f;", "get_matrix", "()Lphonon/puppet/math/Matrix4f;", "set_matrix", "(Lphonon/puppet/math/Matrix4f;)V", "_name", "", "get_name", "()Ljava/lang/String;", "set_name", "(Ljava/lang/String;)V", "_position", "Lphonon/puppet/math/Vector3f;", "get_position", "()Lphonon/puppet/math/Vector3f;", "_rotation", "Lphonon/puppet/math/Euler;", "get_rotation", "()Lphonon/puppet/math/Euler;", "_skeleton", "Lphonon/puppet/objects/Skeleton;", "get_skeleton", "()Lphonon/puppet/objects/Skeleton;", "set_skeleton", "(Lphonon/puppet/objects/Skeleton;)V", "_uuid", "Ljava/util/UUID;", "get_uuid", "()Ljava/util/UUID;", "set_uuid", "(Ljava/util/UUID;)V", "build", "Lphonon/puppet/objects/Actor;", "matrix", "m", "name", "s", "position", "x", "", "y", "z", "", "rotation", "skeleton", "phonon-puppet"})
    public static final class Builder {
        @NotNull
        private String _name = "";
        @NotNull
        private UUID _uuid;
        @NotNull
        private final Vector3f _position;
        @NotNull
        private final Euler _rotation;
        @Nullable
        private Matrix4f _matrix;
        @Nullable
        private Skeleton _skeleton;

        @NotNull
        public final String get_name() {
            return this._name;
        }

        public final void set_name(@NotNull String string) {
            Intrinsics.checkParameterIsNotNull(string, "<set-?>");
            this._name = string;
        }

        @NotNull
        public final UUID get_uuid() {
            return this._uuid;
        }

        public final void set_uuid(@NotNull UUID uUID) {
            Intrinsics.checkParameterIsNotNull(uUID, "<set-?>");
            this._uuid = uUID;
        }

        @NotNull
        public final Vector3f get_position() {
            return this._position;
        }

        @NotNull
        public final Euler get_rotation() {
            return this._rotation;
        }

        @Nullable
        public final Matrix4f get_matrix() {
            return this._matrix;
        }

        public final void set_matrix(@Nullable Matrix4f matrix4f) {
            this._matrix = matrix4f;
        }

        @Nullable
        public final Skeleton get_skeleton() {
            return this._skeleton;
        }

        public final void set_skeleton(@Nullable Skeleton skeleton) {
            this._skeleton = skeleton;
        }

        @NotNull
        public final Builder name(@NotNull String s) {
            Intrinsics.checkParameterIsNotNull(s, "s");
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply._name = s;
            return builder;
        }

        @NotNull
        public final Builder position(float x, float y, float z) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply._position.set(x, y, z);
            return builder;
        }

        @NotNull
        public final Builder position(double x, double y, double z) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply._position.set(x, y, z);
            return builder;
        }

        @NotNull
        public final Builder rotation(float x, float y, float z) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply._rotation.set(x, y, z, $this$apply._rotation.getOrder());
            return builder;
        }

        @NotNull
        public final Builder rotation(double x, double y, double z) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply._rotation.set(x, y, z, $this$apply._rotation.getOrder());
            return builder;
        }

        @NotNull
        public final Builder matrix(@NotNull Matrix4f m) {
            Intrinsics.checkParameterIsNotNull(m, "m");
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply._matrix = m;
            return builder;
        }

        @NotNull
        public final Builder skeleton(@NotNull Skeleton s) {
            Intrinsics.checkParameterIsNotNull(s, "s");
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply._skeleton = s;
            return builder;
        }

        @NotNull
        public final Actor build() {
            return new Actor(this._name, this._uuid, this._skeleton, this._position, this._rotation, this._matrix);
        }

        public Builder() {
            UUID uUID = UUID.randomUUID();
            Intrinsics.checkExpressionValueIsNotNull(uUID, "UUID.randomUUID()");
            this._uuid = uUID;
            this._position = Vector3f.Companion.zero();
            this._rotation = Euler.Companion.zero();
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010 \n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\n\u001a\u00020\u000bJ\u0010\u0010\f\u001a\u0004\u0018\u00010\u00062\u0006\u0010\r\u001a\u00020\u0005J\u0016\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u0006J\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00050\u0012R-\u0010\u0003\u001a\u001e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004j\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0006`\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0013"}, d2={"Lphonon/puppet/objects/Actor$Companion;", "", "()V", "library", "Ljava/util/HashMap;", "", "Lphonon/puppet/objects/ActorPrototype;", "Lkotlin/collections/HashMap;", "getLibrary", "()Ljava/util/HashMap;", "clear", "", "get", "type", "save", "name", "actorType", "types", "", "phonon-puppet"})
    public static final class Companion {
        @NotNull
        public final HashMap<String, ActorPrototype> getLibrary() {
            return library;
        }

        public final void save(@NotNull String name, @NotNull ActorPrototype actorType) {
            Intrinsics.checkParameterIsNotNull(name, "name");
            Intrinsics.checkParameterIsNotNull(actorType, "actorType");
            Companion.getLibrary().put(name, actorType);
        }

        public final void clear() {
            Companion.getLibrary().clear();
        }

        @Nullable
        public final ActorPrototype get(@NotNull String type) {
            Intrinsics.checkParameterIsNotNull(type, "type");
            return Companion.getLibrary().get(type);
        }

        @NotNull
        public final List<String> types() {
            Set<String> set = Companion.getLibrary().keySet();
            Intrinsics.checkExpressionValueIsNotNull(set, "Actor.library.keys");
            return CollectionsKt.toList((Iterable)set);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

