/*
 * Decompiled with CFR 0.152.
 */
package phonon.puppet.math;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.bukkit.Location;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import phonon.puppet.math.Euler;
import phonon.puppet.math.Matrix4f;
import phonon.puppet.math.Quaternion;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u000f\n\u0002\u0010\u0006\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0016\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0014\n\u0000\n\u0002\u0010\b\n\u0002\b\u0019\n\u0002\u0010\u0002\n\u0002\b\r\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\b\u0018\u0000 k2\u00020\u0001:\u0001kB\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u000f\u001a\u00020\u00002\u0006\u0010\u0010\u001a\u00020\u0000J\u000e\u0010\u0011\u001a\u00020\u00002\u0006\u0010\u0012\u001a\u00020\u0013J\u0016\u0010\u0014\u001a\u00020\u00002\u0006\u0010\u0010\u001a\u00020\u00002\u0006\u0010\u0012\u001a\u00020\u0013J\u0016\u0010\u0015\u001a\u00020\u00002\u0006\u0010\u0016\u001a\u00020\u00002\u0006\u0010\u0017\u001a\u00020\u0000J\u000e\u0010\u0018\u001a\u00020\u00132\u0006\u0010\u0010\u001a\u00020\u0000J\u0016\u0010\u0019\u001a\u00020\u00002\u0006\u0010\u001a\u001a\u00020\u00002\u0006\u0010\u001b\u001a\u00020\u0013J\u000e\u0010\u001c\u001a\u00020\u00002\u0006\u0010\u001d\u001a\u00020\u001eJ\u000e\u0010\u001f\u001a\u00020\u00002\u0006\u0010 \u001a\u00020!J\u000e\u0010\"\u001a\u00020\u00002\u0006\u0010#\u001a\u00020$J\u000e\u0010%\u001a\u00020\u00002\u0006\u0010 \u001a\u00020!J\u0006\u0010&\u001a\u00020\u0000J\u0016\u0010'\u001a\u00020\u00002\u0006\u0010(\u001a\u00020\u00002\u0006\u0010)\u001a\u00020\u0000J\u0016\u0010*\u001a\u00020\u00002\u0006\u0010(\u001a\u00020\u00132\u0006\u0010)\u001a\u00020\u0013J\u0016\u0010+\u001a\u00020\u00002\u0006\u0010(\u001a\u00020\u00132\u0006\u0010)\u001a\u00020\u0013J\u0006\u0010,\u001a\u00020\u0000J\t\u0010-\u001a\u00020\u0003H\u00c6\u0003J\t\u0010.\u001a\u00020\u0003H\u00c6\u0003J\t\u0010/\u001a\u00020\u0003H\u00c6\u0003J'\u00100\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0003H\u00c6\u0001J\u000e\u00100\u001a\u00020\u00002\u0006\u00101\u001a\u00020\u0000J\u000e\u00102\u001a\u00020\u00002\u0006\u0010\u0010\u001a\u00020\u0000J\u0016\u00103\u001a\u00020\u00002\u0006\u0010\u0016\u001a\u00020\u00002\u0006\u0010\u0017\u001a\u00020\u0000J\u000e\u00104\u001a\u00020\u00132\u0006\u0010\u0010\u001a\u00020\u0000J\u000e\u00105\u001a\u00020\u00132\u0006\u0010\u0010\u001a\u00020\u0000J\u000e\u00106\u001a\u00020\u00002\u0006\u0010\u0010\u001a\u00020\u0000J\u000e\u00107\u001a\u00020\u00002\u0006\u0010\u0012\u001a\u00020\u0013J\u0016\u00108\u001a\u00020\u00002\u0006\u0010\u0016\u001a\u00020\u00002\u0006\u0010\u0017\u001a\u00020\u0000J\u000e\u00109\u001a\u00020\u00132\u0006\u0010\u0010\u001a\u00020\u0000J\u0013\u0010:\u001a\u00020;2\b\u00101\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\u0006\u0010<\u001a\u00020\u0000J\u0016\u0010=\u001a\u00020\u00002\u0006\u0010>\u001a\u00020?2\u0006\u0010@\u001a\u00020AJ\u0011\u0010B\u001a\u00020\u00032\u0006\u0010C\u001a\u00020AH\u0086\u0002J\t\u0010D\u001a\u00020AH\u00d6\u0001J\u0006\u0010E\u001a\u00020\u0013J\u0006\u0010F\u001a\u00020\u0013J\u0016\u0010G\u001a\u00020\u00002\u0006\u0010\u0010\u001a\u00020\u00002\u0006\u0010H\u001a\u00020\u0013J\u001e\u0010I\u001a\u00020\u00002\u0006\u0010J\u001a\u00020\u00002\u0006\u0010K\u001a\u00020\u00002\u0006\u0010H\u001a\u00020\u0013J\u000e\u0010L\u001a\u00020\u00132\u0006\u0010\u0010\u001a\u00020\u0000J\u0006\u0010M\u001a\u00020\u0013J\u000e\u0010)\u001a\u00020\u00002\u0006\u0010\u0010\u001a\u00020\u0000J\u000e\u0010(\u001a\u00020\u00002\u0006\u0010\u0010\u001a\u00020\u0000J\u000e\u0010N\u001a\u00020\u00002\u0006\u0010\u0010\u001a\u00020\u0000J\u000e\u0010O\u001a\u00020\u00002\u0006\u0010\u0012\u001a\u00020\u0013J\u0016\u0010P\u001a\u00020\u00002\u0006\u0010\u0016\u001a\u00020\u00002\u0006\u0010\u0017\u001a\u00020\u0000J\u0006\u0010Q\u001a\u00020\u0000J\u0006\u0010R\u001a\u00020\u0000J\u000e\u0010S\u001a\u00020\u00002\u0006\u0010T\u001a\u00020\u0000J\u000e\u0010U\u001a\u00020\u00002\u0006\u0010\u0010\u001a\u00020\u0000J\u000e\u0010V\u001a\u00020\u00002\u0006\u0010W\u001a\u00020\u0000J\u0006\u0010X\u001a\u00020\u0000J\u0006\u0010Y\u001a\u00020\u0000J\u001e\u0010Z\u001a\u00020\u00002\u0006\u0010\u0002\u001a\u00020\u00132\u0006\u0010\u0004\u001a\u00020\u00132\u0006\u0010\u0005\u001a\u00020\u0013J\u001e\u0010Z\u001a\u00020\u00002\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u0003J\u0019\u0010Z\u001a\u00020[2\u0006\u0010C\u001a\u00020A2\u0006\u0010\u0010\u001a\u00020\u0003H\u0086\u0002J\u0016\u0010\\\u001a\u00020\u00002\u0006\u0010]\u001a\u00020!2\u0006\u0010^\u001a\u00020AJ\u000e\u0010_\u001a\u00020\u00002\u0006\u0010]\u001a\u00020!J\u000e\u0010`\u001a\u00020\u00002\u0006\u0010]\u001a\u00020!J\u000e\u0010a\u001a\u00020\u00002\u0006\u0010E\u001a\u00020\u0013J\u000e\u0010b\u001a\u00020\u00002\u0006\u0010c\u001a\u00020\u0013J\u000e\u0010\t\u001a\u00020\u00002\u0006\u0010\u0002\u001a\u00020\u0013J\u000e\u0010\f\u001a\u00020\u00002\u0006\u0010\u0004\u001a\u00020\u0013J\u000e\u0010\u000e\u001a\u00020\u00002\u0006\u0010\u0005\u001a\u00020\u0013J\u000e\u0010d\u001a\u00020\u00002\u0006\u0010\u0010\u001a\u00020\u0000J\u000e\u0010e\u001a\u00020\u00002\u0006\u0010\u0012\u001a\u00020\u0013J\u0016\u0010f\u001a\u00020\u00002\u0006\u0010\u0016\u001a\u00020\u00002\u0006\u0010\u0017\u001a\u00020\u0000J\u0006\u0010g\u001a\u00020?J\u0016\u0010g\u001a\u00020?2\u0006\u0010>\u001a\u00020?2\u0006\u0010@\u001a\u00020AJ\t\u0010h\u001a\u00020iH\u00d6\u0001J\u000e\u0010j\u001a\u00020\u00002\u0006\u0010 \u001a\u00020!R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u001a\u0010\u0004\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\b\"\u0004\b\f\u0010\nR\u001a\u0010\u0005\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\b\"\u0004\b\u000e\u0010\n\u00a8\u0006l"}, d2={"Lphonon/puppet/math/Vector3f;", "", "x", "", "y", "z", "(FFF)V", "getX", "()F", "setX", "(F)V", "getY", "setY", "getZ", "setZ", "add", "v", "addScalar", "d", "", "addScaledVector", "addVectors", "a", "b", "angleTo", "applyAxisAngle", "axis", "angle", "applyEuler", "euler", "Lphonon/puppet/math/Euler;", "applyMatrix4", "mat4", "Lphonon/puppet/math/Matrix4f;", "applyQuaternion", "q", "Lphonon/puppet/math/Quaternion;", "applyRotationMatrix4", "ceil", "clamp", "min", "max", "clampLength", "clampScalar", "clone", "component1", "component2", "component3", "copy", "other", "cross", "crossVectors", "distanceTo", "distanceToSquared", "divide", "divideScalar", "divideVectors", "dot", "equals", "", "floor", "fromFloatArray", "array", "", "offset", "", "get", "i", "hashCode", "length", "lengthSquared", "lerp", "alpha", "lerpVectors", "v1", "v2", "manhattanDistanceTo", "manhattanLength", "multiply", "multiplyScalar", "multiplyVectors", "negate", "normalize", "projectOnPlane", "planeNormal", "projectOnVector", "reflect", "normal", "round", "roundToZero", "set", "", "setFromMatrixColumn", "m", "index", "setFromMatrixPosition", "setFromMatrixScale", "setLength", "setScalar", "scalar", "sub", "subScalar", "subVectors", "toFloatArray", "toString", "", "transformDirection", "Companion", "phonon-puppet"})
public final class Vector3f {
    private float x;
    private float y;
    private float z;
    @NotNull
    private static final Vector3f ZERO;
    @NotNull
    private static final Vector3f ONE;
    public static final Companion Companion;

    public final float get(int i) {
        switch (i) {
            case 0: {
                return this.x;
            }
            case 1: {
                return this.y;
            }
            case 2: {
                return this.z;
            }
        }
        throw (Throwable)new ArrayIndexOutOfBoundsException(i);
    }

    public final void set(int i, float v) {
        switch (i) {
            case 0: {
                this.x = v;
                break;
            }
            case 1: {
                this.y = v;
                break;
            }
            case 2: {
                this.z = v;
                break;
            }
            default: {
                throw (Throwable)new ArrayIndexOutOfBoundsException(i);
            }
        }
    }

    @NotNull
    public final Vector3f clone() {
        return new Vector3f(this.x, this.y, this.z);
    }

    @NotNull
    public final Vector3f copy(@NotNull Vector3f other) {
        Intrinsics.checkParameterIsNotNull(other, "other");
        this.x = other.x;
        this.y = other.y;
        this.z = other.z;
        return this;
    }

    @NotNull
    public final Vector3f set(double x, double y, double z) {
        this.x = (float)x;
        this.y = (float)y;
        this.z = (float)z;
        return this;
    }

    @NotNull
    public final Vector3f set(float x, float y, float z) {
        this.x = x;
        this.y = y;
        this.z = z;
        return this;
    }

    @NotNull
    public final Vector3f setScalar(double scalar) {
        this.x = (float)scalar;
        this.y = (float)scalar;
        this.z = (float)scalar;
        return this;
    }

    @NotNull
    public final Vector3f setX(double x) {
        this.x = (float)x;
        return this;
    }

    @NotNull
    public final Vector3f setY(double y) {
        this.y = (float)y;
        return this;
    }

    @NotNull
    public final Vector3f setZ(double z) {
        this.z = (float)z;
        return this;
    }

    @NotNull
    public final Vector3f add(@NotNull Vector3f v) {
        Intrinsics.checkParameterIsNotNull(v, "v");
        this.x += v.x;
        this.y += v.y;
        this.z += v.z;
        return this;
    }

    @NotNull
    public final Vector3f addScalar(double d) {
        float f = (float)d;
        this.x += f;
        this.y += f;
        this.z += f;
        return this;
    }

    @NotNull
    public final Vector3f addVectors(@NotNull Vector3f a, @NotNull Vector3f b) {
        Intrinsics.checkParameterIsNotNull(a, "a");
        Intrinsics.checkParameterIsNotNull(b, "b");
        this.x = a.x + b.x;
        this.y = a.y + b.y;
        this.z = a.z + b.z;
        return this;
    }

    @NotNull
    public final Vector3f addScaledVector(@NotNull Vector3f v, double d) {
        Intrinsics.checkParameterIsNotNull(v, "v");
        float f = (float)d;
        this.x += v.x * f;
        this.y += v.y * f;
        this.z += v.z * f;
        return this;
    }

    @NotNull
    public final Vector3f sub(@NotNull Vector3f v) {
        Intrinsics.checkParameterIsNotNull(v, "v");
        this.x -= v.x;
        this.y -= v.y;
        this.z -= v.z;
        return this;
    }

    @NotNull
    public final Vector3f subScalar(double d) {
        float f = (float)d;
        this.x -= f;
        this.y -= f;
        this.z -= f;
        return this;
    }

    @NotNull
    public final Vector3f subVectors(@NotNull Vector3f a, @NotNull Vector3f b) {
        Intrinsics.checkParameterIsNotNull(a, "a");
        Intrinsics.checkParameterIsNotNull(b, "b");
        this.x = a.x - b.x;
        this.y = a.y - b.y;
        this.z = a.z - b.z;
        return this;
    }

    @NotNull
    public final Vector3f multiply(@NotNull Vector3f v) {
        Intrinsics.checkParameterIsNotNull(v, "v");
        this.x *= v.x;
        this.y *= v.y;
        this.z *= v.z;
        return this;
    }

    @NotNull
    public final Vector3f multiplyScalar(double d) {
        float f = (float)d;
        this.x *= f;
        this.y *= f;
        this.z *= f;
        return this;
    }

    @NotNull
    public final Vector3f multiplyVectors(@NotNull Vector3f a, @NotNull Vector3f b) {
        Intrinsics.checkParameterIsNotNull(a, "a");
        Intrinsics.checkParameterIsNotNull(b, "b");
        this.x = a.x * b.x;
        this.y = a.y * b.y;
        this.z = a.z * b.z;
        return this;
    }

    @NotNull
    public final Vector3f divide(@NotNull Vector3f v) {
        Intrinsics.checkParameterIsNotNull(v, "v");
        this.x /= v.x;
        this.y /= v.y;
        this.z /= v.z;
        return this;
    }

    @NotNull
    public final Vector3f divideScalar(double d) {
        float f = 1.0f / (float)d;
        this.x *= f;
        this.y *= f;
        this.z *= f;
        return this;
    }

    @NotNull
    public final Vector3f divideVectors(@NotNull Vector3f a, @NotNull Vector3f b) {
        Intrinsics.checkParameterIsNotNull(a, "a");
        Intrinsics.checkParameterIsNotNull(b, "b");
        this.x = a.x / b.x;
        this.y = a.y / b.y;
        this.z = a.z / b.z;
        return this;
    }

    public final double dot(@NotNull Vector3f v) {
        Intrinsics.checkParameterIsNotNull(v, "v");
        return this.x * v.x + this.y * v.y + this.z * v.z;
    }

    @NotNull
    public final Vector3f cross(@NotNull Vector3f v) {
        Intrinsics.checkParameterIsNotNull(v, "v");
        return this.crossVectors(this, v);
    }

    @NotNull
    public final Vector3f crossVectors(@NotNull Vector3f a, @NotNull Vector3f b) {
        Intrinsics.checkParameterIsNotNull(a, "a");
        Intrinsics.checkParameterIsNotNull(b, "b");
        this.x = a.y * b.z - a.z * b.y;
        this.y = a.z * b.x - a.x * b.z;
        this.z = a.x * b.y - a.y * b.x;
        return this;
    }

    public final double lengthSquared() {
        return this.x * this.x + this.y * this.y + this.z * this.z;
    }

    public final double length() {
        return Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z);
    }

    public final double manhattanLength() {
        return Math.abs((double)this.x) + Math.abs((double)this.y) + Math.abs((double)this.z);
    }

    public final double distanceToSquared(@NotNull Vector3f v) {
        Intrinsics.checkParameterIsNotNull(v, "v");
        float dx = this.x - v.x;
        float dy = this.y - v.y;
        float dz = this.z - v.z;
        return dx * dx + dy * dy + dz * dz;
    }

    public final double distanceTo(@NotNull Vector3f v) {
        Intrinsics.checkParameterIsNotNull(v, "v");
        return Math.sqrt(this.distanceToSquared(v));
    }

    public final double manhattanDistanceTo(@NotNull Vector3f v) {
        Intrinsics.checkParameterIsNotNull(v, "v");
        return Math.abs((double)(this.x - v.x)) + Math.abs((double)(this.y - v.y)) + Math.abs((double)(this.z - v.z));
    }

    @NotNull
    public final Vector3f normalize() {
        return this.divideScalar(this.length());
    }

    @NotNull
    public final Vector3f setLength(double length) {
        return this.normalize().multiplyScalar(length);
    }

    @NotNull
    public final Vector3f min(@NotNull Vector3f v) {
        Intrinsics.checkParameterIsNotNull(v, "v");
        this.x = Math.min(this.x, v.x);
        this.y = Math.min(this.y, v.y);
        this.z = Math.min(this.z, v.z);
        return this;
    }

    @NotNull
    public final Vector3f max(@NotNull Vector3f v) {
        Intrinsics.checkParameterIsNotNull(v, "v");
        this.x = Math.max(this.x, v.x);
        this.y = Math.max(this.y, v.y);
        this.z = Math.max(this.z, v.z);
        return this;
    }

    @NotNull
    public final Vector3f clamp(@NotNull Vector3f min, @NotNull Vector3f max) {
        Intrinsics.checkParameterIsNotNull(min, "min");
        Intrinsics.checkParameterIsNotNull(max, "max");
        this.x = (float)Math.max((double)min.x, Math.min((double)max.x, (double)this.x));
        this.y = (float)Math.max((double)min.y, Math.min((double)max.y, (double)this.y));
        this.z = (float)Math.max((double)min.z, Math.min((double)max.z, (double)this.z));
        return this;
    }

    @NotNull
    public final Vector3f clampScalar(double min, double max) {
        this.x = (float)Math.max(min, Math.min(max, (double)this.x));
        this.y = (float)Math.max(min, Math.min(max, (double)this.y));
        this.z = (float)Math.max(min, Math.min(max, (double)this.z));
        return this;
    }

    @NotNull
    public final Vector3f clampLength(double min, double max) {
        double length = this.length();
        return this.divideScalar(length).multiplyScalar(Math.max(min, Math.min(max, length)));
    }

    @NotNull
    public final Vector3f floor() {
        this.x = (float)Math.floor(this.x);
        this.y = (float)Math.floor(this.y);
        this.z = (float)Math.floor(this.z);
        return this;
    }

    @NotNull
    public final Vector3f ceil() {
        this.x = (float)Math.ceil(this.x);
        this.y = (float)Math.ceil(this.y);
        this.z = (float)Math.ceil(this.z);
        return this;
    }

    @NotNull
    public final Vector3f round() {
        this.x = Math.round((double)this.x);
        this.y = Math.round((double)this.y);
        this.z = Math.round((double)this.z);
        return this;
    }

    @NotNull
    public final Vector3f roundToZero() {
        this.x = this.x < 0.0f ? (float)Math.ceil(this.x) : (float)Math.floor(this.x);
        this.y = this.y < 0.0f ? (float)Math.ceil(this.y) : (float)Math.floor(this.y);
        this.z = this.z < 0.0f ? (float)Math.ceil(this.z) : (float)Math.floor(this.z);
        return this;
    }

    @NotNull
    public final Vector3f negate() {
        this.x = -this.x;
        this.y = -this.y;
        this.z = -this.z;
        return this;
    }

    @NotNull
    public final Vector3f applyEuler(@NotNull Euler euler) {
        Intrinsics.checkParameterIsNotNull(euler, "euler");
        return this.applyQuaternion(Quaternion.Companion.fromEuler(euler));
    }

    @NotNull
    public final Vector3f applyAxisAngle(@NotNull Vector3f axis, double angle) {
        Intrinsics.checkParameterIsNotNull(axis, "axis");
        return this.applyQuaternion(Quaternion.Companion.fromAxisAngle(axis, angle));
    }

    @NotNull
    public final Vector3f applyMatrix4(@NotNull Matrix4f mat4) {
        Intrinsics.checkParameterIsNotNull(mat4, "mat4");
        float x = this.x;
        float y = this.y;
        float z = this.z;
        float[] e = mat4.getElements();
        float w = 1.0f / (e[3] * x + e[7] * y + e[11] * z + e[15]);
        this.x = (e[0] * x + e[4] * y + e[8] * z + e[12]) * w;
        this.y = (e[1] * x + e[5] * y + e[9] * z + e[13]) * w;
        this.z = (e[2] * x + e[6] * y + e[10] * z + e[14]) * w;
        return this;
    }

    @NotNull
    public final Vector3f applyRotationMatrix4(@NotNull Matrix4f mat4) {
        Intrinsics.checkParameterIsNotNull(mat4, "mat4");
        float x = this.x;
        float y = this.y;
        float z = this.z;
        float[] e = mat4.getElements();
        this.x = e[0] * x + e[4] * y + e[8] * z;
        this.y = e[1] * x + e[5] * y + e[9] * z;
        this.z = e[2] * x + e[6] * y + e[10] * z;
        return this;
    }

    @NotNull
    public final Vector3f applyQuaternion(@NotNull Quaternion q) {
        Intrinsics.checkParameterIsNotNull(q, "q");
        float x = this.x;
        float y = this.y;
        float z = this.z;
        float qx = q.getX();
        float qy = q.getY();
        float qz = q.getZ();
        float qw = q.getW();
        float ix = qw * x + qy * z - qz * y;
        float iy = qw * y + qz * x - qx * z;
        float iz = qw * z + qx * y - qy * x;
        float iw = -qx * x - qy * y - qz * z;
        this.x = ix * qw + iw * -qx + iy * -qz - iz * -qy;
        this.y = iy * qw + iw * -qy + iz * -qx - ix * -qz;
        this.z = iz * qw + iw * -qz + ix * -qy - iy * -qx;
        return this;
    }

    @NotNull
    public final Vector3f transformDirection(@NotNull Matrix4f mat4) {
        Intrinsics.checkParameterIsNotNull(mat4, "mat4");
        float x = this.x;
        float y = this.y;
        float z = this.z;
        float[] e = mat4.getElements();
        this.x = e[0] * x + e[4] * y + e[8] * z;
        this.y = e[1] * x + e[5] * y + e[9] * z;
        this.z = e[2] * x + e[6] * y + e[10] * z;
        return this.normalize();
    }

    @NotNull
    public final Vector3f lerp(@NotNull Vector3f v, double alpha) {
        Intrinsics.checkParameterIsNotNull(v, "v");
        float af = (float)alpha;
        this.x += (v.x - this.x) * af;
        this.y += (v.y - this.y) * af;
        this.z += (v.z - this.z) * af;
        return this;
    }

    @NotNull
    public final Vector3f lerpVectors(@NotNull Vector3f v1, @NotNull Vector3f v2, double alpha) {
        Intrinsics.checkParameterIsNotNull(v1, "v1");
        Intrinsics.checkParameterIsNotNull(v2, "v2");
        float af = (float)alpha;
        this.x = v1.x * (1.0f - af) + v2.x * af;
        this.y = v1.y * (1.0f - af) + v2.y * af;
        this.z = v1.z * (1.0f - af) + v2.z * af;
        return this;
    }

    @NotNull
    public final Vector3f projectOnVector(@NotNull Vector3f v) {
        Intrinsics.checkParameterIsNotNull(v, "v");
        double mag = v.lengthSquared();
        if (mag == 0.0) {
            return this.set(0.0, 0.0, 0.0);
        }
        float scalar = (float)(v.dot(this) / mag);
        this.x = v.x * scalar;
        this.y = v.y * scalar;
        this.z = v.z * scalar;
        return this;
    }

    @NotNull
    public final Vector3f projectOnPlane(@NotNull Vector3f planeNormal) {
        Intrinsics.checkParameterIsNotNull(planeNormal, "planeNormal");
        Vector3f v = this.clone().projectOnVector(planeNormal);
        return this.sub(v);
    }

    @NotNull
    public final Vector3f reflect(@NotNull Vector3f normal) {
        Intrinsics.checkParameterIsNotNull(normal, "normal");
        return this.sub(normal).multiplyScalar(2.0 * this.dot(normal));
    }

    public final double angleTo(@NotNull Vector3f v) {
        Intrinsics.checkParameterIsNotNull(v, "v");
        double denominator = Math.sqrt(this.lengthSquared() * v.lengthSquared());
        if (denominator == 0.0) {
            return 1.5707963267948966;
        }
        double theta = this.dot(v) / denominator;
        theta = Math.max(-1.0, Math.min(1.0, theta));
        return Math.acos(theta);
    }

    @NotNull
    public final Vector3f setFromMatrixPosition(@NotNull Matrix4f m) {
        Intrinsics.checkParameterIsNotNull(m, "m");
        float[] e = m.getElements();
        this.x = e[12];
        this.y = e[13];
        this.z = e[14];
        return this;
    }

    @NotNull
    public final Vector3f setFromMatrixScale(@NotNull Matrix4f m) {
        Intrinsics.checkParameterIsNotNull(m, "m");
        double sx = this.setFromMatrixColumn(m, 0).length();
        double sy = this.setFromMatrixColumn(m, 1).length();
        double sz = this.setFromMatrixColumn(m, 2).length();
        this.x = (float)sx;
        this.y = (float)sy;
        this.z = (float)sz;
        return this;
    }

    @NotNull
    public final Vector3f fromFloatArray(@NotNull float[] array, int offset) {
        Intrinsics.checkParameterIsNotNull(array, "array");
        this.x = array[offset];
        this.y = array[offset + 1];
        this.z = array[offset + 2];
        return this;
    }

    @NotNull
    public final float[] toFloatArray() {
        float[] array = new float[]{this.x, this.y, this.z};
        return array;
    }

    @NotNull
    public final float[] toFloatArray(@NotNull float[] array, int offset) {
        Intrinsics.checkParameterIsNotNull(array, "array");
        array[offset] = this.x;
        array[offset + 1] = this.y;
        array[offset + 2] = this.z;
        return array;
    }

    @NotNull
    public final Vector3f setFromMatrixColumn(@NotNull Matrix4f m, int index) {
        Intrinsics.checkParameterIsNotNull(m, "m");
        switch (index) {
            case 0: {
                this.x = m.getElements()[0];
                this.y = m.getElements()[1];
                this.z = m.getElements()[2];
                break;
            }
            case 1: {
                this.x = m.getElements()[4];
                this.y = m.getElements()[5];
                this.z = m.getElements()[6];
                break;
            }
            case 2: {
                this.x = m.getElements()[8];
                this.y = m.getElements()[9];
                this.z = m.getElements()[10];
                break;
            }
            case 3: {
                this.x = m.getElements()[12];
                this.y = m.getElements()[13];
                this.z = m.getElements()[14];
                break;
            }
            default: {
                throw (Throwable)new ArrayIndexOutOfBoundsException(index);
            }
        }
        return this;
    }

    public final float getX() {
        return this.x;
    }

    public final void setX(float f) {
        this.x = f;
    }

    public final float getY() {
        return this.y;
    }

    public final void setY(float f) {
        this.y = f;
    }

    public final float getZ() {
        return this.z;
    }

    public final void setZ(float f) {
        this.z = f;
    }

    public Vector3f(float x, float y, float z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    static {
        Companion = new Companion(null);
        ZERO = new Vector3f(0.0f, 0.0f, 0.0f);
        ONE = new Vector3f(1.0f, 1.0f, 1.0f);
    }

    public final float component1() {
        return this.x;
    }

    public final float component2() {
        return this.y;
    }

    public final float component3() {
        return this.z;
    }

    @NotNull
    public final Vector3f copy(float x, float y, float z) {
        return new Vector3f(x, y, z);
    }

    public static /* synthetic */ Vector3f copy$default(Vector3f vector3f, float f, float f2, float f3, int n, Object object) {
        if ((n & 1) != 0) {
            f = vector3f.x;
        }
        if ((n & 2) != 0) {
            f2 = vector3f.y;
        }
        if ((n & 4) != 0) {
            f3 = vector3f.z;
        }
        return vector3f.copy(f, f2, f3);
    }

    @NotNull
    public String toString() {
        return "Vector3f(x=" + this.x + ", y=" + this.y + ", z=" + this.z + ")";
    }

    public int hashCode() {
        return (Float.hashCode(this.x) * 31 + Float.hashCode(this.y)) * 31 + Float.hashCode(this.z);
    }

    public boolean equals(@Nullable Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof Vector3f)) break block3;
                Vector3f vector3f = (Vector3f)object;
                if (Float.compare(this.x, vector3f.x) != 0 || Float.compare(this.y, vector3f.y) != 0 || Float.compare(this.z, vector3f.z) != 0) break block3;
            }
            return true;
        }
        return false;
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000bJ\u0006\u0010\f\u001a\u00020\u0004J\u0006\u0010\r\u001a\u00020\u0004J\u0006\u0010\u000e\u001a\u00020\u0004J\u0006\u0010\u000f\u001a\u00020\u0004J\u0006\u0010\u0010\u001a\u00020\u0004R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006\u00a8\u0006\u0011"}, d2={"Lphonon/puppet/math/Vector3f$Companion;", "", "()V", "ONE", "Lphonon/puppet/math/Vector3f;", "getONE", "()Lphonon/puppet/math/Vector3f;", "ZERO", "getZERO", "fromLocation", "loc", "Lorg/bukkit/Location;", "one", "x", "y", "z", "zero", "phonon-puppet"})
    public static final class Companion {
        @NotNull
        public final Vector3f getZERO() {
            return ZERO;
        }

        @NotNull
        public final Vector3f getONE() {
            return ONE;
        }

        @NotNull
        public final Vector3f zero() {
            return new Vector3f(0.0f, 0.0f, 0.0f);
        }

        @NotNull
        public final Vector3f one() {
            return new Vector3f(1.0f, 1.0f, 1.0f);
        }

        @NotNull
        public final Vector3f x() {
            return new Vector3f(1.0f, 0.0f, 0.0f);
        }

        @NotNull
        public final Vector3f y() {
            return new Vector3f(0.0f, 1.0f, 0.0f);
        }

        @NotNull
        public final Vector3f z() {
            return new Vector3f(0.0f, 0.0f, 1.0f);
        }

        @NotNull
        public final Vector3f fromLocation(@NotNull Location loc) {
            Intrinsics.checkParameterIsNotNull(loc, "loc");
            return new Vector3f((float)loc.getX(), (float)loc.getY(), (float)loc.getZ());
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

