/*
 * Decompiled with CFR 0.152.
 */
package phonon.puppet.math;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import phonon.puppet.math.Euler;
import phonon.puppet.math.Matrix4f;
import phonon.puppet.math.Quaternion$WhenMappings;
import phonon.puppet.math.QuaternionKt;
import phonon.puppet.math.Vector3f;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u000f\n\u0002\u0010\u0006\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0014\n\u0000\n\u0002\u0010\b\n\u0002\b\u000f\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\b\u0018\u0000 J2\u00020\u0001:\u0001JB%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0007J\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0000J\u0006\u0010\u0015\u001a\u00020\u0000J\t\u0010\u0016\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0017\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0018\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0019\u001a\u00020\u0003H\u00c6\u0003J\u0006\u0010\u001a\u001a\u00020\u0000J1\u0010\u001b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u0003H\u00c6\u0001J\u000e\u0010\u001b\u001a\u00020\u00002\u0006\u0010\u001c\u001a\u00020\u0000J\u000e\u0010\u001d\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0000J\u0013\u0010\u001e\u001a\u00020\u001f2\b\u0010\u001c\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\u0016\u0010 \u001a\u00020\u00002\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$J\u0011\u0010%\u001a\u00020\u00032\u0006\u0010&\u001a\u00020$H\u0086\u0002J\t\u0010'\u001a\u00020$H\u00d6\u0001J\u0006\u0010(\u001a\u00020\u0000J\u0006\u0010)\u001a\u00020\u0013J\u0006\u0010*\u001a\u00020\u0013J\u000e\u0010+\u001a\u00020\u00002\u0006\u0010\u0014\u001a\u00020\u0000J\u0016\u0010,\u001a\u00020\u00002\u0006\u0010-\u001a\u00020\u00002\u0006\u0010.\u001a\u00020\u0000J\u0006\u0010/\u001a\u00020\u0000J\u000e\u00100\u001a\u00020\u00002\u0006\u0010\u0014\u001a\u00020\u0000J\u0016\u00101\u001a\u00020\u00002\u0006\u0010\u0014\u001a\u00020\u00002\u0006\u00102\u001a\u00020\u0013J&\u00103\u001a\u00020\u00002\u0006\u0010\u0002\u001a\u00020\u00132\u0006\u0010\u0004\u001a\u00020\u00132\u0006\u0010\u0005\u001a\u00020\u00132\u0006\u0010\u0006\u001a\u00020\u0013J&\u00103\u001a\u00020\u00002\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u0003J\u0019\u00103\u001a\u0002042\u0006\u0010&\u001a\u00020$2\u0006\u00105\u001a\u00020\u0003H\u0086\u0002J\u0016\u00106\u001a\u00020\u00002\u0006\u00107\u001a\u0002082\u0006\u00109\u001a\u00020\u0013J\u000e\u0010:\u001a\u00020\u00002\u0006\u0010;\u001a\u00020<J\u000e\u0010=\u001a\u00020\u00002\u0006\u0010>\u001a\u00020?J\u0016\u0010@\u001a\u00020\u00002\u0006\u0010A\u001a\u0002082\u0006\u0010B\u001a\u000208J\u0016\u0010C\u001a\u00020\u00002\u0006\u0010D\u001a\u00020\u00002\u0006\u0010E\u001a\u00020\u0013J\u001e\u0010C\u001a\u00020\u00002\u0006\u0010F\u001a\u00020\u00002\u0006\u0010D\u001a\u00020\u00002\u0006\u0010E\u001a\u00020\u0013J\u0006\u0010G\u001a\u00020\"J\u0016\u0010G\u001a\u00020\"2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$J\t\u0010H\u001a\u00020IH\u00d6\u0001R\u001a\u0010\u0006\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\t\"\u0004\b\r\u0010\u000bR\u001a\u0010\u0004\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\t\"\u0004\b\u000f\u0010\u000bR\u001a\u0010\u0005\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\t\"\u0004\b\u0011\u0010\u000b\u00a8\u0006K"}, d2={"Lphonon/puppet/math/Quaternion;", "", "x", "", "y", "z", "w", "(FFFF)V", "getW", "()F", "setW", "(F)V", "getX", "setX", "getY", "setY", "getZ", "setZ", "angleTo", "", "q", "clone", "component1", "component2", "component3", "component4", "conjugate", "copy", "other", "dot", "equals", "", "fromFloatArray", "array", "", "offset", "", "get", "i", "hashCode", "inverse", "length", "lengthSquared", "multiply", "multiplyQuaternions", "a", "b", "normalize", "premultiply", "rotateTowards", "step", "set", "", "v", "setFromAxisAngle", "axis", "Lphonon/puppet/math/Vector3f;", "angle", "setFromEuler", "euler", "Lphonon/puppet/math/Euler;", "setFromRotationMatrix", "mat4", "Lphonon/puppet/math/Matrix4f;", "setFromUnitVectors", "vFrom", "vTo", "slerp", "qb", "t", "qa", "toFloatArray", "toString", "", "Companion", "phonon-puppet"})
public final class Quaternion {
    private float x;
    private float y;
    private float z;
    private float w;
    public static final Companion Companion = new Companion(null);

    public final float get(int i) {
        switch (i) {
            case 0: {
                return this.x;
            }
            case 1: {
                return this.y;
            }
            case 2: {
                return this.z;
            }
            case 3: {
                return this.w;
            }
        }
        throw (Throwable)new ArrayIndexOutOfBoundsException(i);
    }

    public final void set(int i, float v) {
        switch (i) {
            case 0: {
                this.x = v;
                break;
            }
            case 1: {
                this.y = v;
                break;
            }
            case 2: {
                this.z = v;
                break;
            }
            case 3: {
                this.w = v;
                break;
            }
            default: {
                throw (Throwable)new ArrayIndexOutOfBoundsException(i);
            }
        }
    }

    @NotNull
    public final Quaternion clone() {
        return new Quaternion(this.x, this.y, this.z, this.w);
    }

    @NotNull
    public final Quaternion copy(@NotNull Quaternion other) {
        Intrinsics.checkParameterIsNotNull(other, "other");
        this.x = other.x;
        this.y = other.y;
        this.z = other.z;
        this.w = other.w;
        return this;
    }

    @NotNull
    public final Quaternion set(double x, double y, double z, double w) {
        this.x = (float)x;
        this.y = (float)y;
        this.z = (float)z;
        this.w = (float)w;
        return this;
    }

    @NotNull
    public final Quaternion set(float x, float y, float z, float w) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.w = w;
        return this;
    }

    @NotNull
    public final Quaternion setFromEuler(@NotNull Euler euler) {
        Intrinsics.checkParameterIsNotNull(euler, "euler");
        double x = euler.getX();
        double y = euler.getY();
        double z = euler.getZ();
        float c1 = (float)Math.cos(x / 2.0);
        float c2 = (float)Math.cos(y / 2.0);
        float c3 = (float)Math.cos(z / 2.0);
        float s1 = (float)Math.sin(x / 2.0);
        float s2 = (float)Math.sin(y / 2.0);
        float s3 = (float)Math.sin(z / 2.0);
        switch (Quaternion$WhenMappings.$EnumSwitchMapping$0[euler.getOrder().ordinal()]) {
            case 1: {
                this.x = s1 * c2 * c3 + c1 * s2 * s3;
                this.y = c1 * s2 * c3 - s1 * c2 * s3;
                this.z = c1 * c2 * s3 + s1 * s2 * c3;
                this.w = c1 * c2 * c3 - s1 * s2 * s3;
                break;
            }
            case 2: {
                this.x = s1 * c2 * c3 + c1 * s2 * s3;
                this.y = c1 * s2 * c3 - s1 * c2 * s3;
                this.z = c1 * c2 * s3 - s1 * s2 * c3;
                this.w = c1 * c2 * c3 + s1 * s2 * s3;
                break;
            }
            case 3: {
                this.x = s1 * c2 * c3 - c1 * s2 * s3;
                this.y = c1 * s2 * c3 + s1 * c2 * s3;
                this.z = c1 * c2 * s3 + s1 * s2 * c3;
                this.w = c1 * c2 * c3 - s1 * s2 * s3;
                break;
            }
            case 4: {
                this.x = s1 * c2 * c3 - c1 * s2 * s3;
                this.y = c1 * s2 * c3 + s1 * c2 * s3;
                this.z = c1 * c2 * s3 - s1 * s2 * c3;
                this.w = c1 * c2 * c3 + s1 * s2 * s3;
                break;
            }
            case 5: {
                this.x = s1 * c2 * c3 + c1 * s2 * s3;
                this.y = c1 * s2 * c3 + s1 * c2 * s3;
                this.z = c1 * c2 * s3 - s1 * s2 * c3;
                this.w = c1 * c2 * c3 - s1 * s2 * s3;
                break;
            }
            case 6: {
                this.x = s1 * c2 * c3 - c1 * s2 * s3;
                this.y = c1 * s2 * c3 - s1 * c2 * s3;
                this.z = c1 * c2 * s3 + s1 * s2 * c3;
                this.w = c1 * c2 * c3 + s1 * s2 * s3;
            }
        }
        return this;
    }

    @NotNull
    public final Quaternion setFromAxisAngle(@NotNull Vector3f axis, double angle) {
        Intrinsics.checkParameterIsNotNull(axis, "axis");
        double halfAngle = angle / 2.0;
        float s = (float)Math.sin(halfAngle);
        this.x = axis.getX() * s;
        this.y = axis.getY() * s;
        this.z = axis.getZ() * s;
        this.w = (float)Math.cos(halfAngle);
        return this;
    }

    @NotNull
    public final Quaternion setFromRotationMatrix(@NotNull Matrix4f mat4) {
        Intrinsics.checkParameterIsNotNull(mat4, "mat4");
        float[] e = mat4.getElements();
        float e00 = e[0];
        float e01 = e[4];
        float e02 = e[8];
        float e10 = e[1];
        float e11 = e[5];
        float e12 = e[9];
        float e20 = e[2];
        float e21 = e[6];
        float e22 = e[10];
        double trace = e00 + e11 + e22;
        if (trace > 0.0) {
            float s = 0.5f / (float)Math.sqrt(trace + 1.0);
            this.w = 0.25f / s;
            this.x = (e21 - e12) * s;
            this.y = (e02 - e20) * s;
            this.z = (e10 - e01) * s;
        } else if (e00 > e11 && e00 > e22) {
            float s = 2.0f * (float)Math.sqrt(1.0f + e00 - e11 - e22);
            this.w = (e21 - e12) / s;
            this.x = 0.25f * s;
            this.y = (e01 + e10) / s;
            this.z = (e02 + e20) / s;
        } else if (e11 > e22) {
            float s = 2.0f * (float)Math.sqrt(1.0f + e11 - e00 - e22);
            this.w = (e02 - e20) / s;
            this.x = (e01 + e10) / s;
            this.y = 0.25f * s;
            this.z = (e12 + e21) / s;
        } else {
            float s = 2.0f * (float)Math.sqrt(1.0f + e22 - e00 - e11);
            this.w = (e10 - e01) / s;
            this.x = (e02 + e20) / s;
            this.y = (e12 + e21) / s;
            this.z = 0.25f * s;
        }
        return this;
    }

    @NotNull
    public final Quaternion setFromUnitVectors(@NotNull Vector3f vFrom, @NotNull Vector3f vTo) {
        Intrinsics.checkParameterIsNotNull(vFrom, "vFrom");
        Intrinsics.checkParameterIsNotNull(vTo, "vTo");
        double r = vFrom.dot(vTo) + 1.0;
        double EPSILON = 1.0E-6;
        if (r < EPSILON) {
            if (Math.abs((double)vFrom.getX()) > Math.abs((double)vFrom.getZ())) {
                this.x = -vFrom.getY();
                this.y = vFrom.getX();
                this.z = 0.0f;
                this.w = 0.0f;
            } else {
                this.x = 0.0f;
                this.y = -vFrom.getZ();
                this.z = vFrom.getY();
                this.w = 0.0f;
            }
        } else {
            this.x = vFrom.getY() * vTo.getZ() - vFrom.getZ() * vTo.getY();
            this.y = vFrom.getZ() * vTo.getX() - vFrom.getX() * vTo.getZ();
            this.z = vFrom.getX() * vTo.getY() - vFrom.getY() * vTo.getX();
            this.w = (float)r;
        }
        return this.normalize();
    }

    @NotNull
    public final Quaternion multiplyQuaternions(@NotNull Quaternion a, @NotNull Quaternion b) {
        Intrinsics.checkParameterIsNotNull(a, "a");
        Intrinsics.checkParameterIsNotNull(b, "b");
        float qax = a.x;
        float qay = a.y;
        float qaz = a.z;
        float qaw = a.w;
        float qbx = b.x;
        float qby = b.y;
        float qbz = b.z;
        float qbw = b.w;
        this.x = qax * qbw + qaw * qbx + qay * qbz - qaz * qby;
        this.y = qay * qbw + qaw * qby + qaz * qbx - qax * qbz;
        this.z = qaz * qbw + qaw * qbz + qax * qby - qay * qbx;
        this.w = qaw * qbw - qax * qbx - qay * qby - qaz * qbz;
        return this;
    }

    @NotNull
    public final Quaternion multiply(@NotNull Quaternion q) {
        Intrinsics.checkParameterIsNotNull(q, "q");
        return this.multiplyQuaternions(this, q);
    }

    @NotNull
    public final Quaternion premultiply(@NotNull Quaternion q) {
        Intrinsics.checkParameterIsNotNull(q, "q");
        return this.multiplyQuaternions(q, this);
    }

    @NotNull
    public final Quaternion conjugate() {
        this.x *= -1.0f;
        this.y *= -1.0f;
        this.z *= -1.0f;
        return this;
    }

    @NotNull
    public final Quaternion inverse() {
        return this.conjugate();
    }

    public final double dot(@NotNull Quaternion q) {
        Intrinsics.checkParameterIsNotNull(q, "q");
        return this.x * q.x + this.y * q.y + this.z * q.z + this.w * q.w;
    }

    public final double lengthSquared() {
        return this.x * this.x + this.y * this.y + this.z * this.z + this.w * this.w;
    }

    public final double length() {
        return Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z + this.w * this.w);
    }

    @NotNull
    public final Quaternion normalize() {
        double len = this.length();
        if (len == 0.0) {
            this.x = 0.0f;
            this.y = 0.0f;
            this.z = 0.0f;
            this.w = 1.0f;
        } else {
            float invLen = (float)(1.0 / len);
            this.x *= invLen;
            this.y *= invLen;
            this.z *= invLen;
            this.w *= invLen;
        }
        return this;
    }

    public final double angleTo(@NotNull Quaternion q) {
        Intrinsics.checkParameterIsNotNull(q, "q");
        return 2.0 * Math.acos(Math.abs(QuaternionKt.access$clamp(this.dot(q), -1.0, 1.0)));
    }

    @NotNull
    public final Quaternion slerp(@NotNull Quaternion qb, double t) {
        Intrinsics.checkParameterIsNotNull(qb, "qb");
        if (t <= 0.0) {
            return this;
        }
        if (t >= 1.0) {
            return this.copy(qb);
        }
        float w = this.w;
        float x = this.x;
        float y = this.y;
        float z = this.z;
        double cosHalfTheta = w * qb.w + x * qb.x + y * qb.y + z * qb.z;
        if (cosHalfTheta < (double)0.0f) {
            this.w = -qb.w;
            this.x = -qb.x;
            this.y = -qb.y;
            this.z = -qb.z;
            cosHalfTheta = -cosHalfTheta;
        } else {
            this.copy(qb);
        }
        if (cosHalfTheta >= 1.0) {
            this.w = w;
            this.x = x;
            this.y = y;
            this.z = z;
            return this;
        }
        double sqrSinHalfTheta = 1.0 - cosHalfTheta * cosHalfTheta;
        double EPSILON = 1.0E-8;
        if (sqrSinHalfTheta <= EPSILON) {
            float s = (float)(1.0 - t);
            float tf = (float)t;
            this.w = s * w + tf * this.w;
            this.x = s * x + tf * this.x;
            this.y = s * y + tf * this.y;
            this.z = s * z + tf * this.z;
            return this.normalize();
        }
        double sinHalfTheta = Math.sqrt(sqrSinHalfTheta);
        double halfTheta = Math.atan2(sinHalfTheta, cosHalfTheta);
        float ratioA = (float)(Math.sin((1.0 - t) * halfTheta) / sinHalfTheta);
        float ratioB = (float)(Math.sin(t * halfTheta) / sinHalfTheta);
        this.w = w * ratioA + this.w * ratioB;
        this.x = x * ratioA + this.x * ratioB;
        this.y = y * ratioA + this.y * ratioB;
        this.z = z * ratioA + this.z * ratioB;
        return this;
    }

    @NotNull
    public final Quaternion slerp(@NotNull Quaternion qa, @NotNull Quaternion qb, double t) {
        Intrinsics.checkParameterIsNotNull(qa, "qa");
        Intrinsics.checkParameterIsNotNull(qb, "qb");
        return this.copy(qa).slerp(qb, t);
    }

    @NotNull
    public final Quaternion rotateTowards(@NotNull Quaternion q, double step) {
        Intrinsics.checkParameterIsNotNull(q, "q");
        double angle = this.angleTo(q);
        double EPSILON = 1.0E-5;
        if (angle < EPSILON) {
            return this.copy(q);
        }
        double t = Math.min(1.0, step / angle);
        return this.slerp(q, t);
    }

    @NotNull
    public final Quaternion fromFloatArray(@NotNull float[] array, int offset) {
        Intrinsics.checkParameterIsNotNull(array, "array");
        this.x = array[offset];
        this.y = array[offset + 1];
        this.z = array[offset + 2];
        this.w = array[offset + 3];
        return this;
    }

    @NotNull
    public final float[] toFloatArray() {
        float[] array = new float[]{this.x, this.y, this.z, this.w};
        return array;
    }

    @NotNull
    public final float[] toFloatArray(@NotNull float[] array, int offset) {
        Intrinsics.checkParameterIsNotNull(array, "array");
        array[offset] = this.x;
        array[offset + 1] = this.y;
        array[offset + 2] = this.z;
        array[offset + 3] = this.w;
        return array;
    }

    public final float getX() {
        return this.x;
    }

    public final void setX(float f) {
        this.x = f;
    }

    public final float getY() {
        return this.y;
    }

    public final void setY(float f) {
        this.y = f;
    }

    public final float getZ() {
        return this.z;
    }

    public final void setZ(float f) {
        this.z = f;
    }

    public final float getW() {
        return this.w;
    }

    public final void setW(float f) {
        this.w = f;
    }

    public Quaternion(float x, float y, float z, float w) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.w = w;
    }

    public final float component1() {
        return this.x;
    }

    public final float component2() {
        return this.y;
    }

    public final float component3() {
        return this.z;
    }

    public final float component4() {
        return this.w;
    }

    @NotNull
    public final Quaternion copy(float x, float y, float z, float w) {
        return new Quaternion(x, y, z, w);
    }

    public static /* synthetic */ Quaternion copy$default(Quaternion quaternion, float f, float f2, float f3, float f4, int n, Object object) {
        if ((n & 1) != 0) {
            f = quaternion.x;
        }
        if ((n & 2) != 0) {
            f2 = quaternion.y;
        }
        if ((n & 4) != 0) {
            f3 = quaternion.z;
        }
        if ((n & 8) != 0) {
            f4 = quaternion.w;
        }
        return quaternion.copy(f, f2, f3, f4);
    }

    @NotNull
    public String toString() {
        return "Quaternion(x=" + this.x + ", y=" + this.y + ", z=" + this.z + ", w=" + this.w + ")";
    }

    public int hashCode() {
        return ((Float.hashCode(this.x) * 31 + Float.hashCode(this.y)) * 31 + Float.hashCode(this.z)) * 31 + Float.hashCode(this.w);
    }

    public boolean equals(@Nullable Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof Quaternion)) break block3;
                Quaternion quaternion = (Quaternion)object;
                if (Float.compare(this.x, quaternion.x) != 0 || Float.compare(this.y, quaternion.y) != 0 || Float.compare(this.z, quaternion.z) != 0 || Float.compare(this.w, quaternion.w) != 0) break block3;
            }
            return true;
        }
        return false;
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u000e\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000bJ\u000e\u0010\f\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u000eJ\u0006\u0010\u000f\u001a\u00020\u0004J\u0006\u0010\u0010\u001a\u00020\u0004\u00a8\u0006\u0011"}, d2={"Lphonon/puppet/math/Quaternion$Companion;", "", "()V", "fromAxisAngle", "Lphonon/puppet/math/Quaternion;", "axis", "Lphonon/puppet/math/Vector3f;", "angle", "", "fromEuler", "euler", "Lphonon/puppet/math/Euler;", "fromRotationMatrix", "mat4", "Lphonon/puppet/math/Matrix4f;", "new", "zero", "phonon-puppet"})
    public static final class Companion {
        @NotNull
        public final Quaternion zero() {
            return new Quaternion(0.0f, 0.0f, 0.0f, 0.0f);
        }

        @NotNull
        public final Quaternion new() {
            return new Quaternion(0.0f, 0.0f, 0.0f, 1.0f);
        }

        @NotNull
        public final Quaternion fromEuler(@NotNull Euler euler) {
            Intrinsics.checkParameterIsNotNull(euler, "euler");
            Quaternion q = new Quaternion(0.0f, 0.0f, 0.0f, 0.0f);
            return q.setFromEuler(euler);
        }

        @NotNull
        public final Quaternion fromAxisAngle(@NotNull Vector3f axis, double angle) {
            Intrinsics.checkParameterIsNotNull(axis, "axis");
            Quaternion q = new Quaternion(0.0f, 0.0f, 0.0f, 0.0f);
            return q.setFromAxisAngle(axis, angle);
        }

        @NotNull
        public final Quaternion fromRotationMatrix(@NotNull Matrix4f mat4) {
            Intrinsics.checkParameterIsNotNull(mat4, "mat4");
            Quaternion q = new Quaternion(0.0f, 0.0f, 0.0f, 0.0f);
            return q.setFromRotationMatrix(mat4);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

