/*
 * Decompiled with CFR 0.152.
 */
package phonon.puppet.math;

import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import phonon.puppet.math.Euler;
import phonon.puppet.math.Quaternion;
import phonon.puppet.math.Vector3f;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0014\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\b\n\u0002\b \n\u0002\u0018\u0002\n\u0002\b\u0013\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u0000 T2\u00020\u0001:\u0001TB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0007\u001a\u00020\u0000J\u0016\u0010\b\u001a\u00020\u00002\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\u000e\u0010\r\u001a\u00020\u00002\u0006\u0010\u000e\u001a\u00020\u0000J\u0016\u0010\u000f\u001a\u00020\u00002\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\u0006\u0010\u0010\u001a\u00020\u0011J\u0013\u0010\u0012\u001a\u00020\u00132\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\u000e\u0010\u0014\u001a\u00020\u00002\u0006\u0010\u0015\u001a\u00020\u0000J\u0011\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0086\u0002J\u0006\u0010\u001a\u001a\u00020\u0011J\u0006\u0010\u001b\u001a\u00020\nJ\b\u0010\u001c\u001a\u00020\u0019H\u0016J\u000e\u0010\u001d\u001a\u00020\u00002\u0006\u0010\u0015\u001a\u00020\u0000J\u001e\u0010\u001e\u001a\u00020\u00002\u0006\u0010\u001f\u001a\u00020\n2\u0006\u0010 \u001a\u00020\n2\u0006\u0010!\u001a\u00020\nJ\u0016\u0010\"\u001a\u00020\u00002\u0006\u0010#\u001a\u00020\n2\u0006\u0010$\u001a\u00020\u0011J\u000e\u0010%\u001a\u00020\u00002\u0006\u0010&\u001a\u00020\fJ\u000e\u0010'\u001a\u00020\u00002\u0006\u0010(\u001a\u00020\u0011J\u000e\u0010)\u001a\u00020\u00002\u0006\u0010(\u001a\u00020\u0011J\u000e\u0010*\u001a\u00020\u00002\u0006\u0010(\u001a\u00020\u0011J\u001e\u0010+\u001a\u00020\u00002\u0006\u0010,\u001a\u00020\u00112\u0006\u0010-\u001a\u00020\u00112\u0006\u0010.\u001a\u00020\u0011J\u001e\u0010/\u001a\u00020\u00002\u0006\u0010,\u001a\u00020\u00112\u0006\u0010-\u001a\u00020\u00112\u0006\u0010.\u001a\u00020\u0011J\u001e\u00100\u001a\u00020\u00002\u0006\u0010,\u001a\u00020\u00112\u0006\u0010-\u001a\u00020\u00112\u0006\u0010.\u001a\u00020\u0011J\u000e\u00101\u001a\u00020\u00002\u0006\u0010\u0015\u001a\u00020\u0000J\u0016\u00102\u001a\u00020\u00002\u0006\u00103\u001a\u00020\u00002\u0006\u00104\u001a\u00020\u0000J\u000e\u00105\u001a\u00020\u00002\u0006\u00106\u001a\u00020\u0017J\u000e\u00107\u001a\u00020\u00002\u0006\u0010\u0015\u001a\u00020\u0000J\u000e\u00108\u001a\u00020\u00002\u0006\u00109\u001a\u00020:J\u000e\u0010;\u001a\u00020\u00002\u0006\u0010<\u001a\u00020\nJ\u0086\u0001\u0010=\u001a\u00020\u00002\u0006\u0010>\u001a\u00020\u00172\u0006\u0010?\u001a\u00020\u00172\u0006\u0010@\u001a\u00020\u00172\u0006\u0010A\u001a\u00020\u00172\u0006\u0010B\u001a\u00020\u00172\u0006\u0010C\u001a\u00020\u00172\u0006\u0010D\u001a\u00020\u00172\u0006\u0010E\u001a\u00020\u00172\u0006\u0010F\u001a\u00020\u00172\u0006\u0010G\u001a\u00020\u00172\u0006\u0010H\u001a\u00020\u00172\u0006\u0010I\u001a\u00020\u00172\u0006\u0010J\u001a\u00020\u00172\u0006\u0010K\u001a\u00020\u00172\u0006\u0010L\u001a\u00020\u00172\u0006\u0010M\u001a\u00020\u0017J\u0019\u0010=\u001a\u00020N2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010<\u001a\u00020\u0017H\u0086\u0002J\u000e\u0010O\u001a\u00020\u00002\u0006\u0010<\u001a\u00020\nJ\u001e\u0010P\u001a\u00020\u00002\u0006\u0010,\u001a\u00020\u00172\u0006\u0010-\u001a\u00020\u00172\u0006\u0010.\u001a\u00020\u0017J\b\u0010Q\u001a\u00020RH\u0016J\u0006\u0010S\u001a\u00020\u0000R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006U"}, d2={"Lphonon/puppet/math/Matrix4f;", "", "()V", "elements", "", "getElements", "()[F", "clone", "compose", "position", "Lphonon/puppet/math/Vector3f;", "quaternion", "Lphonon/puppet/math/Quaternion;", "copy", "other", "decompose", "det", "", "equals", "", "extractRotation", "m", "get", "", "i", "", "getMaxScaleOnAxis", "getTranslation", "hashCode", "inv", "lookAt", "eye", "target", "up", "makeRotationAxis", "axis", "angle", "makeRotationFromQuaternion", "q", "makeRotationX", "theta", "makeRotationY", "makeRotationZ", "makeScale", "x", "y", "z", "makeShear", "makeTranslation", "multiply", "multiplyMatrices", "a", "b", "multiplyScalar", "s", "premultiply", "rotationFromEuler", "euler", "Lphonon/puppet/math/Euler;", "scale", "v", "set", "a0", "a1", "a2", "a3", "a4", "a5", "a6", "a7", "a8", "a9", "a10", "a11", "a12", "a13", "a14", "a15", "", "setPosition", "setTranslation", "toString", "", "transpose", "Companion", "phonon-puppet"})
public final class Matrix4f {
    @NotNull
    private final float[] elements = new float[16];
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final float[] getElements() {
        return this.elements;
    }

    public final float get(int i) {
        return this.elements[i];
    }

    public final void set(int i, float v) {
        this.elements[i] = v;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        Object object = other;
        if (Intrinsics.areEqual(object != null ? object.getClass() : null, this.getClass()) ^ true) {
            return false;
        }
        Object object2 = other;
        if (object2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type phonon.puppet.math.Matrix4f");
        }
        Matrix4f cfr_ignored_0 = (Matrix4f)object2;
        return this.elements[0] == ((Matrix4f)other).elements[0] && this.elements[1] == ((Matrix4f)other).elements[1] && this.elements[2] == ((Matrix4f)other).elements[2] && this.elements[3] == ((Matrix4f)other).elements[3] && this.elements[4] == ((Matrix4f)other).elements[4] && this.elements[5] == ((Matrix4f)other).elements[5] && this.elements[6] == ((Matrix4f)other).elements[6] && this.elements[7] == ((Matrix4f)other).elements[7] && this.elements[8] == ((Matrix4f)other).elements[8] && this.elements[9] == ((Matrix4f)other).elements[9] && this.elements[10] == ((Matrix4f)other).elements[10] && this.elements[11] == ((Matrix4f)other).elements[11] && this.elements[12] == ((Matrix4f)other).elements[12] && this.elements[13] == ((Matrix4f)other).elements[13] && this.elements[14] == ((Matrix4f)other).elements[14] && this.elements[15] == ((Matrix4f)other).elements[15];
    }

    public int hashCode() {
        return this.elements.hashCode();
    }

    @NotNull
    public String toString() {
        float[] e = this.elements;
        return "Matrix4f(" + e[0] + ", " + e[1] + ", " + e[2] + ", " + e[3] + ",\n " + e[4] + ", " + e[5] + ", " + e[6] + ", " + e[7] + ",\n " + e[8] + ", " + e[9] + ", " + e[10] + ", " + e[11] + ",\n " + e[12] + ", " + e[13] + ", " + e[14] + ", " + e[15] + ')';
    }

    @NotNull
    public final Matrix4f clone() {
        float[] e = this.elements;
        return Companion.of(e[0], e[4], e[8], e[12], e[1], e[5], e[9], e[13], e[2], e[6], e[10], e[14], e[3], e[7], e[11], e[15]);
    }

    @NotNull
    public final Matrix4f copy(@NotNull Matrix4f other) {
        Intrinsics.checkParameterIsNotNull(other, "other");
        this.elements[0] = other.elements[0];
        this.elements[1] = other.elements[1];
        this.elements[2] = other.elements[2];
        this.elements[3] = other.elements[3];
        this.elements[4] = other.elements[4];
        this.elements[5] = other.elements[5];
        this.elements[6] = other.elements[6];
        this.elements[7] = other.elements[7];
        this.elements[8] = other.elements[8];
        this.elements[9] = other.elements[9];
        this.elements[10] = other.elements[10];
        this.elements[11] = other.elements[11];
        this.elements[12] = other.elements[12];
        this.elements[13] = other.elements[13];
        this.elements[14] = other.elements[14];
        this.elements[15] = other.elements[15];
        return this;
    }

    @NotNull
    public final Matrix4f set(float a0, float a1, float a2, float a3, float a4, float a5, float a6, float a7, float a8, float a9, float a10, float a11, float a12, float a13, float a14, float a15) {
        this.elements[0] = a0;
        this.elements[4] = a1;
        this.elements[8] = a2;
        this.elements[12] = a3;
        this.elements[1] = a4;
        this.elements[5] = a5;
        this.elements[9] = a6;
        this.elements[13] = a7;
        this.elements[2] = a8;
        this.elements[6] = a9;
        this.elements[10] = a10;
        this.elements[14] = a11;
        this.elements[3] = a12;
        this.elements[7] = a13;
        this.elements[11] = a14;
        this.elements[15] = a15;
        return this;
    }

    @NotNull
    public final Matrix4f transpose() {
        float tmp = 0.0f;
        float[] e = this.elements;
        tmp = e[1];
        e[1] = e[4];
        e[4] = tmp;
        tmp = e[2];
        e[2] = e[8];
        e[8] = tmp;
        tmp = e[3];
        e[3] = e[12];
        e[12] = tmp;
        tmp = e[6];
        e[6] = e[9];
        e[9] = tmp;
        tmp = e[7];
        e[7] = e[13];
        e[13] = tmp;
        tmp = e[11];
        e[11] = e[14];
        e[14] = tmp;
        return this;
    }

    public final double det() {
        float[] e = this.elements;
        float e00 = e[0];
        float e01 = e[4];
        float e02 = e[8];
        float e03 = e[12];
        float e10 = e[1];
        float e11 = e[5];
        float e12 = e[9];
        float e13 = e[13];
        float e20 = e[2];
        float e21 = e[6];
        float e22 = e[10];
        float e23 = e[14];
        float e30 = e[3];
        float e31 = e[7];
        float e32 = e[11];
        float e33 = e[15];
        return e30 * (e03 * e12 * e21 - e02 * e13 * e21 - e03 * e11 * e22 + e01 * e13 * e22 + e02 * e11 * e23 - e01 * e12 * e23) + e31 * (e00 * e12 * e23 - e00 * e13 * e22 + e03 * e10 * e22 - e02 * e10 * e23 + e02 * e13 * e20 - e03 * e12 * e20) + e32 * (e00 * e13 * e21 - e00 * e11 * e23 - e03 * e10 * e21 + e01 * e10 * e23 + e03 * e11 * e20 - e01 * e13 * e20) + e33 * (-e02 * e11 * e20 - e00 * e12 * e21 + e00 * e11 * e22 + e02 * e10 * e21 - e01 * e10 * e22 + e01 * e12 * e20);
    }

    @NotNull
    public final Matrix4f inv(@NotNull Matrix4f m) {
        Intrinsics.checkParameterIsNotNull(m, "m");
        float[] te = this.elements;
        float[] e = m.elements;
        float e00 = e[0];
        float e01 = e[4];
        float e02 = e[8];
        float e03 = e[12];
        float e10 = e[1];
        float e11 = e[5];
        float e12 = e[9];
        float e13 = e[13];
        float e20 = e[2];
        float e21 = e[6];
        float e22 = e[10];
        float e23 = e[14];
        float e30 = e[3];
        float e31 = e[7];
        float e32 = e[11];
        float e33 = e[15];
        float t11 = e12 * e23 * e31 - e13 * e22 * e31 + e13 * e21 * e32 - e11 * e23 * e32 - e12 * e21 * e33 + e11 * e22 * e33;
        float t12 = e03 * e22 * e31 - e02 * e23 * e31 - e03 * e21 * e32 + e01 * e23 * e32 + e02 * e21 * e33 - e01 * e22 * e33;
        float t13 = e02 * e13 * e31 - e03 * e12 * e31 + e03 * e11 * e32 - e01 * e13 * e32 - e02 * e11 * e33 + e01 * e12 * e33;
        float t14 = e03 * e12 * e21 - e02 * e13 * e21 - e03 * e11 * e22 + e01 * e13 * e22 + e02 * e11 * e23 - e01 * e12 * e23;
        float det = e00 * t11 + e10 * t12 + e20 * t13 + e30 * t14;
        if (det == 0.0f) {
            return this.set(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f);
        }
        float detInv = 1.0f / det;
        te[0] = t11 * detInv;
        te[1] = (e13 * e22 * e30 - e12 * e23 * e30 - e13 * e20 * e32 + e10 * e23 * e32 + e12 * e20 * e33 - e10 * e22 * e33) * detInv;
        te[2] = (e11 * e23 * e30 - e13 * e21 * e30 + e13 * e20 * e31 - e10 * e23 * e31 - e11 * e20 * e33 + e10 * e21 * e33) * detInv;
        te[3] = (e12 * e21 * e30 - e11 * e22 * e30 - e12 * e20 * e31 + e10 * e22 * e31 + e11 * e20 * e32 - e10 * e21 * e32) * detInv;
        te[4] = t12 * detInv;
        te[5] = (e02 * e23 * e30 - e03 * e22 * e30 + e03 * e20 * e32 - e00 * e23 * e32 - e02 * e20 * e33 + e00 * e22 * e33) * detInv;
        te[6] = (e03 * e21 * e30 - e01 * e23 * e30 - e03 * e20 * e31 + e00 * e23 * e31 + e01 * e20 * e33 - e00 * e21 * e33) * detInv;
        te[7] = (e01 * e22 * e30 - e02 * e21 * e30 + e02 * e20 * e31 - e00 * e22 * e31 - e01 * e20 * e32 + e00 * e21 * e32) * detInv;
        te[8] = t13 * detInv;
        te[9] = (e03 * e12 * e30 - e02 * e13 * e30 - e03 * e10 * e32 + e00 * e13 * e32 + e02 * e10 * e33 - e00 * e12 * e33) * detInv;
        te[10] = (e01 * e13 * e30 - e03 * e11 * e30 + e03 * e10 * e31 - e00 * e13 * e31 - e01 * e10 * e33 + e00 * e11 * e33) * detInv;
        te[11] = (e02 * e11 * e30 - e01 * e12 * e30 - e02 * e10 * e31 + e00 * e12 * e31 + e01 * e10 * e32 - e00 * e11 * e32) * detInv;
        te[12] = t14 * detInv;
        te[13] = (e02 * e13 * e20 - e03 * e12 * e20 + e03 * e10 * e22 - e00 * e13 * e22 - e02 * e10 * e23 + e00 * e12 * e23) * detInv;
        te[14] = (e03 * e11 * e20 - e01 * e13 * e20 - e03 * e10 * e21 + e00 * e13 * e21 + e01 * e10 * e23 - e00 * e11 * e23) * detInv;
        te[15] = (e01 * e12 * e20 - e02 * e11 * e20 + e02 * e10 * e21 - e00 * e12 * e21 - e01 * e10 * e22 + e00 * e11 * e22) * detInv;
        return this;
    }

    @NotNull
    public final Matrix4f multiplyMatrices(@NotNull Matrix4f a, @NotNull Matrix4f b) {
        Intrinsics.checkParameterIsNotNull(a, "a");
        Intrinsics.checkParameterIsNotNull(b, "b");
        float[] ae = a.elements;
        float[] be = b.elements;
        float a00 = ae[0];
        float a01 = ae[4];
        float a02 = ae[8];
        float a03 = ae[12];
        float a10 = ae[1];
        float a11 = ae[5];
        float a12 = ae[9];
        float a13 = ae[13];
        float a20 = ae[2];
        float a21 = ae[6];
        float a22 = ae[10];
        float a23 = ae[14];
        float a30 = ae[3];
        float a31 = ae[7];
        float a32 = ae[11];
        float a33 = ae[15];
        float b00 = be[0];
        float b01 = be[4];
        float b02 = be[8];
        float b03 = be[12];
        float b10 = be[1];
        float b11 = be[5];
        float b12 = be[9];
        float b13 = be[13];
        float b20 = be[2];
        float b21 = be[6];
        float b22 = be[10];
        float b23 = be[14];
        float b30 = be[3];
        float b31 = be[7];
        float b32 = be[11];
        float b33 = be[15];
        float[] e = this.elements;
        e[0] = a00 * b00 + a01 * b10 + a02 * b20 + a03 * b30;
        e[4] = a00 * b01 + a01 * b11 + a02 * b21 + a03 * b31;
        e[8] = a00 * b02 + a01 * b12 + a02 * b22 + a03 * b32;
        e[12] = a00 * b03 + a01 * b13 + a02 * b23 + a03 * b33;
        e[1] = a10 * b00 + a11 * b10 + a12 * b20 + a13 * b30;
        e[5] = a10 * b01 + a11 * b11 + a12 * b21 + a13 * b31;
        e[9] = a10 * b02 + a11 * b12 + a12 * b22 + a13 * b32;
        e[13] = a10 * b03 + a11 * b13 + a12 * b23 + a13 * b33;
        e[2] = a20 * b00 + a21 * b10 + a22 * b20 + a23 * b30;
        e[6] = a20 * b01 + a21 * b11 + a22 * b21 + a23 * b31;
        e[10] = a20 * b02 + a21 * b12 + a22 * b22 + a23 * b32;
        e[14] = a20 * b03 + a21 * b13 + a22 * b23 + a23 * b33;
        e[3] = a30 * b00 + a31 * b10 + a32 * b20 + a33 * b30;
        e[7] = a30 * b01 + a31 * b11 + a32 * b21 + a33 * b31;
        e[11] = a30 * b02 + a31 * b12 + a32 * b22 + a33 * b32;
        e[15] = a30 * b03 + a31 * b13 + a32 * b23 + a33 * b33;
        return this;
    }

    @NotNull
    public final Matrix4f multiply(@NotNull Matrix4f m) {
        Intrinsics.checkParameterIsNotNull(m, "m");
        return this.multiplyMatrices(this, m);
    }

    @NotNull
    public final Matrix4f premultiply(@NotNull Matrix4f m) {
        Intrinsics.checkParameterIsNotNull(m, "m");
        return this.multiplyMatrices(m, this);
    }

    @NotNull
    public final Matrix4f multiplyScalar(float s) {
        float[] e = this.elements;
        e[0] = e[0] * s;
        e[4] = e[4] * s;
        e[8] = e[8] * s;
        e[12] = e[12] * s;
        e[1] = e[1] * s;
        e[5] = e[5] * s;
        e[9] = e[9] * s;
        e[13] = e[13] * s;
        e[2] = e[2] * s;
        e[6] = e[6] * s;
        e[10] = e[10] * s;
        e[14] = e[14] * s;
        e[3] = e[3] * s;
        e[7] = e[7] * s;
        e[11] = e[11] * s;
        e[15] = e[15] * s;
        return this;
    }

    @NotNull
    public final Matrix4f extractRotation(@NotNull Matrix4f m) {
        Intrinsics.checkParameterIsNotNull(m, "m");
        float[] e = this.elements;
        float[] me = m.elements;
        float invScaleX = 1.0f / (float)Math.sqrt(me[0] * me[0] + me[1] * me[1] + me[2] * me[2]);
        float invScaleY = 1.0f / (float)Math.sqrt(me[4] * me[4] + me[5] * me[5] + me[6] * me[6]);
        float invScaleZ = 1.0f / (float)Math.sqrt(me[8] * me[8] + me[9] * me[9] + me[10] * me[10]);
        e[0] = me[0] * invScaleX;
        e[1] = me[1] * invScaleX;
        e[2] = me[2] * invScaleX;
        e[3] = 0.0f;
        e[4] = me[4] * invScaleY;
        e[5] = me[5] * invScaleY;
        e[6] = me[6] * invScaleY;
        e[7] = 0.0f;
        e[8] = me[8] * invScaleZ;
        e[9] = me[9] * invScaleZ;
        e[10] = me[10] * invScaleZ;
        e[11] = 0.0f;
        e[12] = 0.0f;
        e[13] = 0.0f;
        e[14] = 0.0f;
        e[15] = 1.0f;
        return this;
    }

    @NotNull
    public final Matrix4f rotationFromEuler(@NotNull Euler euler) {
        Intrinsics.checkParameterIsNotNull(euler, "euler");
        float[] el = this.elements;
        float x = euler.getX();
        float y = euler.getY();
        float z = euler.getZ();
        float a = (float)Math.cos(x);
        float b = (float)Math.sin(x);
        float c = (float)Math.cos(y);
        float d = (float)Math.sin(y);
        float e = (float)Math.cos(z);
        float f = (float)Math.sin(z);
        if (euler.getOrder() == Euler.Companion.getXYZ()) {
            float ae = a * e;
            float af = a * f;
            float be = b * e;
            float bf = b * f;
            el[0] = c * e;
            el[4] = -c * f;
            el[8] = d;
            el[1] = af + be * d;
            el[5] = ae - bf * d;
            el[9] = -b * c;
            el[2] = bf - ae * d;
            el[6] = be + af * d;
            el[10] = a * c;
        } else if (euler.getOrder() == Euler.Companion.getYXZ()) {
            float ce = c * e;
            float cf = c * f;
            float de = d * e;
            float df = d * f;
            el[0] = ce + df * b;
            el[4] = de * b - cf;
            el[8] = a * d;
            el[1] = a * f;
            el[5] = a * e;
            el[9] = -b;
            el[2] = cf * b - de;
            el[6] = df + ce * b;
            el[10] = a * c;
        } else if (euler.getOrder() == Euler.Companion.getZXY()) {
            float ce = c * e;
            float cf = c * f;
            float de = d * e;
            float df = d * f;
            el[0] = ce - df * b;
            el[4] = -a * f;
            el[8] = de + cf * b;
            el[1] = cf + de * b;
            el[5] = a * e;
            el[9] = df - ce * b;
            el[2] = -a * d;
            el[6] = b;
            el[10] = a * c;
        } else if (euler.getOrder() == Euler.Companion.getZYX()) {
            float ae = a * e;
            float af = a * f;
            float be = b * e;
            float bf = b * f;
            el[0] = c * e;
            el[4] = be * d - af;
            el[8] = ae * d + bf;
            el[1] = c * f;
            el[5] = bf * d + ae;
            el[9] = af * d - be;
            el[2] = -d;
            el[6] = b * c;
            el[10] = a * c;
        } else if (euler.getOrder() == Euler.Companion.getYZX()) {
            float ac = a * c;
            float ad = a * d;
            float bc = b * c;
            float bd = b * d;
            el[0] = c * e;
            el[4] = bd - ac * f;
            el[8] = bc * f + ad;
            el[1] = f;
            el[5] = a * e;
            el[9] = -b * e;
            el[2] = -d * e;
            el[6] = ad * f + bc;
            el[10] = ac - bd * f;
        } else if (euler.getOrder() == Euler.Companion.getXZY()) {
            float ac = a * c;
            float ad = a * d;
            float bc = b * c;
            float bd = b * d;
            el[0] = c * e;
            el[4] = -f;
            el[8] = d * e;
            el[1] = ac * f + bd;
            el[5] = a * e;
            el[9] = ad * f - bc;
            el[2] = bc * f - ad;
            el[6] = b * e;
            el[10] = bd * f + ac;
        }
        el[3] = 0.0f;
        el[7] = 0.0f;
        el[11] = 0.0f;
        el[12] = 0.0f;
        el[13] = 0.0f;
        el[14] = 0.0f;
        el[15] = 1.0f;
        return this;
    }

    @NotNull
    public final Matrix4f makeRotationFromQuaternion(@NotNull Quaternion q) {
        Intrinsics.checkParameterIsNotNull(q, "q");
        return this.compose(Vector3f.Companion.getZERO(), q);
    }

    @NotNull
    public final Matrix4f lookAt(@NotNull Vector3f eye, @NotNull Vector3f target, @NotNull Vector3f up) {
        Intrinsics.checkParameterIsNotNull(eye, "eye");
        Intrinsics.checkParameterIsNotNull(target, "target");
        Intrinsics.checkParameterIsNotNull(up, "up");
        Vector3f vx = Vector3f.Companion.zero();
        Vector3f vy = Vector3f.Companion.zero();
        Vector3f vz = Vector3f.Companion.zero();
        float[] e = this.elements;
        vz.subVectors(eye, target);
        double EPSILON = 1.0E-8;
        if (Math.abs(vz.lengthSquared()) < EPSILON) {
            vz.setZ(1.0f);
        }
        vz.normalize();
        vx.crossVectors(up, vz);
        if (Math.abs(vx.lengthSquared()) < EPSILON) {
            if (Math.abs((double)(up.getZ() - 1.0f)) < EPSILON) {
                Vector3f vector3f = vz;
                vector3f.setX(vector3f.getX() + 1.0E-6f);
            } else {
                Vector3f vector3f = vz;
                vector3f.setZ(vector3f.getZ() + 1.0E-6f);
            }
            vz.normalize();
            vx.crossVectors(up, vz);
        }
        vx.normalize();
        vy.crossVectors(vz, vx);
        e[0] = vx.getX();
        e[4] = vy.getX();
        e[8] = vz.getX();
        e[1] = vx.getY();
        e[5] = vy.getY();
        e[9] = vz.getY();
        e[2] = vx.getZ();
        e[6] = vy.getZ();
        e[10] = vz.getZ();
        return this;
    }

    @NotNull
    public final Vector3f getTranslation() {
        return new Vector3f(this.elements[12], this.elements[13], this.elements[14]);
    }

    @NotNull
    public final Matrix4f setPosition(@NotNull Vector3f v) {
        Intrinsics.checkParameterIsNotNull(v, "v");
        this.elements[12] = v.getX();
        this.elements[13] = v.getY();
        this.elements[14] = v.getZ();
        return this;
    }

    @NotNull
    public final Matrix4f setTranslation(float x, float y, float z) {
        this.elements[12] = x;
        this.elements[13] = y;
        this.elements[14] = z;
        return this;
    }

    @NotNull
    public final Matrix4f scale(@NotNull Vector3f v) {
        Intrinsics.checkParameterIsNotNull(v, "v");
        float[] e = this.elements;
        float x = v.getX();
        float y = v.getY();
        float z = v.getZ();
        e[0] = e[0] * x;
        e[4] = e[4] * y;
        e[8] = e[8] * z;
        e[1] = e[1] * x;
        e[5] = e[5] * y;
        e[9] = e[9] * z;
        e[2] = e[2] * x;
        e[6] = e[6] * y;
        e[10] = e[10] * z;
        e[3] = e[3] * x;
        e[7] = e[7] * y;
        e[11] = e[11] * z;
        return this;
    }

    public final double getMaxScaleOnAxis() {
        float[] e = this.elements;
        double scaleXSq = e[0] * e[0] + e[1] * e[1] + e[2] * e[2];
        double scaleYSq = e[4] * e[4] + e[5] * e[5] + e[6] * e[6];
        double scaleZSq = e[8] * e[8] + e[9] * e[9] + e[10] * e[10];
        return Math.sqrt(Math.max(scaleXSq, Math.max(scaleYSq, scaleZSq)));
    }

    @NotNull
    public final Matrix4f makeTranslation(double x, double y, double z) {
        return this.set(1.0f, 0.0f, 0.0f, (float)x, 0.0f, 1.0f, 0.0f, (float)y, 0.0f, 0.0f, 1.0f, (float)z, 0.0f, 0.0f, 0.0f, 1.0f);
    }

    @NotNull
    public final Matrix4f makeRotationX(double theta) {
        float c = (float)Math.cos(theta);
        float s = (float)Math.sin(theta);
        return this.set(1.0f, 0.0f, 0.0f, 0.0f, 0.0f, c, -s, 0.0f, 0.0f, s, c, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f);
    }

    @NotNull
    public final Matrix4f makeRotationY(double theta) {
        float c = (float)Math.cos(theta);
        float s = (float)Math.sin(theta);
        return this.set(c, 0.0f, s, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, -s, 0.0f, c, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f);
    }

    @NotNull
    public final Matrix4f makeRotationZ(double theta) {
        float c = (float)Math.cos(theta);
        float s = (float)Math.sin(theta);
        return this.set(c, -s, 0.0f, 0.0f, s, c, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f);
    }

    @NotNull
    public final Matrix4f makeRotationAxis(@NotNull Vector3f axis, double angle) {
        Intrinsics.checkParameterIsNotNull(axis, "axis");
        float c = (float)Math.cos(angle);
        float s = (float)Math.sin(angle);
        float t = 1.0f - c;
        float x = axis.getX();
        float y = axis.getY();
        float z = axis.getZ();
        float tx = t * x;
        float ty = t * y;
        return this.set(tx * x + c, tx * y - s * z, tx * z + s * y, 0.0f, tx * y + s * z, ty * y + c, ty * z - s * x, 0.0f, tx * z - s * y, ty * z + s * x, t * z * z + c, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f);
    }

    @NotNull
    public final Matrix4f makeScale(double x, double y, double z) {
        float xf = (float)x;
        float yf = (float)y;
        float zf = (float)z;
        return this.set(xf, 0.0f, 0.0f, 0.0f, 0.0f, yf, 0.0f, 0.0f, 0.0f, 0.0f, zf, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f);
    }

    @NotNull
    public final Matrix4f makeShear(double x, double y, double z) {
        float xf = (float)x;
        float yf = (float)y;
        float zf = (float)z;
        return this.set(1.0f, yf, zf, 0.0f, xf, 1.0f, zf, 0.0f, xf, yf, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f);
    }

    @NotNull
    public final Matrix4f compose(@NotNull Vector3f position, @NotNull Quaternion quaternion) {
        Intrinsics.checkParameterIsNotNull(position, "position");
        Intrinsics.checkParameterIsNotNull(quaternion, "quaternion");
        float[] e = this.elements;
        float x = quaternion.getX();
        float y = quaternion.getY();
        float z = quaternion.getZ();
        float w = quaternion.getW();
        float x2 = x + x;
        float y2 = y + y;
        float z2 = z + z;
        float xx = x * x2;
        float xy = x * y2;
        float xz = x * z2;
        float yy = y * y2;
        float yz = y * z2;
        float zz = z * z2;
        float wx = w * x2;
        float wy = w * y2;
        float wz = w * z2;
        e[0] = 1.0f - (yy + zz);
        e[1] = xy + wz;
        e[2] = xz - wy;
        e[3] = 0.0f;
        e[4] = xy - wz;
        e[5] = 1.0f - (xx + zz);
        e[6] = yz + wx;
        e[7] = 0.0f;
        e[8] = xz + wy;
        e[9] = yz - wx;
        e[10] = 1.0f - (xx + yy);
        e[11] = 0.0f;
        e[12] = position.getX();
        e[13] = position.getY();
        e[14] = position.getZ();
        e[15] = 1.0f;
        return this;
    }

    @NotNull
    public final Matrix4f decompose(@NotNull Vector3f position, @NotNull Quaternion quaternion) {
        Intrinsics.checkParameterIsNotNull(position, "position");
        Intrinsics.checkParameterIsNotNull(quaternion, "quaternion");
        float[] e = this.elements;
        position.setX(e[12]);
        position.setY(e[13]);
        position.setZ(e[14]);
        double det = this.det();
        if (det < 0.0) {
            Matrix4f matTemp = this.clone();
            matTemp.elements[0] = -matTemp.elements[0];
            matTemp.elements[1] = -matTemp.elements[1];
            matTemp.elements[2] = -matTemp.elements[2];
            quaternion.setFromRotationMatrix(matTemp);
        } else {
            quaternion.setFromRotationMatrix(this);
        }
        return this;
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0015\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\tJ\u0014\u0010\n\u001a\u00020\u00042\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00060\fJ\u000e\u0010\r\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u000fJ\u0006\u0010\u0010\u001a\u00020\u0004J\u0086\u0001\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u00062\u0006\u0010\u0014\u001a\u00020\u00062\u0006\u0010\u0015\u001a\u00020\u00062\u0006\u0010\u0016\u001a\u00020\u00062\u0006\u0010\u0017\u001a\u00020\u00062\u0006\u0010\u0018\u001a\u00020\u00062\u0006\u0010\u0019\u001a\u00020\u00062\u0006\u0010\u001a\u001a\u00020\u00062\u0006\u0010\u001b\u001a\u00020\u00062\u0006\u0010\u001c\u001a\u00020\u00062\u0006\u0010\u001d\u001a\u00020\u00062\u0006\u0010\u001e\u001a\u00020\u00062\u0006\u0010\u001f\u001a\u00020\u00062\u0006\u0010 \u001a\u00020\u00062\u0006\u0010!\u001a\u00020\u0006J\u0006\u0010\"\u001a\u00020\u0004J\u0006\u0010#\u001a\u00020\u0004\u00a8\u0006$"}, d2={"Lphonon/puppet/math/Matrix4f$Companion;", "", "()V", "fill", "Lphonon/puppet/math/Matrix4f;", "v", "", "fromEuler", "euler", "Lphonon/puppet/math/Euler;", "fromList", "e", "", "fromQuaternion", "q", "Lphonon/puppet/math/Quaternion;", "identity", "of", "a0", "a1", "a2", "a3", "a4", "a5", "a6", "a7", "a8", "a9", "a10", "a11", "a12", "a13", "a14", "a15", "one", "zero", "phonon-puppet"})
    public static final class Companion {
        @NotNull
        public final Matrix4f zero() {
            return new Matrix4f();
        }

        @NotNull
        public final Matrix4f identity() {
            Matrix4f mat4 = new Matrix4f();
            mat4.getElements()[0] = 1.0f;
            mat4.getElements()[5] = 1.0f;
            mat4.getElements()[10] = 1.0f;
            mat4.getElements()[15] = 1.0f;
            return mat4;
        }

        @NotNull
        public final Matrix4f one() {
            Matrix4f mat4 = new Matrix4f();
            mat4.getElements()[0] = 1.0f;
            mat4.getElements()[4] = 1.0f;
            mat4.getElements()[8] = 1.0f;
            mat4.getElements()[12] = 1.0f;
            mat4.getElements()[1] = 1.0f;
            mat4.getElements()[5] = 1.0f;
            mat4.getElements()[9] = 1.0f;
            mat4.getElements()[13] = 1.0f;
            mat4.getElements()[2] = 1.0f;
            mat4.getElements()[6] = 1.0f;
            mat4.getElements()[10] = 1.0f;
            mat4.getElements()[14] = 1.0f;
            mat4.getElements()[3] = 1.0f;
            mat4.getElements()[7] = 1.0f;
            mat4.getElements()[11] = 1.0f;
            mat4.getElements()[15] = 1.0f;
            return mat4;
        }

        @NotNull
        public final Matrix4f fill(float v) {
            Matrix4f mat4 = new Matrix4f();
            mat4.getElements()[0] = v;
            mat4.getElements()[4] = v;
            mat4.getElements()[8] = v;
            mat4.getElements()[12] = v;
            mat4.getElements()[1] = v;
            mat4.getElements()[5] = v;
            mat4.getElements()[9] = v;
            mat4.getElements()[13] = v;
            mat4.getElements()[2] = v;
            mat4.getElements()[6] = v;
            mat4.getElements()[10] = v;
            mat4.getElements()[14] = v;
            mat4.getElements()[3] = v;
            mat4.getElements()[7] = v;
            mat4.getElements()[11] = v;
            mat4.getElements()[15] = v;
            return mat4;
        }

        @NotNull
        public final Matrix4f of(float a0, float a1, float a2, float a3, float a4, float a5, float a6, float a7, float a8, float a9, float a10, float a11, float a12, float a13, float a14, float a15) {
            Matrix4f mat4 = new Matrix4f();
            mat4.getElements()[0] = a0;
            mat4.getElements()[4] = a1;
            mat4.getElements()[8] = a2;
            mat4.getElements()[12] = a3;
            mat4.getElements()[1] = a4;
            mat4.getElements()[5] = a5;
            mat4.getElements()[9] = a6;
            mat4.getElements()[13] = a7;
            mat4.getElements()[2] = a8;
            mat4.getElements()[6] = a9;
            mat4.getElements()[10] = a10;
            mat4.getElements()[14] = a11;
            mat4.getElements()[3] = a12;
            mat4.getElements()[7] = a13;
            mat4.getElements()[11] = a14;
            mat4.getElements()[15] = a15;
            return mat4;
        }

        @NotNull
        public final Matrix4f fromList(@NotNull List<Float> e) {
            Intrinsics.checkParameterIsNotNull(e, "e");
            return Companion.of(((Number)e.get(0)).floatValue(), ((Number)e.get(1)).floatValue(), ((Number)e.get(2)).floatValue(), ((Number)e.get(3)).floatValue(), ((Number)e.get(4)).floatValue(), ((Number)e.get(5)).floatValue(), ((Number)e.get(6)).floatValue(), ((Number)e.get(7)).floatValue(), ((Number)e.get(8)).floatValue(), ((Number)e.get(9)).floatValue(), ((Number)e.get(10)).floatValue(), ((Number)e.get(11)).floatValue(), ((Number)e.get(12)).floatValue(), ((Number)e.get(13)).floatValue(), ((Number)e.get(14)).floatValue(), ((Number)e.get(15)).floatValue());
        }

        @NotNull
        public final Matrix4f fromEuler(@NotNull Euler euler) {
            Intrinsics.checkParameterIsNotNull(euler, "euler");
            Matrix4f mat4 = Companion.zero();
            return mat4.rotationFromEuler(euler);
        }

        @NotNull
        public final Matrix4f fromQuaternion(@NotNull Quaternion q) {
            Intrinsics.checkParameterIsNotNull(q, "q");
            Matrix4f mat4 = Companion.zero();
            return mat4.makeRotationFromQuaternion(q);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

