/*
 * Decompiled with CFR 0.152.
 */
package phonon.puppet.math;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import phonon.puppet.math.Euler$WhenMappings;
import phonon.puppet.math.EulerKt;
import phonon.puppet.math.EulerOrder;
import phonon.puppet.math.Matrix4f;
import phonon.puppet.math.Quaternion;
import phonon.puppet.math.Vector3f;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0015\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0014\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u0006\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0086\b\u0018\u0000 92\u00020\u0001:\u00019B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0006\u0010\u0015\u001a\u00020\u0000J\t\u0010\u0016\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0017\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0018\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0019\u001a\u00020\u0007H\u00c6\u0003J1\u0010\u001a\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u000e\u0010\u001a\u001a\u00020\u00002\u0006\u0010\u001b\u001a\u00020\u0000J\u0013\u0010\u001c\u001a\u00020\u001d2\b\u0010\u001b\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\u0016\u0010\u001e\u001a\u00020\u00002\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"J\u0011\u0010#\u001a\u00020\u00032\u0006\u0010$\u001a\u00020\"H\u0086\u0002J\t\u0010%\u001a\u00020\"H\u00d6\u0001J\u000e\u0010&\u001a\u00020\u00002\u0006\u0010'\u001a\u00020\u0007J&\u0010(\u001a\u00020\u00002\u0006\u0010\u0002\u001a\u00020)2\u0006\u0010\u0004\u001a\u00020)2\u0006\u0010\u0005\u001a\u00020)2\u0006\u0010\u0006\u001a\u00020\u0007J&\u0010(\u001a\u00020\u00002\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u0007J\u0019\u0010(\u001a\u00020*2\u0006\u0010$\u001a\u00020\"2\u0006\u0010+\u001a\u00020\u0003H\u0086\u0002J\u0016\u0010,\u001a\u00020\u00002\u0006\u0010-\u001a\u00020.2\u0006\u0010\u0006\u001a\u00020\u0007J\u0016\u0010/\u001a\u00020\u00002\u0006\u00100\u001a\u0002012\u0006\u0010\u0006\u001a\u00020\u0007J\u0016\u00102\u001a\u00020\u00002\u0006\u0010+\u001a\u0002032\u0006\u0010\u0006\u001a\u00020\u0007J\u0006\u00104\u001a\u00020 J\u0016\u00104\u001a\u00020 2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"J\t\u00105\u001a\u000206H\u00d6\u0001J\u0006\u00107\u001a\u000203J\u000e\u00107\u001a\u0002032\u0006\u00108\u001a\u000203R\u001a\u0010\u0006\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0004\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u000e\"\u0004\b\u0012\u0010\u0010R\u001a\u0010\u0005\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u000e\"\u0004\b\u0014\u0010\u0010\u00a8\u0006:"}, d2={"Lphonon/puppet/math/Euler;", "", "x", "", "y", "z", "order", "Lphonon/puppet/math/EulerOrder;", "(FFFLphonon/puppet/math/EulerOrder;)V", "getOrder", "()Lphonon/puppet/math/EulerOrder;", "setOrder", "(Lphonon/puppet/math/EulerOrder;)V", "getX", "()F", "setX", "(F)V", "getY", "setY", "getZ", "setZ", "clone", "component1", "component2", "component3", "component4", "copy", "other", "equals", "", "fromFloatArray", "array", "", "offset", "", "get", "i", "hashCode", "reorder", "newOrder", "set", "", "", "v", "setFromQuaternion", "q", "Lphonon/puppet/math/Quaternion;", "setFromRotationMatrix", "mat4", "Lphonon/puppet/math/Matrix4f;", "setFromVector3", "Lphonon/puppet/math/Vector3f;", "toFloatArray", "toString", "", "toVector3", "target", "Companion", "phonon-puppet"})
public final class Euler {
    private float x;
    private float y;
    private float z;
    @NotNull
    private EulerOrder order;
    @NotNull
    private static final EulerOrder XYZ;
    @NotNull
    private static final EulerOrder YZX;
    @NotNull
    private static final EulerOrder ZXY;
    @NotNull
    private static final EulerOrder XZY;
    @NotNull
    private static final EulerOrder YXZ;
    @NotNull
    private static final EulerOrder ZYX;
    public static final Companion Companion;

    public final float get(int i) {
        switch (i) {
            case 0: {
                return this.x;
            }
            case 1: {
                return this.y;
            }
            case 2: {
                return this.z;
            }
        }
        throw (Throwable)new ArrayIndexOutOfBoundsException(i);
    }

    public final void set(int i, float v) {
        switch (i) {
            case 0: {
                this.x = v;
                break;
            }
            case 1: {
                this.y = v;
                break;
            }
            case 2: {
                this.z = v;
                break;
            }
            default: {
                throw (Throwable)new ArrayIndexOutOfBoundsException(i);
            }
        }
    }

    @NotNull
    public final Euler clone() {
        return new Euler(this.x, this.y, this.z, this.order);
    }

    @NotNull
    public final Euler copy(@NotNull Euler other) {
        Intrinsics.checkParameterIsNotNull(other, "other");
        this.x = other.x;
        this.y = other.y;
        this.z = other.z;
        return this;
    }

    @NotNull
    public final Euler set(float x, float y, float z, @NotNull EulerOrder order) {
        Intrinsics.checkParameterIsNotNull((Object)order, "order");
        this.x = x;
        this.y = y;
        this.z = z;
        this.order = order;
        return this;
    }

    @NotNull
    public final Euler set(double x, double y, double z, @NotNull EulerOrder order) {
        Intrinsics.checkParameterIsNotNull((Object)order, "order");
        this.x = (float)x;
        this.y = (float)y;
        this.z = (float)z;
        this.order = order;
        return this;
    }

    @NotNull
    public final Euler setFromRotationMatrix(@NotNull Matrix4f mat4, @NotNull EulerOrder order) {
        Intrinsics.checkParameterIsNotNull(mat4, "mat4");
        Intrinsics.checkParameterIsNotNull((Object)order, "order");
        float[] e = mat4.getElements();
        double e00 = e[0];
        double e01 = e[4];
        double e02 = e[8];
        double e10 = e[1];
        double e11 = e[5];
        double e12 = e[9];
        double e20 = e[2];
        double e21 = e[6];
        double e22 = e[10];
        switch (Euler$WhenMappings.$EnumSwitchMapping$0[order.ordinal()]) {
            case 1: {
                this.y = (float)Math.asin(EulerKt.access$clamp(e02, -1.0, 1.0));
                if (Math.abs(e02) < 0.9999999) {
                    this.x = (float)Math.atan2(-e12, e22);
                    this.z = (float)Math.atan2(-e01, e00);
                    break;
                }
                this.x = (float)Math.atan2(e21, e11);
                this.z = 0.0f;
                break;
            }
            case 2: {
                this.x = (float)Math.asin(-EulerKt.access$clamp(e12, -1.0, 1.0));
                if (Math.abs(e12) < 0.9999999) {
                    this.y = (float)Math.atan2(e02, e22);
                    this.z = (float)Math.atan2(e10, e11);
                    break;
                }
                this.y = (float)Math.atan2(-e20, e00);
                this.z = 0.0f;
                break;
            }
            case 3: {
                this.x = (float)Math.asin(EulerKt.access$clamp(e21, -1.0, 1.0));
                if (Math.abs(e21) < 0.9999999) {
                    this.y = (float)Math.atan2(-e20, e22);
                    this.z = (float)Math.atan2(-e01, e11);
                    break;
                }
                this.y = 0.0f;
                this.z = (float)Math.atan2(e10, e00);
                break;
            }
            case 4: {
                this.y = (float)Math.asin(-EulerKt.access$clamp(e20, -1.0, 1.0));
                if (Math.abs(e20) < 0.9999999) {
                    this.x = (float)Math.atan2(e21, e22);
                    this.z = (float)Math.atan2(e10, e00);
                    break;
                }
                this.x = 0.0f;
                this.z = (float)Math.atan2(-e01, e11);
                break;
            }
            case 5: {
                this.z = (float)Math.asin(EulerKt.access$clamp(e10, -1.0, 1.0));
                if (Math.abs(e10) < 0.9999999) {
                    this.x = (float)Math.atan2(-e12, e11);
                    this.y = (float)Math.atan2(-e20, e00);
                    break;
                }
                this.x = 0.0f;
                this.y = (float)Math.atan2(e02, e22);
                break;
            }
            case 6: {
                this.z = (float)Math.asin(-EulerKt.access$clamp(e01, -1.0, 1.0));
                if (Math.abs(e01) < 0.9999999) {
                    this.x = (float)Math.atan2(e21, e11);
                    this.y = (float)Math.atan2(e02, e00);
                    break;
                }
                this.x = (float)Math.atan2(-e12, e22);
                this.y = 0.0f;
            }
        }
        this.order = order;
        return this;
    }

    @NotNull
    public final Euler setFromQuaternion(@NotNull Quaternion q, @NotNull EulerOrder order) {
        Intrinsics.checkParameterIsNotNull(q, "q");
        Intrinsics.checkParameterIsNotNull((Object)order, "order");
        float x = q.getX();
        float y = q.getY();
        float z = q.getZ();
        float w = q.getW();
        float x2 = x + x;
        float y2 = y + y;
        float z2 = z + z;
        float xx = x * x2;
        float xy = x * y2;
        float xz = x * z2;
        float yy = y * y2;
        float yz = y * z2;
        float zz = z * z2;
        float wx = w * x2;
        float wy = w * y2;
        float wz = w * z2;
        double e00 = 1.0f - (yy + zz);
        double e10 = xy + wz;
        double e20 = xz - wy;
        double e01 = xy - wz;
        double e11 = 1.0f - (xx + zz);
        double e21 = yz + wx;
        double e02 = xz + wy;
        double e12 = yz - wx;
        double e22 = 1.0f - (xx + yy);
        switch (Euler$WhenMappings.$EnumSwitchMapping$1[order.ordinal()]) {
            case 1: {
                this.y = (float)Math.asin(EulerKt.access$clamp(e02, -1.0, 1.0));
                if (Math.abs(e02) < 0.9999999) {
                    this.x = (float)Math.atan2(-e12, e22);
                    this.z = (float)Math.atan2(-e01, e00);
                    break;
                }
                this.x = (float)Math.atan2(e21, e11);
                this.z = 0.0f;
                break;
            }
            case 2: {
                this.x = (float)Math.asin(-EulerKt.access$clamp(e12, -1.0, 1.0));
                if (Math.abs(e12) < 0.9999999) {
                    this.y = (float)Math.atan2(e02, e22);
                    this.z = (float)Math.atan2(e10, e11);
                    break;
                }
                this.y = (float)Math.atan2(-e20, e00);
                this.z = 0.0f;
                break;
            }
            case 3: {
                this.x = (float)Math.asin(EulerKt.access$clamp(e21, -1.0, 1.0));
                if (Math.abs(e21) < 0.9999999) {
                    this.y = (float)Math.atan2(-e20, e22);
                    this.z = (float)Math.atan2(-e01, e11);
                    break;
                }
                this.y = 0.0f;
                this.z = (float)Math.atan2(e10, e00);
                break;
            }
            case 4: {
                this.y = (float)Math.asin(-EulerKt.access$clamp(e20, -1.0, 1.0));
                if (Math.abs(e20) < 0.9999999) {
                    this.x = (float)Math.atan2(e21, e22);
                    this.z = (float)Math.atan2(e10, e00);
                    break;
                }
                this.x = 0.0f;
                this.z = (float)Math.atan2(-e01, e11);
                break;
            }
            case 5: {
                this.z = (float)Math.asin(EulerKt.access$clamp(e10, -1.0, 1.0));
                if (Math.abs(e10) < 0.9999999) {
                    this.x = (float)Math.atan2(-e12, e11);
                    this.y = (float)Math.atan2(-e20, e00);
                    break;
                }
                this.x = 0.0f;
                this.y = (float)Math.atan2(e02, e22);
                break;
            }
            case 6: {
                this.z = (float)Math.asin(-EulerKt.access$clamp(e01, -1.0, 1.0));
                if (Math.abs(e01) < 0.9999999) {
                    this.x = (float)Math.atan2(e21, e11);
                    this.y = (float)Math.atan2(e02, e00);
                    break;
                }
                this.x = (float)Math.atan2(-e12, e22);
                this.y = 0.0f;
            }
        }
        this.order = order;
        return this;
    }

    @NotNull
    public final Euler setFromVector3(@NotNull Vector3f v, @NotNull EulerOrder order) {
        Intrinsics.checkParameterIsNotNull(v, "v");
        Intrinsics.checkParameterIsNotNull((Object)order, "order");
        this.x = v.getX();
        this.y = v.getY();
        this.z = v.getZ();
        this.order = order;
        return this;
    }

    @NotNull
    public final Euler reorder(@NotNull EulerOrder newOrder) {
        Intrinsics.checkParameterIsNotNull((Object)newOrder, "newOrder");
        Quaternion q = Quaternion.Companion.fromEuler(this);
        return this.setFromQuaternion(q, newOrder);
    }

    @NotNull
    public final Euler fromFloatArray(@NotNull float[] array, int offset) {
        Intrinsics.checkParameterIsNotNull(array, "array");
        this.x = array[offset];
        this.y = array[offset + 1];
        this.z = array[offset + 2];
        return this;
    }

    @NotNull
    public final float[] toFloatArray() {
        float[] array = new float[]{this.x, this.y, this.z};
        return array;
    }

    @NotNull
    public final float[] toFloatArray(@NotNull float[] array, int offset) {
        Intrinsics.checkParameterIsNotNull(array, "array");
        array[offset] = this.x;
        array[offset + 1] = this.y;
        array[offset + 2] = this.z;
        return array;
    }

    @NotNull
    public final Vector3f toVector3() {
        return new Vector3f(this.x, this.y, this.z);
    }

    @NotNull
    public final Vector3f toVector3(@NotNull Vector3f target) {
        Intrinsics.checkParameterIsNotNull(target, "target");
        return target.set(this.x, this.y, this.z);
    }

    public final float getX() {
        return this.x;
    }

    public final void setX(float f) {
        this.x = f;
    }

    public final float getY() {
        return this.y;
    }

    public final void setY(float f) {
        this.y = f;
    }

    public final float getZ() {
        return this.z;
    }

    public final void setZ(float f) {
        this.z = f;
    }

    @NotNull
    public final EulerOrder getOrder() {
        return this.order;
    }

    public final void setOrder(@NotNull EulerOrder eulerOrder) {
        Intrinsics.checkParameterIsNotNull((Object)eulerOrder, "<set-?>");
        this.order = eulerOrder;
    }

    public Euler(float x, float y, float z, @NotNull EulerOrder order) {
        Intrinsics.checkParameterIsNotNull((Object)order, "order");
        this.x = x;
        this.y = y;
        this.z = z;
        this.order = order;
    }

    static {
        Companion = new Companion(null);
        XYZ = EulerOrder.XYZ;
        YZX = EulerOrder.YZX;
        ZXY = EulerOrder.ZXY;
        XZY = EulerOrder.XZY;
        YXZ = EulerOrder.YXZ;
        ZYX = EulerOrder.ZYX;
    }

    public final float component1() {
        return this.x;
    }

    public final float component2() {
        return this.y;
    }

    public final float component3() {
        return this.z;
    }

    @NotNull
    public final EulerOrder component4() {
        return this.order;
    }

    @NotNull
    public final Euler copy(float x, float y, float z, @NotNull EulerOrder order) {
        Intrinsics.checkParameterIsNotNull((Object)order, "order");
        return new Euler(x, y, z, order);
    }

    public static /* synthetic */ Euler copy$default(Euler euler, float f, float f2, float f3, EulerOrder eulerOrder, int n, Object object) {
        if ((n & 1) != 0) {
            f = euler.x;
        }
        if ((n & 2) != 0) {
            f2 = euler.y;
        }
        if ((n & 4) != 0) {
            f3 = euler.z;
        }
        if ((n & 8) != 0) {
            eulerOrder = euler.order;
        }
        return euler.copy(f, f2, f3, eulerOrder);
    }

    @NotNull
    public String toString() {
        return "Euler(x=" + this.x + ", y=" + this.y + ", z=" + this.z + ", order=" + (Object)((Object)this.order) + ")";
    }

    public int hashCode() {
        EulerOrder eulerOrder = this.order;
        return ((Float.hashCode(this.x) * 31 + Float.hashCode(this.y)) * 31 + Float.hashCode(this.z)) * 31 + (eulerOrder != null ? ((Object)((Object)eulerOrder)).hashCode() : 0);
    }

    public boolean equals(@Nullable Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof Euler)) break block3;
                Euler euler = (Euler)object;
                if (Float.compare(this.x, euler.x) != 0 || Float.compare(this.y, euler.y) != 0 || Float.compare(this.z, euler.z) != 0 || !Intrinsics.areEqual((Object)this.order, (Object)euler.order)) break block3;
            }
            return true;
        }
        return false;
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0004J\u0016\u0010\u0016\u001a\u00020\u00122\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0015\u001a\u00020\u0004J\u0006\u0010\u0019\u001a\u00020\u0012R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u0011\u0010\t\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0006R\u0011\u0010\u000b\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u0006R\u0011\u0010\r\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u0006R\u0011\u0010\u000f\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0006\u00a8\u0006\u001a"}, d2={"Lphonon/puppet/math/Euler$Companion;", "", "()V", "XYZ", "Lphonon/puppet/math/EulerOrder;", "getXYZ", "()Lphonon/puppet/math/EulerOrder;", "XZY", "getXZY", "YXZ", "getYXZ", "YZX", "getYZX", "ZXY", "getZXY", "ZYX", "getZYX", "fromQuaternion", "Lphonon/puppet/math/Euler;", "q", "Lphonon/puppet/math/Quaternion;", "order", "fromRotationMatrix", "mat4", "Lphonon/puppet/math/Matrix4f;", "zero", "phonon-puppet"})
    public static final class Companion {
        @NotNull
        public final EulerOrder getXYZ() {
            return XYZ;
        }

        @NotNull
        public final EulerOrder getYZX() {
            return YZX;
        }

        @NotNull
        public final EulerOrder getZXY() {
            return ZXY;
        }

        @NotNull
        public final EulerOrder getXZY() {
            return XZY;
        }

        @NotNull
        public final EulerOrder getYXZ() {
            return YXZ;
        }

        @NotNull
        public final EulerOrder getZYX() {
            return ZYX;
        }

        @NotNull
        public final Euler zero() {
            return new Euler(0.0f, 0.0f, 0.0f, EulerOrder.ZYX);
        }

        @NotNull
        public final Euler fromQuaternion(@NotNull Quaternion q, @NotNull EulerOrder order) {
            Intrinsics.checkParameterIsNotNull(q, "q");
            Intrinsics.checkParameterIsNotNull((Object)order, "order");
            Euler euler = new Euler(0.0f, 0.0f, 0.0f, order);
            return euler.setFromQuaternion(q, order);
        }

        @NotNull
        public final Euler fromRotationMatrix(@NotNull Matrix4f mat4, @NotNull EulerOrder order) {
            Intrinsics.checkParameterIsNotNull(mat4, "mat4");
            Intrinsics.checkParameterIsNotNull((Object)order, "order");
            Euler euler = new Euler(0.0f, 0.0f, 0.0f, order);
            return euler.setFromRotationMatrix(mat4, order);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

