/*
 * Decompiled with CFR 0.152.
 */
package phonon.puppet.commands;

import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import phonon.puppet.Message;
import phonon.puppet.Puppet;
import phonon.puppet.PuppetPlugin;
import phonon.puppet.animation.AnimationTrack;
import phonon.puppet.commands.PuppetCommandKt;
import phonon.puppet.objects.Mesh;
import phonon.puppet.objects.Skeleton;
import phonon.puppet.utils.FilterKt;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0007\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J#\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0002\u00a2\u0006\u0002\u0010\u000bJ#\u0010\f\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0002\u00a2\u0006\u0002\u0010\u000bJ3\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\n2\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0016\u00a2\u0006\u0002\u0010\u0012J9\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\n0\u00142\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\n2\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0016\u00a2\u0006\u0002\u0010\u0017J\u0010\u0010\u0018\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0010\u0010\u0019\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0010\u0010\u001a\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a8\u0006\u001b"}, d2={"Lphonon/puppet/commands/PuppetCommand;", "Lorg/bukkit/command/CommandExecutor;", "Lorg/bukkit/command/TabCompleter;", "()V", "killAllActors", "", "sender", "Lorg/bukkit/command/CommandSender;", "args", "", "", "(Lorg/bukkit/command/CommandSender;[Ljava/lang/String;)V", "manageEngine", "onCommand", "", "cmd", "Lorg/bukkit/command/Command;", "commandLabel", "(Lorg/bukkit/command/CommandSender;Lorg/bukkit/command/Command;Ljava/lang/String;[Ljava/lang/String;)Z", "onTabComplete", "", "command", "alias", "(Lorg/bukkit/command/CommandSender;Lorg/bukkit/command/Command;Ljava/lang/String;[Ljava/lang/String;)Ljava/util/List;", "printHelp", "printInfo", "reload", "phonon-puppet"})
public final class PuppetCommand
implements CommandExecutor,
TabCompleter {
    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command cmd, @NotNull String commandLabel, @NotNull String[] args2) {
        Player player;
        Intrinsics.checkParameterIsNotNull(sender, "sender");
        Intrinsics.checkParameterIsNotNull(cmd, "cmd");
        Intrinsics.checkParameterIsNotNull(commandLabel, "commandLabel");
        Intrinsics.checkParameterIsNotNull(args2, "args");
        Player player2 = player = sender instanceof Player ? (Player)sender : null;
        if (args2.length == 0) {
            this.printInfo(sender);
            return true;
        }
        String string = args2[0];
        boolean bl = false;
        String string2 = string;
        if (string2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string3 = string2.toLowerCase();
        Intrinsics.checkExpressionValueIsNotNull(string3, "(this as java.lang.String).toLowerCase()");
        switch (string3) {
            case "help": {
                this.printHelp(sender);
                break;
            }
            case "reload": {
                this.reload(sender);
                break;
            }
            case "engine": {
                this.manageEngine(sender, args2);
                break;
            }
            case "killall": {
                this.killAllActors(sender, args2);
                break;
            }
            default: {
                Message.INSTANCE.error(sender, "Invalid command, use \"/puppet help\"");
            }
        }
        return true;
    }

    @NotNull
    public List<String> onTabComplete(@NotNull CommandSender sender, @NotNull Command command, @NotNull String alias, @NotNull String[] args2) {
        Intrinsics.checkParameterIsNotNull(sender, "sender");
        Intrinsics.checkParameterIsNotNull(command, "command");
        Intrinsics.checkParameterIsNotNull(alias, "alias");
        Intrinsics.checkParameterIsNotNull(args2, "args");
        if (args2.length == 1) {
            return FilterKt.filterByStart(PuppetCommandKt.access$getSUBCOMMANDS$p(), args2[0]);
        }
        if (args2.length > 1) {
            String string = args2[0];
            boolean bl = false;
            String string2 = string;
            if (string2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string3 = string2.toLowerCase();
            Intrinsics.checkExpressionValueIsNotNull(string3, "(this as java.lang.String).toLowerCase()");
            string = string3;
            switch (string.hashCode()) {
                case -1298662846: {
                    if (!string.equals("engine") || args2.length != 2) break;
                    return FilterKt.filterByStart(PuppetCommandKt.access$getENGINE_SUBCOMMANDS$p(), args2[1]);
                }
            }
        }
        boolean bl = false;
        return CollectionsKt.emptyList();
    }

    private final void printInfo(CommandSender sender) {
        Puppet.INSTANCE.printInfo(sender);
        Message.INSTANCE.print(sender, "Type \"/puppet help\" to see list of engine commands.");
    }

    private final void printHelp(CommandSender sender) {
        Message.INSTANCE.print(sender, "[Puppet] Engine Commands:");
        Message.INSTANCE.print(sender, "/puppet reload" + ChatColor.WHITE + ": Reload libraries and re-create resourcepack");
        Message.INSTANCE.print(sender, "/puppet engine" + ChatColor.WHITE + ": Start/stop/step rendering engine");
        Message.INSTANCE.print(sender, "/puppet killall" + ChatColor.WHITE + ": Kill all actors");
    }

    private final void reload(CommandSender sender) {
        Message.INSTANCE.print(sender, "[Puppet] Reloading resources and creating resource pack...");
        PuppetPlugin puppetPlugin = Puppet.INSTANCE.getPlugin$phonon_puppet();
        if (puppetPlugin != null) {
            puppetPlugin.loadConfig();
        }
        Puppet.loadResources$default(Puppet.INSTANCE, false, 1, null);
        Message.INSTANCE.print(sender, "- Models: " + Mesh.Companion.getLibrary().size());
        Message.INSTANCE.print(sender, "- Skeletons: " + Skeleton.Companion.getLibrary().size());
        Message.INSTANCE.print(sender, "- Animations: " + AnimationTrack.Companion.getLibrary().size());
    }

    private final void manageEngine(CommandSender sender, String[] args2) {
        if (args2.length < 2) {
            String engineStatus = Puppet.INSTANCE.isRunning() ? ChatColor.GREEN + "running" : ChatColor.GRAY + "stopped";
            Message.INSTANCE.print(sender, "Engine status: " + engineStatus);
            Message.INSTANCE.print(sender, "Usage: /puppet engine [start|stop|step]");
            return;
        }
        String string = args2[1];
        boolean bl = false;
        String string2 = string;
        if (string2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string3 = string2.toLowerCase();
        Intrinsics.checkExpressionValueIsNotNull(string3, "(this as java.lang.String).toLowerCase()");
        switch (string3) {
            case "start": {
                Puppet.INSTANCE.startEngine();
                Message.INSTANCE.print(sender, ChatColor.BOLD + "Starting Puppet render engine");
                break;
            }
            case "stop": {
                Puppet.INSTANCE.stopEngine();
                Message.INSTANCE.print(sender, ChatColor.BOLD + "Stopping Puppet render engine");
                break;
            }
            case "step": {
                Puppet.INSTANCE.stepEngine();
                Message.INSTANCE.print(sender, ChatColor.BOLD + "Step Puppet render engine");
            }
        }
    }

    private final void killAllActors(CommandSender sender, String[] args2) {
        Puppet.INSTANCE.destroyAllActors();
        Message.INSTANCE.print(sender, "Destroyed all actors");
    }
}

