/*
 * Decompiled with CFR 0.152.
 */
package phonon.puppet.commands;

import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import phonon.puppet.Message;
import phonon.puppet.Puppet;
import phonon.puppet.animation.AnimationTrack;
import phonon.puppet.animation.TransformTrack;
import phonon.puppet.commands.ActorCommand;
import phonon.puppet.commands.ActorCommandKt;
import phonon.puppet.math.Euler;
import phonon.puppet.math.Vector3f;
import phonon.puppet.objects.Actor;
import phonon.puppet.objects.Bone;
import phonon.puppet.objects.Mesh;
import phonon.puppet.objects.Skeleton;
import phonon.puppet.objects.Transform;
import phonon.puppet.utils.FilterKt;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0016\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J#\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0002\u00a2\u0006\u0002\u0010\u000bJ#\u0010\f\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0002\u00a2\u0006\u0002\u0010\u000bJ#\u0010\r\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0002\u00a2\u0006\u0002\u0010\u000bJ#\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0002\u00a2\u0006\u0002\u0010\u000bJ#\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0002\u00a2\u0006\u0002\u0010\u000bJ#\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0002\u00a2\u0006\u0002\u0010\u000bJ#\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0002\u00a2\u0006\u0002\u0010\u000bJ#\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0002\u00a2\u0006\u0002\u0010\u000bJ#\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0002\u00a2\u0006\u0002\u0010\u000bJ#\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0002\u00a2\u0006\u0002\u0010\u000bJ3\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\n2\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0016\u00a2\u0006\u0002\u0010\u001aJ9\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\n0\u001c2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u001d\u001a\u00020\u00182\u0006\u0010\u001e\u001a\u00020\n2\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0016\u00a2\u0006\u0002\u0010\u001fJ#\u0010 \u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0002\u00a2\u0006\u0002\u0010\u000bJ#\u0010!\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0002\u00a2\u0006\u0002\u0010\u000bJ#\u0010\"\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0002\u00a2\u0006\u0002\u0010\u000bJ#\u0010#\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0002\u00a2\u0006\u0002\u0010\u000bJ\u0010\u0010$\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0010\u0010%\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0010\u0010&\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J#\u0010'\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0002\u00a2\u0006\u0002\u0010\u000bJ#\u0010(\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0002\u00a2\u0006\u0002\u0010\u000bJ#\u0010)\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0002\u00a2\u0006\u0002\u0010\u000bJ!\u0010*\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\u0002\u0010\u000bJ#\u0010+\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0002\u00a2\u0006\u0002\u0010\u000bJ#\u0010,\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0002\u00a2\u0006\u0002\u0010\u000bJ#\u0010-\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0002\u00a2\u0006\u0002\u0010\u000bJ#\u0010.\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0002\u00a2\u0006\u0002\u0010\u000bJ#\u0010/\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0002\u00a2\u0006\u0002\u0010\u000bJ#\u00100\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0002\u00a2\u0006\u0002\u0010\u000bJ#\u00101\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0002\u00a2\u0006\u0002\u0010\u000b\u00a8\u00062"}, d2={"Lphonon/puppet/commands/ActorCommand;", "Lorg/bukkit/command/CommandExecutor;", "Lorg/bukkit/command/TabCompleter;", "()V", "actorInfo", "", "sender", "Lorg/bukkit/command/CommandSender;", "args", "", "", "(Lorg/bukkit/command/CommandSender;[Ljava/lang/String;)V", "animationInfo", "boneCommands", "createActor", "createMesh", "killActor", "killAllActor", "listActors", "listAnimations", "moveActor", "onCommand", "", "cmd", "Lorg/bukkit/command/Command;", "commandLabel", "(Lorg/bukkit/command/CommandSender;Lorg/bukkit/command/Command;Ljava/lang/String;[Ljava/lang/String;)Z", "onTabComplete", "", "command", "alias", "(Lorg/bukkit/command/CommandSender;Lorg/bukkit/command/Command;Ljava/lang/String;[Ljava/lang/String;)Ljava/util/List;", "pauseAnimation", "playAnimation", "poseActor", "printBoneInfo", "printHelp", "printInfo", "printModels", "resetActorPose", "restartAnimation", "rotateActor", "setBonePosition", "setBoneRotation", "startAnimation", "stepAnimation", "stopAllAnimation", "stopAnimation", "teleportActor", "toggleArmorStands", "phonon-puppet"})
public final class ActorCommand
implements CommandExecutor,
TabCompleter {
    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command cmd, @NotNull String commandLabel, @NotNull String[] args2) {
        Player player;
        Intrinsics.checkParameterIsNotNull(sender, "sender");
        Intrinsics.checkParameterIsNotNull(cmd, "cmd");
        Intrinsics.checkParameterIsNotNull(commandLabel, "commandLabel");
        Intrinsics.checkParameterIsNotNull(args2, "args");
        Player player2 = player = sender instanceof Player ? (Player)sender : null;
        if (args2.length == 0) {
            this.printInfo(sender);
            return true;
        }
        String string = args2[0];
        boolean bl = false;
        String string2 = string;
        if (string2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string3 = string2.toLowerCase();
        Intrinsics.checkExpressionValueIsNotNull(string3, "(this as java.lang.String).toLowerCase()");
        switch (string3) {
            case "help": {
                this.printHelp(sender);
                break;
            }
            case "info": {
                this.actorInfo(sender, args2);
                break;
            }
            case "create": {
                this.createActor(sender, args2);
                break;
            }
            case "mesh": {
                this.createMesh(sender, args2);
                break;
            }
            case "kill": {
                this.killActor(sender, args2);
                break;
            }
            case "killall": {
                this.killAllActor(sender, args2);
                break;
            }
            case "list": {
                this.listActors(sender, args2);
                break;
            }
            case "models": {
                this.printModels(sender);
                break;
            }
            case "reset": {
                this.resetActorPose(sender, args2);
                break;
            }
            case "move": {
                this.moveActor(sender, args2);
                break;
            }
            case "teleport": {
                this.teleportActor(sender, args2);
                break;
            }
            case "rotate": {
                this.rotateActor(sender, args2);
                break;
            }
            case "pose": {
                this.poseActor(sender, args2);
                break;
            }
            case "armorstands": {
                this.toggleArmorStands(sender, args2);
                break;
            }
            case "animinfo": {
                this.animationInfo(sender, args2);
                break;
            }
            case "animlist": {
                this.listAnimations(sender, args2);
                break;
            }
            case "play": {
                this.playAnimation(sender, args2);
                break;
            }
            case "pause": {
                this.pauseAnimation(sender, args2);
                break;
            }
            case "stop": {
                this.stopAnimation(sender, args2);
                break;
            }
            case "stopall": {
                this.stopAllAnimation(sender, args2);
                break;
            }
            case "start": {
                this.startAnimation(sender, args2);
                break;
            }
            case "step": {
                this.stepAnimation(sender, args2);
                break;
            }
            case "restart": {
                this.restartAnimation(sender, args2);
                break;
            }
            case "bone": {
                this.boneCommands(sender, args2);
                break;
            }
            default: {
                Message.INSTANCE.error(sender, "Invalid command, use \"/actor help\"");
            }
        }
        return true;
    }

    @NotNull
    public List<String> onTabComplete(@NotNull CommandSender sender, @NotNull Command command, @NotNull String alias, @NotNull String[] args2) {
        Intrinsics.checkParameterIsNotNull(sender, "sender");
        Intrinsics.checkParameterIsNotNull(command, "command");
        Intrinsics.checkParameterIsNotNull(alias, "alias");
        Intrinsics.checkParameterIsNotNull(args2, "args");
        if (args2.length == 1) {
            return FilterKt.filterByStart(ActorCommandKt.access$getSUBCOMMANDS$p(), args2[0]);
        }
        if (args2.length > 1) {
            String string = args2[0];
            boolean bl = false;
            String string2 = string;
            if (string2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string3 = string2.toLowerCase();
            Intrinsics.checkExpressionValueIsNotNull(string3, "(this as java.lang.String).toLowerCase()");
            switch (string3) {
                case "create": {
                    if (args2.length != 2) break;
                    return FilterKt.filterByStart(Actor.Companion.types(), args2[1]);
                }
                case "animinfo": {
                    if (args2.length != 2) break;
                    return FilterKt.filterByStart(AnimationTrack.Companion.list(), args2[1]);
                }
                case "rotate": 
                case "move": 
                case "teleport": {
                    if (args2.length < 5) break;
                    return FilterKt.filterByStart(Puppet.INSTANCE.getActorNames(), args2[args2.length - 1]);
                }
                case "pose": 
                case "restart": 
                case "start": 
                case "kill": 
                case "pause": 
                case "stopall": 
                case "reset": 
                case "step": 
                case "info": {
                    if (args2.length < 2) break;
                    return FilterKt.filterByStart(Puppet.INSTANCE.getActorNames(), args2[args2.length - 1]);
                }
                case "play": 
                case "stop": {
                    if (args2.length == 2) {
                        return FilterKt.filterByStart(AnimationTrack.Companion.list(), args2[1]);
                    }
                    if (args2.length < 3) break;
                    return FilterKt.filterByStart(Puppet.INSTANCE.getActorNames(), args2[args2.length - 1]);
                }
                case "armorstands": {
                    if (args2.length == 2) {
                        return FilterKt.filterByStart(CollectionsKt.listOf("show", "hide"), args2[1]);
                    }
                    if (args2.length < 3) break;
                    return FilterKt.filterByStart(Puppet.INSTANCE.getActorNames(), args2[args2.length - 1]);
                }
                case "bone": {
                    Skeleton skeleton;
                    if (args2.length == 2) {
                        return FilterKt.filterByStart(CollectionsKt.listOf("info", "rotate", "position"), args2[1]);
                    }
                    if (args2.length == 3) {
                        return FilterKt.filterByStart(Puppet.INSTANCE.getActorNames(), args2[2]);
                    }
                    if (args2.length != 4) break;
                    String actorName = args2[2];
                    Actor actor = Puppet.INSTANCE.getActor(actorName);
                    Skeleton skeleton2 = skeleton = actor != null ? actor.getSkeleton() : null;
                    if (skeleton == null) {
                        boolean bl2 = false;
                        return CollectionsKt.emptyList();
                    }
                    Set<String> set = skeleton.getBones().keySet();
                    Intrinsics.checkExpressionValueIsNotNull(set, "skeleton.bones.keys");
                    return FilterKt.filterByStart(CollectionsKt.toList((Iterable)set), args2[3]);
                }
            }
        }
        boolean bl = false;
        return CollectionsKt.emptyList();
    }

    private final void printInfo(CommandSender sender) {
        Puppet.INSTANCE.printInfo(sender);
        Message.INSTANCE.print(sender, "Type \"/actor help\" to see list of actor commands.");
    }

    private final void printHelp(CommandSender sender) {
        Message.INSTANCE.print(sender, "[Puppet] Actor Commands:");
        Message.INSTANCE.print(sender, "/actor info" + ChatColor.WHITE + ": Print info about actor");
        Message.INSTANCE.print(sender, "/actor create" + ChatColor.WHITE + ": Create an actor");
        Message.INSTANCE.print(sender, "/actor mesh" + ChatColor.WHITE + ": Create mesh type actor");
        Message.INSTANCE.print(sender, "/actor kill" + ChatColor.WHITE + ": Kill an actor");
        Message.INSTANCE.print(sender, "/actor killall" + ChatColor.WHITE + ": Kill all actors");
        Message.INSTANCE.print(sender, "/actor list" + ChatColor.WHITE + ": List actors created");
        Message.INSTANCE.print(sender, "/actor models" + ChatColor.WHITE + ": List all available models");
        Message.INSTANCE.print(sender, "/actor reset" + ChatColor.WHITE + ": Reset actor pose to default");
        Message.INSTANCE.print(sender, "/actor move" + ChatColor.WHITE + ": Adjust actor position");
        Message.INSTANCE.print(sender, "/actor teleport" + ChatColor.WHITE + ": Teleport actor to location");
        Message.INSTANCE.print(sender, "/actor rotate" + ChatColor.WHITE + ": Adjust actor rotation");
        Message.INSTANCE.print(sender, "/actor pose" + ChatColor.WHITE + ": Adjust actor position/rotation using player movement");
        Message.INSTANCE.print(sender, "/actor armorstands" + ChatColor.WHITE + ": Show actor Armor Stands");
        Message.INSTANCE.print(sender, "/actor animinfo" + ChatColor.WHITE + ": Print info about an animation");
        Message.INSTANCE.print(sender, "/actor animlist" + ChatColor.WHITE + ": List all animations");
        Message.INSTANCE.print(sender, "/actor play" + ChatColor.WHITE + ": Make actor play animation");
        Message.INSTANCE.print(sender, "/actor pause" + ChatColor.WHITE + ": Stop actor animation (can resume)");
        Message.INSTANCE.print(sender, "/actor start" + ChatColor.WHITE + ": Start playing actor animations");
        Message.INSTANCE.print(sender, "/actor stop" + ChatColor.WHITE + ": Stop and remove actor animations");
        Message.INSTANCE.print(sender, "/actor stopall" + ChatColor.WHITE + ": Stop and remove all actor animations");
        Message.INSTANCE.print(sender, "/actor step" + ChatColor.WHITE + ": Run 1 animation frame for actor");
        Message.INSTANCE.print(sender, "/actor restart" + ChatColor.WHITE + ": Restart animation");
        Message.INSTANCE.print(sender, "/actor bone info" + ChatColor.WHITE + ": Print actor bone info");
        Message.INSTANCE.print(sender, "/actor bone rotate" + ChatColor.WHITE + ": Set actor bone rotation");
        Message.INSTANCE.print(sender, "/actor bone position" + ChatColor.WHITE + ": Set actor bone position");
    }

    private final void actorInfo(CommandSender sender, String[] args2) {
        List targets = ActorCommandKt.access$getActorTargets(sender, args2, 1);
        if (targets.size() == 0) {
            Message.INSTANCE.error(sender, "Usage: /actor info: info for actor player is looking at");
            Message.INSTANCE.error(sender, "Usage: /actor info [actor0] [actor1] ...: info for actor id");
            return;
        }
        for (Actor actor : targets) {
            Message.INSTANCE.print(sender, "Actor: " + actor.getName());
            StringBuilder stringBuilder = new StringBuilder().append("- skeleton: ");
            Object object = actor.getSkeleton();
            if (object == null || (object = ((Skeleton)object).getName()) == null) {
                object = "none";
            }
            Message.INSTANCE.print(sender, stringBuilder.append((String)object).toString());
            Message.INSTANCE.print(sender, "- animations:");
            for (String anim : actor.getAnimation().getPlaying().keySet()) {
                Message.INSTANCE.print(sender, "   - " + anim);
            }
        }
    }

    private final void createActor(CommandSender sender, String[] args2) {
        Location location;
        Player player;
        if (args2.length < 2) {
            Message.INSTANCE.error(sender, "Usage: /actor create [type] [x] [y] [z]");
            Message.INSTANCE.error(sender, "Will create at player location if (x, y, z) not specified.");
            return;
        }
        Player player2 = player = sender instanceof Player ? (Player)sender : null;
        if (player == null) {
            if (args2.length < 5) {
                Message.INSTANCE.error(sender, "Usage: /actor create [type] [x] [y] [z]");
                Message.INSTANCE.error(sender, "Must enter all (x, y, z) values.");
                return;
            }
            String string = args2[2];
            boolean bl = false;
            double x = Double.parseDouble(string);
            String string2 = args2[3];
            boolean bl2 = false;
            double y = Double.parseDouble(string2);
            String string3 = args2[4];
            boolean bl3 = false;
            double z = Double.parseDouble(string3);
            location = new Location((World)Bukkit.getWorlds().get(0), x, y, z);
        } else {
            Location location2 = player.getLocation();
            location = location2;
            Intrinsics.checkExpressionValueIsNotNull(location2, "player.location");
        }
        Location spawnLocation = location;
        String type = args2[1];
        Object result = Puppet.INSTANCE.createActorAtLocation(type, spawnLocation);
        if (Result.isSuccess-impl(result)) {
            Object object = result;
            boolean bl = false;
            Object object2 = Result.isFailure-impl(object) ? null : object;
            if (object2 == null) {
                Intrinsics.throwNpe();
            }
            Actor actor = (Actor)object2;
            Message.INSTANCE.print(sender, "Created actor " + type + " named \"" + actor.getName() + "\" at (" + spawnLocation.getX() + ", " + spawnLocation.getY() + ", " + spawnLocation.getZ() + ')');
        } else {
            Message.INSTANCE.error(sender, "Invalid mesh type: " + type);
        }
    }

    private final void createMesh(CommandSender sender, String[] args2) {
        Location location;
        Player player;
        if (args2.length < 2) {
            Message.INSTANCE.error(sender, "Usage: /actor mesh [type] [x] [y] [z]");
            Message.INSTANCE.error(sender, "Will create at player location if (x, y, z) not specified.");
            return;
        }
        Player player2 = player = sender instanceof Player ? (Player)sender : null;
        if (player == null) {
            if (args2.length < 5) {
                Message.INSTANCE.error(sender, "Usage: /actor mesh [type] [x] [y] [z]");
                Message.INSTANCE.error(sender, "Must enter all (x, y, z) values.");
                return;
            }
            String string = args2[2];
            boolean bl = false;
            double x = Double.parseDouble(string);
            String string2 = args2[3];
            boolean bl2 = false;
            double y = Double.parseDouble(string2);
            String string3 = args2[4];
            boolean bl3 = false;
            double z = Double.parseDouble(string3);
            location = new Location((World)Bukkit.getWorlds().get(0), x, y, z);
        } else {
            Location location2 = player.getLocation();
            location = location2;
            Intrinsics.checkExpressionValueIsNotNull(location2, "player.location");
        }
        Location spawnLocation = location;
        String type = args2[1];
        Object result = Puppet.INSTANCE.createMeshAtLocation(type, spawnLocation);
        if (Result.isSuccess-impl(result)) {
            Object object = result;
            boolean bl = false;
            Object object2 = Result.isFailure-impl(object) ? null : object;
            if (object2 == null) {
                Intrinsics.throwNpe();
            }
            Actor actor = (Actor)object2;
            Message.INSTANCE.print(sender, "Created mesh " + type + " named \"" + actor.getName() + "\" at (" + spawnLocation.getX() + ", " + spawnLocation.getY() + ", " + spawnLocation.getZ() + ')');
        } else {
            Message.INSTANCE.error(sender, "Invalid mesh type: " + type);
        }
    }

    private final void killActor(CommandSender sender, String[] args2) {
        List targets = ActorCommandKt.access$getActorTargets(sender, args2, 1);
        if (targets.size() < 1) {
            Message.INSTANCE.error(sender, "Usage: /actor kill [actor0] [actor1] ...");
            Message.INSTANCE.error(sender, "If no actor ids are specified, it will run on actor player is looking at");
            return;
        }
        for (Actor actor : targets) {
            Puppet.INSTANCE.destroyActor(actor);
            Unit result = Unit.INSTANCE;
            Message.INSTANCE.print(sender, "Destroyed actor \"" + actor.getName() + '\"');
        }
    }

    private final void killAllActor(CommandSender sender, String[] args2) {
        Player player;
        if (sender instanceof Player && !(player = (Player)sender).isOp()) {
            Message.INSTANCE.error(sender, "Only op players can use /actor killall");
            return;
        }
        Puppet.INSTANCE.destroyAllActors();
        Message.INSTANCE.print(sender, "Destroyed all actors");
    }

    private final void listActors(CommandSender sender, String[] args2) {
        Message.INSTANCE.print(sender, "Actors currently in game:");
        Map map = Puppet.INSTANCE.getActors();
        boolean bl = false;
        Iterator iterator2 = map.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry entry;
            Map.Entry entry2 = entry = iterator2.next();
            boolean bl2 = false;
            String name = (String)entry2.getKey();
            entry2 = entry;
            bl2 = false;
            Actor actor = (Actor)entry2.getValue();
            Vector3f p = actor.getPosition();
            Message.INSTANCE.print(sender, "- " + name + ": (" + p.getX() + ", " + p.getY() + ", " + p.getZ() + ')');
        }
    }

    private final void printModels(CommandSender sender) {
        if (sender != null) {
            Mesh.Companion.printInfo(sender);
        }
    }

    private final void resetActorPose(CommandSender sender, String[] args2) {
        List targets = ActorCommandKt.access$getActorTargets(sender, args2, 1);
        if (targets.size() < 1) {
            Message.INSTANCE.error(sender, "Usage: /actor reset: run on actor you are looking at");
            Message.INSTANCE.error(sender, "Usage: /actor reset [actor0] [actor1] ...: run on actor list");
            return;
        }
        for (Actor actor : targets) {
            Transform.DefaultImpls.setRotation$default((Transform)actor, 0.0, 0.0, 0.0, false, 8, null);
            Skeleton skeleton = actor.getSkeleton();
            if (skeleton != null) {
                skeleton.reset();
                Message.INSTANCE.print(sender, "Resetting actor \"" + actor.getName() + "\" pose.");
                continue;
            }
            Message.INSTANCE.error(sender, "Actor \"" + actor.getName() + "\" has no bones.");
        }
    }

    private final void moveActor(CommandSender sender, String[] args2) {
        if (args2.length < 4) {
            Message.INSTANCE.error(sender, "Usage: /actor move [x] [y] [z] [actor0] [actor1] ...");
            Message.INSTANCE.error(sender, "If no actor ids are specified, it will run on actor player is looking at");
            return;
        }
        if (args2.length < 5 && !(sender instanceof Player)) {
            Message.INSTANCE.error(sender, "Usage: /actor move [x] [y] [z] [actor0] [actor1] ...");
            Message.INSTANCE.error(sender, "Actor id required if you are not a player in game");
            return;
        }
        String string = args2[1];
        boolean bl = false;
        double dx = Double.parseDouble(string);
        String string2 = args2[2];
        boolean bl2 = false;
        double dy = Double.parseDouble(string2);
        String string3 = args2[3];
        boolean bl3 = false;
        double dz = Double.parseDouble(string3);
        List targets = ActorCommandKt.access$getActorTargets(sender, args2, 4);
        for (Actor actor : targets) {
            Vector3f p = actor.getPosition();
            Transform.DefaultImpls.setPosition$default(actor, (double)p.getX() + dx, (double)p.getY() + dy, (double)p.getZ() + dz, false, 8, null);
            Message.INSTANCE.print(sender, "Moving actor \"" + actor.getName() + "\" by (" + dx + ", " + dy + ", " + dz + ')');
        }
    }

    private final void teleportActor(CommandSender sender, String[] args2) {
        if (args2.length < 4) {
            Message.INSTANCE.error(sender, "Usage: /actor teleport [x] [y] [z] [actor0] [actor1] ...");
            Message.INSTANCE.error(sender, "If no actor ids are specified, it will run on actor player is looking at");
            return;
        }
        if (args2.length < 5 && !(sender instanceof Player)) {
            Message.INSTANCE.error(sender, "Usage: /actor teleport [x] [y] [z] [actor0] [actor1] ...");
            Message.INSTANCE.error(sender, "Actor id required if you are not a player in game");
            return;
        }
        String string = args2[1];
        boolean bl = false;
        double x = Double.parseDouble(string);
        String string2 = args2[2];
        boolean bl2 = false;
        double y = Double.parseDouble(string2);
        String string3 = args2[3];
        boolean bl3 = false;
        double z = Double.parseDouble(string3);
        List targets = ActorCommandKt.access$getActorTargets(sender, args2, 4);
        for (Actor actor : targets) {
            Transform.DefaultImpls.setPosition$default(actor, x, y, z, false, 8, null);
            Message.INSTANCE.print(sender, "Teleporting actor \"" + actor.getName() + "\" to (" + x + ", " + y + ", " + z + ')');
        }
    }

    private final void rotateActor(CommandSender sender, String[] args2) {
        if (args2.length < 4) {
            Message.INSTANCE.error(sender, "Usage: /actor rotate [x] [y] [z] [actor0] [actor1] ...");
            Message.INSTANCE.error(sender, "If no actor ids are specified, it will run on actor player is looking at");
            return;
        }
        if (args2.length < 5 && !(sender instanceof Player)) {
            Message.INSTANCE.error(sender, "Usage: /actor rotate [x] [y] [z] [actor0] [actor1] ...");
            Message.INSTANCE.error(sender, "Actor id required if you are not a player in game");
            return;
        }
        String string = args2[1];
        boolean bl = false;
        double dxDeg = Double.parseDouble(string);
        String string2 = args2[2];
        boolean bl2 = false;
        double dyDeg = Double.parseDouble(string2);
        String string3 = args2[3];
        boolean bl3 = false;
        double dzDeg = Double.parseDouble(string3);
        double dx = Math.toRadians(dxDeg);
        double dy = Math.toRadians(dyDeg);
        double dz = Math.toRadians(dzDeg);
        List targets = ActorCommandKt.access$getActorTargets(sender, args2, 4);
        for (Actor actor : targets) {
            Euler r = actor.getRotation();
            Transform.DefaultImpls.setRotation$default((Transform)actor, (double)r.getX() + dx, (double)r.getY() + dy, (double)r.getZ() + dz, false, 8, null);
            Message.INSTANCE.print(sender, "Rotating actor \"" + actor.getName() + "\" by (" + dxDeg + ", " + dyDeg + ", " + dzDeg + ')');
        }
    }

    private final void poseActor(CommandSender sender, String[] args2) {
        Actor posingActor;
        Player player;
        Player player2 = player = sender instanceof Player ? (Player)sender : null;
        if (player == null) {
            return;
        }
        if (args2.length < 2 && (posingActor = Puppet.INSTANCE.getPlayerPosingActor().get(player)) != null) {
            Puppet.INSTANCE.getPlayerPosingActor().remove(player);
            Message.INSTANCE.print(player, "Stopped posing actor: " + posingActor.getName());
            return;
        }
        List targets = ActorCommandKt.access$getActorTargets(sender, args2, 1);
        if (targets.size() >= 1) {
            Actor actor = (Actor)targets.get(0);
            Puppet.INSTANCE.getPlayerPosingActor().put(player, actor);
            Message.INSTANCE.print(sender, "Posing actor \"" + actor.getName() + "\" by player movement");
            Message.INSTANCE.print(sender, "(Type \"/actor pose\" again to stop posing)");
        } else {
            Message.INSTANCE.error(sender, "Usage: /actor pose [actor0] [actor1] ...");
        }
    }

    /*
     * Unable to fully structure code
     */
    private final void toggleArmorStands(CommandSender sender, String[] args) {
        block7: {
            if (args.length < 2) {
                Message.INSTANCE.print(sender, "Usage: /actor armorstands [show/hide] [actor0] [actor1] ...");
                return;
            }
            var4_3 = args[1];
            var5_4 = false;
            v0 = var4_3;
            if (v0 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            v1 = v0.toLowerCase();
            Intrinsics.checkExpressionValueIsNotNull(v1, "(this as java.lang.String).toLowerCase()");
            var4_3 = v1;
            switch (var4_3.hashCode()) {
                case 3202370: {
                    if (!var4_3.equals("hide")) ** break;
                    break;
                }
                case 3529469: {
                    if (!var4_3.equals("show")) ** break;
                    v2 = true;
                    break block7;
                }
            }
            v2 = false;
            break block7;
            v2 = false;
        }
        visible = v2;
        targets = ActorCommandKt.access$getActorTargets(sender, args, 2);
        for (Actor actor : targets) {
            Puppet.INSTANCE.toggleArmorStands(actor, visible);
            Message.INSTANCE.print(sender, "Set actor \"" + actor.getName() + "\" armor stands visiblity: " + visible);
        }
    }

    private final void listAnimations(CommandSender sender, String[] args2) {
        Message.INSTANCE.print(sender, "Animations:");
        List<String> animations = AnimationTrack.Companion.list();
        for (String name : animations) {
            Message.INSTANCE.print(sender, "- " + name);
        }
    }

    private final void animationInfo(CommandSender sender, String[] args2) {
        if (args2.length < 2) {
            Message.INSTANCE.print(sender, "Usage: /actor animinfo [animation]");
            return;
        }
        AnimationTrack animTrack = AnimationTrack.Companion.get(args2[1]);
        if (animTrack == null) {
            Message.INSTANCE.error(sender, "Animation \"" + args2[1] + "\" does not exist");
            return;
        }
        Message.INSTANCE.print(sender, "Animation: " + animTrack.getName());
        Message.INSTANCE.print(sender, "- length: " + animTrack.getLength());
        if (args2.length > 2) {
            String boneName = args2[2];
            TransformTrack transformTracks = animTrack.getTransformTracks().get(boneName);
            if (transformTracks != null) {
                String string;
                String string2;
                String string3;
                boolean bl;
                Message message;
                CommandSender commandSender;
                StringBuilder stringBuilder;
                float[] fArray;
                Message message2 = Message.INSTANCE;
                CommandSender commandSender2 = sender;
                StringBuilder stringBuilder2 = new StringBuilder().append("- position: ");
                float[] fArray2 = transformTracks.getPosition();
                if (fArray2 != null) {
                    fArray = fArray2;
                    stringBuilder = stringBuilder2;
                    commandSender = commandSender2;
                    message = message2;
                    bl = false;
                    String string4 = Arrays.toString(fArray);
                    Intrinsics.checkExpressionValueIsNotNull(string4, "java.util.Arrays.toString(this)");
                    string3 = string4;
                    message2 = message;
                    commandSender2 = commandSender;
                    stringBuilder2 = stringBuilder;
                    string2 = string3;
                } else {
                    string2 = null;
                }
                message2.print(commandSender2, stringBuilder2.append(string2).toString());
                Message message3 = Message.INSTANCE;
                CommandSender commandSender3 = sender;
                StringBuilder stringBuilder3 = new StringBuilder().append("- quaternion: ");
                float[] fArray3 = transformTracks.getQuaternion();
                if (fArray3 != null) {
                    fArray = fArray3;
                    stringBuilder = stringBuilder3;
                    commandSender = commandSender3;
                    message = message3;
                    bl = false;
                    String string5 = Arrays.toString(fArray);
                    Intrinsics.checkExpressionValueIsNotNull(string5, "java.util.Arrays.toString(this)");
                    string3 = string5;
                    message3 = message;
                    commandSender3 = commandSender;
                    stringBuilder3 = stringBuilder;
                    string = string3;
                } else {
                    string = null;
                }
                message3.print(commandSender3, stringBuilder3.append(string).toString());
            }
        }
    }

    private final void playAnimation(CommandSender sender, String[] args2) {
        if (args2.length < 2) {
            Message.INSTANCE.error(sender, "Usage: /actor play [animation]: run on actor you are looking at");
            Message.INSTANCE.error(sender, "Usage: /actor play [animation] [actor0] [actor1] ...: run on actor list");
            return;
        }
        String animName = args2[1];
        List targets = ActorCommandKt.access$getActorTargets(sender, args2, 2);
        for (Actor actor : targets) {
            actor.getAnimation().play(animName, 1.0);
            Message.INSTANCE.print(sender, "Actor \"" + actor.getName() + "\" playing: \"" + animName + '\"');
        }
    }

    private final void stopAnimation(CommandSender sender, String[] args2) {
        if (args2.length < 2) {
            Message.INSTANCE.error(sender, "Usage: /actor stop [animation]: run on actor you are looking at");
            Message.INSTANCE.error(sender, "Usage: /actor stop [animation] [actor0] [actor1] ...: run on actor list");
            return;
        }
        String animName = args2[1];
        List targets = ActorCommandKt.access$getActorTargets(sender, args2, 2);
        for (Actor actor : targets) {
            actor.getAnimation().stop(animName);
            Message.INSTANCE.print(sender, "Actor \"" + actor.getName() + "\" stopped playing: \"" + animName + "\".");
        }
    }

    private final void stopAllAnimation(CommandSender sender, String[] args2) {
        List targets = ActorCommandKt.access$getActorTargets(sender, args2, 1);
        if (targets.size() < 1) {
            Message.INSTANCE.error(sender, "Usage: /actor stopall: run on actor you are looking at");
            Message.INSTANCE.error(sender, "Usage: /actor stopall [actor0] [actor1] ...: run on actor list");
            return;
        }
        for (Actor actor : targets) {
            actor.getAnimation().stopAll();
            Message.INSTANCE.print(sender, "Actor \"" + actor.getName() + "\" stopped all animations.");
        }
    }

    private final void pauseAnimation(CommandSender sender, String[] args2) {
        List targets = ActorCommandKt.access$getActorTargets(sender, args2, 1);
        if (targets.size() < 1) {
            Message.INSTANCE.error(sender, "Usage: /actor pause: run on actor you are looking at");
            Message.INSTANCE.error(sender, "Usage: /actor pause [actor0] [actor1] ...: run on actor list");
            return;
        }
        for (Actor actor : targets) {
            actor.getAnimation().enable(false);
            Message.INSTANCE.print(sender, "Actor \"" + actor.getName() + "\" paused animations.");
        }
    }

    private final void startAnimation(CommandSender sender, String[] args2) {
        List targets = ActorCommandKt.access$getActorTargets(sender, args2, 1);
        if (targets.size() < 1) {
            Message.INSTANCE.error(sender, "Usage: /actor start: run on actor you are looking at");
            Message.INSTANCE.error(sender, "Usage: /actor start [actor0] [actor1] ...: run on actor list");
            return;
        }
        for (Actor actor : targets) {
            actor.getAnimation().enable(true);
            Message.INSTANCE.print(sender, "Actor \"" + actor.getName() + "\" unpaused animations.");
        }
    }

    private final void stepAnimation(CommandSender sender, String[] args2) {
        List targets = ActorCommandKt.access$getActorTargets(sender, args2, 1);
        if (targets.size() < 1) {
            Message.INSTANCE.error(sender, "Usage: /actor step: run on actor you are looking at");
            Message.INSTANCE.error(sender, "Usage: /actor step [actor0] [actor1] ...: run on actor list");
            return;
        }
        for (Actor actor : targets) {
            if (Puppet.INSTANCE.isRunning()) {
                actor.getAnimation().update();
            } else {
                actor.update();
                actor.render();
            }
            Message.INSTANCE.print(sender, "Actor \"" + actor.getName() + "\" stepped animation by 1 tick.");
        }
    }

    private final void restartAnimation(CommandSender sender, String[] args2) {
        List targets = ActorCommandKt.access$getActorTargets(sender, args2, 1);
        if (targets.size() < 1) {
            Message.INSTANCE.error(sender, "Usage: /actor restart: run on actor you are looking at");
            Message.INSTANCE.error(sender, "Usage: /actor restart [actor0] [actor1] ...: run on actor list");
            return;
        }
        for (Actor actor : targets) {
            actor.getAnimation().restart();
            Message.INSTANCE.print(sender, "Actor \"" + actor.getName() + "\" restarted all animations.");
        }
    }

    /*
     * Unable to fully structure code
     */
    private final void boneCommands(CommandSender sender, String[] args) {
        block8: {
            block7: {
                $fun$printBoneCommandInfo$1 = boneCommands.1.INSTANCE;
                if (args.length < 2) {
                    $fun$printBoneCommandInfo$1.invoke(sender);
                    return;
                }
                var4_4 = args[1];
                var5_5 = false;
                v0 = var4_4;
                if (v0 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                v1 = v0.toLowerCase();
                Intrinsics.checkExpressionValueIsNotNull(v1, "(this as java.lang.String).toLowerCase()");
                var4_4 = v1;
                switch (var4_4.hashCode()) {
                    case -925180581: {
                        if (!var4_4.equals("rotate")) ** break;
                        break;
                    }
                    case 0x2C929929: {
                        if (!var4_4.equals("position")) ** break;
                        break block7;
                    }
                    case 3237038: {
                        if (!var4_4.equals("info")) ** break;
                        this.printBoneInfo(sender, args);
                        break block8;
                    }
                }
                this.setBoneRotation(sender, args);
                break block8;
            }
            this.setBonePosition(sender, args);
            break block8;
            Message.INSTANCE.error(sender, "Invalid /actor bone subcommand");
            $fun$printBoneCommandInfo$1.invoke(sender);
        }
    }

    private final void printBoneInfo(CommandSender sender, String[] args2) {
        Bone bone;
        if (args2.length < 4) {
            Message.INSTANCE.error(sender, "Usage: /actor bone info [actor] [bone]");
            return;
        }
        String actorName = args2[2];
        Actor actor = Puppet.INSTANCE.getActor(actorName);
        if (actor == null) {
            Message.INSTANCE.error(sender, "Invalid actor: " + actorName);
            return;
        }
        String boneName = args2[3];
        Object object = actor.getSkeleton();
        Bone bone2 = object != null && (object = ((Skeleton)object).getBones()) != null ? (Bone)((LinkedHashMap)object).get(boneName) : (bone = null);
        if (bone == null) {
            Message.INSTANCE.error(sender, "Invalid bone: " + boneName);
            return;
        }
        Message.INSTANCE.print(sender, "Actor \"" + actor.getName() + "\":");
        bone.printInfo(sender);
    }

    private final void setBoneRotation(CommandSender sender, String[] args2) {
        Bone bone;
        if (args2.length < 4) {
            Message.INSTANCE.error(sender, "Usage: /actor bone rotate [actor] [bone] [x] [y] [z]");
            return;
        }
        String actorName = args2[2];
        Actor actor = Puppet.INSTANCE.getActor(actorName);
        if (actor == null) {
            Message.INSTANCE.error(sender, "Invalid actor: " + actorName);
            return;
        }
        String boneName = args2[3];
        Object object = actor.getSkeleton();
        Bone bone2 = object != null && (object = ((Skeleton)object).getBones()) != null ? (Bone)((LinkedHashMap)object).get(boneName) : (bone = null);
        if (bone == null) {
            Message.INSTANCE.error(sender, "Invalid bone: " + boneName);
            return;
        }
        if (args2.length < 7) {
            Message.INSTANCE.error(sender, "Usage: /actor bone rotate [actor] [bone] [x] [y] [z]");
            Message.INSTANCE.error(sender, "Need to input all (x, y, z) values...");
            return;
        }
        String string = args2[4];
        boolean bl = false;
        double xDeg = Double.parseDouble(string);
        String string2 = args2[5];
        boolean bl2 = false;
        double yDeg = Double.parseDouble(string2);
        String string3 = args2[6];
        boolean bl3 = false;
        double zDeg = Double.parseDouble(string3);
        double x = Math.toRadians(xDeg);
        double y = Math.toRadians(yDeg);
        double z = Math.toRadians(zDeg);
        Transform.DefaultImpls.setRotation$default((Transform)bone, x, y, z, false, 8, null);
        actor.update();
        Message.INSTANCE.print(sender, "Set actor \"" + actor.getName() + "\" bone \"" + bone.getName() + "\" rotation to (" + xDeg + ", " + yDeg + ", " + zDeg + ')');
        if (!Puppet.INSTANCE.isRunning()) {
            actor.render();
        }
    }

    public final void setBonePosition(@NotNull CommandSender sender, @NotNull String[] args2) {
        Bone bone;
        Intrinsics.checkParameterIsNotNull(sender, "sender");
        Intrinsics.checkParameterIsNotNull(args2, "args");
        if (args2.length < 4) {
            Message.INSTANCE.error(sender, "Usage: /actor bone position [actor] [bone] [x] [y] [z]");
            return;
        }
        String actorName = args2[2];
        Actor actor = Puppet.INSTANCE.getActor(actorName);
        if (actor == null) {
            Message.INSTANCE.error(sender, "Invalid actor: " + actorName);
            return;
        }
        String boneName = args2[3];
        Object object = actor.getSkeleton();
        Bone bone2 = object != null && (object = ((Skeleton)object).getBones()) != null ? (Bone)((LinkedHashMap)object).get(boneName) : (bone = null);
        if (bone == null) {
            Message.INSTANCE.error(sender, "Invalid bone: " + boneName);
            return;
        }
        if (args2.length < 7) {
            Message.INSTANCE.error(sender, "Usage: /actor bone position [actor] [bone] [x] [y] [z]");
            Message.INSTANCE.error(sender, "Need to input all (x, y, z) values...");
            return;
        }
        String string = args2[4];
        boolean bl = false;
        double x = Double.parseDouble(string);
        String string2 = args2[5];
        boolean bl2 = false;
        double y = Double.parseDouble(string2);
        String string3 = args2[6];
        boolean bl3 = false;
        double z = Double.parseDouble(string3);
        Transform.DefaultImpls.setPosition$default(bone, x, y, z, false, 8, null);
        actor.update();
        Message.INSTANCE.print(sender, "Set actor \"" + actor.getName() + "\" bone \"" + bone.getName() + "\" position to (" + x + ", " + y + ", " + z + ')');
        if (!Puppet.INSTANCE.isRunning()) {
            actor.render();
        }
    }
}

