/*
 * Decompiled with CFR 0.152.
 */
package phonon.puppet.animation;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import phonon.puppet.animation.Keyframe;
import phonon.puppet.math.Quaternion;
import phonon.puppet.math.Vector3f;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=2, d1={"\u00004\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0014\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\u001ad\u0010\u0000\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00020\u00012\u0012\u0010\u0004\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u00020\u00012\u0012\u0010\u0006\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u00020\u00012\u0012\u0010\u0007\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u00020\u00012\u0012\u0010\b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u00020\u0001H\u0002\u001a<\u0010\t\u001a\u00020\n2\u0012\u0010\u000b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u00020\u00012\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u000fH\u0002\u001a,\u0010\u0012\u001a\u00020\n2\u0012\u0010\u000b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00020\u00012\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002\u001a,\u0010\u0013\u001a\u00020\n2\u0012\u0010\u000b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00140\u00020\u00012\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002\u00a8\u0006\u0015"}, d2={"formQuaternionKeyframes", "", "Lphonon/puppet/animation/Keyframe;", "Lphonon/puppet/math/Quaternion;", "keyframesX", "", "keyframesY", "keyframesZ", "keyframesW", "sampleDoubleKeyframesIntoBuffer", "", "keyframes", "buffer", "", "numBlocks", "", "block", "offset", "sampleQuaternionKeyframesIntoBuffer", "sampleVectorKeyframesIntoBuffer", "Lphonon/puppet/math/Vector3f;", "phonon-puppet"})
public final class AnimationTrackKt {
    private static final List<Keyframe<Quaternion>> formQuaternionKeyframes(List<Keyframe<Double>> keyframesX, List<Keyframe<Double>> keyframesY, List<Keyframe<Double>> keyframesZ, List<Keyframe<Double>> keyframesW) {
        Iterator<Keyframe<Double>> iterKeysY = keyframesY.iterator();
        Iterator<Keyframe<Double>> iterKeysZ = keyframesZ.iterator();
        Iterator<Keyframe<Double>> iterKeysW = keyframesW.iterator();
        Keyframe<Double> currKeyY = iterKeysY.next();
        Keyframe<Double> currKeyZ = iterKeysZ.next();
        Keyframe<Double> currKeyW = iterKeysW.next();
        boolean bl = false;
        List keyframesQuat = new ArrayList();
        for (Keyframe<Double> currKeyX : keyframesX) {
            int frame = currKeyX.getTick();
            currKeyY = iterKeysY.hasNext() && currKeyY.getTick() < frame ? iterKeysY.next() : currKeyY;
            currKeyZ = iterKeysZ.hasNext() && currKeyZ.getTick() < frame ? iterKeysZ.next() : currKeyZ;
            currKeyW = iterKeysW.hasNext() && currKeyW.getTick() < frame ? iterKeysW.next() : currKeyW;
            float x = (float)((Number)currKeyX.getValue()).doubleValue();
            float y = (float)((Number)currKeyY.getValue()).doubleValue();
            float z = (float)((Number)currKeyZ.getValue()).doubleValue();
            float w = (float)((Number)currKeyW.getValue()).doubleValue();
            keyframesQuat.add(new Keyframe<Quaternion>(frame, new Quaternion(x, y, z, w).normalize(), currKeyX.getInterpolation()));
        }
        return CollectionsKt.toList(keyframesQuat);
    }

    /*
     * WARNING - void declaration
     */
    private static final void sampleDoubleKeyframesIntoBuffer(List<Keyframe<Double>> keyframes, float[] buffer, int numBlocks, int block, int offset) {
        if (keyframes.size() == 0) {
            return;
        }
        Iterator<Keyframe<Double>> keyIter = keyframes.iterator();
        Keyframe<Double> currKey = keyIter.next();
        Keyframe<Double> nextKey = keyIter.hasNext() ? keyIter.next() : currKey;
        int n = 0;
        int n2 = numBlocks;
        while (n < n2) {
            void i;
            if (i >= nextKey.getTick() && keyIter.hasNext()) {
                currKey = nextKey;
                nextKey = keyIter.next();
            }
            double value = nextKey.getTick() > currKey.getTick() ? nextKey.getInterpolation().interpolate(((Number)currKey.getValue()).doubleValue(), ((Number)nextKey.getValue()).doubleValue(), (double)(i - currKey.getTick()) / (double)(nextKey.getTick() - currKey.getTick())) : ((Number)currKey.getValue()).doubleValue();
            buffer[i * block + offset] = (float)value;
            ++i;
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final void sampleVectorKeyframesIntoBuffer(List<Keyframe<Vector3f>> keyframes, float[] buffer, int numBlocks) {
        if (keyframes.size() == 0) {
            return;
        }
        Iterator<Keyframe<Vector3f>> keyIter = keyframes.iterator();
        Keyframe<Vector3f> currKey = keyIter.next();
        Keyframe<Vector3f> nextKey = keyIter.hasNext() ? keyIter.next() : currKey;
        Vector3f v = Vector3f.Companion.zero();
        int n = 0;
        int n2 = numBlocks;
        while (n < n2) {
            void i;
            if (i >= nextKey.getTick() && keyIter.hasNext()) {
                currKey = nextKey;
                nextKey = keyIter.next();
            }
            double a = nextKey.getTick() > currKey.getTick() ? nextKey.getInterpolation().interpolate(0.0, 1.0, (double)(i - currKey.getTick()) / (double)(nextKey.getTick() - currKey.getTick())) : 0.0;
            v.lerpVectors(currKey.getValue(), nextKey.getValue(), a);
            void index = i * 3;
            buffer[index] = v.getX();
            buffer[index + true] = v.getY();
            buffer[index + 2] = v.getZ();
            ++i;
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final void sampleQuaternionKeyframesIntoBuffer(List<Keyframe<Quaternion>> keyframes, float[] buffer, int numBlocks) {
        if (keyframes.size() == 0) {
            return;
        }
        Iterator<Keyframe<Quaternion>> keyIter = keyframes.iterator();
        Keyframe<Quaternion> currKey = keyIter.next();
        Keyframe<Quaternion> nextKey = keyIter.hasNext() ? keyIter.next() : currKey;
        Quaternion q = Quaternion.Companion.zero();
        int n = 0;
        int n2 = numBlocks;
        while (n < n2) {
            void i;
            if (i >= nextKey.getTick() && keyIter.hasNext()) {
                currKey = nextKey;
                nextKey = keyIter.next();
            }
            double a = nextKey.getTick() > currKey.getTick() ? nextKey.getInterpolation().interpolate(0.0, 1.0, (double)(i - currKey.getTick()) / (double)(nextKey.getTick() - currKey.getTick())) : 0.0;
            q.slerp(currKey.getValue(), nextKey.getValue(), a);
            void index = i * 4;
            buffer[index] = q.getX();
            buffer[index + true] = q.getY();
            buffer[index + 2] = q.getZ();
            buffer[index + 3] = q.getW();
            ++i;
        }
    }

    public static final /* synthetic */ void access$sampleVectorKeyframesIntoBuffer(List keyframes, float[] buffer, int numBlocks) {
        AnimationTrackKt.sampleVectorKeyframesIntoBuffer(keyframes, buffer, numBlocks);
    }

    public static final /* synthetic */ void access$sampleQuaternionKeyframesIntoBuffer(List keyframes, float[] buffer, int numBlocks) {
        AnimationTrackKt.sampleQuaternionKeyframesIntoBuffer(keyframes, buffer, numBlocks);
    }
}

