/*
 * Decompiled with CFR 0.152.
 */
package phonon.puppet.animation;

import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import phonon.puppet.animation.AnimationTrackKt;
import phonon.puppet.animation.Keyframe;
import phonon.puppet.animation.TransformTrack;
import phonon.puppet.math.Quaternion;
import phonon.puppet.math.Vector3f;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eB\u0085\u0001\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012:\u0010\u0004\u001a6\u0012\u0004\u0012\u00020\u0003\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00070\u00060\u0005j\u001a\u0012\u0004\u0012\u00020\u0003\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00070\u0006`\t\u0012:\u0010\n\u001a6\u0012\u0004\u0012\u00020\u0003\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\u00070\u00060\u0005j\u001a\u0012\u0004\u0012\u00020\u0003\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\u00070\u0006`\t\u00a2\u0006\u0002\u0010\fJ&\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u001b\u001a\u00020\u00112\u0006\u0010\u001c\u001a\u00020\b2\u0006\u0010\u001d\u001a\u00020\u000bRE\u0010\u0004\u001a6\u0012\u0004\u0012\u00020\u0003\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00070\u00060\u0005j\u001a\u0012\u0004\u0012\u00020\u0003\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00070\u0006`\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eRE\u0010\n\u001a6\u0012\u0004\u0012\u00020\u0003\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\u00070\u00060\u0005j\u001a\u0012\u0004\u0012\u00020\u0003\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\u00070\u0006`\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000eR\u0011\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R-\u0010\u0016\u001a\u001e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00170\u0005j\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0017`\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u000e\u00a8\u0006\u001f"}, d2={"Lphonon/puppet/animation/AnimationTrack;", "", "name", "", "keyframesPosition", "Ljava/util/HashMap;", "", "Lphonon/puppet/animation/Keyframe;", "Lphonon/puppet/math/Vector3f;", "Lkotlin/collections/HashMap;", "keyframesQuaternion", "Lphonon/puppet/math/Quaternion;", "(Ljava/lang/String;Ljava/util/HashMap;Ljava/util/HashMap;)V", "getKeyframesPosition", "()Ljava/util/HashMap;", "getKeyframesQuaternion", "length", "", "getLength", "()I", "getName", "()Ljava/lang/String;", "transformTracks", "Lphonon/puppet/animation/TransformTrack;", "getTransformTracks", "writeIntoPositionQuaternion", "", "tick", "position", "quaternion", "Companion", "phonon-puppet"})
public final class AnimationTrack {
    @NotNull
    private final HashMap<String, TransformTrack> transformTracks;
    private final int length;
    @NotNull
    private final String name;
    @NotNull
    private final HashMap<String, List<Keyframe<Vector3f>>> keyframesPosition;
    @NotNull
    private final HashMap<String, List<Keyframe<Quaternion>>> keyframesQuaternion;
    @NotNull
    private static final HashMap<String, AnimationTrack> library;
    public static final Companion Companion;

    @NotNull
    public final HashMap<String, TransformTrack> getTransformTracks() {
        return this.transformTracks;
    }

    public final int getLength() {
        return this.length;
    }

    public final boolean writeIntoPositionQuaternion(@NotNull String name, int tick, @NotNull Vector3f position, @NotNull Quaternion quaternion) {
        int index;
        Intrinsics.checkParameterIsNotNull(name, "name");
        Intrinsics.checkParameterIsNotNull(position, "position");
        Intrinsics.checkParameterIsNotNull(quaternion, "quaternion");
        TransformTrack dataTrack = this.transformTracks.get(name);
        if (dataTrack == null) {
            return false;
        }
        float[] positionTrack = dataTrack.getPosition();
        float[] quaternionTrack = dataTrack.getQuaternion();
        if (positionTrack != null) {
            index = tick * 3;
            position.setX(positionTrack[index]);
            position.setY(positionTrack[index + 1]);
            position.setZ(positionTrack[index + 2]);
        }
        if (quaternionTrack != null) {
            index = tick * 4;
            quaternion.setX(quaternionTrack[index]);
            quaternion.setY(quaternionTrack[index + 1]);
            quaternion.setZ(quaternionTrack[index + 2]);
            quaternion.setW(quaternionTrack[index + 3]);
        }
        return true;
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    @NotNull
    public final HashMap<String, List<Keyframe<Vector3f>>> getKeyframesPosition() {
        return this.keyframesPosition;
    }

    @NotNull
    public final HashMap<String, List<Keyframe<Quaternion>>> getKeyframesQuaternion() {
        return this.keyframesQuaternion;
    }

    /*
     * WARNING - void declaration
     */
    public AnimationTrack(@NotNull String name, @NotNull HashMap<String, List<Keyframe<Vector3f>>> keyframesPosition, @NotNull HashMap<String, List<Keyframe<Quaternion>>> keyframesQuaternion) {
        List<Keyframe<Object>> keyframeQuaternionList;
        Intrinsics.checkParameterIsNotNull(name, "name");
        Intrinsics.checkParameterIsNotNull(keyframesPosition, "keyframesPosition");
        Intrinsics.checkParameterIsNotNull(keyframesQuaternion, "keyframesQuaternion");
        this.name = name;
        this.keyframesPosition = keyframesPosition;
        this.keyframesQuaternion = keyframesQuaternion;
        AnimationTrack animationTrack = this;
        boolean bl = false;
        HashMap hashMap = new HashMap();
        animationTrack.transformTracks = hashMap;
        Set<String> set = this.keyframesPosition.keySet();
        Intrinsics.checkExpressionValueIsNotNull(set, "this.keyframesPosition.keys");
        Set<String> set2 = this.keyframesQuaternion.keySet();
        Intrinsics.checkExpressionValueIsNotNull(set2, "this.keyframesQuaternion.keys");
        Set<String> bonesToTransform = SetsKt.plus(set, (Iterable)set2);
        int firstKeyframeTick = 0;
        int lastKeyframeTick = 0;
        for (String boneName : bonesToTransform) {
            Keyframe lastKeyframe;
            List<Keyframe<Vector3f>> keyframePositionList = this.keyframesPosition.get(boneName);
            if (keyframePositionList != null) {
                Keyframe lastKeyframe2;
                Iterable $this$sortedBy$iv = keyframePositionList;
                boolean $i$f$sortedBy = false;
                Iterable iterable = $this$sortedBy$iv;
                boolean bl2 = false;
                Comparator comparator = new Comparator<T>(){

                    public final int compare(T a, T b) {
                        boolean bl = false;
                        Keyframe it = (Keyframe)a;
                        boolean bl2 = false;
                        Comparable comparable = Integer.valueOf(it.getTick());
                        it = (Keyframe)b;
                        Comparable comparable2 = comparable;
                        bl2 = false;
                        Integer n = it.getTick();
                        return ComparisonsKt.compareValues(comparable2, (Comparable)n);
                    }
                };
                List sortedKeyframeList = CollectionsKt.sortedWith(iterable, comparator);
                this.keyframesPosition.put(boneName, sortedKeyframeList);
                Keyframe firstKeyframe = (Keyframe)CollectionsKt.firstOrNull(sortedKeyframeList);
                if (firstKeyframe != null) {
                    int n = firstKeyframeTick = firstKeyframe.getTick() < firstKeyframeTick ? firstKeyframe.getTick() : firstKeyframeTick;
                }
                if ((lastKeyframe2 = (Keyframe)CollectionsKt.lastOrNull(sortedKeyframeList)) != null) {
                    int n = lastKeyframeTick = lastKeyframe2.getTick() > lastKeyframeTick ? lastKeyframe2.getTick() : lastKeyframeTick;
                }
            }
            if ((keyframeQuaternionList = this.keyframesQuaternion.get(boneName)) == null) continue;
            Iterable $this$sortedBy$iv = keyframeQuaternionList;
            boolean $i$f$sortedBy = false;
            Iterable iterable = $this$sortedBy$iv;
            boolean bl3 = false;
            Comparator comparator = new Comparator<T>(){

                public final int compare(T a, T b) {
                    boolean bl = false;
                    Keyframe it = (Keyframe)a;
                    boolean bl2 = false;
                    Comparable comparable = Integer.valueOf(it.getTick());
                    it = (Keyframe)b;
                    Comparable comparable2 = comparable;
                    bl2 = false;
                    Integer n = it.getTick();
                    return ComparisonsKt.compareValues(comparable2, (Comparable)n);
                }
            };
            List sortedKeyframeList = CollectionsKt.sortedWith(iterable, comparator);
            this.keyframesQuaternion.put(boneName, sortedKeyframeList);
            Keyframe firstKeyframe = (Keyframe)CollectionsKt.firstOrNull(sortedKeyframeList);
            if (firstKeyframe != null) {
                int n = firstKeyframeTick = firstKeyframe.getTick() < firstKeyframeTick ? firstKeyframe.getTick() : firstKeyframeTick;
            }
            if ((lastKeyframe = (Keyframe)CollectionsKt.lastOrNull(sortedKeyframeList)) == null) continue;
            lastKeyframeTick = lastKeyframe.getTick() > lastKeyframeTick ? lastKeyframe.getTick() : lastKeyframeTick;
        }
        this.length = 1 + lastKeyframeTick - firstKeyframeTick;
        for (String boneName : bonesToTransform) {
            float[] fArray;
            float[] positionTrack;
            float[] fArray2;
            int n;
            int n2;
            boolean bl4;
            if (this.keyframesPosition.get(boneName) != null) {
                boolean bl5 = false;
                bl4 = false;
                List<Keyframe<Object>> keyframeList = keyframeQuaternionList;
                boolean bl6 = false;
                int n3 = this.length * 3;
                float[] fArray3 = new float[n3];
                int n4 = 0;
                while (n4 < n3) {
                    float f;
                    n2 = n4;
                    n = n4++;
                    float[] fArray4 = fArray3;
                    boolean bl7 = false;
                    fArray4[n] = f = 0.0f;
                }
                float[] buffer = fArray3;
                List<Keyframe<Object>> list = keyframeList;
                Intrinsics.checkExpressionValueIsNotNull(list, "keyframeList");
                AnimationTrackKt.access$sampleVectorKeyframesIntoBuffer(list, buffer, this.length);
                fArray2 = buffer;
            } else {
                fArray2 = positionTrack = null;
            }
            if (this.keyframesQuaternion.get(boneName) != null) {
                List<Keyframe<Quaternion>> list;
                bl4 = false;
                boolean bl8 = false;
                List<Keyframe<Quaternion>> keyframeList = list;
                boolean bl9 = false;
                int n5 = this.length * 4;
                float[] fArray5 = new float[n5];
                for (n2 = 0; n2 < n5; ++n2) {
                    void i;
                    float f;
                    n = n2;
                    int n6 = n2;
                    float[] fArray6 = fArray5;
                    boolean bl10 = false;
                    fArray6[n6] = f = (i + true) % 4 == false ? 1.0f : 0.0f;
                }
                float[] buffer = fArray5;
                List<Keyframe<Quaternion>> list2 = keyframeList;
                Intrinsics.checkExpressionValueIsNotNull(list2, "keyframeList");
                AnimationTrackKt.access$sampleQuaternionKeyframesIntoBuffer(list2, buffer, this.length);
                fArray = buffer;
            } else {
                fArray = null;
            }
            float[] quaternionTrack = fArray;
            this.transformTracks.put(boneName, new TransformTrack(positionTrack, quaternionTrack));
        }
    }

    static {
        Companion = new Companion(null);
        boolean bl = false;
        library = new HashMap();
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\n\u001a\u00020\u000bJ\u0010\u0010\f\u001a\u0004\u0018\u00010\u00062\u0006\u0010\r\u001a\u00020\u0005J\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00050\u000fJ\u000e\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u0006R-\u0010\u0003\u001a\u001e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004j\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0006`\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0012"}, d2={"Lphonon/puppet/animation/AnimationTrack$Companion;", "", "()V", "library", "Ljava/util/HashMap;", "", "Lphonon/puppet/animation/AnimationTrack;", "Lkotlin/collections/HashMap;", "getLibrary", "()Ljava/util/HashMap;", "clear", "", "get", "name", "list", "", "save", "animTrack", "phonon-puppet"})
    public static final class Companion {
        @NotNull
        public final HashMap<String, AnimationTrack> getLibrary() {
            return library;
        }

        public final void save(@NotNull AnimationTrack animTrack) {
            Intrinsics.checkParameterIsNotNull(animTrack, "animTrack");
            Companion.getLibrary().put(animTrack.getName(), animTrack);
        }

        public final void clear() {
            Companion.getLibrary().clear();
        }

        @Nullable
        public final AnimationTrack get(@NotNull String name) {
            Intrinsics.checkParameterIsNotNull(name, "name");
            return Companion.getLibrary().get(name);
        }

        @NotNull
        public final List<String> list() {
            Set<String> set = Companion.getLibrary().keySet();
            Intrinsics.checkExpressionValueIsNotNull(set, "AnimationTrack.library.keys");
            return CollectionsKt.toList((Iterable)set);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

