/*
 * Decompiled with CFR 0.152.
 */
package phonon.puppet.animation;

import java.util.HashMap;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import phonon.puppet.animation.AnimationAction;
import phonon.puppet.animation.AnimationTrack;
import phonon.puppet.objects.Bone;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\f\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J.\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\u0016\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u0018J\u000e\u0010\u0019\u001a\u00020\u00112\u0006\u0010\u001a\u001a\u00020\u0004J\u0006\u0010\u001b\u001a\u00020\u0011J\u0016\u0010\u001c\u001a\u00020\u00112\u0006\u0010\u001d\u001a\u00020\u000b2\u0006\u0010\u001e\u001a\u00020\u0014J\u0006\u0010\u001f\u001a\u00020\u0011J\u000e\u0010 \u001a\u00020\u00112\u0006\u0010\u001d\u001a\u00020\u000bJ\u0006\u0010!\u001a\u00020\u0011J\u0006\u0010\"\u001a\u00020\u0011J\u0014\u0010#\u001a\u00020\u00112\f\u0010$\u001a\b\u0012\u0004\u0012\u00020&0%R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR-\u0010\t\u001a\u001e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\nj\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f`\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006'"}, d2={"Lphonon/puppet/animation/AnimationMixer;", "", "()V", "enabled", "", "getEnabled", "()Z", "setEnabled", "(Z)V", "playing", "Ljava/util/HashMap;", "", "Lphonon/puppet/animation/AnimationAction;", "Lkotlin/collections/HashMap;", "getPlaying", "()Ljava/util/HashMap;", "crossfade", "", "oldAnim", "oldWeight", "", "newAnim", "newWeight", "ticks", "", "enable", "flag", "normalizeAnimationWeights", "play", "name", "weight", "restart", "stop", "stopAll", "update", "writeBoneTransforms", "bones", "", "Lphonon/puppet/objects/Bone;", "phonon-puppet"})
public final class AnimationMixer {
    @NotNull
    private final HashMap<String, AnimationAction> playing;
    private boolean enabled;

    @NotNull
    public final HashMap<String, AnimationAction> getPlaying() {
        return this.playing;
    }

    public final boolean getEnabled() {
        return this.enabled;
    }

    public final void setEnabled(boolean bl) {
        this.enabled = bl;
    }

    public final void enable(boolean flag) {
        this.enabled = flag;
    }

    public final void play(@NotNull String name, double weight) {
        block0: {
            Intrinsics.checkParameterIsNotNull(name, "name");
            AnimationTrack animationTrack = AnimationTrack.Companion.get(name);
            if (animationTrack == null) break block0;
            AnimationTrack animationTrack2 = animationTrack;
            boolean bl = false;
            boolean bl2 = false;
            AnimationTrack track2 = animationTrack2;
            boolean bl3 = false;
            this.playing.put(name, new AnimationAction(track2, 0, weight));
        }
    }

    public final void stop(@NotNull String name) {
        Intrinsics.checkParameterIsNotNull(name, "name");
        this.playing.remove(name);
    }

    public final void stopAll() {
        this.playing.clear();
    }

    public final void restart() {
        for (AnimationAction anim : this.playing.values()) {
            anim.setTick(0);
        }
    }

    public final void crossfade(@NotNull String oldAnim, double oldWeight, @NotNull String newAnim, double newWeight, long ticks) {
        Intrinsics.checkParameterIsNotNull(oldAnim, "oldAnim");
        Intrinsics.checkParameterIsNotNull(newAnim, "newAnim");
    }

    public final void normalizeAnimationWeights() {
        double sum = 0.0;
        for (AnimationAction anim : this.playing.values()) {
            sum += anim.getWeight();
        }
        for (AnimationAction anim : this.playing.values()) {
            anim.setWeight(anim.getWeight() / sum);
        }
    }

    public final void update() {
        for (AnimationAction action : this.playing.values()) {
            if (!action.getEnabled()) continue;
            action.update();
        }
    }

    public final void writeBoneTransforms(@NotNull Iterable<Bone> bones) {
        Intrinsics.checkParameterIsNotNull(bones, "bones");
        for (AnimationAction action : this.playing.values()) {
            if (!action.getBonesNeedUpdate()) continue;
            for (Bone bone : bones) {
                boolean result = action.writeIntoPositionQuaternion(bone.getName(), bone.getPosition(), bone.getQuaternion());
                if (!result) continue;
                bone.getPosition().addVectors(bone.getBindPosition(), bone.getPosition());
                bone.getQuaternion().premultiply(bone.getBindQuaternion());
                bone.getRotation().setFromQuaternion(bone.getQuaternion(), bone.getRotation().getOrder());
            }
            action.setBonesNeedUpdate(false);
        }
    }

    public AnimationMixer() {
        AnimationMixer animationMixer = this;
        boolean bl = false;
        HashMap hashMap = new HashMap();
        animationMixer.playing = hashMap;
        this.enabled = true;
    }
}

