/*
 * Decompiled with CFR 0.152.
 */
package phonon.puppet;

import java.io.File;
import java.util.logging.Logger;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.PluginCommand;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.java.JavaPlugin;
import phonon.puppet.Config;
import phonon.puppet.Puppet;
import phonon.puppet.animation.AnimationTrack;
import phonon.puppet.commands.ActorCommand;
import phonon.puppet.commands.PuppetCommand;
import phonon.puppet.listeners.EntityDamageListener;
import phonon.puppet.listeners.PlayerMoveListener;
import phonon.puppet.objects.Mesh;
import phonon.puppet.objects.Skeleton;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0003\u001a\u00020\u0004J\b\u0010\u0005\u001a\u00020\u0004H\u0016J\b\u0010\u0006\u001a\u00020\u0004H\u0016\u00a8\u0006\u0007"}, d2={"Lphonon/puppet/PuppetPlugin;", "Lorg/bukkit/plugin/java/JavaPlugin;", "()V", "loadConfig", "", "onDisable", "onEnable", "phonon-puppet"})
public final class PuppetPlugin
extends JavaPlugin {
    public void onEnable() {
        long timeStart = System.currentTimeMillis();
        Logger logger = this.getLogger();
        Intrinsics.checkExpressionValueIsNotNull(logger, "this.getLogger()");
        Logger logger2 = logger;
        this.loadConfig();
        Puppet.INSTANCE.initialize(this);
        if (Config.INSTANCE.getAutoStartEngine()) {
            Puppet.INSTANCE.startEngine();
        }
        PluginManager pluginManager = this.getServer().getPluginManager();
        Intrinsics.checkExpressionValueIsNotNull(pluginManager, "this.getServer().getPluginManager()");
        PluginManager pm = pluginManager;
        pm.registerEvents((Listener)new EntityDamageListener(), (Plugin)this);
        pm.registerEvents((Listener)new PlayerMoveListener(), (Plugin)this);
        PluginCommand pluginCommand = this.getCommand("actor");
        if (pluginCommand != null) {
            pluginCommand.setExecutor((CommandExecutor)new ActorCommand());
        }
        PluginCommand pluginCommand2 = this.getCommand("puppet");
        if (pluginCommand2 != null) {
            pluginCommand2.setExecutor((CommandExecutor)new PuppetCommand());
        }
        logger2.info("Loaded:");
        logger2.info("- Models: " + Mesh.Companion.getLibrary().size());
        logger2.info("- Skeletons: " + Skeleton.Companion.getLibrary().size());
        logger2.info("- Animations: " + AnimationTrack.Companion.getLibrary().size());
        long timeEnd = System.currentTimeMillis();
        long timeLoad = timeEnd - timeStart;
        logger2.info("Enabled in " + timeLoad + "ms");
        logger2.info("now this is epic");
    }

    public void onDisable() {
        this.getLogger().info("wtf i hate puppet now");
    }

    public final void loadConfig() {
        Logger logger = this.getLogger();
        Intrinsics.checkExpressionValueIsNotNull(logger, "this.getLogger()");
        Logger logger2 = logger;
        File configPath = new File(this.getDataFolder().getPath(), "config.yml");
        if (!configPath.exists()) {
            logger2.info("No config found: generating default config.yml");
            this.saveDefaultConfig();
        }
        FileConfiguration fileConfiguration = this.getConfig();
        Intrinsics.checkExpressionValueIsNotNull(fileConfiguration, "this.getConfig()");
        FileConfiguration config = fileConfiguration;
        if (config != null) {
            Config.INSTANCE.load(config);
        }
    }
}

