/*
 * Decompiled with CFR 0.152.
 */
package phonon.puppet;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.logging.Logger;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitScheduler;
import org.bukkit.scheduler.BukkitTask;
import org.bukkit.util.RayTraceResult;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import phonon.puppet.Message;
import phonon.puppet.Puppet;
import phonon.puppet.Puppet$sam$java_util_function_Predicate$0;
import phonon.puppet.PuppetPlugin;
import phonon.puppet.animation.AnimationTrack;
import phonon.puppet.math.Vector3f;
import phonon.puppet.objects.Actor;
import phonon.puppet.objects.ActorPrototype;
import phonon.puppet.objects.Bone;
import phonon.puppet.objects.Mesh;
import phonon.puppet.objects.Skeleton;
import phonon.puppet.objects.TransformGraphNode;
import phonon.puppet.resourcepack.ModelData;
import phonon.puppet.resourcepack.Resource;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u00a6\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u00102\u001a\u0002032\u0006\u00104\u001a\u00020+J$\u00105\u001a\b\u0012\u0004\u0012\u00020\b062\u0006\u00107\u001a\u00020\u00072\u0006\u00108\u001a\u000209\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010:J$\u0010;\u001a\b\u0012\u0004\u0012\u00020\b062\u0006\u0010<\u001a\u00020\u00072\u0006\u00108\u001a\u000209\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010:J\u000e\u0010=\u001a\u0002032\u0006\u0010>\u001a\u00020\bJ\u0006\u0010?\u001a\u000203J\u000e\u0010@\u001a\u00020\u00072\u0006\u00107\u001a\u00020\u0007J\u0010\u0010A\u001a\u0004\u0018\u00010\b2\u0006\u0010B\u001a\u00020\u0007J\u0010\u0010C\u001a\u0004\u0018\u00010\b2\u0006\u0010D\u001a\u00020\rJ\u0010\u0010E\u001a\u0004\u0018\u00010\b2\u0006\u0010F\u001a\u00020\u0011J\f\u0010G\u001a\b\u0012\u0004\u0012\u00020\u00070HJ\u001a\u0010I\u001a\u0004\u0018\u00010\b2\u0006\u0010J\u001a\u00020!2\b\b\u0002\u0010K\u001a\u00020LJ\u000e\u0010M\u001a\u0002032\u0006\u0010#\u001a\u00020$J\u0010\u0010N\u001a\u0002032\b\b\u0002\u0010O\u001a\u00020\u0016J\u000e\u0010P\u001a\u0002032\u0006\u0010Q\u001a\u00020RJ\u000e\u0010S\u001a\u0002032\u0006\u0010>\u001a\u00020\bJ\u000e\u0010T\u001a\u0002032\u0006\u00104\u001a\u00020+J\u0006\u0010U\u001a\u000203J\u0006\u0010V\u001a\u000203J\u0006\u0010W\u001a\u000203J\u0006\u0010X\u001a\u000203J\u0016\u0010Y\u001a\u0002032\u0006\u0010Z\u001a\u00020[2\u0006\u0010\\\u001a\u00020\u0016R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R-\u0010\u0005\u001a\u001e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006j\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b`\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR-\u0010\f\u001a\u001e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\b0\u0006j\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\b`\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000bR-\u0010\u000f\u001a\u001e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\b0\u0010j\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\b`\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u001a\u0010\u0015\u001a\u00020\u0016X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u001c\u0010\u001a\u001a\u0004\u0018\u00010\u001bX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001fR-\u0010 \u001a\u001e\u0012\u0004\u0012\u00020!\u0012\u0004\u0012\u00020\b0\u0010j\u000e\u0012\u0004\u0012\u00020!\u0012\u0004\u0012\u00020\b`\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010\u0014R\u001c\u0010#\u001a\u0004\u0018\u00010$X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b%\u0010&\"\u0004\b'\u0010(R!\u0010)\u001a\u0012\u0012\u0004\u0012\u00020+0*j\b\u0012\u0004\u0012\u00020+`,\u00a2\u0006\b\n\u0000\u001a\u0004\b-\u0010.R\u0014\u0010/\u001a\u00020\u0007X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b0\u00101\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006]"}, d2={"Lphonon/puppet/Puppet;", "", "()V", "_task", "Lorg/bukkit/scheduler/BukkitTask;", "actors", "Ljava/util/LinkedHashMap;", "", "Lphonon/puppet/objects/Actor;", "Lkotlin/collections/LinkedHashMap;", "getActors", "()Ljava/util/LinkedHashMap;", "actorsById", "Ljava/util/UUID;", "getActorsById", "entityToActor", "Ljava/util/HashMap;", "Lorg/bukkit/entity/Entity;", "Lkotlin/collections/HashMap;", "getEntityToActor", "()Ljava/util/HashMap;", "isRunning", "", "()Z", "setRunning", "(Z)V", "logger", "Ljava/util/logging/Logger;", "getLogger$phonon_puppet", "()Ljava/util/logging/Logger;", "setLogger$phonon_puppet", "(Ljava/util/logging/Logger;)V", "playerPosingActor", "Lorg/bukkit/entity/Player;", "getPlayerPosingActor", "plugin", "Lphonon/puppet/PuppetPlugin;", "getPlugin$phonon_puppet", "()Lphonon/puppet/PuppetPlugin;", "setPlugin$phonon_puppet", "(Lphonon/puppet/PuppetPlugin;)V", "renderable", "Ljava/util/ArrayList;", "Lphonon/puppet/objects/Mesh;", "Lkotlin/collections/ArrayList;", "getRenderable", "()Ljava/util/ArrayList;", "version", "getVersion", "()Ljava/lang/String;", "addRenderable", "", "mesh", "createActorAtLocation", "Lkotlin/Result;", "type", "location", "Lorg/bukkit/Location;", "(Ljava/lang/String;Lorg/bukkit/Location;)Ljava/lang/Object;", "createMeshAtLocation", "meshType", "destroyActor", "actor", "destroyAllActors", "generateActorName", "getActor", "name", "getActorById", "uuid", "getActorFromEntity", "entity", "getActorNames", "", "getActorPlayerIsLookingAt", "player", "maxDistance", "", "initialize", "loadResources", "cleanExisting", "printInfo", "target", "Lorg/bukkit/command/CommandSender;", "registerActor", "removeRenderable", "render", "startEngine", "stepEngine", "stopEngine", "toggleArmorStands", "root", "Lphonon/puppet/objects/TransformGraphNode;", "visible", "phonon-puppet"})
public final class Puppet {
    @NotNull
    private static final String version = "0.1.0";
    @Nullable
    private static PuppetPlugin plugin;
    @Nullable
    private static Logger logger;
    private static BukkitTask _task;
    private static boolean isRunning;
    @NotNull
    private static final LinkedHashMap<String, Actor> actors;
    @NotNull
    private static final LinkedHashMap<UUID, Actor> actorsById;
    @NotNull
    private static final HashMap<Entity, Actor> entityToActor;
    @NotNull
    private static final ArrayList<Mesh> renderable;
    @NotNull
    private static final HashMap<Player, Actor> playerPosingActor;
    public static final Puppet INSTANCE;

    @NotNull
    public final String getVersion() {
        return version;
    }

    @Nullable
    public final PuppetPlugin getPlugin$phonon_puppet() {
        return plugin;
    }

    public final void setPlugin$phonon_puppet(@Nullable PuppetPlugin puppetPlugin) {
        plugin = puppetPlugin;
    }

    @Nullable
    public final Logger getLogger$phonon_puppet() {
        return logger;
    }

    public final void setLogger$phonon_puppet(@Nullable Logger logger) {
        Puppet.logger = logger;
    }

    public final boolean isRunning() {
        return isRunning;
    }

    public final void setRunning(boolean bl) {
        isRunning = bl;
    }

    @NotNull
    public final LinkedHashMap<String, Actor> getActors() {
        return actors;
    }

    @NotNull
    public final LinkedHashMap<UUID, Actor> getActorsById() {
        return actorsById;
    }

    @NotNull
    public final HashMap<Entity, Actor> getEntityToActor() {
        return entityToActor;
    }

    @NotNull
    public final ArrayList<Mesh> getRenderable() {
        return renderable;
    }

    @NotNull
    public final HashMap<Player, Actor> getPlayerPosingActor() {
        return playerPosingActor;
    }

    public final void initialize(@NotNull PuppetPlugin plugin) {
        Intrinsics.checkParameterIsNotNull((Object)plugin, "plugin");
        Puppet.plugin = plugin;
        logger = plugin.getLogger();
        INSTANCE.loadResources(false);
    }

    /*
     * WARNING - void declaration
     */
    public final void loadResources(boolean cleanExisting) {
        void skeletons;
        void customModelData;
        if (cleanExisting) {
            Mesh.Companion.clear();
            Skeleton.Companion.clear();
            Actor.Companion.clear();
            AnimationTrack.Companion.clear();
        }
        Resource.INSTANCE.initialize();
        ModelData modelData = Resource.INSTANCE.load();
        List<String> list = modelData.component1();
        List<Skeleton> list2 = modelData.component2();
        List<AnimationTrack> animations = modelData.component3();
        Mesh.Companion.loadCustomModelData((List<String>)customModelData);
        for (Skeleton skeleton : skeletons) {
            Skeleton.Companion.save(skeleton);
            ActorPrototype actorType = new ActorPrototype(skeleton.getName(), skeleton.getName());
            Actor.Companion.save(skeleton.getName(), actorType);
        }
        for (AnimationTrack animTrack : animations) {
            AnimationTrack.Companion.save(animTrack);
        }
    }

    public static /* synthetic */ void loadResources$default(Puppet puppet, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = true;
        }
        puppet.loadResources(bl);
    }

    public final void printInfo(@NotNull CommandSender target) {
        Intrinsics.checkParameterIsNotNull(target, "target");
        Message.INSTANCE.print(target, ChatColor.BOLD + "Puppet Animation Engine v" + version);
        Message.INSTANCE.print(target, "Library:");
        Message.INSTANCE.print(target, "- Models: " + Mesh.Companion.getLibrary().size());
        Message.INSTANCE.print(target, "- Skeletons: " + Skeleton.Companion.getLibrary().size());
        Message.INSTANCE.print(target, "- Animations: " + AnimationTrack.Companion.getLibrary().size());
    }

    @NotNull
    public final Object createMeshAtLocation(@NotNull String meshType, @NotNull Location location) {
        Intrinsics.checkParameterIsNotNull(meshType, "meshType");
        Intrinsics.checkParameterIsNotNull(location, "location");
        if (!Mesh.Companion.has(meshType)) {
            Result.Companion companion = Result.Companion;
            Throwable throwable = new Exception("Mesh type does not exist");
            boolean bl = false;
            return Result.constructor-impl(ResultKt.createFailure(throwable));
        }
        String actorName = INSTANCE.generateActorName(meshType);
        Actor actor = new Actor.Builder().name(actorName).position(location.getX(), location.getY(), location.getZ()).build();
        Mesh mesh = new Mesh.Builder().name("mesh").model(meshType).position(0.0, 0.0, 0.0).rotation(0.0, 0.0, 0.0).build();
        actor.add(mesh);
        actor.updateTransform();
        actor.render();
        INSTANCE.registerActor(actor);
        Result.Companion companion = Result.Companion;
        boolean bl = false;
        return Result.constructor-impl(actor);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Object createActorAtLocation(@NotNull String type, @NotNull Location location) {
        void modelName;
        Intrinsics.checkParameterIsNotNull(type, "type");
        Intrinsics.checkParameterIsNotNull(location, "location");
        ActorPrototype actorType = Actor.Companion.get(type);
        if (actorType == null) {
            Result.Companion companion = Result.Companion;
            Throwable throwable = new Exception("Skeleton does not exist");
            boolean bl = false;
            return Result.constructor-impl(ResultKt.createFailure(throwable));
        }
        ActorPrototype actorPrototype = actorType;
        String string = actorPrototype.component1();
        String skeletonName = actorPrototype.component2();
        Skeleton skeleton = Skeleton.Companion.create(skeletonName);
        if (skeleton == null) {
            Result.Companion companion = Result.Companion;
            Throwable throwable = new Exception("Skeleton does not exist");
            boolean bl = false;
            return Result.constructor-impl(ResultKt.createFailure(throwable));
        }
        String actorName = INSTANCE.generateActorName(type);
        Actor actor = new Actor.Builder().name(actorName).skeleton(skeleton).position(location.getX(), location.getY(), location.getZ()).build();
        Function1<Bone, Unit> $fun$linkMeshToBone$1 = new Function1<Bone, Unit>((String)modelName, actor){
            final /* synthetic */ String $modelName;
            final /* synthetic */ Actor $actor;

            public final void invoke(@NotNull Bone bone) {
                Intrinsics.checkParameterIsNotNull(bone, "bone");
                for (TransformGraphNode child : bone.getChildren()) {
                    if (!(child instanceof Bone)) continue;
                    this.invoke((Bone)child);
                }
                String meshName = this.$modelName + '.' + bone.getName();
                Integer customModelData = Mesh.Companion.get(meshName);
                if (customModelData != null) {
                    Vector3f boneWorldPosition = bone.getWorldMatrix().getTranslation();
                    Mesh mesh = new Mesh.Builder().name(meshName).customModelData(customModelData).position(boneWorldPosition.getX(), boneWorldPosition.getY(), boneWorldPosition.getZ()).build();
                    this.$actor.add(mesh);
                    bone.setMesh(mesh);
                }
            }
            {
                this.$modelName = string;
                this.$actor = actor;
                super(1);
            }
        };
        $fun$linkMeshToBone$1.invoke(skeleton.getRoot());
        actor.updateTransform();
        actor.render();
        INSTANCE.registerActor(actor);
        Result.Companion companion = Result.Companion;
        boolean bl = false;
        return Result.constructor-impl(actor);
    }

    public final void registerActor(@NotNull Actor actor) {
        Intrinsics.checkParameterIsNotNull(actor, "actor");
        actors.put(actor.getName(), actor);
        actorsById.put(actor.getUuid(), actor);
        actor.traverse((Function1<? super TransformGraphNode, Unit>)new Function1<TransformGraphNode, Unit>(actor){
            final /* synthetic */ Actor $actor;

            public final void invoke(@NotNull TransformGraphNode obj) {
                Intrinsics.checkParameterIsNotNull(obj, "obj");
                if (obj instanceof Mesh) {
                    Puppet.INSTANCE.getRenderable().add((Mesh)obj);
                    Puppet.INSTANCE.getEntityToActor().put((Entity)((Mesh)obj).getArmorStand(), this.$actor);
                }
            }
            {
                this.$actor = actor;
                super(1);
            }
        });
    }

    public final void destroyActor(@NotNull Actor actor) {
        Intrinsics.checkParameterIsNotNull(actor, "actor");
        actor.traverse((Function1<? super TransformGraphNode, Unit>)new Function1<TransformGraphNode, Unit>(actor){
            final /* synthetic */ Actor $actor;

            public final void invoke(@NotNull TransformGraphNode obj) {
                Intrinsics.checkParameterIsNotNull(obj, "obj");
                if (obj instanceof Mesh) {
                    ((Mesh)obj).getArmorStand().remove();
                    Puppet.INSTANCE.getRenderable().remove(obj);
                    Puppet.INSTANCE.getEntityToActor().remove(((Mesh)obj).getArmorStand(), this.$actor);
                }
            }
            {
                this.$actor = actor;
                super(1);
            }
        });
        actors.remove(actor.getName());
        actorsById.remove(actor.getUuid());
        Set<Map.Entry<Player, Actor>> set = playerPosingActor.entrySet();
        Intrinsics.checkExpressionValueIsNotNull(set, "Puppet.playerPosingActor.entries");
        Iterator iterator2 = CollectionsKt.toList((Iterable)set).iterator();
        while (iterator2.hasNext()) {
            Map.Entry entry;
            Map.Entry entry2 = entry = (Map.Entry)iterator2.next();
            boolean bl = false;
            Player player = (Player)entry2.getKey();
            entry2 = entry;
            bl = false;
            Actor posingActor = (Actor)entry2.getValue();
            if (posingActor != actor) continue;
            playerPosingActor.remove(player);
            break;
        }
    }

    public final void destroyAllActors() {
        Collection<Actor> collection = actors.values();
        Intrinsics.checkExpressionValueIsNotNull(collection, "Puppet.actors.values");
        List actors = CollectionsKt.toList((Iterable)collection);
        Iterator iterator2 = actors.iterator();
        while (iterator2.hasNext()) {
            Actor a;
            Actor actor = a = (Actor)iterator2.next();
            Intrinsics.checkExpressionValueIsNotNull(actor, "a");
            INSTANCE.destroyActor(actor);
        }
    }

    @NotNull
    public final List<String> getActorNames() {
        Set<String> set = actors.keySet();
        Intrinsics.checkExpressionValueIsNotNull(set, "Puppet.actors.keys");
        return CollectionsKt.toList((Iterable)set);
    }

    @Nullable
    public final Actor getActor(@NotNull String name) {
        Intrinsics.checkParameterIsNotNull(name, "name");
        return actors.get(name);
    }

    @Nullable
    public final Actor getActorById(@NotNull UUID uuid) {
        Intrinsics.checkParameterIsNotNull(uuid, "uuid");
        return actorsById.get(uuid);
    }

    @Nullable
    public final Actor getActorFromEntity(@NotNull Entity entity) {
        Intrinsics.checkParameterIsNotNull(entity, "entity");
        return entityToActor.get(entity);
    }

    @Nullable
    public final Actor getActorPlayerIsLookingAt(@NotNull Player player, double maxDistance) {
        Entity entityHit;
        RayTraceResult raytraceResult;
        Intrinsics.checkParameterIsNotNull(player, "player");
        Location location = player.getEyeLocation();
        Intrinsics.checkExpressionValueIsNotNull(location, "player.getEyeLocation()");
        Location start = location;
        Vector vector = start.getDirection();
        Intrinsics.checkExpressionValueIsNotNull(vector, "start.direction");
        Vector direction = vector;
        double raySize = 0.0;
        Function1 filter2 = getActorPlayerIsLookingAt.filter.1.INSTANCE;
        World world = player.getWorld();
        Object object = filter2;
        if (object != null) {
            Function1 function1 = object;
            object = new Puppet$sam$java_util_function_Predicate$0(function1);
        }
        RayTraceResult rayTraceResult = raytraceResult = world.rayTraceEntities(start, direction, maxDistance, raySize, (Predicate)object);
        Object object2 = entityHit = rayTraceResult != null ? rayTraceResult.getHitEntity() : null;
        if (entityHit != null) {
            return INSTANCE.getActorFromEntity(entityHit);
        }
        return null;
    }

    public static /* synthetic */ Actor getActorPlayerIsLookingAt$default(Puppet puppet, Player player, double d, int n, Object object) {
        if ((n & 2) != 0) {
            d = 10.0;
        }
        return puppet.getActorPlayerIsLookingAt(player, d);
    }

    public final void toggleArmorStands(@NotNull TransformGraphNode root, boolean visible) {
        Intrinsics.checkParameterIsNotNull(root, "root");
        root.traverse((Function1<? super TransformGraphNode, Unit>)new Function1<TransformGraphNode, Unit>(visible){
            final /* synthetic */ boolean $visible;

            public final void invoke(@NotNull TransformGraphNode obj) {
                Intrinsics.checkParameterIsNotNull(obj, "obj");
                if (obj instanceof Mesh) {
                    ((Mesh)obj).getArmorStand().setVisible(this.$visible);
                }
            }
            {
                this.$visible = bl;
                super(1);
            }
        });
    }

    @NotNull
    public final String generateActorName(@NotNull String type) {
        Intrinsics.checkParameterIsNotNull(type, "type");
        int i = 0;
        String name = type + i;
        while (true) {
            Map map = actors;
            boolean bl = false;
            Map map2 = map;
            boolean bl2 = false;
            if (!map2.containsKey(name)) break;
            name = type + ++i;
        }
        return name;
    }

    public final void addRenderable(@NotNull Mesh mesh) {
        Intrinsics.checkParameterIsNotNull(mesh, "mesh");
        renderable.add(mesh);
    }

    public final void removeRenderable(@NotNull Mesh mesh) {
        Intrinsics.checkParameterIsNotNull(mesh, "mesh");
        renderable.remove(mesh);
    }

    public final void startEngine() {
        if (_task == null) {
            BukkitScheduler bukkitScheduler = Bukkit.getScheduler();
            PuppetPlugin puppetPlugin = plugin;
            if (puppetPlugin == null) {
                Intrinsics.throwNpe();
            }
            _task = bukkitScheduler.runTaskTimer((Plugin)puppetPlugin, new Runnable(){

                public void run() {
                    Puppet.INSTANCE.render();
                }
            }, 0L, 0L);
            Logger logger = Puppet.logger;
            if (logger == null) {
                Intrinsics.throwNpe();
            }
            logger.info("Running render loop");
            isRunning = true;
        } else {
            System.err.println("Puppet already running render loop");
        }
    }

    public final void stopEngine() {
        if (_task != null) {
            BukkitTask bukkitTask = _task;
            if (bukkitTask == null) {
                Intrinsics.throwNpe();
            }
            bukkitTask.cancel();
            _task = null;
            Logger logger = Puppet.logger;
            if (logger == null) {
                Intrinsics.throwNpe();
            }
            logger.info("Stopped render loop");
            isRunning = false;
        } else {
            System.err.println("Puppet already running render loop");
        }
    }

    public final void stepEngine() {
        this.render();
    }

    public final void render() {
        for (Actor actor : actors.values()) {
            actor.update();
        }
        for (Mesh mesh : renderable) {
            mesh.render();
        }
    }

    private Puppet() {
    }

    static {
        Puppet puppet;
        INSTANCE = puppet = new Puppet();
        version = version;
        actors = new LinkedHashMap();
        actorsById = new LinkedHashMap();
        boolean bl = false;
        entityToActor = new HashMap();
        bl = false;
        renderable = new ArrayList();
        bl = false;
        playerPosingActor = new HashMap();
    }
}

