/*
 * Decompiled with CFR 0.152.
 */
package fr.ulity.core.addons.packutils.bukkit.commands.teleports;

import fr.ulity.core.addons.packutils.bukkit.MainBukkitPackUtils;
import fr.ulity.core.addons.packutils.bukkit.methods.TeleportMethods;
import fr.ulity.core.api.CommandManager;
import org.bukkit.Location;
import org.bukkit.command.Command;
import org.bukkit.command.CommandMap;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.java.JavaPlugin;

public class TpCommand
extends CommandManager.Assisted {
    public TpCommand(CommandMap commandMap, JavaPlugin plugin) {
        super(plugin, "tp");
        this.addPermission("ulity.packutils.tp");
        if (MainBukkitPackUtils.enabler.canEnable(this.getName())) {
            this.registerCommand(commandMap);
        }
    }

    public void exec(CommandSender sender, Command command, String label, String[] args) {
        if (this.arg.inRange(1, 4)) {
            TeleportMethods teleporting = new TeleportMethods(sender);
            if (args.length == 1 && this.requirePlayer()) {
                if (this.arg.requirePlayerNoSelf(0)) {
                    teleporting.tpPlayer((Player)sender, this.arg.getPlayer(0));
                }
            } else if (args.length == 2) {
                if (this.arg.requirePlayer(0) && this.arg.requirePlayer(1)) {
                    teleporting.tpPlayer(this.arg.getPlayer(0), this.arg.getPlayer(1));
                }
            } else {
                int ind = -3 + args.length;
                try {
                    double x = Double.parseDouble(args[ind]);
                    double y = Double.parseDouble(args[ind + 1]);
                    double z = Double.parseDouble(args[ind + 2]);
                    Player player = null;
                    if (ind == 0 && this.requirePlayer()) {
                        player = (Player)sender;
                    } else if (this.arg.requirePlayer(0)) {
                        player = this.arg.getPlayer(0);
                    } else {
                        this.setStatus(CommandManager.Assisted.Status.STOP);
                    }
                    if (this.status.equals((Object)CommandManager.Assisted.Status.SUCCESS)) {
                        teleporting.tpCoords(player, new Location(player.getWorld(), x, y, z));
                    }
                }
                catch (NumberFormatException ignored) {
                    this.setStatus(CommandManager.Assisted.Status.SYNTAX);
                }
            }
        } else {
            this.setStatus(CommandManager.Assisted.Status.SYNTAX);
        }
    }
}

