/*
 * Decompiled with CFR 0.152.
 */
package fr.ulity.core.addons.packutils.bukkit.commands.teleports;

import fr.ulity.core.addons.packutils.bukkit.MainBukkitPackUtils;
import fr.ulity.core.api.CommandManager;
import fr.ulity.core.api.Lang;
import org.bukkit.Location;
import org.bukkit.command.Command;
import org.bukkit.command.CommandMap;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.java.JavaPlugin;

public class TopCommand
extends CommandManager.Assisted {
    public TopCommand(CommandMap commandMap, JavaPlugin plugin) {
        super(plugin, "top");
        this.addPermission("ulity.packutils.top");
        if (MainBukkitPackUtils.enabler.canEnable(this.getName())) {
            this.registerCommand(commandMap);
        }
    }

    public static Location getTopLoc(Player player) {
        Location loc = player.getLocation();
        int y = player.getLocation().getWorld().getHighestBlockYAt(loc) + 1;
        return new Location(loc.getWorld(), loc.getX(), (double)y, loc.getZ());
    }

    public void exec(CommandSender sender, Command command, String label, String[] args) {
        if (this.arg.inRange(0, 1)) {
            if (!this.arg.is(0) && this.requirePlayer()) {
                Player player = (Player)sender;
                player.teleport(TopCommand.getTopLoc(player));
                player.sendMessage(Lang.get((Object)player, (String)"commands.top.expressions.notification"));
            } else if (this.requirePermission("ulity.packutils.top.others") && this.arg.requirePlayer(0)) {
                Player target = this.arg.getPlayer(0);
                target.teleport(TopCommand.getTopLoc(target));
                Lang.prepare((String)"commands.top.expressions.notification").sendPlayer(target);
                if (!sender.getName().equals(target.getName())) {
                    Lang.prepare((String)"commands.top.expressions.result_other").variable("player", target.getName()).sendPlayer(sender);
                }
            }
        } else {
            this.setStatus(CommandManager.Assisted.Status.SYNTAX);
        }
    }
}

