/*
 * Decompiled with CFR 0.152.
 */
package fr.ulity.core.addons.packutils.bukkit.commands.teleports;

import fr.ulity.core.addons.packutils.bukkit.MainBukkitPackUtils;
import fr.ulity.core.addons.packutils.bukkit.methods.SpawnMethods;
import fr.ulity.core.api.CommandManager;
import fr.ulity.core.api.Lang;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.command.Command;
import org.bukkit.command.CommandMap;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class SpawnCommand
extends CommandManager.Assisted {
    public SpawnCommand(CommandMap commandMap, JavaPlugin plugin) {
        super(plugin, "spawn");
        this.addPermission("ulity.packutils.spawn");
        if (MainBukkitPackUtils.enabler.canEnable(this.getName())) {
            this.registerCommand(commandMap);
        }
    }

    public void exec(CommandSender sender, Command command, String label, String[] args) {
        Location spawnLoc = SpawnMethods.getSpawnLocation();
        if (spawnLoc == null) {
            Lang.prepare((String)"commands.spawn.expressions.not_defined").sendPlayer(sender);
        } else if (this.arg.inRange(0, 1)) {
            Player origin = null;
            if (!this.arg.is(0) && this.requirePlayer()) {
                origin = (Player)sender;
            } else if (this.requirePermission("ulity.packutils.spawn.others") && this.arg.requirePlayer(0)) {
                origin = this.arg.getPlayer(0);
            }
            if (this.status.equals((Object)CommandManager.Assisted.Status.SUCCESS)) {
                assert (origin != null);
                Lang.prepare((String)"commands.spawn.expressions.prevent_teleport").sendPlayer(origin);
                if (!origin.getName().equals(sender.getName())) {
                    Lang.prepare((String)"commands.spawn.expressions.others_result").variable("player", origin.getName()).sendPlayer(sender);
                }
                Player finalOrigin = origin;
                Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)MainBukkitPackUtils.plugin, () -> {
                    if (finalOrigin.isOnline()) {
                        finalOrigin.teleport(spawnLoc);
                        Lang.prepare((String)"commands.spawn.expressions.teleported").sendPlayer(finalOrigin);
                    }
                }, 100L);
            }
        } else {
            this.setStatus(CommandManager.Assisted.Status.SYNTAX);
        }
    }
}

