/*
 * Decompiled with CFR 0.152.
 */
package fr.ulity.core.addons.packutils.bukkit.commands.teleports;

import fr.ulity.core.addons.packutils.bukkit.MainBukkitPackUtils;
import fr.ulity.core.addons.packutils.bukkit.methods.HomeMethods;
import fr.ulity.core.api.CommandManager;
import fr.ulity.core.api.Lang;
import java.util.Arrays;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandMap;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.server.TabCompleteEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class HomeCommand
extends CommandManager.Assisted
implements Listener {
    public HomeCommand(CommandMap commandMap, JavaPlugin plugin) {
        super(plugin, "home");
        this.addPermission("ulity.packutils.home");
        this.addArrayTabbComplete(0, "ulity.packutils.home", new String[0], new String[]{"\u00a7Homes"});
        if (MainBukkitPackUtils.enabler.canEnable(this.getName())) {
            Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)this.getPlugin());
            this.registerCommand(commandMap);
        }
    }

    @EventHandler
    public void onTabComplete(TabCompleteEvent e) {
        String request = e.getBuffer();
        String[] args = request.split(" ");
        if (args[0].replace("/", "").equalsIgnoreCase(this.getName()) && e.getCompletions().contains("\u00a7Homes")) {
            e.setCompletions(Arrays.asList(HomeMethods.getHomeListName((Player)e.getSender())));
        }
    }

    public void exec(CommandSender sender, Command command, String label, String[] args) {
        if (this.requirePlayer()) {
            if (this.arg.inRange(0, 1)) {
                String homeName;
                Player player = (Player)sender;
                String string = homeName = args.length == 1 ? args[0] : "home";
                if (HomeMethods.isHomeExist(player, homeName)) {
                    Lang.prepare((String)"commands.home.expressions.prevent_teleport").variable("home", homeName).sendPlayer(player);
                    Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)MainBukkitPackUtils.plugin, () -> {
                        if (player.isOnline()) {
                            player.teleport(HomeMethods.getHomeLocation(player, homeName));
                            Lang.prepare((String)"commands.home.expressions.teleported").variable("home", homeName).sendPlayer(player);
                        }
                    }, 100L);
                } else if (homeName.equals("home")) {
                    Object[] list = HomeMethods.getHomeListName(player);
                    String toText = list.length == 0 ? Lang.get((Object)player, (String)"commands.home.expressions.nothing_list") : Arrays.toString(list);
                    Lang.prepare((String)"commands.home.expressions.home_list").variable("list", toText.replaceAll("[\\[|\\]]", "")).sendPlayer(player);
                } else {
                    Lang.prepare((String)"commands.home.expressions.unknown_home").variable("home", homeName).sendPlayer(player);
                }
            } else {
                this.setStatus(CommandManager.Assisted.Status.SYNTAX);
            }
        }
    }
}

