/*
 * Decompiled with CFR 0.152.
 */
package fr.ulity.core.addons.packutils.bukkit.commands.teleports;

import fr.ulity.core.addons.packutils.bukkit.MainBukkitPackUtils;
import fr.ulity.core.addons.packutils.bukkit.methods.HomeMethods;
import fr.ulity.core.api.CommandManager;
import fr.ulity.core.api.Lang;
import java.util.Arrays;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandMap;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.server.TabCompleteEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class DelhomeCommand
extends CommandManager.Assisted
implements Listener {
    public DelhomeCommand(CommandMap commandMap, JavaPlugin plugin) {
        super(plugin, "delhome");
        this.addPermission("ulity.packutils.delhome");
        this.addArrayTabbComplete(0, "ulity.packutils.delhome", new String[0], new String[]{"\u00a7Homes"});
        if (MainBukkitPackUtils.enabler.canEnable(this.getName())) {
            Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)this.getPlugin());
            this.registerCommand(commandMap);
        }
    }

    @EventHandler
    public void onTabComplete(TabCompleteEvent e) {
        String request = e.getBuffer();
        String[] args = request.split(" ");
        if (args[0].replace("/", "").equalsIgnoreCase(this.getName()) && e.getCompletions().contains("\u00a7Homes")) {
            e.setCompletions(Arrays.asList(HomeMethods.getHomeListName((Player)e.getSender())));
        }
    }

    public void exec(CommandSender sender, Command command, String label, String[] args) {
        if (this.requirePlayer()) {
            if (this.arg.inRange(1, 1)) {
                Player player = (Player)sender;
                if (HomeMethods.isHomeExist(player, args[0])) {
                    HomeMethods.delHome(player, args[0]);
                    Lang.prepare((String)"commands.delhome.expressions.deleted").variable("home", args[0]).sendPlayer(player);
                } else {
                    Lang.prepare((String)"commands.delhome.expressions.unknown_home").variable("home", args[0]).sendPlayer(player);
                }
            } else {
                this.setStatus(CommandManager.Assisted.Status.SYNTAX);
            }
        }
    }
}

