/*
 * Decompiled with CFR 0.152.
 */
package fr.ulity.core.addons.packutils.bukkit.commands.players;

import fr.ulity.core.addons.packutils.bukkit.MainBukkitPackUtils;
import fr.ulity.core.api.CommandManager;
import fr.ulity.core.api.Lang;
import org.bukkit.command.Command;
import org.bukkit.command.CommandMap;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.java.JavaPlugin;

public class FlyCommand
extends CommandManager.Assisted {
    public FlyCommand(CommandMap commandMap, JavaPlugin plugin) {
        super(plugin, "fly");
        this.addPermission("ulity.packutils.fly");
        if (MainBukkitPackUtils.enabler.canEnable(this.getName())) {
            this.registerCommand(commandMap);
        }
    }

    public void exec(CommandSender sender, Command command, String label, String[] args) {
        if (this.arg.inRange(0, 1)) {
            Player target = null;
            if (this.arg.is(0)) {
                if (this.requirePermission("ulity.packutils.fly.others") && this.arg.requirePlayer(0)) {
                    target = this.arg.getPlayer(0);
                }
            } else if (this.requirePlayer()) {
                target = (Player)sender;
            }
            if (this.status.equals((Object)CommandManager.Assisted.Status.SUCCESS)) {
                assert (target != null);
                target.setAllowFlight(!target.getAllowFlight());
                Lang.Prepared preparedEnabled = Lang.prepare((String)"global.enabled").prefix("\u00a7a");
                Lang.Prepared preparedDisabled = Lang.prepare((String)"global.disabled").prefix("\u00a7c");
                Lang.Prepared status = target.getAllowFlight() ? preparedEnabled : preparedDisabled;
                Lang.prepare((String)"commands.fly.expressions.fly_changed").variable("status", status.getOutput((Object)target)).sendPlayer(target);
                if (!sender.getName().equals(target.getName())) {
                    Lang.prepare((String)"commands.fly.expressions.result").variable("status", status.getOutput((Object)sender)).variable("player", target.getName()).sendPlayer(sender);
                }
            }
        } else {
            this.setStatus(CommandManager.Assisted.Status.SYNTAX);
        }
    }
}

